/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.treenodes;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.gui.treenodes.DimensionConfigTreeNode;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class PlotConfigurationTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;

    public PlotConfigurationTreeNode(PlotConfiguration plotConfig) {
        super(plotConfig);
    }

    public int getRangeAxisIndex(RangeAxisConfig rangeAxis) {
        for (Object child : this.children) {
            if (rangeAxis != ((DefaultMutableTreeNode)child).getUserObject()) continue;
            return this.children.indexOf(child);
        }
        return -1;
    }

    public int getDimensionConfigIndex(DimensionConfig.PlotDimension dimension) {
        for (Object child : this.children) {
            if (!(child instanceof DimensionConfigTreeNode) || ((DimensionConfigTreeNode)child).getDimension() != dimension) continue;
            return this.children.indexOf(child);
        }
        return -1;
    }

    public TreeNode getChild(RangeAxisConfig rangeAxis) {
        int rangeAxisIndex = this.getRangeAxisIndex(rangeAxis);
        if (rangeAxisIndex < 0) {
            return null;
        }
        return this.getChildAt(rangeAxisIndex);
    }

    public TreeNode getChild(DimensionConfig.PlotDimension dimension) {
        int dimensionConfigIndex = this.getDimensionConfigIndex(dimension);
        if (dimensionConfigIndex < 0) {
            return null;
        }
        return this.getChildAt(dimensionConfigIndex);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public PlotConfiguration getUserObject() {
        return (PlotConfiguration)super.getUserObject();
    }
}

