/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.listener.events;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushSelection;
import com.owc.gui.charting.listener.events.ConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.LegendConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import com.owc.gui.charting.templates.style.ColorScheme;
import com.rapidminer.datatable.DataTable;
import java.awt.Color;
import java.awt.Font;
import java.util.LinkedList;
import java.util.List;
import org.jfree.chart.plot.PlotOrientation;

public class PlotConfigurationChangeEvent
implements ConfigurationChangeEvent {
    private final PlotConfigurationChangeType type;
    private PlotConfiguration source;
    private final List<PlotConfigurationChangeEvent> plotConfigChangeEvents = new LinkedList<PlotConfigurationChangeEvent>();
    private RangeAxisConfig rangeAxisConfig = null;
    private Integer index = null;
    private DimensionConfig.PlotDimension dimension = null;
    private DimensionConfig dimensionConfig = null;
    private String chartTitle = null;
    private Font axesFont = null;
    private Color plotBackgroundColor = null;
    private Color frameBackgroundColor = null;
    private Color axisLineColor = null;
    private PlotOrientation orientation = null;
    private DimensionConfigChangeEvent dimensionChange = null;
    private RangeAxisConfigChangeEvent rangeAxisConfigChange = null;
    private Float domainAxisLineWidth = null;
    private ColorScheme colorScheme = null;
    private DataTable dataTable = null;
    private LinkAndBrushSelection linkAndBrushSelection = null;
    private LegendConfigurationChangeEvent legendConfigurationChangeEvent = null;

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, PlotConfigurationChangeType type, RangeAxisConfig rangeAxis, Integer index) {
        this.setSource(source);
        if (type != PlotConfigurationChangeType.RANGE_AXIS_CONFIG_ADDED && type != PlotConfigurationChangeType.RANGE_AXIS_CONFIG_REMOVED && type != PlotConfigurationChangeType.RANGE_AXIS_CONFIG_MOVED) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.type = type;
        this.rangeAxisConfig = rangeAxis;
        this.index = index;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source) {
        this.setSource(source);
        this.type = PlotConfigurationChangeType.TRIGGER_REPLOT;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, PlotConfigurationChangeType type, DimensionConfig.PlotDimension dimension, DimensionConfig dimensionConfig) {
        if (type != PlotConfigurationChangeType.DIMENSION_CONFIG_ADDED && type != PlotConfigurationChangeType.DIMENSION_CONFIG_REMOVED) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.setSource(source);
        this.type = type;
        this.dimension = dimension;
        this.dimensionConfig = dimensionConfig;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, String chartTitle) {
        this.setSource(source);
        this.type = PlotConfigurationChangeType.CHART_TITLE;
        this.chartTitle = chartTitle;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, List<PlotConfigurationChangeEvent> plotConfigChangeEvents) {
        this.setSource(source);
        this.type = PlotConfigurationChangeType.META_CHANGE;
        this.plotConfigChangeEvents.addAll(plotConfigChangeEvents);
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, Font axesFont) {
        this.setSource(source);
        this.type = PlotConfigurationChangeType.AXES_FONT;
        this.axesFont = axesFont;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, PlotConfigurationChangeType type, Color color) {
        this.setSource(source);
        this.type = type;
        if (type != PlotConfigurationChangeType.FRAME_BACKGROUND_COLOR && type != PlotConfigurationChangeType.PLOT_BACKGROUND_COLOR && type != PlotConfigurationChangeType.AXIS_LINE_COLOR) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        if (type == PlotConfigurationChangeType.FRAME_BACKGROUND_COLOR) {
            this.frameBackgroundColor = color;
        } else if (type == PlotConfigurationChangeType.AXIS_LINE_COLOR) {
            this.axisLineColor = color;
        } else if (type == PlotConfigurationChangeType.PLOT_BACKGROUND_COLOR) {
            this.plotBackgroundColor = color;
        } else {
            throw new RuntimeException("Unknown type for color assignment");
        }
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, DimensionConfigChangeEvent dimensionChange) {
        this.setSource(source);
        this.type = PlotConfigurationChangeType.DIMENSION_CONFIG_CHANGED;
        this.dimensionChange = dimensionChange;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, LinkAndBrushSelection selection) {
        this.setSource(source);
        this.type = PlotConfigurationChangeType.LINK_AND_BRUSH_SELECTION;
        this.linkAndBrushSelection = selection;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration source, RangeAxisConfigChangeEvent rangeAxisChange) {
        this.setSource(source);
        this.type = PlotConfigurationChangeType.RANGE_AXIS_CONFIG_CHANGED;
        this.rangeAxisConfigChange = rangeAxisChange;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration plotConfiguration, PlotOrientation orientation) {
        this.setSource(plotConfiguration);
        this.type = PlotConfigurationChangeType.PLOT_ORIENTATION;
        this.orientation = orientation;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration plotConfiguration, float domainAxisLineWidth) {
        this.setSource(plotConfiguration);
        this.type = PlotConfigurationChangeType.AXIS_LINE_WIDTH;
        this.domainAxisLineWidth = Float.valueOf(domainAxisLineWidth);
    }

    public PlotConfigurationChangeEvent(PlotConfiguration plotConfiguration, ColorScheme colorScheme) {
        this.setSource(plotConfiguration);
        this.type = PlotConfigurationChangeType.COLOR_SCHEME;
        this.colorScheme = colorScheme;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration plotConfiguration, DataTable dataTable) {
        this.setSource(plotConfiguration);
        this.type = PlotConfigurationChangeType.DATA_TABLE_EXCHANGED;
        this.dataTable = dataTable;
    }

    public PlotConfigurationChangeEvent(PlotConfiguration plotConfiguration, LegendConfigurationChangeEvent change) {
        this.setSource(plotConfiguration);
        this.type = PlotConfigurationChangeType.LEGEND_CHANGED;
        this.legendConfigurationChangeEvent = change;
    }

    public void setSource(PlotConfiguration plotConfiguration) {
        this.source = plotConfiguration;
    }

    public DimensionConfigChangeEvent getDimensionChange() {
        return this.dimensionChange;
    }

    public void addPlotConfigChangeEvent(PlotConfiguration newSource, PlotConfigurationChangeEvent changeEvent) {
        if (this.type != PlotConfigurationChangeType.META_CHANGE) {
            throw new IllegalArgumentException("Wrong type. Only META_CHANGE is allowed!");
        }
        this.source = newSource;
        this.plotConfigChangeEvents.add(changeEvent);
    }

    public List<PlotConfigurationChangeEvent> getPlotConfigChangeEvents() {
        return this.plotConfigChangeEvents;
    }

    public PlotConfigurationChangeType getType() {
        return this.type;
    }

    public RangeAxisConfig getRangeAxisConfig() {
        return this.rangeAxisConfig;
    }

    public Integer getIndex() {
        return this.index;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public LinkAndBrushSelection getLinkAndBrushSelection() {
        return this.linkAndBrushSelection;
    }

    public DimensionConfig.PlotDimension getDimension() {
        return this.dimension;
    }

    public DimensionConfig getDimensionConfig() {
        return this.dimensionConfig;
    }

    public Color getDomainAxisLineColor() {
        return this.axisLineColor;
    }

    public float getDomainAxisLineWidth() {
        return this.domainAxisLineWidth.floatValue();
    }

    public RangeAxisConfigChangeEvent getRangeAxisConfigChange() {
        return this.rangeAxisConfigChange;
    }

    public PlotConfiguration getSource() {
        return this.source;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public Font getAxesFont() {
        return this.axesFont;
    }

    public Color getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public Color getFrameBackgroundColor() {
        return this.frameBackgroundColor;
    }

    @Override
    public ConfigurationChangeEvent.ConfigurationChangeType getConfigurationChangeType() {
        return ConfigurationChangeEvent.ConfigurationChangeType.PLOT_CONFIGURATION_CHANGE;
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public String toString() {
        return this.getType().toString();
    }

    public LegendConfigurationChangeEvent getLegendConfigurationChangeEvent() {
        return this.legendConfigurationChangeEvent;
    }

    public static enum PlotConfigurationChangeType {
        RANGE_AXIS_CONFIG_ADDED,
        RANGE_AXIS_CONFIG_REMOVED,
        RANGE_AXIS_CONFIG_MOVED,
        DIMENSION_CONFIG_ADDED,
        DIMENSION_CONFIG_REMOVED,
        CHART_TITLE,
        AXES_FONT,
        FRAME_BACKGROUND_COLOR,
        PLOT_BACKGROUND_COLOR,
        PLOT_ORIENTATION,
        DATA_TABLE_EXCHANGED,
        RANGE_AXIS_CONFIG_CHANGED,
        DIMENSION_CONFIG_CHANGED,
        AXIS_LINE_COLOR,
        AXIS_LINE_WIDTH,
        COLOR_SCHEME,
        LINK_AND_BRUSH_SELECTION,
        LEGEND_CHANGED,
        META_CHANGE,
        TRIGGER_REPLOT;

    }
}

