/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.listener.events;

import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.listener.events.ConfigurationChangeEvent;
import java.awt.Color;

public class SeriesFormatChangeEvent
implements ConfigurationChangeEvent {
    private final SeriesFormat source;
    private final SeriesFormatChangeType type;
    private SeriesFormat.VisualizationType seriesType = null;
    private SeriesFormat.StackingMode stackingMode = null;
    private SeriesFormat.IndicatorType errorIndicator = null;
    private LineFormat.LineStyle lineStyle = null;
    private SeriesFormat.ItemShape itemShape = null;
    private Double itemSize = null;
    private Float lineWidth = null;
    private Color itemColor = null;
    private Color lineColor = null;
    private SeriesFormat.FillStyle areaFillStyle = null;
    private Integer opacity = null;

    public SeriesFormatChangeEvent(SeriesFormat source, SeriesFormat.VisualizationType seriesType) {
        this.type = SeriesFormatChangeType.SERIES_TYPE;
        this.seriesType = seriesType;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, SeriesFormat.StackingMode stackingMode) {
        this.type = SeriesFormatChangeType.STACKING_MODE;
        this.stackingMode = stackingMode;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, SeriesFormat.IndicatorType errorIndicator) {
        this.type = SeriesFormatChangeType.UTILITY_INDICATOR;
        this.errorIndicator = errorIndicator;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, LineFormat.LineStyle lineStyle) {
        this.type = SeriesFormatChangeType.LINE_STYLE;
        this.lineStyle = lineStyle;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, SeriesFormat.ItemShape itemShape) {
        this.type = SeriesFormatChangeType.ITEM_SHAPE;
        this.itemShape = itemShape;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, Double itemSize) {
        this.type = SeriesFormatChangeType.ITEM_SIZE;
        this.itemSize = itemSize;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, Float lineWidth) {
        this.type = SeriesFormatChangeType.LINE_WIDTH;
        this.lineWidth = lineWidth;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, SeriesFormat.FillStyle areaFillStyle) {
        this.type = SeriesFormatChangeType.AREA_FILL_STYLE;
        this.areaFillStyle = areaFillStyle;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, Integer opacity) {
        this.type = SeriesFormatChangeType.OPACITY;
        this.opacity = opacity;
        this.source = source;
    }

    public SeriesFormatChangeEvent(SeriesFormat source, SeriesFormatChangeType type, Color color) {
        this.type = type;
        if (type != SeriesFormatChangeType.ITEM_COLOR && type != SeriesFormatChangeType.LINE_COLOR) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        if (type == SeriesFormatChangeType.LINE_COLOR) {
            this.lineColor = color;
        } else {
            this.itemColor = color;
        }
        this.source = source;
    }

    public SeriesFormatChangeType getType() {
        return this.type;
    }

    public SeriesFormat.VisualizationType getSeriesType() {
        return this.seriesType;
    }

    public SeriesFormat.IndicatorType getErrorIndicator() {
        return this.errorIndicator;
    }

    public SeriesFormat.StackingMode getStackingMode() {
        return this.stackingMode;
    }

    public SeriesFormat getSource() {
        return this.source;
    }

    public LineFormat.LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public SeriesFormat.ItemShape getItemShape() {
        return this.itemShape;
    }

    public Double getItemSize() {
        return this.itemSize;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Integer getOpacity() {
        return this.opacity;
    }

    public void setSeriesType(SeriesFormat.VisualizationType seriesType) {
        this.seriesType = seriesType;
    }

    public void setStackingMode(SeriesFormat.StackingMode stackingMode) {
        this.stackingMode = stackingMode;
    }

    public Color getItemColor() {
        return this.itemColor;
    }

    public SeriesFormat.FillStyle getAreaFillStyle() {
        return this.areaFillStyle;
    }

    @Override
    public ConfigurationChangeEvent.ConfigurationChangeType getConfigurationChangeType() {
        return ConfigurationChangeEvent.ConfigurationChangeType.SERIES_FORMAT_CHANGE;
    }

    public String toString() {
        return this.getType().toString();
    }

    public static enum SeriesFormatChangeType {
        ITEM_SHAPE,
        ITEM_SIZE,
        ITEM_COLOR,
        LINE_WIDTH,
        LINE_STYLE,
        LINE_COLOR,
        OPACITY,
        AREA_FILL_STYLE,
        SERIES_TYPE,
        STACKING_MODE,
        UTILITY_INDICATOR;

    }
}

