/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.listener.events;

import com.owc.gui.charting.listener.events.ConfigurationChangeEvent;
import com.owc.gui.charting.utility.ValueRange;

public class ValueRangeChangeEvent
implements ConfigurationChangeEvent {
    private final ValueRange source;
    private final ValueRangeChangeType type;
    private Double upperBound = null;
    private Double lowerBound = null;
    private boolean useLowerBound;
    private boolean useUpperBound;

    public ValueRangeChangeEvent(ValueRange source, ValueRangeChangeType type) {
        if (type != ValueRangeChangeType.RESET) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.source = source;
        this.type = type;
    }

    public ValueRangeChangeEvent(ValueRange source, ValueRangeChangeType type, Double bound) {
        if (type != ValueRangeChangeType.UPPER_BOUND && type != ValueRangeChangeType.LOWER_BOUND) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.type = type;
        this.source = source;
        if (type == ValueRangeChangeType.UPPER_BOUND) {
            this.upperBound = bound;
        } else {
            this.lowerBound = bound;
        }
    }

    public ValueRangeChangeEvent(ValueRange source, ValueRangeChangeType type, boolean useBoundary) {
        if (type != ValueRangeChangeType.USE_UPPER_BOUND && type != ValueRangeChangeType.USE_LOWER_BOUND) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.type = type;
        this.source = source;
        if (type == ValueRangeChangeType.USE_LOWER_BOUND) {
            this.useLowerBound = useBoundary;
        } else {
            this.useUpperBound = useBoundary;
        }
    }

    public ValueRange getSource() {
        return this.source;
    }

    public ValueRangeChangeType getType() {
        return this.type;
    }

    public Double getUpperBound() {
        return this.upperBound;
    }

    public Double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public ConfigurationChangeEvent.ConfigurationChangeType getConfigurationChangeType() {
        return ConfigurationChangeEvent.ConfigurationChangeType.VALUE_RANGE_CHANGE;
    }

    public boolean getUseLowerBound() {
        return this.useLowerBound;
    }

    public boolean getUseUpperBound() {
        return this.useUpperBound;
    }

    public String toString() {
        return this.getType().toString();
    }

    public static enum ValueRangeChangeType {
        UPPER_BOUND,
        LOWER_BOUND,
        USE_UPPER_BOUND,
        USE_LOWER_BOUND,
        RESET;

    }
}

