/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.listener.events;

import com.owc.gui.charting.configuration.AggregationWindowing;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.listener.events.ConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.SeriesFormatChangeEvent;
import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;

public class ValueSourceChangeEvent
implements ConfigurationChangeEvent {
    private final ValueSource source;
    private final ValueSourceChangeType type;
    private Boolean useRelative = null;
    private Boolean usesGrouping = null;
    private ValueRangeChangeEvent valueRangeChanged = null;
    private SeriesFormatChangeEvent seriesFormatChange = null;
    private DataTableColumn column = null;
    private AbstractAggregationFunction.AggregationFunctionType aggregationFunctionType = null;
    private ValueSource.SeriesUsageType seriesUsagType = null;
    private AggregationWindowing aggregationWindowing = null;
    private Boolean autoNaming;
    private String label;

    public ValueSourceChangeEvent(ValueSource source, DataTableColumn column, ValueSource.SeriesUsageType seriesUsage) {
        this.source = source;
        this.type = ValueSourceChangeType.DATATABLE_COLUMN_MAP;
        this.column = column;
        this.seriesUsagType = seriesUsage;
    }

    public ValueSourceChangeEvent(ValueSource source, AbstractAggregationFunction.AggregationFunctionType function, ValueSource.SeriesUsageType seriesUsage) {
        this.source = source;
        this.type = ValueSourceChangeType.AGGREGATION_FUNCTION_MAP;
        this.seriesUsagType = seriesUsage;
        this.aggregationFunctionType = function;
    }

    public ValueSourceChangeEvent(ValueSource source, ValueSourceChangeType type, Boolean bool) {
        if (type != ValueSourceChangeType.USE_RELATIVE_UTILITIES && type != ValueSourceChangeType.USES_GROUPING && type != ValueSourceChangeType.AUTO_NAMING) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.source = source;
        this.type = type;
        if (type == ValueSourceChangeType.USE_RELATIVE_UTILITIES) {
            this.useRelative = bool;
        } else if (type == ValueSourceChangeType.USES_GROUPING) {
            this.usesGrouping = bool;
        } else {
            this.autoNaming = bool;
        }
    }

    public ValueSourceChangeEvent(ValueSource source, String label) {
        this.source = source;
        this.type = ValueSourceChangeType.LABEL;
        this.label = label;
    }

    public ValueSourceChangeEvent(ValueSource source, SeriesFormatChangeEvent seriesFormatChange) {
        this.source = source;
        this.type = ValueSourceChangeType.SERIES_FORMAT_CHANGED;
        this.seriesFormatChange = seriesFormatChange;
    }

    public ValueSourceChangeEvent(ValueSource source, AggregationWindowing newWindowing) {
        this.source = source;
        this.type = ValueSourceChangeType.AGGREGATION_WINDOWING_CHANGED;
        this.aggregationWindowing = newWindowing;
    }

    public ValueSourceChangeEvent(ValueSource source) {
        this.source = source;
        this.type = ValueSourceChangeType.UPDATED;
    }

    @Override
    public ConfigurationChangeEvent.ConfigurationChangeType getConfigurationChangeType() {
        return ConfigurationChangeEvent.ConfigurationChangeType.VALUE_SOURCE_CHANGE;
    }

    public ValueSource getSource() {
        return this.source;
    }

    public ValueSourceChangeType getType() {
        return this.type;
    }

    public Boolean getUsesGrouping() {
        return this.usesGrouping;
    }

    public Boolean getAutoNaming() {
        return this.autoNaming;
    }

    public String getLabel() {
        return this.label;
    }

    public ValueRangeChangeEvent getValueRangeChanged() {
        return this.valueRangeChanged;
    }

    public Boolean getUseRelative() {
        return this.useRelative;
    }

    public SeriesFormatChangeEvent getSeriesFormatChange() {
        return this.seriesFormatChange;
    }

    public DataTableColumn getDataTableColumn() {
        return this.column;
    }

    public AbstractAggregationFunction.AggregationFunctionType getAggregationFunctionType() {
        return this.aggregationFunctionType;
    }

    public ValueSource.SeriesUsageType getSeriesUsagType() {
        return this.seriesUsagType;
    }

    public AggregationWindowing getAggregationWindowing() {
        return this.aggregationWindowing;
    }

    public String toString() {
        return this.getType().toString();
    }

    public static enum ValueSourceChangeType {
        DATATABLE_COLUMN_MAP,
        AGGREGATION_FUNCTION_MAP,
        USES_GROUPING,
        SERIES_FORMAT_CHANGED,
        AGGREGATION_WINDOWING_CHANGED,
        USE_RELATIVE_UTILITIES,
        UPDATED,
        AUTO_NAMING,
        LABEL;

    }
}

