/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.templates.style;

import com.owc.gui.charting.templates.style.ColorRGB;
import com.owc.gui.charting.utility.ListUtility;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.AbstractChangeAwareSaveable;
import com.rapidminer.tools.ChangeAwareSaveable;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.XMLException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColorScheme
extends AbstractChangeAwareSaveable<ColorRGB>
implements Serializable {
    private static final long serialVersionUID = 975544231008107322L;
    public static final String XML_TAG_NAME = "color-scheme";
    private static final String GRADIENT_END_COLOR_XML_TAG = "gradient-end-color";
    private static final String GRADIENT_START_COLOR_XML_TAG = "gradient-start-color";
    private static final String COLORS_XML_TAG = "category-colors";
    private static final String NAME_XML_TAG = "name";
    private String name;
    private List<ColorRGB> listOfColors;
    private ColorRGB gradientStartColor;
    private ColorRGB gradientEndColor;
    private transient String repositoryLocation;
    private transient boolean initialized = false;

    public ColorScheme(String name, List<ColorRGB> listOfColors) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null!");
        }
        if (listOfColors == null) {
            throw new IllegalArgumentException("listOfColors must not be null!");
        }
        if (listOfColors.size() < 1) {
            throw new IllegalArgumentException("listOfColors must not be empty!");
        }
        this.name = name;
        this.listOfColors = listOfColors;
        this.gradientStartColor = listOfColors.get(0);
        this.gradientEndColor = listOfColors.get(listOfColors.size() - 1);
        this.initialized = true;
    }

    public ColorScheme(String name, List<ColorRGB> listOfColors, ColorRGB gradientStart, ColorRGB gradientEnd) {
        this(name, listOfColors);
        this.gradientStartColor = gradientStart;
        this.gradientEndColor = gradientEnd;
        this.initialized = true;
    }

    public ColorScheme(Element element) throws XMLException {
        if (!XML_TAG_NAME.equals(element.getTagName())) {
            throw new XMLException("<color-scheme> expected.");
        }
        this.name = XMLTools.getTagContents((Element)element, (String)NAME_XML_TAG);
        Element gradientStartColorElement = XMLTools.getChildTag((Element)element, (String)GRADIENT_START_COLOR_XML_TAG, (boolean)false);
        this.gradientStartColor = new ColorRGB(XMLTools.getChildTag((Element)gradientStartColorElement, (String)"color", (boolean)false));
        Element gradientEndColorElement = XMLTools.getChildTag((Element)element, (String)GRADIENT_END_COLOR_XML_TAG, (boolean)false);
        this.gradientEndColor = new ColorRGB(XMLTools.getChildTag((Element)gradientEndColorElement, (String)"color", (boolean)false));
        this.listOfColors = new LinkedList<ColorRGB>();
        Element categoryColorsElement = XMLTools.getChildTag((Element)element, (String)COLORS_XML_TAG, (boolean)false);
        Collection categoryColors = XMLTools.getChildElements((Element)categoryColorsElement, (String)"color");
        for (Element colorElement : categoryColors) {
            this.addColor(new ColorRGB(colorElement));
        }
        this.initialized = true;
    }

    public String getName() {
        return this.toString();
    }

    public ColorRGB getGradientStartColor() {
        return this.gradientStartColor;
    }

    public ColorRGB getGradientEndColor() {
        return this.gradientEndColor;
    }

    public void setGradientStartColor(ColorRGB gradientStartColor) {
        this.gradientStartColor = gradientStartColor;
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void setGradientEndColor(ColorRGB gradientEndColor) {
        this.gradientEndColor = gradientEndColor;
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void setName(String name) {
        this.name = name;
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void setColors(List<ColorRGB> listOfColors) {
        if (listOfColors == null) {
            throw new IllegalArgumentException("listOfColors must not be null!");
        }
        this.listOfColors = listOfColors;
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void addColor(ColorRGB color) {
        this.listOfColors.add(color);
        this.observeForChanges((Observable)color);
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void addColor(int index, ColorRGB color) {
        int oldIdx = this.listOfColors.indexOf(color);
        if (oldIdx != -1) {
            ListUtility.changeIndex(this.listOfColors, color, index);
        } else {
            this.listOfColors.add(index, color);
            this.observeForChanges((Observable)color);
        }
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void removeColor(ColorRGB color) {
        this.listOfColors.remove(color);
        this.stopObservingForChanges((Observable)color);
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void removeColor(int index) {
        ColorRGB color = this.listOfColors.remove(index);
        this.stopObservingForChanges((Observable)color);
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void setColor(ColorRGB oldColor, ColorRGB newColor) {
        int index = this.listOfColors.indexOf(oldColor);
        if (index != -1) {
            this.listOfColors.set(index, newColor);
        }
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public List<ColorRGB> getColors() {
        return new LinkedList<ColorRGB>(this.listOfColors);
    }

    public String[] getColorsAsHexArray() {
        List<ColorRGB> colors = this.getColors();
        String[] hexColors = new String[colors.size()];
        int index = 0;
        for (ColorRGB color : colors) {
            hexColors[index] = ColorRGB.convertColorRGBToHex(color);
            ++index;
        }
        return hexColors;
    }

    public String getGradientStartColorAsHex() {
        return ColorRGB.convertColorRGBToHex(this.getGradientStartColor());
    }

    public String getGradientEndColorAsHex() {
        return ColorRGB.convertColorRGBToHex(this.getGradientEndColor());
    }

    public String toString() {
        return this.name;
    }

    public ColorScheme clone() {
        LinkedList<ColorRGB> clonedList = new LinkedList<ColorRGB>();
        for (ColorRGB color : this.listOfColors) {
            clonedList.add(color.clone());
        }
        return new ColorScheme(this.name, clonedList, this.gradientStartColor.clone(), this.gradientEndColor.clone());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ColorScheme)) {
            return false;
        }
        ColorScheme givenColorScheme = (ColorScheme)obj;
        if (!this.name.equals(givenColorScheme.getName())) {
            return false;
        }
        if (!this.gradientStartColor.equals(givenColorScheme.getGradientStartColor())) {
            return false;
        }
        if (!this.gradientEndColor.equals(givenColorScheme.getGradientEndColor())) {
            return false;
        }
        if (givenColorScheme.getColors().size() != this.getColors().size()) {
            return false;
        }
        for (int i = 0; i < givenColorScheme.getColors().size(); ++i) {
            ColorRGB thisColorRGB;
            ColorRGB givenColorRGB = givenColorScheme.getColors().get(i);
            if (givenColorRGB.equals(thisColorRGB = this.getColors().get(i))) continue;
            return false;
        }
        return true;
    }

    public Document toXML() {
        Document doc = XMLTools.createDocument();
        doc.appendChild(this.toXML(doc));
        return doc;
    }

    public Element toXML(Document doc) {
        Element root = doc.createElement(XML_TAG_NAME);
        XMLTools.setTagContents((Element)root, (String)NAME_XML_TAG, (String)this.getName());
        Element colors = XMLTools.addTag((Element)root, (String)COLORS_XML_TAG);
        for (ColorRGB color : this.getColors()) {
            colors.appendChild(color.toXML(doc));
        }
        Element gradientStartColorTag = XMLTools.addTag((Element)root, (String)GRADIENT_START_COLOR_XML_TAG);
        gradientStartColorTag.appendChild(this.getGradientStartColor().toXML(doc));
        Element gradientEndColorTag = XMLTools.addTag((Element)root, (String)GRADIENT_END_COLOR_XML_TAG);
        gradientEndColorTag.appendChild(this.getGradientEndColor().toXML(doc));
        return root;
    }

    public static ColorScheme fromXML(Document doc) throws XMLException {
        return new ColorScheme(doc.getDocumentElement());
    }

    public String getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public void exchange(ColorRGB c1, ColorRGB c2) {
        if (c1 == c2) {
            return;
        }
        int i1 = this.listOfColors.indexOf(c1);
        int i2 = this.listOfColors.indexOf(c2);
        if (i1 != -1 && i2 != -1) {
            this.listOfColors.set(i1, c2);
            this.listOfColors.set(i2, c1);
        }
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public void exchange(int i1, int i2) {
        if (i1 == i2) {
            return;
        }
        if (i1 > -1 && i2 > -1 && this.listOfColors.size() > i1 && this.listOfColors.size() > i2) {
            ColorRGB c1 = this.listOfColors.get(i1);
            ColorRGB c2 = this.listOfColors.get(i2);
            this.listOfColors.set(i1, c2);
            this.listOfColors.set(i2, c1);
        }
        this.fireUpdate((ChangeAwareSaveable)this);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getPath() {
        return this.getRepositoryLocation();
    }

    public boolean isAlreadyStored() {
        return this.getRepositoryLocation() != null;
    }
}

