/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.utility.ContinuousSizeProvider;
import com.owc.gui.charting.utility.SizeProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoricalSizeProvider
implements SizeProvider {
    private Map<Double, Double> sizeMap;
    private double minScalingFactor;
    private double maxScalingFactor;

    public CategoricalSizeProvider(List<Double> categoryList, double minSize, double maxSize) {
        this.sizeMap = this.createSizeMapping(categoryList, minSize, maxSize);
        this.updateMinMaxScalingFactor();
    }

    public CategoricalSizeProvider(Map<Double, Double> sizeMap) {
        this.sizeMap = sizeMap;
        this.updateMinMaxScalingFactor();
    }

    private void updateMinMaxScalingFactor() {
        this.minScalingFactor = Double.POSITIVE_INFINITY;
        this.maxScalingFactor = Double.NEGATIVE_INFINITY;
        for (Double factor : this.sizeMap.values()) {
            if (factor < this.minScalingFactor) {
                this.minScalingFactor = factor;
            }
            if (!(factor > this.maxScalingFactor)) continue;
            this.maxScalingFactor = factor;
        }
    }

    private Map<Double, Double> createSizeMapping(List<Double> categoryList, double minSize, double maxSize) {
        int categoryCount = categoryList.size();
        HashMap<Double, Double> sizeMap = new HashMap<Double, Double>();
        if (categoryCount > 0) {
            ContinuousSizeProvider sizeProvider = new ContinuousSizeProvider(0.0, categoryCount - 1, minSize, maxSize, false);
            int idx = 0;
            for (Double category : categoryList) {
                sizeMap.put(category, sizeProvider.getScalingFactorForValue(idx));
                ++idx;
            }
        }
        return sizeMap;
    }

    @Override
    public double getScalingFactorForValue(double value) {
        return this.sizeMap.get(value);
    }

    @Override
    public boolean supportsCategoricalValues() {
        return true;
    }

    @Override
    public boolean supportsNumericalValues() {
        return false;
    }

    @Override
    public CategoricalSizeProvider clone() {
        HashMap<Double, Double> clonedSizeMap = new HashMap<Double, Double>();
        clonedSizeMap.putAll(this.sizeMap);
        return new CategoricalSizeProvider(clonedSizeMap);
    }

    @Override
    public double getMinScalingFactor() {
        return this.minScalingFactor;
    }

    @Override
    public double getMaxScalingFactor() {
        return this.maxScalingFactor;
    }
}

