/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.tools.container.Pair;
import java.awt.Color;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DataStructureUtils {
    public static <K, V> Map<K, V> getMapClone(Map<K, V> map) {
        HashMap<K, V> clone = new HashMap<K, V>();
        clone.putAll(map);
        return clone;
    }

    public static Color setColorAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static int multiplyOpacities256(int opacity1, int opacity2) {
        double op1 = (double)opacity1 / 255.0;
        double op2 = (double)opacity2 / 255.0;
        double resultOpacity = op1 * op2;
        return (int)Math.round(resultOpacity * 255.0);
    }

    public static List<Double> getAllDataTableValues(DataTable table, int columnIdx) {
        LinkedList<Double> values = new LinkedList<Double>();
        for (DataTableRow row : table) {
            values.add(row.getValue(columnIdx));
        }
        return values;
    }

    public static <T> Set<T> getDistinctValues(T[] array) {
        HashSet<T> resultSet = new HashSet<T>();
        for (int i = 0; i < array.length; ++i) {
            resultSet.add(array[i]);
        }
        return resultSet;
    }

    public static <T> Set<T> getDistinctValues(Iterable<T> iterable) {
        HashSet<T> resultSet = new HashSet<T>();
        for (T value : iterable) {
            resultSet.add(value);
        }
        return resultSet;
    }

    public static List<Double> getDistinctDataTableValues(DataTable table, int columnIdx) {
        LinkedHashSet<Double> values = new LinkedHashSet<Double>();
        for (DataTableRow row : table) {
            double value = row.getValue(columnIdx);
            values.add(value);
        }
        LinkedList<Double> resultList = new LinkedList<Double>();
        for (Double value : values) {
            resultList.add(value);
        }
        return resultList;
    }

    public static float[] cloneAndMultiplyArray(float[] array, float factor) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * factor;
        }
        return result;
    }

    public static int getOptimalPrecision(double min, double max) {
        if (Double.isInfinite(min) || Double.isInfinite(max)) {
            return Integer.MAX_VALUE;
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            return Integer.MAX_VALUE;
        }
        double range = max - min;
        if (range == 0.0) {
            return Integer.MAX_VALUE;
        }
        int powerOf10 = (range = Math.abs(range)) < 1.0 ? (int)Math.floor(Math.log10(range)) : (int)Math.floor(Math.log10(range)) - 1;
        return powerOf10;
    }

    public static String getRoundedString(double value, int powerOf10) {
        StringBuilder builder = new StringBuilder();
        if (powerOf10 < 2147483547) {
            value = DataStructureUtils.roundToPowerOf10(value, powerOf10);
        }
        Formatter formatter = new Formatter(builder, Locale.getDefault());
        String format = powerOf10 < 0 ? "%." + -powerOf10 + "f" : "%.0f";
        formatter.format(format, value);
        formatter.close();
        return builder.toString();
    }

    public static double intelligentRound(double min, double max, double value, int precisionModifier, boolean preDecimalRound) {
        int powerOf10 = DataStructureUtils.getOptimalPrecision(min, max);
        if (powerOf10 == Integer.MAX_VALUE) {
            return value;
        }
        return DataStructureUtils.roundToPowerOf10(value, powerOf10 + precisionModifier);
    }

    public static double roundToPowerOf10(double value, int powerOf10) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return value;
        }
        value *= Math.pow(10.0, -powerOf10);
        value = Math.round(value);
        return value /= Math.pow(10.0, -powerOf10);
    }

    public static boolean greaterOrAlmostEqual(float a, float b, float maxRelativeError) {
        return DataStructureUtils.almostEqual(a, b, maxRelativeError) ? true : a > b;
    }

    public static boolean greaterOrAlmostEqual(double a, double b, double maxRelativeError) {
        return DataStructureUtils.almostEqual(a, b, maxRelativeError) ? true : a > b;
    }

    public static boolean almostEqual(float a, float b, float maxRelativeError) {
        if (Float.isNaN(a) || Float.isNaN(b)) {
            return false;
        }
        if (a == b) {
            return true;
        }
        float relativeError = Math.abs(b) > Math.abs(a) ? Math.abs((a - b) / b) : Math.abs((a - b) / a);
        return relativeError <= maxRelativeError;
    }

    public static boolean almostEqual(double a, double b, double maxRelativeError) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        if (a == b) {
            return true;
        }
        double relativeError = Math.abs(b) > Math.abs(a) ? Math.abs((a - b) / b) : Math.abs((a - b) / a);
        return relativeError <= maxRelativeError;
    }

    public static class PairComparator<U, T extends Comparable<T>>
    implements Comparator<Pair<U, T>> {
        boolean ascending;

        public PairComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(Pair<U, T> o1, Pair<U, T> o2) {
            if (this.ascending) {
                return ((Comparable)o1.getSecond()).compareTo(o2.getSecond());
            }
            return -((Comparable)o1.getSecond()).compareTo(o2.getSecond());
        }
    }
}

