/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.rapidminer.Process;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DataTransformation {
    private static final String TO_REPLACE_WITH_DEPIVOT_ATTRIBUTE_LIST = "TO_REPLACE_WITH_DEPIVOT_ATTRIBUTE_LIST";
    private static final String TO_REPLACE_WITH_NOM_TO_NUM_ATTRIBUTE_LIST = "TO_REPLACE_WITH_NOM_TO_NUM_ATTRIBUTE_LIST";
    private static final String INVERT_NOM_TO_NUM_SELECTION = "INVERT_NOM_TO_NUM_SELECTION";

    public static ExampleSet createDePivotizedExampleSet(ExampleSet exampleSet, List<String> listOfNumericalAttributes) {
        return DataTransformation.createDePivotizedExampleSet(exampleSet, listOfNumericalAttributes, null);
    }

    public static ExampleSet createDePivotizedExampleSet(ExampleSet exampleSet, List<String> listOfNumericalAttributes, Collection<String> selectedNomToNumericAttributesList) {
        if (exampleSet == null) {
            throw new IllegalArgumentException("exampleSet must not be null!");
        }
        if (listOfNumericalAttributes == null) {
            throw new IllegalArgumentException("listOfNumericalAttributes must not be null!");
        }
        if (listOfNumericalAttributes.size() == 0) {
            return null;
        }
        listOfNumericalAttributes.remove("id");
        try {
            IOContainer inputContainer;
            IOContainer resultContainer;
            String invertNomToNumSelection;
            String nominalToNumericalValueString;
            InputStream is = DataTransformation.class.getResourceAsStream("/com/rapidminer/resources/processes/TransformationDepivot.rmp");
            String transformProcessXML = Tools.readTextFile((InputStream)is);
            StringBuffer defaultValueBuffer = new StringBuffer();
            if (selectedNomToNumericAttributesList != null) {
                selectedNomToNumericAttributesList.remove("id");
                for (String attName : selectedNomToNumericAttributesList) {
                    defaultValueBuffer.append(Pattern.quote(attName));
                    defaultValueBuffer.append("|");
                }
            }
            if (selectedNomToNumericAttributesList == null || selectedNomToNumericAttributesList.isEmpty()) {
                nominalToNumericalValueString = ".*";
                invertNomToNumSelection = "true";
            } else {
                nominalToNumericalValueString = defaultValueBuffer.substring(0, defaultValueBuffer.length() - 1);
                invertNomToNumSelection = "false";
            }
            transformProcessXML = transformProcessXML.replace(TO_REPLACE_WITH_NOM_TO_NUM_ATTRIBUTE_LIST, nominalToNumericalValueString);
            transformProcessXML = transformProcessXML.replace(INVERT_NOM_TO_NUM_SELECTION, invertNomToNumSelection);
            for (String attName : listOfNumericalAttributes) {
                defaultValueBuffer.append(Pattern.quote(attName));
                defaultValueBuffer.append("|");
            }
            String numericalValuesString = defaultValueBuffer.substring(0, defaultValueBuffer.length() - 1);
            transformProcessXML = transformProcessXML.replace(TO_REPLACE_WITH_DEPIVOT_ATTRIBUTE_LIST, numericalValuesString);
            Process transformProcess = new Process(transformProcessXML);
            ParameterTypeCategory loggingParameterType = (ParameterTypeCategory)transformProcess.getOperator("Process").getParameterType("logverbosity");
            loggingParameterType.setDefaultValue((Object)loggingParameterType.getIndex("off"));
            if (exampleSet.getAttributes().getId() != null) {
                transformProcess.getOperator("Generate ID").setEnabled(false);
                transformProcess.getOperator("idToNumerical").setEnabled(false);
            }
            if ((resultContainer = transformProcess.run(inputContainer = new IOContainer(new IOObject[]{exampleSet}))).getElementAt(0) instanceof ExampleSet) {
                return (ExampleSet)resultContainer.getElementAt(0);
            }
            throw new OperatorException("First element returned was not ExampleSet, but " + resultContainer.getElementAt(0).getClass());
        }
        catch (XMLException e) {
            LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.owc.gui.charting.utility.DataTransformation.creating_metainformationdepivotized_transformation_error", (Object[])new Object[0]), e);
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.owc.gui.charting.utility.DataTransformation.reading_metainformationdepivotized_transformation_error", (Object[])new Object[0]), e);
        }
        catch (OperatorException e) {
            LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.owc.gui.charting.utility.DataTransformation.executing_metainformationdepivotized_transformation_error", (Object[])new Object[0]), e);
        }
        return null;
    }
}

