/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.owc.gui.charting.utility.AbstractValueRange;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.ParameterService;
import java.sql.Date;
import java.text.DateFormat;

public class NumericalValueRange
extends AbstractValueRange {
    private static final long serialVersionUID = 4627292435065465419L;
    private double lowerBound;
    private double upperBound;
    private int columnIdx;
    private boolean includeLowerBound;
    private boolean includeUpperBound;
    private int upperPrecision;
    private int lowerPrecision;
    private DateFormat dateFormat;

    public NumericalValueRange(double lowerBound, double upperBound, int columnIdx) {
        this(lowerBound, upperBound, columnIdx, true, false);
    }

    public NumericalValueRange(double lowerBound, double upperBound, int columnIdx, DateFormat dateFormat, boolean includeLowerBound, boolean includeUpperBound) {
        this.lowerPrecision = this.upperPrecision = -Integer.parseInt(ParameterService.getParameterValue((String)"rapidminer.general.fractiondigits.numbers"));
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.includeLowerBound = includeLowerBound;
        this.includeUpperBound = includeUpperBound;
        this.columnIdx = columnIdx;
        this.dateFormat = dateFormat;
    }

    public NumericalValueRange(double lowerBound, double upperBound, int columnIdx, boolean includeLowerBound, boolean includeUpperBound) {
        this(lowerBound, upperBound, columnIdx, null, includeLowerBound, includeUpperBound);
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lowerBound) {
        if (lowerBound != this.lowerBound) {
            this.lowerBound = lowerBound;
            this.fireValueRangeChanged(new ValueRangeChangeEvent((ValueRange)this, ValueRangeChangeEvent.ValueRangeChangeType.LOWER_BOUND, lowerBound));
        }
    }

    @Override
    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upperBound) {
        if (upperBound != this.upperBound) {
            this.upperBound = upperBound;
            this.fireValueRangeChanged(new ValueRangeChangeEvent((ValueRange)this, ValueRangeChangeEvent.ValueRangeChangeType.UPPER_BOUND, upperBound));
        }
    }

    public boolean includesLowerBound() {
        return this.includeLowerBound;
    }

    public boolean includesUpperBound() {
        return this.includeUpperBound;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    public void setColumnIdx(int index) {
        if (index != this.columnIdx) {
            this.columnIdx = index;
            this.fireValueRangeChanged(new ValueRangeChangeEvent(this, ValueRangeChangeEvent.ValueRangeChangeType.RESET));
        }
    }

    public boolean keepRow(DataTableRow row) {
        double value = row.getValue(this.columnIdx);
        boolean belowLowerBound = false;
        if (this.includeLowerBound && value < this.lowerBound) {
            belowLowerBound = true;
        } else if (!this.includeLowerBound && value <= this.lowerBound) {
            belowLowerBound = true;
        }
        if (belowLowerBound) {
            return false;
        }
        boolean aboveUpperBound = false;
        if (this.includeUpperBound && value > this.upperBound) {
            aboveUpperBound = true;
        } else if (!this.includeUpperBound && value >= this.upperBound) {
            aboveUpperBound = true;
        }
        return !aboveUpperBound;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.includesLowerBound() || Double.isInfinite(this.getLowerBound())) {
            builder.append("(");
        } else {
            builder.append("[");
        }
        if (this.dateFormat != null) {
            builder.append(this.getDateStringForValue(this.getLowerBound()));
            builder.append(", ");
            builder.append(this.getDateStringForValue(this.getUpperBound()));
        } else {
            double min = DataStructureUtils.roundToPowerOf10(this.getLowerBound(), this.lowerPrecision);
            double max = DataStructureUtils.roundToPowerOf10(this.getUpperBound(), this.upperPrecision);
            builder.append(DataStructureUtils.getRoundedString(min, this.lowerPrecision));
            builder.append(", ");
            builder.append(DataStructureUtils.getRoundedString(max, this.upperPrecision));
        }
        if (!this.includesUpperBound() || Double.isInfinite(this.getUpperBound())) {
            builder.append(")");
        } else {
            builder.append("]");
        }
        return builder.toString();
    }

    private String getDateStringForValue(double value) {
        if (Double.isNaN(value)) {
            return I18N.getGUILabel((String)"plotter.unknown_value_label", (Object[])new Object[0]);
        }
        if (Double.isInfinite(value)) {
            return Double.toString(value);
        }
        return this.dateFormat.format(new Date((long)value));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericalValueRange)) {
            return false;
        }
        NumericalValueRange otherRange = (NumericalValueRange)obj;
        if (otherRange.lowerBound != this.lowerBound) {
            return false;
        }
        if (otherRange.upperBound != this.upperBound) {
            return false;
        }
        if (otherRange.includeLowerBound != this.includeLowerBound) {
            return false;
        }
        return otherRange.includeUpperBound == this.includeUpperBound;
    }

    public int hashCode() {
        Double upperBoundDouble = this.upperBound;
        Double lowerBoundDouble = this.lowerBound;
        return upperBoundDouble.hashCode() + lowerBoundDouble.hashCode();
    }

    @Override
    public double getValue() {
        return (this.getUpperBound() + this.getLowerBound()) / 2.0;
    }

    public void setVisualPrecision(int lowerPrecision, int upperPrecision) {
        this.lowerPrecision = lowerPrecision;
        this.upperPrecision = upperPrecision;
    }

    @Override
    public NumericalValueRange clone() {
        return new NumericalValueRange(this.getLowerBound(), this.getUpperBound(), this.getColumnIdx(), this.includesLowerBound(), this.includesUpperBound());
    }

    @Override
    public boolean definesUpperLowerBound() {
        return true;
    }

    public int getVisualUpperPrecision() {
        return this.upperPrecision;
    }

    public int getVisualLowerPrecision() {
        return this.lowerPrecision;
    }

    public void setVisualUpperPrecision(int upperPrecision) {
        this.upperPrecision = upperPrecision;
    }

    public void setVisualLowerPrecision(int lowerPrecision) {
        this.lowerPrecision = lowerPrecision;
    }

    public boolean isDate() {
        return this.dateFormat != null;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }
}

