/*
 * Decompiled with CFR 0.152.
 */
package com.owc.io;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class SigningInputStream
extends InputStream {
    private static final int EOF = 4;
    private static final int ESCAPE = 0;
    private static final int DATA = 0;
    private static final int ESCAPED_BYTE = 1;
    private static final int SIGNATURE = 2;
    private Signature signatureMethod;
    private InputStream inputStream;
    private int status = 0;
    private int escapeBuffer;
    private byte[] signatureBuffer;
    private int signaturePosition;
    private byte[] salt;

    public SigningInputStream(InputStream stream, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this(stream, "SHA256withRSA", privateKey);
    }

    public SigningInputStream(InputStream stream, String signingMethod, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this(stream, signingMethod, privateKey, null);
    }

    public SigningInputStream(InputStream stream, String signingMethod, PrivateKey privateKey, byte[] salt) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this.signatureMethod = Signature.getInstance(signingMethod);
        this.signatureMethod.initSign(privateKey);
        this.salt = salt;
        if (salt != null) {
            this.signatureMethod.update(salt);
        }
        this.inputStream = stream;
    }

    @Override
    public void close() throws IOException {
        if (this.status != 2 && this.signaturePosition != this.signatureBuffer.length) {
            throw new IOException("Closed before signing");
        }
        this.inputStream.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
        try {
            this.signatureMethod.sign();
            if (this.salt != null) {
                this.signatureMethod.update(this.salt);
            }
        }
        catch (SignatureException e) {
            throw new IOException("Could not reset signature", e);
        }
    }

    @Override
    public int read() throws IOException {
        switch (this.status) {
            case 0: {
                int readByte = this.inputStream.read();
                try {
                    if (readByte != -1) {
                        this.signatureMethod.update((byte)readByte);
                        if (readByte == 0 || readByte == 4) {
                            this.status = 1;
                            this.escapeBuffer = readByte;
                            return 0;
                        }
                        return readByte;
                    }
                    this.status = 2;
                    this.signatureBuffer = this.signatureMethod.sign();
                    this.signaturePosition = -2;
                    return 4;
                }
                catch (Exception e) {
                    throw new IOException("Could not sign data.", e);
                }
            }
            case 1: {
                this.status = 0;
                return this.escapeBuffer;
            }
        }
        ++this.signaturePosition;
        if (this.signaturePosition < 0) {
            return 4;
        }
        if (this.signaturePosition < this.signatureBuffer.length) {
            return this.signatureBuffer[this.signaturePosition] & 0xFF;
        }
        return -1;
    }
}

