/*
 * Decompiled with CFR 0.152.
 */
package com.owc.license.io;

import java.io.IOException;
import java.io.InputStream;

public class ChunkingInputStream
extends InputStream {
    private InputStream inputStream;
    private byte separator;
    private boolean isEnded = false;

    public ChunkingInputStream(InputStream in, byte separator) {
        this.inputStream = in;
        this.separator = separator;
    }

    @Override
    public int read() throws IOException {
        if (this.isEnded) {
            return -1;
        }
        int value = this.inputStream.read();
        if (value < 0 || value == this.separator) {
            this.isEnded = true;
            return -1;
        }
        return value;
    }

    public void next() {
        this.isEnded = false;
    }

    @Override
    public void close() throws IOException {
    }

    public void closeFinal() throws IOException {
        this.inputStream.close();
    }
}

