/*
 * Decompiled with CFR 0.152.
 */
package com.owc.mail;

import com.rapidminer.tools.config.AbstractConfigurable;
import com.rapidminer.tools.config.TestConfigurableAction;
import com.rapidminer.tools.config.actions.ActionResult;
import com.rapidminer.tools.config.actions.SimpleActionResult;
import java.util.Date;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailConnectionConfigurable
extends AbstractConfigurable {
    public static final String TYPE_ID = "MailConnection";

    public String getTypeId() {
        return TYPE_ID;
    }

    public String getUsername() {
        return this.getParameter("username");
    }

    public String getServer() {
        return this.getParameter("smtp_server");
    }

    public String getPassword() {
        return this.getParameter("password");
    }

    public int getPort() {
        return Integer.valueOf(this.getParameter("port"));
    }

    public String getFrom() {
        return this.getParameter("from_email");
    }

    public Session createSession() {
        String host = this.getServer();
        int port = this.getPort();
        final String username = this.getUsername();
        final String password = this.getPassword();
        String from = this.getFrom();
        Properties mailProperties = new Properties();
        mailProperties.put("mail.smtp.auth", (Object)true);
        mailProperties.put("mail.smtp.starttls.enable", (Object)true);
        mailProperties.put("mail.from", from);
        mailProperties.put("mail.smtp.host", host);
        mailProperties.put("mail.smtp.port", (Object)port);
        mailProperties.put("mail.smtp.socketFactory.port", (Object)port);
        mailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        mailProperties.put("mail.smtp.socketFactory.fallback", "false");
        Session session = Session.getInstance((Properties)mailProperties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        return session;
    }

    public TestConfigurableAction getTestAction() {
        return new TestConfigurableAction(){

            public ActionResult doWork() {
                try {
                    Session mailSession = MailConnectionConfigurable.this.createSession();
                    MimeMessage message = new MimeMessage(mailSession);
                    MimeBodyPart textPart = new MimeBodyPart();
                    message.setRecipients(Message.RecipientType.TO, MailConnectionConfigurable.this.getFrom());
                    message.setSubject("Test Mail from Advanced Reporting Extension", "UTF-8");
                    message.setSentDate(new Date());
                    textPart.setText("This was send as test for the connection " + MailConnectionConfigurable.this.getName(), "UTF-8");
                    MimeMultipart multipart = new MimeMultipart();
                    multipart.addBodyPart((BodyPart)textPart);
                    message.setContent((Multipart)multipart);
                    Transport.send((Message)message);
                    return new SimpleActionResult("Successfully send test mail to " + MailConnectionConfigurable.this.getFrom(), ActionResult.Result.SUCCESS);
                }
                catch (MessagingException e) {
                    return new SimpleActionResult("Could not send mail. " + e.getMessage(), ActionResult.Result.FAILURE);
                }
            }
        };
    }
}

