/*
 * Decompiled with CFR 0.152.
 */
package com.owc.mail;

import com.owc.mail.MailConnectionConfigurable;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.config.AbstractConfigurator;
import java.util.LinkedList;
import java.util.List;

public class MailConnectionConfigurator
extends AbstractConfigurator<MailConnectionConfigurable> {
    public static final String PARAMETER_HOST = "smtp_server";
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_USER = "username";
    public static final String PARAMETER_FROM = "from_email";

    public Class<MailConnectionConfigurable> getConfigurableClass() {
        return MailConnectionConfigurable.class;
    }

    public String getTypeId() {
        return "MailConnection";
    }

    public String getI18NBaseKey() {
        return "mail.connection";
    }

    public List<ParameterType> getParameterTypes(ParameterHandler parameterHandler) {
        LinkedList<ParameterType> list = new LinkedList<ParameterType>();
        list.add((ParameterType)new ParameterTypeString(PARAMETER_HOST, "The name of the smtp server."));
        list.add((ParameterType)new ParameterTypeInt(PARAMETER_PORT, "The port of the server", 1, 65535, 60));
        list.add((ParameterType)new ParameterTypeString(PARAMETER_USER, "The user name."));
        list.add((ParameterType)new ParameterTypePassword(PARAMETER_PASSWORD, "The password for this user."));
        list.add((ParameterType)new ParameterTypeString(PARAMETER_FROM, "The email that is used as sender of the mails."));
        for (ParameterType type : list) {
            type.setExpert(false);
        }
        return list;
    }
}

