/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.mail;

import com.owc.license.ProductInformation;
import com.owc.mail.MailConnectionConfigurable;
import com.owc.operator.OrderedPortOperator;
import com.rapidminer.extension.PluginInitAdvancedReportingExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.config.ConfigurationManager;
import com.rapidminer.tools.config.ParameterTypeConfigurable;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendMailWithAttachmentOperator
extends OrderedPortOperator {
    private InputPortExtender attachmentInputPort = new InputPortExtender("attachments", (Ports)this.getInputPorts()){

        protected Precondition makePrecondition(InputPort port) {
            return new SimplePrecondition(port, new MetaData(FileObject.class), false);
        }
    };
    private PortPairExtender throughExtender = new PortPairExtender("through", this.getInputPorts(), this.getOutputPorts());
    public static final String PARAMETER_CONNECTION = "smtp_connection";
    public static final String PARAMETER_RECIPIENT = "to";
    public static final String PARAMETER_RECIPIENT_OPTIONAL = "toAdditional";
    public static final String PARAMETER_RECIPIENT_BCC = "bcc";
    public static final String PARAMETER_RECIPIENT_BCC_OPTIONAL = "bccAdditional";
    public static final String PARAMETER_RECIPIENT_CC = "cc";
    public static final String PARAMETER_RECIPIENT_CC_OPTIONAL = "ccAdditional";
    public static final String PARAMETER_SUBJECT = "subject";
    public static final String PARAMETER_CONTENT_PLAIN = "body_plain";
    public static final String PARAMETER_CONTENT_HTML = "body_html";
    public static final String PARAMETER_USE_HTML = "use_html";
    public static final String PARAMETER_HEADERS = "headers";
    public static final String PARAMETER_FILE_NAMES = "file_names";
    public static final String PARAMETER_FILE_NAME = "file_name";

    public SendMailWithAttachmentOperator(OperatorDescription description) {
        super(description);
        this.throughExtender.start();
        this.attachmentInputPort.start();
        this.getTransformer().addRule(this.throughExtender.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        String content;
        String[] transformString2Enumeration = ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_FILE_NAMES));
        String recipient = this.getParameterAsString(PARAMETER_RECIPIENT);
        String recipientBcc = this.getParameterAsString(PARAMETER_RECIPIENT_BCC);
        String recipientCc = this.getParameterAsString(PARAMETER_RECIPIENT_CC);
        String subject = this.getParameterAsString(PARAMETER_SUBJECT);
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String[] entry : this.getParameterList(PARAMETER_HEADERS)) {
            headers.put(entry[0], entry[1]);
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_HTML)) {
            content = this.getParameterAsString(PARAMETER_CONTENT_HTML);
            headers.put("Content-Type", "text/html");
        } else {
            content = this.getParameterAsString(PARAMETER_CONTENT_PLAIN);
        }
        List attachments = this.attachmentInputPort.getData(FileObject.class, true);
        Session mailSession = this.createSession();
        MimeMessage message = new MimeMessage(mailSession);
        MimeBodyPart textPart = new MimeBodyPart();
        try {
            message.setRecipients(Message.RecipientType.TO, recipient);
            if (recipientBcc != null) {
                message.setRecipients(Message.RecipientType.BCC, recipientBcc);
            }
            if (recipientCc != null) {
                message.setRecipients(Message.RecipientType.CC, recipientCc);
            }
            message.setSubject(subject, "UTF-8");
            message.setSentDate(new Date());
            textPart.setText(content, "UTF-8");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)textPart);
            int i = 0;
            for (FileObject fileObject : attachments) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.attachFile(fileObject.getFile());
                if (i < transformString2Enumeration.length) {
                    messageBodyPart.setFileName(transformString2Enumeration[i]);
                }
                multipart.addBodyPart((BodyPart)messageBodyPart);
                ++i;
            }
            message.setContent((Multipart)multipart);
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    message.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            throw new UserError((Operator)this, e.getCause(), "sending_mail_to_address_error");
        }
        catch (IOException eIO) {
            throw new UserError((Operator)this, eIO.getCause(), "sending_mail_to_address_error");
        }
        this.throughExtender.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeConfigurable type = new ParameterTypeConfigurable(PARAMETER_CONNECTION, "The connection to use for sending the mail.", "MailConnection");
        type.setExpert(false);
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_RECIPIENT, "Recipient of this mail", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeEnumeration(PARAMETER_RECIPIENT_OPTIONAL, "Additional Recipients of this mail", (ParameterType)new ParameterTypeString("additional_Recipions", "Additional Recipient for this mail"));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_RECIPIENT_CC, "Recipients that recieve a copy of this mail", true, false));
        type = new ParameterTypeEnumeration(PARAMETER_RECIPIENT_CC_OPTIONAL, "Additional Recipients that recieve a copy of this mail", (ParameterType)new ParameterTypeString("additional_Recipions", "Additional Recipient for this mail"));
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_RECIPIENT_BCC, "Recipient that recieve a blind copy of this mail", true, false));
        type = new ParameterTypeEnumeration(PARAMETER_RECIPIENT_BCC_OPTIONAL, "Additional Recipients that recieve a blind copy of this mail", (ParameterType)new ParameterTypeString("additional_Recipions", "Additional Recipient for this mail"));
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_SUBJECT, "Subject of the mail", false, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_USE_HTML, "Format Content as HTML?", false, false));
        type = new ParameterTypeText(PARAMETER_CONTENT_PLAIN, "Main Content of the email", TextType.PLAIN, false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_HTML, false, false));
        type.setExpert(false);
        types.add((ParameterType)type);
        type = new ParameterTypeText(PARAMETER_CONTENT_HTML, "Main Content of the email in HTML format", TextType.HTML, "<html>\n\t<head>\n\t\t<title>RapidMiner Email</title>\n\t</head>\n\t<body>\n\t\t<p>\n\t\t</p>\n\t</body>\n</html>\n");
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_HTML, false, true));
        type.setExpert(false);
        types.add((ParameterType)type);
        type = new ParameterTypeList(PARAMETER_HEADERS, "Additional mail headers", (ParameterType)new ParameterTypeString("header", "Name of the header"), (ParameterType)new ParameterTypeString("value", "value of the header"));
        type.setExpert(true);
        types.add((ParameterType)type);
        type = new ParameterTypeEnumeration(PARAMETER_FILE_NAMES, "Names of provided attachments", (ParameterType)new ParameterTypeString(PARAMETER_FILE_NAME, "File Name for the provided attachment"));
        type.setExpert(false);
        types.add((ParameterType)type);
        return types;
    }

    private Session createSession() throws UserError {
        try {
            MailConnectionConfigurable config = (MailConnectionConfigurable)ConfigurationManager.getInstance().lookup("MailConnection", this.getParameterAsString(PARAMETER_CONNECTION), this.getProcess().getRepositoryAccessor());
            Session session = config.createSession();
            return session;
        }
        catch (ConfigurationException e) {
            throw new UserError((Operator)this, (Throwable)e, "mail.configuration_exception");
        }
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitAdvancedReportingExtension.PRODUCT_INFORMATION;
    }
}

