/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.reporting;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.operator.reporting.ExcelCellRange;
import com.owc.operator.reporting.OpenExcelReportOperator;
import com.rapidminer.extension.PluginInitAdvancedReportingExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.preprocessing.filter.AbstractDateDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.tools.Tools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class WriteExcelReportCellOperator
extends LicensedOperator {
    public static final String PARAMETER_SHEET = "sheet";
    public static final String PARAMETER_FILL_POSITION = "fill_position";
    public static final String PARAMETER_VALUE_TYPE = "value_and_type";
    public static final String PARAMETER_VALUE = "value";
    public static final String PARAMETER_TYPE = "type";
    public static final String PARAMETER_ADDITIONAL_VALUES = "additional_values";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_TIME_ZONE = "time_zone";
    public static final String PARAMETER_LOCALE = "locale";
    public static final String[] TYPES = new String[]{"Real", "String", "Timestamp"};
    private PortPairExtender throughPairExtender = new PortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public WriteExcelReportCellOperator(OperatorDescription description) {
        super(description);
        this.throughPairExtender.start();
        this.getTransformer().addRule(this.throughPairExtender.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        SimpleDateFormat format;
        String[] enumerations;
        LinkedList<ExcelCellRange> positions = new LinkedList<ExcelCellRange>();
        LinkedList<String> values = new LinkedList<String>();
        LinkedList<Integer> types = new LinkedList<Integer>();
        if (this.isParameterSet(PARAMETER_FILL_POSITION) || this.isParameterSet(PARAMETER_VALUE_TYPE)) {
            try {
                positions.add(new ExcelCellRange(this.getParameterAsString(PARAMETER_FILL_POSITION)));
            }
            catch (IllegalArgumentException e) {
                throw new UserError((Operator)this, (Throwable)e, "reporting.invalid_excel_range");
            }
            String[] tupel = ParameterTypeTupel.transformString2Tupel((String)this.getParameterAsString(PARAMETER_VALUE_TYPE));
            try {
                types.add(Arrays.binarySearch(TYPES, tupel[0]));
            }
            catch (NumberFormatException e) {
                throw new UserError((Operator)this, 225, new Object[]{PARAMETER_TYPE, tupel[0]});
            }
            values.add(tupel[1]);
        }
        for (String enumeration : enumerations = ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_ADDITIONAL_VALUES))) {
            String[] tupel = ParameterTypeTupel.transformString2Tupel((String)enumeration);
            try {
                positions.add(new ExcelCellRange(tupel[0]));
            }
            catch (IllegalArgumentException e) {
                throw new UserError((Operator)this, (Throwable)e, "reporting.invalid_excel_range");
            }
            try {
                types.add(Arrays.binarySearch(TYPES, tupel[1]));
            }
            catch (NumberFormatException e) {
                throw new UserError((Operator)this, 225, new Object[]{PARAMETER_TYPE, tupel[0]});
            }
            values.add(tupel[2]);
        }
        try {
            String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
            int localeIndex = this.getParameterAsInt(PARAMETER_LOCALE);
            Locale selectedLocale = Locale.US;
            if (localeIndex >= 0 && localeIndex < AbstractDateDataProcessing.availableLocales.size()) {
                selectedLocale = (Locale)AbstractDateDataProcessing.availableLocales.get(this.getParameterAsInt(PARAMETER_LOCALE));
            }
            format = new SimpleDateFormat(dateFormat, selectedLocale);
        }
        catch (IllegalArgumentException e) {
            throw new UserError((Operator)this, (Throwable)e, "invalid_date_format", new Object[]{this.getParameterAsString(PARAMETER_DATE_FORMAT), e.getMessage()});
        }
        format.setTimeZone(Tools.getTimeZone((int)this.getParameterAsInt(PARAMETER_TIME_ZONE)));
        Sheet sheet = this.getWorkbookFromParent().getSheetAt(this.getParameterAsInt(PARAMETER_SHEET) - 1);
        Iterator positionsIterator = positions.iterator();
        Iterator typesIterator = types.iterator();
        Iterator valuesIterator = values.iterator();
        while (positionsIterator.hasNext()) {
            Cell cell;
            ExcelCellRange position = (ExcelCellRange)positionsIterator.next();
            Integer type = (Integer)typesIterator.next();
            String value = (String)valuesIterator.next();
            Row row = sheet.getRow(position.getRowOffset());
            if (row == null) {
                row = sheet.createRow(position.getRowOffset());
            }
            if ((cell = row.getCell(position.getColumnOffset())) == null) {
                cell = row.createCell(position.getColumnOffset());
            }
            if (type == 1) {
                cell.setCellValue(value);
                continue;
            }
            if (type == 0) {
                try {
                    cell.setCellValue(Double.parseDouble(value));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 211, new Object[]{PARAMETER_VALUE, value});
                }
            }
            try {
                Date date = format.parse(value);
                cell.setCellValue(date);
            }
            catch (ParseException e) {
                throw new UserError((Operator)this, 218, new Object[]{PARAMETER_VALUE, value});
            }
        }
        this.throughPairExtender.passDataThrough();
    }

    private Workbook getWorkbookFromParent() throws UserError {
        OperatorChain parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof OpenExcelReportOperator); parent = parent.getParent()) {
        }
        if (parent != null) {
            return ((OpenExcelReportOperator)parent).getWorkbook();
        }
        throw new UserError((Operator)this, "reporting.operator_misplaced");
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_SHEET, "The index of the sheet, counting starts from 1.", 1, 256, 1, false));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_FILL_POSITION, "Range where to fill in the data, e.g. B2:D25 or B2 for an open interval."));
        types.add((ParameterType)new ParameterTypeTupel(PARAMETER_VALUE_TYPE, "Specify the actual value and its type.", new ParameterType[]{new ParameterTypeCategory(PARAMETER_TYPE, "The value type", TYPES, 0), new ParameterTypeString(PARAMETER_VALUE, "The value to fill in. Will be parsed according to value type.")}));
        types.add((ParameterType)new ParameterTypeEnumeration(PARAMETER_ADDITIONAL_VALUES, "If you want to set more than one value in the template, you can add additional here.", (ParameterType)new ParameterTypeTupel(PARAMETER_VALUE_TYPE, "Specify the actual value and its type.", new ParameterType[]{new ParameterTypeString(PARAMETER_FILL_POSITION, "Range where to fill in the data, e.g. B2:D25 or B2 for an open interval."), new ParameterTypeCategory(PARAMETER_TYPE, "The value type", TYPES, 0), new ParameterTypeString(PARAMETER_VALUE, "The value to fill in. Will be parsed according to value type.")})));
        ParameterTypeDateFormat type = new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "The parse format of the date values, for example \"yyyy/MM/dd\".", false);
        type.setExpert(false);
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeCategory(PARAMETER_TIME_ZONE, "The time zone used for the date objects if not specified in the date string itself.", Tools.getAllTimeZones(), Tools.getPreferredTimeZoneIndex());
        types.add((ParameterType)type);
        type = new ParameterTypeCategory(PARAMETER_LOCALE, "The used locale for date texts, for example \"Wed\" (English) in contrast to \"Mi\" (German).", AbstractDateDataProcessing.availableLocaleNames, AbstractDateDataProcessing.defaultLocale);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitAdvancedReportingExtension.PRODUCT_INFORMATION;
    }
}

