/*
 * Decompiled with CFR 0.152.
 */
package com.owc.repository;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.ProgressListener;
import java.util.HashMap;

public class RepositoryAccessSynchronizationService {
    private static HashMap<String, Object> locationLocks = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void store(IOObject ioobject, RepositoryLocation location, Operator callingOperator, ProgressListener progressListener) throws RepositoryException {
        Object lock;
        String locationString = location.getAbsoluteLocation();
        Object object = locationLocks;
        synchronized (object) {
            lock = locationLocks.get(locationString);
            if (lock == null) {
                lock = new Object();
                locationLocks.put(locationString, lock);
            }
        }
        object = lock;
        synchronized (object) {
            Entry entry = location.locateEntry();
            if (entry == null) {
                Folder parentFolder;
                RepositoryLocation parentLocation = location.parent();
                if (parentLocation == null) throw new RepositoryException("Entry '" + location + "' does not exist.");
                HashMap<String, Object> hashMap = locationLocks;
                synchronized (hashMap) {
                    Entry parentEntry = parentLocation.locateEntry();
                    if (parentEntry != null) {
                        if (!(parentEntry instanceof Folder)) throw new RepositoryException("Parent '" + parentLocation + "' of '" + location + "' is not a folder.");
                        parentFolder = (Folder)parentEntry;
                    } else {
                        parentFolder = parentLocation.createFoldersRecursively();
                    }
                }
                String childName = location.getName();
                parentFolder.createIOObjectEntry(childName, ioobject, callingOperator, progressListener);
            } else {
                if (!(entry instanceof IOObjectEntry)) throw new RepositoryException("Entry '" + location + "' is not a data entry, but " + entry.getType());
                ((IOObjectEntry)entry).storeData(ioobject, callingOperator, null);
            }
            return;
        }
    }

    public Folder createFoldersRecursively(RepositoryLocation folderLocation) throws RepositoryException {
        HashMap<String, Object> hashMap = locationLocks;
        synchronized (hashMap) {
            Entry entry = folderLocation.locateEntry();
            if (entry == null) {
                Folder folder = this.createFoldersRecursively(folderLocation.parent());
                Folder child = folder.createFolder(folderLocation.getName());
                return child;
            }
            if (entry instanceof Folder) {
                return (Folder)entry;
            }
            throw new RepositoryException(this.toString() + " is not a folder.");
        }
    }
}

