/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.container.Pair;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang.NotImplementedException;

public class TimeTools {
    static ChronoUnit[] timeUnits = ChronoUnit.values();
    static String[] timeUnitNames = new String[timeUnits.length - 8];
    static int unitSecondsIndex = -1;

    private static int getUnitSecondsIndex() {
        if (unitSecondsIndex < 0) {
            int writeCount = 0;
            for (int i = 0; i < timeUnits.length; ++i) {
                if (timeUnits[i] == ChronoUnit.NANOS || timeUnits[i] == ChronoUnit.MICROS || timeUnits[i] == ChronoUnit.HALF_DAYS || timeUnits[i] == ChronoUnit.DECADES || timeUnits[i] == ChronoUnit.CENTURIES || timeUnits[i] == ChronoUnit.ERAS || timeUnits[i] == ChronoUnit.FOREVER || timeUnits[i] == ChronoUnit.MILLENNIA) continue;
                TimeTools.timeUnitNames[writeCount++] = timeUnits[i].name();
                if (timeUnits[i] != ChronoUnit.SECONDS) continue;
                unitSecondsIndex = i;
            }
        }
        return unitSecondsIndex;
    }

    public static String getShortForm(ChronoUnit chrono) {
        switch (chrono) {
            case DAYS: {
                return "d";
            }
            case HOURS: {
                return "h";
            }
            case MILLIS: {
                return "ms";
            }
            case MINUTES: {
                return "m";
            }
            case MONTHS: {
                return "M";
            }
            case SECONDS: {
                return "s";
            }
            case WEEKS: {
                return "w";
            }
            case YEARS: {
                return "y";
            }
        }
        return "";
    }

    public static ParameterType getOnlyUnitParameter(String key, String description, boolean expert) {
        return new ParameterTypeCategory(key, "Select time unit.", timeUnitNames, TimeTools.getUnitSecondsIndex(), expert);
    }

    public static ParameterType getTimeParameter(String key, String description, boolean optional, boolean expert) {
        ParameterTypeTupel type = new ParameterTypeTupel(key, description, new ParameterType[]{new ParameterTypeInt("time_value", "Set time value.", 0, Integer.MAX_VALUE, optional), new ParameterTypeCategory("Select_time_unit", "Select time unit.", timeUnitNames, TimeTools.getUnitSecondsIndex(), false)});
        type.setOptional(optional);
        type.setExpert(expert);
        return type;
    }

    public static ParameterType getTimeParameterWithNegatives(String key, String description, boolean optional, boolean expert) {
        ParameterTypeTupel type = new ParameterTypeTupel(key, description, new ParameterType[]{new ParameterTypeInt("time_value", "Set time value.", Integer.MIN_VALUE, Integer.MAX_VALUE, optional), new ParameterTypeCategory("Select_time_unit", "Select time unit.", timeUnitNames, TimeTools.getUnitSecondsIndex(), false)});
        type.setOptional(optional);
        type.setExpert(expert);
        return type;
    }

    public static ChronoUnit evaluateTimeUnitFromParameter(String key, Operator operator) throws UserError {
        String unit = operator.getParameterAsString(key);
        return ChronoUnit.valueOf(unit);
    }

    public static Pair<Integer, ChronoUnit> evaluateTimeTupelFromParameter(String key, String[] tupel, Operator operator) throws UserError {
        try {
            return new Pair((Object)Integer.parseInt(tupel[0]), (Object)ChronoUnit.valueOf(tupel[1]));
        }
        catch (NumberFormatException e) {
            throw new UserError(operator, (Throwable)e, "toolkit.illegal_numeric_parameter_value", new Object[]{key, tupel[0]});
        }
    }

    public static Pair<Integer, ChronoUnit> evaluateTimeParameter(String key, Operator operator) throws UserError {
        String[] tupel = ParameterTypeTupel.transformString2Tupel((String)operator.getParameterAsString(key));
        if (tupel[0] == null) {
            throw new UndefinedParameterError(key, operator);
        }
        return TimeTools.evaluateTimeTupelFromParameter(key, tupel, operator);
    }

    public static Pair<Integer, ChronoUnit> executeSubtraction(Pair<Integer, ChronoUnit> minuend, Pair<Integer, ChronoUnit> subtrahend) {
        if (!((ChronoUnit)minuend.getSecond()).equals(subtrahend.getSecond())) {
            throw new NotImplementedException();
        }
        return new Pair((Object)((Integer)minuend.getFirst() - (Integer)subtrahend.getFirst()), minuend.getSecond());
    }

    public static Pair<Integer, ChronoUnit> executeDivision(Pair<Integer, ChronoUnit> dividend, Pair<Integer, ChronoUnit> divisor) {
        if (!((ChronoUnit)dividend.getSecond()).equals(divisor.getSecond())) {
            throw new NotImplementedException();
        }
        return new Pair((Object)((Integer)dividend.getFirst() / (Integer)divisor.getFirst()), dividend.getSecond());
    }
}

