/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting;

import com.owc.gui.charting.PlotConfigurationError;
import com.rapidminer.tools.Tools;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class ConfigurationChangeResponse {
    private List<PlotConfigurationError> errorList = new LinkedList<PlotConfigurationError>();
    private List<PlotConfigurationError> warningList = new LinkedList<PlotConfigurationError>();
    private static final URL ERROR_ICON_URL = Tools.getResource((String)"icons/16/error.png");
    private static final URL WARNING_ICON_URL = Tools.getResource((String)"icons/16/sign_warning.png");

    public boolean hasErrors() {
        return !this.errorList.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warningList.isEmpty();
    }

    public boolean hasErrorsOrWarnings() {
        return !this.errorList.isEmpty() || !this.warningList.isEmpty();
    }

    public List<PlotConfigurationError> getErrors() {
        return this.errorList;
    }

    public List<PlotConfigurationError> getWarnings() {
        return this.warningList;
    }

    public void addError(PlotConfigurationError error) {
        this.errorList.add(error);
    }

    public void addWarning(PlotConfigurationError warning) {
        this.warningList.add(warning);
    }

    public void clearWarnings() {
        this.warningList.clear();
    }

    public void clearErrors() {
        this.errorList.clear();
    }

    public void append(ConfigurationChangeResponse other) {
        this.errorList.addAll(other.errorList);
        this.warningList.addAll(other.warningList);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.hasErrors()) {
            builder.append("### Errors:\n");
            for (PlotConfigurationError error : this.getErrors()) {
                builder.append(" - ");
                builder.append(error.getErrorName()).append("\n");
                builder.append(error.getErrorMessage()).append("\n");
                builder.append(error.getErrorDescription()).append("\n");
                builder.append("\n");
            }
            builder.append("\n");
        }
        if (this.hasWarnings()) {
            builder.append("### Warnings:\n");
            for (PlotConfigurationError warning : this.getWarnings()) {
                builder.append(" - ");
                builder.append(warning.getErrorName()).append("\n");
                builder.append(warning.getErrorMessage()).append("\n");
                builder.append(warning.getErrorDescription()).append("\n");
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public String toHtmlString() {
        StringBuilder builder = new StringBuilder();
        if (this.hasErrors()) {
            builder.append("<div style=\"color:#cc0000;\">");
            for (PlotConfigurationError error : this.getErrors()) {
                builder.append("<img valign=\"middle\" style=\"vertical-align:middle;\" src=\"" + ERROR_ICON_URL + "\"/>&nbsp;");
                builder.append("<strong>");
                builder.append(error.getErrorName());
                builder.append("</strong>");
                builder.append("<br>");
                builder.append(error.getErrorMessage()).append("<br>");
                builder.append(error.getErrorDescription()).append("<br>");
            }
            builder.append("</div>");
        }
        if (this.hasWarnings()) {
            builder.append("<div style=\"color:#cc6600;\">");
            for (PlotConfigurationError warning : this.getWarnings()) {
                builder.append("<img valign=\"middle\" style=\"vertical-align:middle;\" src=\"" + WARNING_ICON_URL + "\"/>&nbsp;");
                builder.append("<strong>");
                builder.append(warning.getErrorName());
                builder.append("</strong>");
                builder.append("<br>");
                builder.append(warning.getErrorMessage()).append("<br>");
                builder.append(warning.getErrorDescription()).append("<br>");
            }
            builder.append("</div>");
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ConfigurationChangeResponse)) {
            return false;
        }
        ConfigurationChangeResponse other = (ConfigurationChangeResponse)obj;
        if (!other.getErrors().equals(this.errorList)) {
            return false;
        }
        return other.getWarnings().equals(this.warningList);
    }

    public boolean isEmpty() {
        return !this.hasErrors() && !this.hasWarnings();
    }
}

