/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.listener.DimensionConfigListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDimensionConfig
implements DimensionConfig,
Serializable {
    private static final long serialVersionUID = -7383928094390526708L;
    private final DimensionConfig.PlotDimension dimension;
    private boolean fireEvents = true;
    private transient List<WeakReference<DimensionConfigListener>> listeners = new LinkedList<WeakReference<DimensionConfigListener>>();

    public AbstractDimensionConfig(DimensionConfig.PlotDimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public DimensionConfig.PlotDimension getDimension() {
        return this.dimension;
    }

    @Override
    public void addDimensionConfigListener(DimensionConfigListener l) {
        this.listeners.add(new WeakReference<DimensionConfigListener>(l));
    }

    @Override
    public void removeDimensionConfigListener(DimensionConfigListener l) {
        Iterator<WeakReference<DimensionConfigListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            DimensionConfigListener listener = (DimensionConfigListener)it.next().get();
            if (listener != null && listener != l) continue;
            it.remove();
        }
    }

    protected void setFireEvents(boolean fireEvents) {
        this.fireEvents = fireEvents;
    }

    protected boolean isFiringEvents() {
        return this.fireEvents;
    }

    protected void fireDimensionConfigChanged(DimensionConfigChangeEvent e) {
        if (this.isFiringEvents()) {
            Iterator<WeakReference<DimensionConfigListener>> it = this.listeners.iterator();
            while (it.hasNext()) {
                DimensionConfigListener listener = (DimensionConfigListener)it.next().get();
                if (listener == null) {
                    it.remove();
                    continue;
                }
                listener.dimensionConfigChanged(e);
            }
        }
    }
}

