/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.listener.AggregationWindowingListener;
import com.owc.gui.charting.utility.AggregatedValueRange;
import com.owc.gui.charting.utility.ValueRange;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class AggregationWindowing
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7787371700655432416L;
    private int grabLeft = 0;
    private int grabRight = 0;
    private boolean includeIncompleteGroups = true;
    private List<AggregationWindowingListener> listeners = new LinkedList<AggregationWindowingListener>();

    public AggregationWindowing(int grabLeft, int grabRight, boolean includeIncompleteGroups) {
        this.grabLeft = grabLeft;
        this.grabRight = grabRight;
        this.includeIncompleteGroups = includeIncompleteGroups;
    }

    public int getGrabLeft() {
        return this.grabLeft;
    }

    public void setGrabLeft(int grabLeft) {
        if (grabLeft != this.grabLeft) {
            this.grabLeft = grabLeft;
            this.fireAggregationWindowingChanged();
        }
    }

    public int getGrabRight() {
        return this.grabRight;
    }

    public void setGrabRight(int grabRight) {
        if (grabRight != this.grabRight) {
            this.grabRight = grabRight;
            this.fireAggregationWindowingChanged();
        }
    }

    public boolean isIncludingIncompleteGroups() {
        return this.includeIncompleteGroups;
    }

    public void setIncludeIncompleteGroups(boolean includeIncompleteGroups) {
        if (includeIncompleteGroups != this.includeIncompleteGroups) {
            this.includeIncompleteGroups = includeIncompleteGroups;
            this.fireAggregationWindowingChanged();
        }
    }

    public List<ValueRange> applyOnGrouping(List<ValueRange> grouping) {
        if (this.grabLeft == 0 && this.grabRight == 0) {
            return grouping;
        }
        LinkedList<ValueRange> leftGrabbedList = new LinkedList<ValueRange>();
        LinkedList<ValueRange> rightGrabbedList = new LinkedList<ValueRange>();
        LinkedList<ValueRange> cumulatedGrouping = new LinkedList<ValueRange>();
        ValueRange currentRange = null;
        for (ValueRange range : grouping) {
            rightGrabbedList.add(range);
            if (currentRange != null) {
                leftGrabbedList.add(currentRange);
                if (this.grabLeft > -1 && leftGrabbedList.size() > this.grabLeft) {
                    leftGrabbedList.removeFirst();
                }
            }
            if (this.grabRight > -1 && rightGrabbedList.size() > this.grabRight) {
                currentRange = (ValueRange)rightGrabbedList.removeFirst();
            }
            boolean addAggregatedRange = false;
            if (currentRange != null) {
                if (this.includeIncompleteGroups) {
                    addAggregatedRange = true;
                } else if (this.grabLeft == -1) {
                    addAggregatedRange = true;
                } else if (leftGrabbedList.size() >= this.grabLeft) {
                    addAggregatedRange = true;
                }
            }
            if (addAggregatedRange) {
                AggregatedValueRange aggregatedRange = this.createAggregatedRange(leftGrabbedList, rightGrabbedList, currentRange);
                cumulatedGrouping.add(aggregatedRange);
                continue;
            }
            if (currentRange == null) continue;
            cumulatedGrouping.add(null);
        }
        if (this.includeIncompleteGroups || this.grabRight == -1) {
            while (!rightGrabbedList.isEmpty()) {
                if (currentRange != null) {
                    leftGrabbedList.add(currentRange);
                }
                currentRange = (ValueRange)rightGrabbedList.removeFirst();
                if (this.grabLeft > -1 && leftGrabbedList.size() > this.grabLeft) {
                    leftGrabbedList.removeFirst();
                }
                cumulatedGrouping.add(this.createAggregatedRange(leftGrabbedList, rightGrabbedList, currentRange));
            }
        } else {
            while (cumulatedGrouping.size() < grouping.size()) {
                cumulatedGrouping.add(null);
            }
        }
        return cumulatedGrouping;
    }

    private AggregatedValueRange createAggregatedRange(LinkedList<ValueRange> leftGrabbedList, LinkedList<ValueRange> rightGrabbedList, ValueRange currentRange) {
        AggregatedValueRange aggregatedRange = new AggregatedValueRange();
        aggregatedRange.addSubRange(currentRange);
        for (ValueRange subRange : leftGrabbedList) {
            aggregatedRange.addSubRange(subRange);
        }
        for (ValueRange subRange : rightGrabbedList) {
            aggregatedRange.addSubRange(subRange);
        }
        return aggregatedRange;
    }

    public void addAggregationWindowingListener(AggregationWindowingListener l) {
        this.listeners.add(l);
    }

    public void removeAggregationWindowingListener(AggregationWindowingListener l) {
        this.listeners.remove(l);
    }

    private void fireAggregationWindowingChanged() {
        for (AggregationWindowingListener l : this.listeners) {
            l.aggregationWindowingChanged(this);
        }
    }

    public AggregationWindowing clone() {
        return new AggregationWindowing(this.grabLeft, this.grabRight, this.includeIncompleteGroups);
    }
}

