/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.LineFormatListener;
import com.owc.gui.charting.event.AxisParallelLineConfigurationChangeEvent;
import com.owc.gui.charting.listener.AxisParallelLineConfigurationListener;
import com.owc.gui.charting.listener.events.LineFormatChangeEvent;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AxisParallelLineConfiguration
implements LineFormatListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1183604211195507682L;
    private LineFormat format = new LineFormat();
    private boolean labelVisible = true;
    private double value;
    private transient List<WeakReference<AxisParallelLineConfigurationListener>> listeners = new LinkedList<WeakReference<AxisParallelLineConfigurationListener>>();

    public AxisParallelLineConfiguration(double value, boolean labelVisible) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (this.value != value) {
            this.value = value;
            this.fireAxisParallelLineConfigurationChanged(new AxisParallelLineConfigurationChangeEvent(this, value));
        }
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public LineFormat getFormat() {
        return this.format;
    }

    public void setLabelVisible(boolean labelVisible) {
        if (labelVisible != this.labelVisible) {
            this.labelVisible = labelVisible;
            this.fireAxisParallelLineConfigurationChanged(new AxisParallelLineConfigurationChangeEvent(this, labelVisible));
        }
    }

    @Override
    public void lineFormatChanged(LineFormatChangeEvent e) {
        this.fireAxisParallelLineConfigurationChanged(new AxisParallelLineConfigurationChangeEvent(this, e));
    }

    private void fireAxisParallelLineConfigurationChanged(AxisParallelLineConfigurationChangeEvent e) {
        Iterator<WeakReference<AxisParallelLineConfigurationListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            AxisParallelLineConfigurationListener l = (AxisParallelLineConfigurationListener)it.next().get();
            if (l != null) {
                l.axisParallelLineConfigurationChanged(e);
                continue;
            }
            it.remove();
        }
    }

    public AxisParallelLineConfiguration clone() {
        AxisParallelLineConfiguration clone = new AxisParallelLineConfiguration(this.value, this.labelVisible);
        clone.format = this.format.clone();
        return clone;
    }

    public String toString() {
        return "Line (value: " + this.value + ")";
    }

    public void addAxisParallelLineConfigurationListener(AxisParallelLineConfigurationListener l) {
        this.listeners.add(new WeakReference<AxisParallelLineConfigurationListener>(l));
    }

    public void removeAxisParallelLineConfigurationListener(AxisParallelLineConfigurationListener l) {
        Iterator<WeakReference<AxisParallelLineConfigurationListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            AxisParallelLineConfigurationListener listener = (AxisParallelLineConfigurationListener)it.next().get();
            if (l != null) {
                if (listener == null || !listener.equals(l)) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AxisParallelLineConfiguration)) {
            return false;
        }
        AxisParallelLineConfiguration line = (AxisParallelLineConfiguration)obj;
        if (!this.checkDoubleForEquality(this.getValue(), line.getValue())) {
            return false;
        }
        if (this.isLabelVisible() != line.isLabelVisible()) {
            return false;
        }
        if (!this.getFormat().getColor().equals(line.getFormat().getColor())) {
            return false;
        }
        if (!this.getFormat().getStyle().equals((Object)line.getFormat().getStyle())) {
            return false;
        }
        float floatEepsilon = 1.0E-5f;
        return !(Math.abs(this.getFormat().getWidth() - line.getFormat().getWidth()) > floatEepsilon);
    }

    private boolean checkDoubleForEquality(double expected, double actual) {
        if (expected == actual) {
            return true;
        }
        if (Double.isNaN(expected) && !Double.isNaN(actual)) {
            return false;
        }
        if (!Double.isNaN(expected) && Double.isNaN(actual)) {
            return false;
        }
        double MAX_RELATIVE_ERROR = 1.0E-9;
        double relativeError = Math.abs(actual) > Math.abs(expected) ? Math.abs((expected - actual) / actual) : Math.abs((expected - actual) / expected);
        return !(relativeError > 1.0E-9);
    }
}

