/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.tools.Ontology;
import java.io.Serializable;

public class DataTableColumn
implements Cloneable,
Serializable {
    private final String columnName;
    private final ValueType valueType;

    public DataTableColumn(String name, ValueType valueType) {
        this.columnName = name;
        this.valueType = valueType;
    }

    public DataTableColumn(DataTable dataTable, int columnIdx) {
        if (columnIdx >= 0 && columnIdx < dataTable.getColumnNumber()) {
            this.columnName = dataTable.getColumnName(columnIdx);
            this.valueType = dataTable.isDateTime(columnIdx) ? ValueType.DATE_TIME : (dataTable.isNominal(columnIdx) ? ValueType.NOMINAL : (dataTable.isNumerical(columnIdx) ? ValueType.NUMERICAL : ValueType.INVALID));
        } else {
            this.columnName = null;
            this.valueType = ValueType.INVALID;
        }
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isNominal() {
        return this.valueType == ValueType.NOMINAL;
    }

    public boolean isNumerical() {
        return this.valueType == ValueType.NUMERICAL;
    }

    public boolean isDate() {
        return this.valueType == ValueType.DATE_TIME;
    }

    public String getName() {
        return this.columnName;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableColumn)) {
            return false;
        }
        DataTableColumn other = (DataTableColumn)obj;
        if (this.valueType != other.valueType) {
            return false;
        }
        return this.columnName != null ? this.columnName.equals(other.columnName) : other.columnName == null;
    }

    public DataTableColumn clone() {
        return new DataTableColumn(this.getName(), this.getValueType());
    }

    public static int getColumnIndex(DataTable dataTable, String columnName, ValueType valueType) {
        int columnIdx = dataTable.getColumnIndex(columnName);
        if (columnIdx >= 0) {
            switch (valueType) {
                case NOMINAL: {
                    if (dataTable.isNominal(columnIdx)) break;
                    columnIdx = -1;
                    break;
                }
                case NUMERICAL: {
                    if (dataTable.isNumerical(columnIdx)) break;
                    columnIdx = -1;
                    break;
                }
                case DATE_TIME: {
                    if (dataTable.isDateTime(columnIdx)) break;
                    columnIdx = -1;
                    break;
                }
                case INVALID: {
                    break;
                }
            }
        }
        return columnIdx;
    }

    public boolean isValidForDataTable(DataTable dataTable) {
        int columnIdx = DataTableColumn.getColumnIndex(dataTable, this.columnName, this.valueType);
        return columnIdx >= 0 && this.valueType != ValueType.INVALID && this.columnName != null;
    }

    public static int getColumnIndex(DataTable dataTable, DataTableColumn dataTableColumn) {
        return DataTableColumn.getColumnIndex(dataTable, dataTableColumn.getName(), dataTableColumn.getValueType());
    }

    public static enum ValueType {
        INVALID,
        UNKNOWN,
        NOMINAL,
        NUMERICAL,
        DATE_TIME;


        public static int convertToRapidMinerOntology(ValueType valueType) {
            switch (valueType) {
                case DATE_TIME: {
                    return 9;
                }
                case INVALID: {
                    return 0;
                }
                case NUMERICAL: {
                    return 2;
                }
            }
            return 1;
        }

        public static ValueType convertFromRapidMinerOntology(int rmValueType) {
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(rmValueType, 2)) {
                return NUMERICAL;
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(rmValueType, 1)) {
                return NOMINAL;
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(rmValueType, 9)) {
                return DATE_TIME;
            }
            return INVALID;
        }
    }
}

