/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.configuration.AbstractDimensionConfig;
import com.owc.gui.charting.configuration.AxisParallelLinesConfiguration;
import com.owc.gui.charting.configuration.AxisParallelLinesConfigurationListener;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DistinctValueGrouping;
import com.owc.gui.charting.configuration.EquidistantFixedBinCountBinning;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.configuration.event.AxisParallelLinesConfigurationChangeEvent;
import com.owc.gui.charting.listener.DimensionConfigListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class DomainConfigManager
extends AbstractDimensionConfig
implements DimensionConfigListener,
Cloneable,
AxisParallelLinesConfigurationListener {
    private static final long serialVersionUID = -7868904538554504435L;
    private static final Sorting DEFAULT_SORTING_MODE = Sorting.ASCENDING;
    private DefaultDimensionConfig ungroupedMasterDimensionConfig;
    private DefaultDimensionConfig groupedMasterDimensionConfig;
    private PlotConfiguration plotConfiguration;
    private Sorting sortingMode = DEFAULT_SORTING_MODE;
    private AxisParallelLinesConfiguration crosshairLines = new AxisParallelLinesConfiguration();
    private final int id;

    public DomainConfigManager(PlotConfiguration plotConfiguration, DataTableColumn domainColumn) {
        super(DimensionConfig.PlotDimension.DOMAIN);
        if (plotConfiguration == null) {
            throw new IllegalArgumentException("null plotConfiguration not allowed.");
        }
        this.id = plotConfiguration.getNextId();
        this.plotConfiguration = plotConfiguration;
        this.ungroupedMasterDimensionConfig = new DefaultDimensionConfig(plotConfiguration, domainColumn, this.getDimension());
        this.groupedMasterDimensionConfig = new DefaultDimensionConfig(plotConfiguration, domainColumn, this.getDimension());
        try {
            this.groupedMasterDimensionConfig.setGrouping(new EquidistantFixedBinCountBinning(5, Double.NaN, Double.NaN, domainColumn, domainColumn.isNominal(), this.getDateFormat()));
        }
        catch (ChartConfigurationException e) {
            this.groupedMasterDimensionConfig.setGrouping(new DistinctValueGrouping(domainColumn, domainColumn.isNominal(), this.getDateFormat()));
        }
        this.groupedMasterDimensionConfig.addDimensionConfigListener(this);
        this.crosshairLines.addAxisParallelLinesConfigurationListener(this);
    }

    private DomainConfigManager(int id) {
        super(DimensionConfig.PlotDimension.DOMAIN);
        this.ungroupedMasterDimensionConfig = null;
        this.groupedMasterDimensionConfig = null;
        this.plotConfiguration = null;
        this.crosshairLines.addAxisParallelLinesConfigurationListener(this);
        this.id = id;
    }

    public DefaultDimensionConfig getDomainConfig(boolean grouped) {
        if (grouped) {
            return this.groupedMasterDimensionConfig;
        }
        return this.ungroupedMasterDimensionConfig;
    }

    public boolean isLogarithmicDomainAxis() {
        return this.groupedMasterDimensionConfig.isLogarithmic();
    }

    @Override
    public ValueRange getUserDefinedRangeClone(DataTable dataTable) {
        return this.groupedMasterDimensionConfig.getUserDefinedRangeClone(dataTable);
    }

    public DataTableColumn getDomainColumn() {
        return this.ungroupedMasterDimensionConfig.getDataTableColumn();
    }

    @Override
    public DimensionConfig.PlotDimension getDimension() {
        return DimensionConfig.PlotDimension.DOMAIN;
    }

    @Override
    public DataTableColumn getDataTableColumn() {
        return this.groupedMasterDimensionConfig.getDataTableColumn();
    }

    @Override
    public ValueGrouping getGrouping() {
        return this.groupedMasterDimensionConfig.getGrouping();
    }

    @Override
    public String getLabel() {
        return this.groupedMasterDimensionConfig.getLabel();
    }

    @Override
    public boolean isAutoRangeRequired() {
        return this.groupedMasterDimensionConfig.isAutoRangeRequired();
    }

    @Override
    public boolean isLogarithmic() {
        return this.groupedMasterDimensionConfig.isLogarithmic();
    }

    @Override
    public boolean isAutoNaming() {
        return this.groupedMasterDimensionConfig.isAutoNaming();
    }

    @Override
    public void setDataTableColumn(DataTableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException("Null Domain columns are not allowed");
        }
        if (column.isNominal() && this.groupedMasterDimensionConfig.getGrouping().getGroupingType() != ValueGrouping.GroupingType.DISTINCT_VALUES) {
            this.setFireEvents(false);
            try {
                this.setGrouping(ValueGrouping.ValueGroupingFactory.getValueGrouping(ValueGrouping.GroupingType.DISTINCT_VALUES, this.getDataTableColumn(), true, this.getDateFormat()));
            }
            catch (ChartConfigurationException e) {
                throw new RuntimeException("Could not create grouping. This should not happen");
            }
            this.setFireEvents(true);
        }
        this.ungroupedMasterDimensionConfig.setDataTableColumn(column);
        this.groupedMasterDimensionConfig.setDataTableColumn(column);
    }

    public Sorting getSortingMode() {
        return this.sortingMode;
    }

    public void setSortingMode(Sorting sortingMode) {
        if (sortingMode != this.sortingMode) {
            this.sortingMode = sortingMode;
            this.fireDimensionConfigChanged(new DimensionConfigChangeEvent((DimensionConfig)this, DimensionConfig.PlotDimension.DOMAIN, sortingMode));
        }
    }

    @Override
    public void setUserDefinedRange(NumericalValueRange range) {
        this.ungroupedMasterDimensionConfig.setUserDefinedRange(range);
        this.groupedMasterDimensionConfig.setUserDefinedRange(range);
    }

    @Override
    public void setLogarithmic(boolean logarithmic) {
        this.ungroupedMasterDimensionConfig.setLogarithmic(logarithmic);
        this.groupedMasterDimensionConfig.setLogarithmic(logarithmic);
    }

    @Override
    public void setAutoNaming(boolean autoNaming) {
        this.groupedMasterDimensionConfig.setAutoNaming(autoNaming);
    }

    @Override
    public void setLabel(String label) {
        this.groupedMasterDimensionConfig.setLabel(label);
    }

    @Override
    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errors = new LinkedList<PlotConfigurationError>();
        DataTableColumn dataTableColumn = this.getDataTableColumn();
        if (dataTableColumn.getName() == null || dataTableColumn.getName().isEmpty()) {
            PlotConfigurationError error = new PlotConfigurationError("undefined_dimension", DimensionConfig.PlotDimension.DOMAIN.getName());
            errors.add(error);
            return errors;
        }
        errors.addAll(this.groupedMasterDimensionConfig.getErrors());
        if (errors.size() > 0) {
            return errors;
        }
        errors.addAll(this.ungroupedMasterDimensionConfig.getErrors());
        return errors;
    }

    @Override
    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        warnings.addAll(this.groupedMasterDimensionConfig.getWarnings());
        if (warnings.size() > 0) {
            return warnings;
        }
        warnings.addAll(this.ungroupedMasterDimensionConfig.getWarnings());
        return warnings;
    }

    @Override
    public boolean isValid() {
        return this.getErrors().isEmpty();
    }

    @Override
    public DataTableColumn.ValueType getValueType() {
        DataTableColumn.ValueType valueType = DataTableColumn.ValueType.INVALID;
        List<ValueSource> allValueSources = this.plotConfiguration.getAllValueSources();
        if (allValueSources.isEmpty()) {
            if (this.isGrouping() && this.getDataTableColumn().getName().length() == 0) {
                return this.getGrouping().getDomainType();
            }
            return DataTableColumn.ValueType.UNKNOWN;
        }
        for (ValueSource valueSource : allValueSources) {
            DataTableColumn.ValueType currentValueType = valueSource.getDomainConfig().getValueType();
            if (currentValueType == valueType) continue;
            if (valueType == DataTableColumn.ValueType.INVALID) {
                valueType = currentValueType;
                continue;
            }
            return DataTableColumn.ValueType.INVALID;
        }
        return valueType;
    }

    @Override
    public boolean isNominal() {
        return this.getValueType() == DataTableColumn.ValueType.NOMINAL;
    }

    @Override
    public boolean isNumerical() {
        return this.getValueType() == DataTableColumn.ValueType.NUMERICAL;
    }

    @Override
    public boolean isDate() {
        return this.getValueType() == DataTableColumn.ValueType.DATE_TIME;
    }

    @Override
    public void setGrouping(ValueGrouping grouping) {
        this.groupedMasterDimensionConfig.setGrouping(grouping);
    }

    @Override
    public void setUpperBound(Double upperBound) {
        this.ungroupedMasterDimensionConfig.setUpperBound(upperBound);
        this.groupedMasterDimensionConfig.setUpperBound(upperBound);
    }

    @Override
    public void setLowerBound(Double lowerBound) {
        this.ungroupedMasterDimensionConfig.setLowerBound(lowerBound);
        this.groupedMasterDimensionConfig.setLowerBound(lowerBound);
    }

    @Override
    public Double getUserDefinedUpperBound() {
        return this.groupedMasterDimensionConfig.getUserDefinedUpperBound();
    }

    @Override
    public Double getUserDefinedLowerBound() {
        return this.groupedMasterDimensionConfig.getUserDefinedLowerBound();
    }

    @Override
    public boolean isGrouping() {
        for (ValueSource valueSource : this.plotConfiguration.getAllValueSources()) {
            if (!valueSource.isUsingDomainGrouping()) continue;
            return true;
        }
        return false;
    }

    public GroupingState getGroupingState() {
        int groupingCounter = 0;
        for (ValueSource valueSource : this.plotConfiguration.getAllValueSources()) {
            if (!valueSource.isUsingDomainGrouping()) continue;
            ++groupingCounter;
        }
        if (groupingCounter == this.plotConfiguration.getAllValueSources().size()) {
            return GroupingState.GROUPED;
        }
        if (groupingCounter > 0) {
            return GroupingState.PARTIALLY_GROUPED;
        }
        return GroupingState.UNGROUPED;
    }

    @Override
    public void dimensionConfigChanged(DimensionConfigChangeEvent change) {
        DimensionConfigChangeEvent domainManagerEvent;
        DimensionConfigChangeEvent.DimensionConfigChangeType type = change.getType();
        switch (type) {
            case ABOUT_TO_CHANGE_GROUPING: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), type);
                break;
            }
            case AUTO_NAMING: {
                domainManagerEvent = new DimensionConfigChangeEvent(this, change.getDimension(), change.getAutoNaming(), type);
                break;
            }
            case COLOR_PROVIDER: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), change.getColorProvider());
                break;
            }
            case COLOR_SCHEME: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), type);
                break;
            }
            case COLUMN: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), change.getDataTableColumn());
                break;
            }
            case CROSSHAIR_LINES_CHANGED: {
                domainManagerEvent = new DimensionConfigChangeEvent(this, change.getDimension(), change.getCrosshairLinesChange());
                break;
            }
            case DATE_FORMAT_CHANGED: {
                domainManagerEvent = new DimensionConfigChangeEvent(this, change.getDateFormat());
                break;
            }
            case GROUPING_CHANGED: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), change.getGroupingChangeEvent());
                break;
            }
            case LABEL: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), change.getLabel());
                break;
            }
            case RANGE: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), change.getValueRangeChangedEvent());
                break;
            }
            case RESET: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), type);
                break;
            }
            case SCALING: {
                domainManagerEvent = new DimensionConfigChangeEvent(this, change.getDimension(), change.getLogarithmic(), type);
                break;
            }
            case SHAPE_PROVIDER: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), change.getShapeProvider());
                break;
            }
            case SIZE_PROVIDER: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), change.getSizeProvider());
                break;
            }
            case SORTING: {
                domainManagerEvent = new DimensionConfigChangeEvent((DimensionConfig)this, change.getDimension(), change.getSortingMode());
                break;
            }
            default: {
                throw new IllegalArgumentException("Should not happen. Unknown event typ " + (Object)((Object)type));
            }
        }
        this.fireDimensionConfigChanged(domainManagerEvent);
    }

    @Override
    public Vector<ValueGrouping.GroupingType> getValidGroupingTypes() {
        ValueGrouping.GroupingType[] values = ValueGrouping.GroupingType.values();
        Vector<ValueGrouping.GroupingType> valueVector = new Vector<ValueGrouping.GroupingType>();
        for (int i = 0; i < values.length; ++i) {
            ValueGrouping.GroupingType type = values[i];
            if (this.getDataTableColumn().isNominal() && (type == ValueGrouping.GroupingType.EQUAL_DATA_FRACTION || type == ValueGrouping.GroupingType.EQUIDISTANT_FIXED_BIN_COUNT) || type == ValueGrouping.GroupingType.NONE) continue;
            valueVector.add(type);
        }
        return valueVector;
    }

    @Override
    public Set<DataTableColumn.ValueType> getSupportedValueTypes() {
        HashSet<DataTableColumn.ValueType> supportedTypes = new HashSet<DataTableColumn.ValueType>();
        supportedTypes.add(DataTableColumn.ValueType.NOMINAL);
        supportedTypes.add(DataTableColumn.ValueType.NUMERICAL);
        supportedTypes.add(DataTableColumn.ValueType.DATE_TIME);
        return supportedTypes;
    }

    @Override
    public boolean isUsingUserDefinedLowerBound() {
        return this.groupedMasterDimensionConfig.isUsingUserDefinedLowerBound();
    }

    @Override
    public boolean isUsingUserDefinedUpperBound() {
        return this.groupedMasterDimensionConfig.isUsingUserDefinedUpperBound();
    }

    @Override
    public void setUseUserDefinedUpperBound(boolean useUpperBound) {
        this.ungroupedMasterDimensionConfig.setUseUserDefinedUpperBound(useUpperBound);
        this.groupedMasterDimensionConfig.setUseUserDefinedUpperBound(useUpperBound);
    }

    @Override
    public void setUseUserDefinedLowerBound(boolean useLowerBound) {
        this.ungroupedMasterDimensionConfig.setUseUserDefinedLowerBound(useLowerBound);
        this.groupedMasterDimensionConfig.setUseUserDefinedLowerBound(useLowerBound);
    }

    public DomainConfigManager clone() {
        DomainConfigManager clone = new DomainConfigManager(this.getId());
        clone.plotConfiguration = this.plotConfiguration;
        clone.groupedMasterDimensionConfig = this.groupedMasterDimensionConfig.clone();
        clone.groupedMasterDimensionConfig.addDimensionConfigListener(clone);
        clone.ungroupedMasterDimensionConfig = this.ungroupedMasterDimensionConfig.clone();
        clone.crosshairLines = this.crosshairLines.clone();
        clone.sortingMode = this.sortingMode;
        return clone;
    }

    @Override
    public void colorSchemeChanged() {
        this.ungroupedMasterDimensionConfig.colorSchemeChanged();
        this.groupedMasterDimensionConfig.colorSchemeChanged();
    }

    public void setPlotConfiguration(PlotConfiguration plotConfiguration) {
        this.plotConfiguration = plotConfiguration;
    }

    @Override
    public void axisParallelLineConfigurationsChanged(AxisParallelLinesConfigurationChangeEvent e) {
        this.fireDimensionConfigChanged(new DimensionConfigChangeEvent(this, this.getDimension(), e));
    }

    public AxisParallelLinesConfiguration getCrosshairLines() {
        return this.crosshairLines;
    }

    @Override
    public DateFormat getDateFormat() {
        return this.groupedMasterDimensionConfig.getDateFormat();
    }

    @Override
    public void setUserDefinedDateFormatString(String formatString) {
        this.ungroupedMasterDimensionConfig.setUserDefinedDateFormatString(formatString);
        this.groupedMasterDimensionConfig.setUserDefinedDateFormatString(formatString);
    }

    @Override
    public String getUserDefinedDateFormatString() {
        return this.groupedMasterDimensionConfig.getUserDefinedDateFormatString();
    }

    @Override
    public void setUseUserDefinedDateFormat(boolean yes) {
        this.ungroupedMasterDimensionConfig.setUseUserDefinedDateFormat(yes);
        this.groupedMasterDimensionConfig.setUseUserDefinedDateFormat(yes);
    }

    @Override
    public boolean isUsingUserDefinedDateFormat() {
        return this.groupedMasterDimensionConfig.isUsingUserDefinedDateFormat();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void resetToDefaults() {
        DataTableColumn domainColumn = new DataTableColumn(null, DataTableColumn.ValueType.INVALID);
        this.setDataTableColumn(domainColumn);
        this.setSortingMode(DEFAULT_SORTING_MODE);
        while (!this.crosshairLines.getLines().isEmpty()) {
            this.crosshairLines.removeLine(this.crosshairLines.getLines().get(0));
        }
        this.setAutoNaming(true);
        try {
            this.setGrouping(new EquidistantFixedBinCountBinning(5, Double.NaN, Double.NaN, domainColumn, domainColumn.isNominal(), this.getDateFormat()));
        }
        catch (ChartConfigurationException e) {
            this.setGrouping(new DistinctValueGrouping(domainColumn, domainColumn.isNominal(), this.getDateFormat()));
        }
        this.setUserDefinedDateFormatString("dd.MM.yyyy HH:mm");
        this.setUseUserDefinedDateFormat(false);
        this.setUseUserDefinedLowerBound(false);
        this.setUseUserDefinedUpperBound(false);
        this.setLowerBound(0.0);
        this.setUpperBound(1.0);
        this.setLogarithmic(false);
    }

    public static enum GroupingState {
        GROUPED,
        UNGROUPED,
        PARTIALLY_GROUPED;

    }

    public static enum Sorting {
        NONE,
        ASCENDING;

    }
}

