/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.AxisParallelLinesConfiguration;
import com.owc.gui.charting.configuration.AxisParallelLinesConfigurationListener;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.configuration.event.AxisParallelLinesConfigurationChangeEvent;
import com.owc.gui.charting.listener.RangeAxisConfigListener;
import com.owc.gui.charting.listener.ValueRangeListener;
import com.owc.gui.charting.listener.ValueSourceListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.owc.gui.charting.listener.events.ValueSourceChangeEvent;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.ListUtility;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.tools.I18N;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;

public class RangeAxisConfig
implements ValueSourceListener,
ValueRangeListener,
Cloneable,
AxisParallelLinesConfigurationListener,
Serializable {
    private static final long serialVersionUID = 6205911966239423166L;
    private List<ValueSource> valueSourceList = new LinkedList<ValueSource>();
    private String name = "";
    private boolean autoNaming = false;
    private boolean logarithmicAxis = false;
    private NumericalValueRange userDefinedRange;
    private boolean useUserDefinedLowerBound;
    private boolean useUserDefinedUpperBound;
    private AxisParallelLinesConfiguration crosshairLines = new AxisParallelLinesConfiguration();
    public static final double padFactor = 0.05;
    public static final double logPadFactor = 0.15;
    private transient List<WeakReference<RangeAxisConfigListener>> listeners = new LinkedList<WeakReference<RangeAxisConfigListener>>();
    private final int Id;

    public RangeAxisConfig(String name, PlotConfiguration plotConfig) {
        this(name, plotConfig.getNextId());
    }

    private RangeAxisConfig(String name, int Id) {
        this.Id = Id;
        if (name == null) {
            this.autoNaming = true;
            this.setAutoLabelIfEnabled();
        } else {
            this.name = name;
        }
        this.userDefinedRange = new NumericalValueRange(0.0, 1.0, -1);
        this.userDefinedRange.addValueRangeListener(this);
        this.crosshairLines.addAxisParallelLinesConfigurationListener(this);
    }

    public String getLabel() {
        return this.name;
    }

    public void setLabel(String name) {
        if (name == null ? name != this.name : !name.equals(this.name)) {
            this.name = name;
            this.fireLabelChanged();
        }
    }

    public void addValueSource(int index, ValueSource valueSource, SeriesFormat seriesFormat) {
        StaticDebug.debug("RangeAxisConfig: ADDING VALUE SOURCE " + valueSource + " (id: " + valueSource.getId() + ") to RangeAxis with ID " + this.getId());
        if (seriesFormat != null) {
            valueSource.setSeriesFormat(seriesFormat);
        }
        this.valueSourceList.add(index, valueSource);
        valueSource.addValueSourceListener(this);
        this.setAutoLabelIfEnabled();
        this.fireAdded(index, valueSource);
        if (this.getValueType() == DataTableColumn.ValueType.DATE_TIME) {
            this.setUseUserDefinedLowerViewBound(false);
            this.setUseUserDefinedUpperViewBound(false);
        }
    }

    public void addValueSource(ValueSource valueSource, SeriesFormat seriesFormat) {
        this.addValueSource(this.valueSourceList.size(), valueSource, seriesFormat);
    }

    public void removeValueSource(ValueSource valueSource) {
        int idx = this.valueSourceList.indexOf(valueSource);
        this.removeValueSource(idx);
    }

    public void removeValueSource(int index) {
        ValueSource cachedValueSource = this.valueSourceList.get(index);
        cachedValueSource.removeValueSourceListener(this);
        this.valueSourceList.remove(index);
        this.setAutoLabelIfEnabled();
        this.fireRemoved(index, cachedValueSource);
        if (this.getValueType() == DataTableColumn.ValueType.DATE_TIME) {
            this.setUseUserDefinedLowerViewBound(false);
            this.setUseUserDefinedUpperViewBound(false);
        }
    }

    public void changeIndex(int index, ValueSource source) {
        if (ListUtility.changeIndex(this.valueSourceList, source, index)) {
            this.setAutoLabelIfEnabled();
            this.fireMoved(index, source);
        }
    }

    public List<ValueSource> getValueSources() {
        return this.valueSourceList;
    }

    public void addRangeAxisConfigListener(RangeAxisConfigListener l) {
        this.listeners.add(new WeakReference<RangeAxisConfigListener>(l));
    }

    public void removeRangeAxisConfigListener(RangeAxisConfigListener l) {
        Iterator<WeakReference<RangeAxisConfigListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            RangeAxisConfigListener listener = (RangeAxisConfigListener)it.next().get();
            if (listener != null && listener != l) continue;
            it.remove();
        }
    }

    public void clearValueSources() {
        for (ValueSource valueSource : this.valueSourceList) {
            valueSource.removeAllListeners();
        }
        this.valueSourceList.clear();
        this.setAutoLabelIfEnabled();
        this.fireCleared();
    }

    public DataTableColumn.ValueType getValueType() {
        DataTableColumn.ValueType valueType = DataTableColumn.ValueType.UNKNOWN;
        for (ValueSource valueSource : this.getValueSources()) {
            DataTableColumn.ValueType valueSourceValueType = valueSource.getValueType();
            if (valueSourceValueType == valueType) continue;
            if (valueType == DataTableColumn.ValueType.UNKNOWN) {
                valueType = valueSourceValueType;
                continue;
            }
            return DataTableColumn.ValueType.INVALID;
        }
        return valueType;
    }

    private void setAutoLabelIfEnabled() {
        if (this.isAutoNaming()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ValueSource valueSource : this.valueSourceList) {
                stringBuilder.append(valueSource.toString());
                stringBuilder.append(", ");
            }
            if (stringBuilder.toString().isEmpty()) {
                this.setLabel(I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.plotter.configuration_dialog.empty_dimension.label", (Object[])new Object[0]));
            } else {
                this.setLabel(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 2));
            }
        }
    }

    public boolean hasAbsolutStackedPlot() {
        for (ValueSource valueSource : this.valueSourceList) {
            SeriesFormat.VisualizationType seriesType = valueSource.getSeriesFormat().getSeriesType();
            if (seriesType != SeriesFormat.VisualizationType.BARS && seriesType != SeriesFormat.VisualizationType.AREA || valueSource.getSeriesFormat().getStackingMode() != SeriesFormat.StackingMode.ABSOLUTE) continue;
            return true;
        }
        return false;
    }

    public ValueSource getValueSourceById(int id) {
        for (ValueSource valueSource : this.getValueSources()) {
            if (valueSource.getId() != id) continue;
            return valueSource;
        }
        return null;
    }

    public boolean isAutoNaming() {
        return this.autoNaming;
    }

    public void setAutoNaming(boolean autoName) {
        if (autoName != this.autoNaming) {
            this.autoNaming = autoName;
            this.setAutoLabelIfEnabled();
            this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, RangeAxisConfigChangeEvent.RangeAxisConfigChangeType.AUTO_NAMING, autoName));
        }
    }

    public void setUseUserDefinedUpperViewBound(boolean useUpperBound) {
        if (this.useUserDefinedUpperBound != useUpperBound) {
            this.useUserDefinedUpperBound = useUpperBound;
            this.fireValueRangeChanged(new ValueRangeChangeEvent((ValueRange)this.userDefinedRange, ValueRangeChangeEvent.ValueRangeChangeType.USE_UPPER_BOUND, useUpperBound));
        }
    }

    public boolean isUsingUserDefinedUpperViewBound() {
        return this.useUserDefinedUpperBound;
    }

    public void setUseUserDefinedLowerViewBound(boolean useLowerBound) {
        if (this.useUserDefinedLowerBound != useLowerBound) {
            this.useUserDefinedLowerBound = useLowerBound;
            this.fireValueRangeChanged(new ValueRangeChangeEvent((ValueRange)this.userDefinedRange, ValueRangeChangeEvent.ValueRangeChangeType.USE_LOWER_BOUND, useLowerBound));
        }
    }

    public boolean isUsingUserDefinedLowerViewBound() {
        return this.useUserDefinedLowerBound;
    }

    public int getSize() {
        return this.valueSourceList.size();
    }

    public NumericalValueRange getUserDefinedRange() {
        return this.userDefinedRange;
    }

    private void fireCleared() {
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this));
    }

    private void fireMoved(int index, ValueSource valueSource) {
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, RangeAxisConfigChangeEvent.RangeAxisConfigChangeType.VALUE_SOURCE_MOVED, valueSource, index));
    }

    private void fireAdded(int index, ValueSource valueSource) {
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, RangeAxisConfigChangeEvent.RangeAxisConfigChangeType.VALUE_SOURCE_ADDED, valueSource, index));
    }

    private void fireRemoved(int index, ValueSource valueSource) {
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, RangeAxisConfigChangeEvent.RangeAxisConfigChangeType.VALUE_SOURCE_REMOVED, valueSource, index));
    }

    private void fireLabelChanged() {
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, this.getLabel()));
    }

    private void fireAxisScalingChanged() {
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, RangeAxisConfigChangeEvent.RangeAxisConfigChangeType.SCALING, this.logarithmicAxis));
    }

    private void fireValueRangeChanged(ValueRangeChangeEvent e) {
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, e));
    }

    private void fireRangeAxisChanged(RangeAxisConfigChangeEvent e) {
        Iterator<WeakReference<RangeAxisConfigListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            RangeAxisConfigListener listener = (RangeAxisConfigListener)it.next().get();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.rangeAxisConfigChanged(e);
        }
    }

    public boolean isLogarithmicAxis() {
        return this.logarithmicAxis;
    }

    public void setLogarithmicAxis(boolean logarithmicAxis) {
        if (logarithmicAxis != this.logarithmicAxis) {
            this.logarithmicAxis = logarithmicAxis;
            this.fireAxisScalingChanged();
        }
    }

    private void usageTypeToColumnMapChange() {
        this.setAutoLabelIfEnabled();
    }

    public void domainDimensionConfigChanged(DimensionConfigChangeEvent e) {
        this.setAutoLabelIfEnabled();
    }

    private void aggregationFunctionChanged() {
        this.setAutoLabelIfEnabled();
    }

    @Override
    public void valueSourceChanged(ValueSourceChangeEvent e) {
        switch (e.getType()) {
            case AGGREGATION_FUNCTION_MAP: {
                this.aggregationFunctionChanged();
                break;
            }
            case DATATABLE_COLUMN_MAP: {
                this.usageTypeToColumnMapChange();
                break;
            }
            case SERIES_FORMAT_CHANGED: {
                break;
            }
            case USES_GROUPING: {
                this.aggregationFunctionChanged();
                break;
            }
            case AGGREGATION_WINDOWING_CHANGED: {
                this.aggregationFunctionChanged();
                break;
            }
            case USE_RELATIVE_UTILITIES: {
                break;
            }
            case UPDATED: {
                break;
            }
            case LABEL: {
                this.setAutoLabelIfEnabled();
                break;
            }
        }
        if (this.getValueType() == DataTableColumn.ValueType.DATE_TIME) {
            this.setUseUserDefinedLowerViewBound(false);
            this.setUseUserDefinedUpperViewBound(false);
        }
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, e));
    }

    @Override
    public void valueRangeChanged(ValueRangeChangeEvent e) {
        this.fireValueRangeChanged(e);
    }

    public boolean mustHaveUpperBoundOne(double initialUpperBound) {
        int relativePlots = 0;
        for (ValueSource valueSource : this.valueSourceList) {
            SeriesFormat.VisualizationType seriesType = valueSource.getSeriesFormat().getSeriesType();
            if (seriesType != SeriesFormat.VisualizationType.BARS && seriesType != SeriesFormat.VisualizationType.AREA || valueSource.getSeriesFormat().getStackingMode() != SeriesFormat.StackingMode.RELATIVE) continue;
            ++relativePlots;
        }
        boolean onlyRelativePlots = relativePlots == this.valueSourceList.size();
        boolean hasRelativePlotsButUpperBoundBelowOne = relativePlots > 0 && initialUpperBound < 1.0;
        return onlyRelativePlots || hasRelativePlotsButUpperBoundBelowOne;
    }

    public RangeAxisConfig clone() {
        RangeAxisConfig clone = new RangeAxisConfig(this.name, this.Id);
        clone.autoNaming = this.autoNaming;
        clone.logarithmicAxis = this.logarithmicAxis;
        clone.crosshairLines = this.crosshairLines.clone();
        clone.userDefinedRange = this.userDefinedRange.clone();
        clone.userDefinedRange.addValueRangeListener(clone);
        clone.useUserDefinedLowerBound = this.useUserDefinedLowerBound;
        clone.useUserDefinedUpperBound = this.useUserDefinedUpperBound;
        for (ValueSource valueSource : this.valueSourceList) {
            clone.addValueSource(valueSource.clone(), null);
        }
        return clone;
    }

    public void setLowerViewBound(double lowerBound) {
        this.userDefinedRange.setLowerBound(lowerBound);
    }

    public void setUpperViewBound(double upperBound) {
        this.userDefinedRange.setUpperBound(upperBound);
    }

    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errors = new LinkedList<PlotConfigurationError>();
        String label = this.getLabel();
        if (label == null) {
            label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
        }
        if (this.getValueType() == DataTableColumn.ValueType.INVALID) {
            errors.add(new PlotConfigurationError("mixed_value_types_on_axis", label));
        }
        List<ValueSource> valueSources = this.getValueSources();
        if (this.getValueType() == DataTableColumn.ValueType.NOMINAL) {
            String columnName = null;
            for (ValueSource valueSource : valueSources) {
                String valueSourceColumnName = valueSource.getLabel();
                if (valueSourceColumnName == null) {
                    valueSourceColumnName = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
                }
                if (columnName == null) {
                    columnName = valueSourceColumnName;
                }
                if (columnName == null || columnName.equals(valueSourceColumnName)) continue;
                errors.add(new PlotConfigurationError("mixed_categories_on_axis", label));
                break;
            }
        }
        if (this.isUsingUserDefinedLowerViewBound() && this.isUsingUserDefinedUpperViewBound() && DataStructureUtils.greaterOrAlmostEqual(this.getUserDefinedRange().getLowerBound(), this.getUserDefinedRange().getUpperBound(), 1.0E-7)) {
            PlotConfigurationError error = new PlotConfigurationError("min_bound_greater_max_bound", this.getLabel());
            errors.add(error);
        }
        DataTableColumn.ValueType valueType = DataTableColumn.ValueType.UNKNOWN;
        for (ValueSource valueSource : valueSources) {
            DataTableColumn.ValueType valueSourceValueType = valueSource.getDomainConfigValueType();
            if (valueSourceValueType == valueType) continue;
            if (valueType == DataTableColumn.ValueType.UNKNOWN) {
                valueType = valueSourceValueType;
                continue;
            }
            PlotConfigurationError error = new PlotConfigurationError("mixed_domain_dimension_value_types_on_axis", this.getLabel());
            errors.add(error);
            break;
        }
        for (ValueSource valueSource : this.valueSourceList) {
            errors.addAll(valueSource.getErrors());
        }
        return errors;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        for (ValueSource valueSource : this.valueSourceList) {
            warnings.addAll(valueSource.getWarnings());
        }
        return warnings;
    }

    @Override
    public void axisParallelLineConfigurationsChanged(AxisParallelLinesConfigurationChangeEvent e) {
        this.fireCrosshairLinesChanged(e);
    }

    private void fireCrosshairLinesChanged(AxisParallelLinesConfigurationChangeEvent e) {
        this.fireRangeAxisChanged(new RangeAxisConfigChangeEvent(this, e));
    }

    public AxisParallelLinesConfiguration getCrossHairLines() {
        return this.crosshairLines;
    }

    public int getId() {
        return this.Id;
    }

    public String toString() {
        return String.valueOf(this.getLabel());
    }
}

