/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.listener.SeriesFormatListener;
import com.owc.gui.charting.listener.events.SeriesFormatChangeEvent;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.rapidminer.tools.I18N;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SeriesFormat
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9017496276535555468L;
    private ItemShape itemShape = ItemShape.CIRCLE;
    private double itemSize = 1.0;
    private Color itemColor = Color.GRAY;
    private FillStyle areaFillStyle = FillStyle.SOLID;
    private int opacity = 255;
    private StackingMode stackingMode = StackingMode.NONE;
    private VisualizationType seriesType = VisualizationType.LINES_AND_SHAPES;
    private IndicatorType utilityUsage = IndicatorType.NONE;
    private LineFormat lineFormat = new LineFormat();
    private List<WeakReference<SeriesFormatListener>> changedListenerList = new LinkedList<WeakReference<SeriesFormatListener>>();

    public Paint getAreaFillPaint() {
        return this.getAreaFillPaint(this.getItemColor());
    }

    public Paint getAreaFillPaint(Color color) {
        return this.areaFillPaintFactory(this.areaFillStyle, color);
    }

    public LineFormat.LineStyle getLineStyle() {
        return this.lineFormat.getStyle();
    }

    public void setLineStyle(LineFormat.LineStyle lineStyle) {
        if (lineStyle != this.getLineStyle()) {
            this.lineFormat.setStyle(lineStyle);
            this.fireChanged(new SeriesFormatChangeEvent(this, lineStyle));
        }
    }

    public ItemShape getItemShape() {
        return this.itemShape;
    }

    public void setItemShape(ItemShape itemShape) {
        if (itemShape != this.itemShape) {
            this.itemShape = itemShape;
            this.fireChanged(new SeriesFormatChangeEvent(this, itemShape));
        }
    }

    public double getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(double itemSize) {
        if (itemSize != this.itemSize) {
            this.itemSize = itemSize;
            this.fireChanged(new SeriesFormatChangeEvent(this, itemSize));
        }
    }

    public float getLineWidth() {
        return this.lineFormat.getWidth();
    }

    public void setLineWidth(float lineWidth) {
        if (lineWidth != this.lineFormat.getWidth()) {
            this.lineFormat.setWidth(lineWidth);
            this.fireChanged(new SeriesFormatChangeEvent(this, Float.valueOf(lineWidth)));
        }
    }

    public Color getItemColor() {
        return this.itemColor;
    }

    public void setItemColor(Color itemColor) {
        if (!(itemColor == null || this.itemColor != null && itemColor.equals(new Color(this.itemColor.getRed(), this.itemColor.getGreen(), this.itemColor.getBlue(), itemColor.getAlpha())))) {
            Color opacityItemColor;
            this.itemColor = opacityItemColor = new Color(itemColor.getRed(), itemColor.getGreen(), itemColor.getBlue(), this.opacity);
            this.fireChanged(new SeriesFormatChangeEvent(this, SeriesFormatChangeEvent.SeriesFormatChangeType.ITEM_COLOR, this.itemColor));
        }
    }

    public Color getLineColor() {
        return this.lineFormat.getColor();
    }

    public void setLineColor(Color lineColor) {
        Color currentColor = this.lineFormat.getColor();
        if (!(lineColor == null || currentColor != null && lineColor.equals(new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), lineColor.getAlpha())))) {
            Color opacityLineColor = new Color(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), this.opacity);
            this.lineFormat.setColor(opacityLineColor);
            this.fireChanged(new SeriesFormatChangeEvent(this, SeriesFormatChangeEvent.SeriesFormatChangeType.LINE_COLOR, currentColor));
        }
    }

    public FillStyle getAreaFillStyle() {
        return this.areaFillStyle;
    }

    public void setAreaFillStyle(FillStyle areaFillStyle) {
        if (areaFillStyle != this.areaFillStyle) {
            this.areaFillStyle = areaFillStyle;
            this.fireChanged(new SeriesFormatChangeEvent(this, areaFillStyle));
        }
    }

    public int getOpacity() {
        return this.opacity;
    }

    private Paint areaFillPaintFactory(FillStyle style, Color color) {
        if (this.areaFillStyle == FillStyle.NONE) {
            return new Color(0, 0, 0, 0);
        }
        if (this.areaFillStyle == FillStyle.SOLID) {
            return color;
        }
        int s = 10;
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(color);
        g2.setStroke(new BasicStroke(1.0f, 2, 0));
        if (this.areaFillStyle == FillStyle.FALLING_HATCHED) {
            g2.drawLine(0, 0, 10, 10);
            g2.drawLine(0, -10, 20, 10);
            g2.drawLine(-10, 0, 10, 20);
        } else if (this.areaFillStyle == FillStyle.RISING_HATCHED) {
            g2.drawLine(0, 10, 10, 0);
            g2.drawLine(-10, 10, 10, -10);
            g2.drawLine(0, 20, 20, 0);
        } else if (this.areaFillStyle == FillStyle.CROSS_HATCHED) {
            g2.drawLine(0, 10, 10, 0);
            g2.drawLine(0, 0, 10, 10);
        } else if (this.areaFillStyle == FillStyle.HORIZONTALLY_HATCHED) {
            g2.drawLine(0, 2, 10, 2);
            g2.drawLine(0, 7, 10, 7);
        } else if (this.areaFillStyle == FillStyle.VERTICALLY_HATCHED) {
            g2.drawLine(2, 0, 2, 10);
            g2.drawLine(7, 0, 7, 10);
        } else {
            throw new RuntimeException("Illegal area fill style: " + (Object)((Object)this.areaFillStyle) + ". This cannot happen");
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, rect);
        return texturePaint;
    }

    public void setOpacity(int opacity) {
        if (opacity != this.opacity) {
            this.itemColor = DataStructureUtils.setColorAlpha(this.itemColor, opacity);
            this.lineFormat.setColor(DataStructureUtils.setColorAlpha(this.lineFormat.getColor(), opacity));
            this.opacity = opacity;
            this.fireChanged(new SeriesFormatChangeEvent(this, opacity));
        }
    }

    public void addChangeListener(SeriesFormatListener listener) {
        this.changedListenerList.add(new WeakReference<SeriesFormatListener>(listener));
    }

    public void removeChangeListener(SeriesFormatListener listener) {
        Iterator<WeakReference<SeriesFormatListener>> it = this.changedListenerList.iterator();
        while (it.hasNext()) {
            SeriesFormatListener l = (SeriesFormatListener)it.next().get();
            if (l != null && listener != l) continue;
            it.remove();
        }
    }

    private void fireChanged(SeriesFormatChangeEvent e) {
        Iterator<WeakReference<SeriesFormatListener>> it = this.changedListenerList.iterator();
        while (it.hasNext()) {
            SeriesFormatListener listener = (SeriesFormatListener)it.next().get();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.seriesFormatChanged(e);
        }
    }

    public float getStrokeLength() {
        float[] dashArray = this.lineFormat.getScaledDashArray();
        if (dashArray != null) {
            float sum = 0.0f;
            for (float value : dashArray) {
                sum += value;
            }
            return sum;
        }
        return 0.0f;
    }

    public BasicStroke getStroke() {
        return this.lineFormat.getStroke();
    }

    public VisualizationType getSeriesType() {
        return this.seriesType;
    }

    public void setSeriesType(VisualizationType seriesType) {
        if (seriesType != this.seriesType) {
            this.seriesType = seriesType;
            this.fireChanged(new SeriesFormatChangeEvent(this, seriesType));
        }
    }

    public StackingMode getStackingMode() {
        return this.stackingMode;
    }

    public void setStackingMode(StackingMode stackingMode) {
        if (stackingMode != this.stackingMode) {
            this.stackingMode = stackingMode;
            this.fireChanged(new SeriesFormatChangeEvent(this, stackingMode));
        }
    }

    public IndicatorType getUtilityUsage() {
        return this.utilityUsage;
    }

    public void setUtilityUsage(IndicatorType errorIndicator) {
        if (errorIndicator != this.utilityUsage) {
            this.utilityUsage = errorIndicator;
            this.fireChanged(new SeriesFormatChangeEvent(this, errorIndicator));
        }
    }

    public static boolean calculateIndividualFormatForEachItem(DimensionConfig domainConfig, DimensionConfig dimensionConfig) {
        if (dimensionConfig == null) {
            return false;
        }
        if (dimensionConfig.isGrouping()) {
            return false;
        }
        return !domainConfig.isGrouping();
    }

    public static boolean useSeriesFormatFromDimensionConfig(DimensionConfig domainConfig, DimensionConfig dimensionConfig) {
        if (SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, dimensionConfig)) {
            return false;
        }
        if (dimensionConfig == null) {
            return false;
        }
        return dimensionConfig.isGrouping();
    }

    public SeriesFormat clone() {
        SeriesFormat clone = new SeriesFormat();
        clone.areaFillStyle = this.areaFillStyle;
        clone.utilityUsage = this.utilityUsage;
        clone.itemColor = this.itemColor;
        clone.itemShape = this.itemShape;
        clone.itemSize = this.itemSize;
        clone.lineFormat = this.lineFormat.clone();
        clone.opacity = this.opacity;
        clone.seriesType = this.seriesType;
        clone.stackingMode = this.stackingMode;
        return clone;
    }

    public static enum StackingMode {
        NONE(I18N.getGUILabel((String)"plotter.stacking_mode.none", (Object[])new Object[0])),
        ABSOLUTE(I18N.getGUILabel((String)"plotter.stacking_mode.absolute", (Object[])new Object[0])),
        RELATIVE(I18N.getGUILabel((String)"plotter.stacking_mode.percentage", (Object[])new Object[0]));

        private final String name;

        private StackingMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum VisualizationType {
        LINES_AND_SHAPES(I18N.getGUILabel((String)"plotter.series_type.lines_and_shapes", (Object[])new Object[0])),
        BARS(I18N.getGUILabel((String)"plotter.series_type.bars", (Object[])new Object[0])),
        AREA(I18N.getGUILabel((String)"plotter.series_type.area", (Object[])new Object[0]));

        private final String name;

        private VisualizationType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum FillStyle {
        NONE(I18N.getGUILabel((String)"plotter.fillstyle.NONE.label", (Object[])new Object[0])),
        SOLID(I18N.getGUILabel((String)"plotter.fillstyle.SOLID.label", (Object[])new Object[0])),
        CROSS_HATCHED(I18N.getGUILabel((String)"plotter.fillstyle.CROSS_HATCHED.label", (Object[])new Object[0])),
        RISING_HATCHED(I18N.getGUILabel((String)"plotter.fillstyle.RISING_HATCHED.label", (Object[])new Object[0])),
        FALLING_HATCHED(I18N.getGUILabel((String)"plotter.fillstyle.FALLING_HATCHED.label", (Object[])new Object[0])),
        VERTICALLY_HATCHED(I18N.getGUILabel((String)"plotter.fillstyle.VERTICALLY_HATCHED.label", (Object[])new Object[0])),
        HORIZONTALLY_HATCHED(I18N.getGUILabel((String)"plotter.fillstyle.HORIZONTALLY_HATCHED.label", (Object[])new Object[0]));

        private final String name;

        private FillStyle(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum IndicatorType {
        NONE(I18N.getGUILabel((String)"plotter.error_indicator.NONE.label", (Object[])new Object[0])),
        BARS(I18N.getGUILabel((String)"plotter.error_indicator.BARS.label", (Object[])new Object[0])),
        BAND(I18N.getGUILabel((String)"plotter.error_indicator.BAND.label", (Object[])new Object[0])),
        DIFFERENCE(I18N.getGUILabel((String)"plotter.error_indicator.DIFFERENCE.label", (Object[])new Object[0]));

        private final String name;

        private IndicatorType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ItemShape {
        NONE(null, I18N.getGUILabel((String)"plotter.dotstyle.NONE.label", (Object[])new Object[0])),
        CIRCLE(ItemShapeFactory.createCircle(), I18N.getGUILabel((String)"plotter.dotstyle.CIRCLE.label", (Object[])new Object[0])),
        SQUARE(ItemShapeFactory.createSquare(), I18N.getGUILabel((String)"plotter.dotstyle.SQUARE.label", (Object[])new Object[0])),
        DIAMOND(ItemShapeFactory.createDiamond(), I18N.getGUILabel((String)"plotter.dotstyle.DIAMOND.label", (Object[])new Object[0])),
        TRIANGLE(ItemShapeFactory.createTriangular(), I18N.getGUILabel((String)"plotter.dotstyle.TRIANGLE.label", (Object[])new Object[0])),
        TRIANGLE_UPSIDE_DOWN(ItemShapeFactory.createTurnedTriangular(), I18N.getGUILabel((String)"plotter.dotstyle.TRIANGLE_UPSIDE_DOWN.label", (Object[])new Object[0])),
        STAR(ItemShapeFactory.createStar(), I18N.getGUILabel((String)"plotter.dotstyle.STAR.label", (Object[])new Object[0])),
        HOURGLASS(ItemShapeFactory.createHourglass(), I18N.getGUILabel((String)"plotter.dotstyle.HOURGLASS.label", (Object[])new Object[0])),
        CROSSHAIRS(ItemShapeFactory.createCrosshairs(), I18N.getGUILabel((String)"plotter.dotstyle.CROSSHAIRS.label", (Object[])new Object[0]));

        private final Shape shape;
        private final String name;

        private ItemShape(Shape shape, String name) {
            this.shape = shape;
            this.name = name;
        }

        public Shape getShape() {
            return this.shape;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class ItemShapeFactory {
        private static final float SHAPE_SIZE = 7.5f;

        private ItemShapeFactory() {
        }

        public static Shape createSquare() {
            float s = 7.5f;
            float s_d2 = Math.round(3.75);
            float s_dm2 = s_d2 * 2.0f;
            return new Rectangle2D.Float(-s_d2, -s_d2, s_dm2, s_dm2);
        }

        public static Shape createCircle() {
            float s = 7.5f;
            float s_d2 = Math.round(3.75);
            float s_dm2 = s_d2 * 2.0f;
            return new Ellipse2D.Float(-s_d2, -s_d2, s_dm2, s_dm2);
        }

        public static Shape createDiamond() {
            float s = 7.5f;
            double d = Math.round(Math.sqrt(112.5) / 2.0);
            GeneralPath p = new GeneralPath();
            p.moveTo(0.0, d);
            p.lineTo(d, 0.0);
            p.lineTo(0.0, -d);
            p.lineTo(-d, 0.0);
            p.closePath();
            return p;
        }

        public static Shape createTriangular() {
            double s = 7.5;
            int s_2 = (int)Math.round(s / 2.0);
            int[] xPoints = new int[]{-s_2, 0, s_2};
            int[] yPoints = new int[]{s_2, -s_2, s_2};
            return new Polygon(xPoints, yPoints, xPoints.length);
        }

        public static Shape createTurnedTriangular() {
            double s = 7.5;
            int s_2 = (int)Math.round(s / 2.0);
            int[] xPoints = new int[]{-s_2, 0, s_2};
            int[] yPoints = new int[]{-s_2, s_2, -s_2};
            return new Polygon(xPoints, yPoints, xPoints.length);
        }

        public static Shape createCrosshairs() {
            double x = 0.0;
            double y = 0.0;
            double pointSize = 6.5;
            int[] xPoints = new int[]{(int)Math.ceil(x - pointSize / 6.0), (int)Math.ceil(x + pointSize / 6.0), (int)Math.ceil(x + pointSize / 6.0), (int)Math.ceil(x + pointSize / 2.0), (int)Math.ceil(x + pointSize / 2.0), (int)Math.ceil(x + pointSize / 6.0), (int)Math.ceil(x + pointSize / 6.0), (int)Math.ceil(x - pointSize / 6.0), (int)Math.ceil(x - pointSize / 6.0), (int)Math.ceil(x - pointSize / 2.0), (int)Math.ceil(x - pointSize / 2.0), (int)Math.ceil(x - pointSize / 6.0)};
            int[] yPoints = new int[]{(int)Math.ceil(y - pointSize / 2.0), (int)Math.ceil(y - pointSize / 2.0), (int)Math.ceil(y - pointSize / 6.0), (int)Math.ceil(y - pointSize / 6.0), (int)Math.ceil(y + pointSize / 6.0), (int)Math.ceil(y + pointSize / 6.0), (int)Math.ceil(y + pointSize / 2.0), (int)Math.ceil(y + pointSize / 2.0), (int)Math.ceil(y + pointSize / 6.0), (int)Math.ceil(y + pointSize / 6.0), (int)Math.ceil(y - pointSize / 6.0), (int)Math.ceil(y - pointSize / 6.0)};
            return new Polygon(xPoints, yPoints, xPoints.length);
        }

        public static Shape createHourglass() {
            Area area = new Area();
            area.add(new Area(ItemShapeFactory.createTriangular()));
            area.add(new Area(ItemShapeFactory.createTurnedTriangular()));
            return area;
        }

        public static Shape createStar() {
            int s_2 = (int)Math.round(3.0);
            AffineTransform t = new AffineTransform();
            t.translate(0.0, s_2);
            Area area = new Area();
            area.add(new Area(ItemShapeFactory.createTriangular()));
            area.add(new Area(t.createTransformedShape(ItemShapeFactory.createTurnedTriangular())));
            return area;
        }
    }
}

