/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.configuration;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.configuration.AggregationWindowing;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DomainConfigManager;
import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.listener.AggregationWindowingListener;
import com.owc.gui.charting.listener.SeriesFormatListener;
import com.owc.gui.charting.listener.ValueSourceListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.SeriesFormatChangeEvent;
import com.owc.gui.charting.listener.events.ValueSourceChangeEvent;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValueSource
implements AggregationWindowingListener,
SeriesFormatListener,
Serializable {
    private static final long serialVersionUID = -7543620346504862691L;
    private boolean useDomainGrouping;
    private SeriesFormat format;
    private Map<SeriesUsageType, DataTableColumn> dataTableColumnMap = new HashMap<SeriesUsageType, DataTableColumn>();
    private List<WeakReference<ValueSourceListener>> listeners = new LinkedList<WeakReference<ValueSourceListener>>();
    private Map<SeriesUsageType, AggregationFunction> aggregationFunctionMap = new HashMap<SeriesUsageType, AggregationFunction>();
    private Map<SeriesUsageType, AbstractAggregationFunction.AggregationFunctionType> aggregationFunctionTypeMap = new HashMap<SeriesUsageType, AbstractAggregationFunction.AggregationFunctionType>();
    private AggregationWindowing aggregationWindowing = new AggregationWindowing(0, 0, false);
    private boolean useRelativeUtilities = true;
    private String label;
    private boolean autoNaming;
    private final int Id;
    private DomainConfigManager domainConfigManager;

    public ValueSource(PlotConfiguration plotConfiguration, DataTableColumn mainDataTableColumn, AbstractAggregationFunction.AggregationFunctionType aggregationFunctionType, boolean grouped) {
        this(plotConfiguration.getDomainConfigManager(), mainDataTableColumn, aggregationFunctionType, grouped, plotConfiguration.getNextId());
    }

    private ValueSource(DomainConfigManager domainConfigManager, DataTableColumn mainDataTableColumn, AbstractAggregationFunction.AggregationFunctionType aggregationFunctionType, boolean grouped, int Id) {
        this.domainConfigManager = domainConfigManager;
        this.Id = Id;
        this.dataTableColumnMap.put(SeriesUsageType.MAIN_SERIES, mainDataTableColumn);
        this.setAggregationFunction(SeriesUsageType.MAIN_SERIES, aggregationFunctionType);
        this.setAggregationFunction(SeriesUsageType.INDICATOR_1, AbstractAggregationFunction.AggregationFunctionType.standard_deviation);
        this.setAggregationFunction(SeriesUsageType.INDICATOR_2, AbstractAggregationFunction.AggregationFunctionType.standard_deviation);
        this.aggregationWindowing.addAggregationWindowingListener(this);
        this.format = new SeriesFormat();
        this.format.addChangeListener(this);
        this.setUseDomainGrouping(grouped);
        this.setAutoNaming(true);
    }

    public AggregationFunction getAggregationFunction(SeriesUsageType usageType) {
        return this.aggregationFunctionMap.get((Object)usageType);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label == null ? label != this.label : !label.equals(this.label)) {
            this.label = label;
            this.fireValueSourceChanged(new ValueSourceChangeEvent(this, label));
        }
    }

    private void setAutoLabelIfEnabled() {
        if (this.isAutoNaming()) {
            this.setLabel(this.getAutoLabel());
        }
    }

    public boolean isAutoNaming() {
        return this.autoNaming;
    }

    public String getAutoLabel() {
        DataTableColumn dataTableColumn = this.getDataTableColumn(SeriesUsageType.MAIN_SERIES);
        if (dataTableColumn != null) {
            String label = dataTableColumn.getName();
            if (this.isUsingDomainGrouping()) {
                label = this.getAggregationFunctionType(SeriesUsageType.MAIN_SERIES) + "(" + label + ")";
            }
            return label;
        }
        return "-Empty-";
    }

    public void setAutoNaming(boolean autoName) {
        if (autoName != this.autoNaming) {
            this.autoNaming = autoName;
            this.setAutoLabelIfEnabled();
            this.fireValueSourceChanged(new ValueSourceChangeEvent(this, ValueSourceChangeEvent.ValueSourceChangeType.AUTO_NAMING, autoName));
        }
    }

    public void setDataTableColumn(SeriesUsageType seriesUsage, DataTableColumn dataTableColumn) throws ChartConfigurationException {
        DataTableColumn oldDataTableColumn = this.dataTableColumnMap.get((Object)seriesUsage);
        if (dataTableColumn != null && !dataTableColumn.equals(oldDataTableColumn)) {
            this.dataTableColumnMap.put(seriesUsage, dataTableColumn);
            this.fireUsageTypeToColumnMapChanged(dataTableColumn, seriesUsage);
            if (seriesUsage == SeriesUsageType.MAIN_SERIES) {
                this.setAutoLabelIfEnabled();
            }
        } else if (dataTableColumn == null && dataTableColumn != oldDataTableColumn) {
            if (seriesUsage == SeriesUsageType.MAIN_SERIES) {
                throw new ChartConfigurationException("remove_main_domain_column", new Object[0]);
            }
            this.dataTableColumnMap.remove((Object)seriesUsage);
            this.fireUsageTypeToColumnMapChanged(dataTableColumn, seriesUsage);
        }
    }

    public void setAggregationFunction(SeriesUsageType seriesUsage, AbstractAggregationFunction.AggregationFunctionType functionType) {
        if (functionType == null) {
            this.aggregationFunctionMap.remove((Object)seriesUsage);
            if (seriesUsage == SeriesUsageType.MAIN_SERIES) {
                this.setAutoLabelIfEnabled();
            }
            this.fireAggregationFunctionChanged(null, seriesUsage);
        } else {
            AggregationFunction currentFunction = this.aggregationFunctionMap.get((Object)seriesUsage);
            String currentFunctionName = null;
            if (currentFunction != null) {
                currentFunctionName = currentFunction.getName();
            }
            if (functionType.toString().equals(currentFunctionName)) {
                return;
            }
            AggregationFunction aggregationFunction = null;
            try {
                aggregationFunction = AbstractAggregationFunction.createAggregationFunction((String)functionType.toString());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unknown aggregation function type " + functionType);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unknown aggregation function type " + functionType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unknown aggregation function type " + functionType);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Unknown aggregation function type " + functionType);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Unknown aggregation function type " + functionType);
            }
            this.aggregationFunctionMap.put(seriesUsage, aggregationFunction);
            this.aggregationFunctionTypeMap.put(seriesUsage, functionType);
            if (seriesUsage == SeriesUsageType.MAIN_SERIES) {
                this.setAutoLabelIfEnabled();
            }
            this.fireAggregationFunctionChanged(aggregationFunction, seriesUsage);
        }
    }

    public boolean isNominal() {
        return this.getValueType() == DataTableColumn.ValueType.NOMINAL;
    }

    public DataTableColumn.ValueType getValueType(SeriesUsageType usageType) {
        if (!this.getDefinedUsageTypes().contains((Object)usageType)) {
            return DataTableColumn.ValueType.INVALID;
        }
        if (this.isUsingDomainGrouping()) {
            DataTableColumn.ValueType valueType = this.getDataTableColumn(usageType).getValueType();
            int rmInputValueType = DataTableColumn.ValueType.convertToRapidMinerOntology(valueType);
            int rmOutputValueType = this.getAggregationFunction(usageType).getValueTypeOfResult(rmInputValueType);
            DataTableColumn.ValueType valueTypeOfResult = DataTableColumn.ValueType.convertFromRapidMinerOntology(rmOutputValueType);
            return valueTypeOfResult;
        }
        DataTableColumn dataTableColumn = this.dataTableColumnMap.get((Object)usageType);
        return dataTableColumn.getValueType();
    }

    public DataTableColumn.ValueType getDomainConfigValueType() {
        return this.getDomainConfig().getValueType();
    }

    public DataTableColumn.ValueType getValueType() {
        return this.getValueType(SeriesUsageType.MAIN_SERIES);
    }

    public boolean isDate() {
        return this.getValueType() == DataTableColumn.ValueType.DATE_TIME;
    }

    public boolean isNumerical() {
        return this.getValueType() == DataTableColumn.ValueType.NUMERICAL;
    }

    public AbstractAggregationFunction.AggregationFunctionType getAggregationFunctionType(SeriesUsageType usageType) {
        AggregationFunction aggregationFunction = this.aggregationFunctionMap.get((Object)usageType);
        if (aggregationFunction != null) {
            return AbstractAggregationFunction.AggregationFunctionType.valueOf((String)aggregationFunction.getName());
        }
        return null;
    }

    public Set<SeriesUsageType> getDefinedUsageTypes() {
        return this.dataTableColumnMap.keySet();
    }

    public String toString() {
        if (this.label == null) {
            return I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
        }
        return this.getLabel();
    }

    public boolean useSeriesFormatForDimension(PlotConfiguration plotConfig, DimensionConfig.PlotDimension dimension) {
        DefaultDimensionConfig dimensionConfig = (DefaultDimensionConfig)plotConfig.getDimensionConfig(dimension);
        if (dimensionConfig == null) {
            return true;
        }
        return !dimensionConfig.isGrouping() && this.isUsingDomainGrouping();
    }

    public void addValueSourceListener(ValueSourceListener l) {
        this.listeners.add(new WeakReference<ValueSourceListener>(l));
    }

    public void removeValueSourceListener(ValueSourceListener l) {
        Iterator<WeakReference<ValueSourceListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            ValueSourceListener listener = (ValueSourceListener)it.next().get();
            if (listener != null && listener != l) continue;
            it.remove();
        }
    }

    public SeriesFormat getSeriesFormat() {
        return this.format;
    }

    public void setSeriesFormat(SeriesFormat format) {
        if (format != this.format) {
            if (this.format != null) {
                format.removeChangeListener(this);
            }
            this.format = format;
            if (format != null) {
                format.addChangeListener(this);
            }
        }
    }

    private void fireValueSourceChanged(ValueSourceChangeEvent e) {
        Iterator<WeakReference<ValueSourceListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            ValueSourceListener l = (ValueSourceListener)it.next().get();
            if (l != null) {
                l.valueSourceChanged(e);
                continue;
            }
            it.remove();
        }
    }

    private void fireAggregationFunctionChanged(AggregationFunction function, SeriesUsageType seriesUsage) {
        if (function != null) {
            this.fireValueSourceChanged(new ValueSourceChangeEvent(this, AbstractAggregationFunction.AggregationFunctionType.valueOf((String)function.getName()), seriesUsage));
        }
    }

    private void fireAggregationWindowingChanged() {
        this.fireValueSourceChanged(new ValueSourceChangeEvent(this, this.aggregationWindowing));
    }

    private void fireUsageTypeToColumnMapChanged(DataTableColumn column, SeriesUsageType seriesUsage) {
        this.fireValueSourceChanged(new ValueSourceChangeEvent(this, column, seriesUsage));
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public DefaultDimensionConfig getDomainConfig() {
        return this.domainConfigManager.getDomainConfig(this.useDomainGrouping);
    }

    @Override
    public void seriesFormatChanged(SeriesFormatChangeEvent e) {
        this.fireValueSourceChanged(new ValueSourceChangeEvent(this, e));
    }

    public boolean isUsingDomainGrouping() {
        return this.useDomainGrouping;
    }

    public void setUseDomainGrouping(boolean useDomainGrouping) {
        if (this.useDomainGrouping != useDomainGrouping) {
            this.useDomainGrouping = useDomainGrouping;
            this.setAutoLabelIfEnabled();
            this.fireValueSourceChanged(new ValueSourceChangeEvent(this, ValueSourceChangeEvent.ValueSourceChangeType.USES_GROUPING, useDomainGrouping));
        }
    }

    public void dimensionConfigChanged(DimensionConfigChangeEvent e) {
        switch (e.getType()) {
            case RESET: 
            case SORTING: 
            case COLUMN: 
            case GROUPING_CHANGED: 
            case RANGE: {
                this.fireValueSourceChanged(new ValueSourceChangeEvent(this));
                break;
            }
        }
    }

    public AggregationWindowing getAggregationWindowing() {
        return this.aggregationWindowing;
    }

    public void setAggregationWindowing(AggregationWindowing aggregationWindowing) {
        if (aggregationWindowing == null) {
            throw new IllegalArgumentException("null not allowed for aggregationWindowing");
        }
        if (this.aggregationWindowing != aggregationWindowing) {
            this.aggregationWindowing.removeAggregationWindowingListener(this);
            this.aggregationWindowing = aggregationWindowing;
            aggregationWindowing.addAggregationWindowingListener(this);
        }
    }

    @Override
    public void aggregationWindowingChanged(AggregationWindowing source) {
        this.fireAggregationWindowingChanged();
    }

    public boolean isUsingRelativeIndicator() {
        return this.useRelativeUtilities;
    }

    public void setUseRelativeUtilities(boolean relativeUtilities) {
        if (relativeUtilities != this.useRelativeUtilities) {
            this.useRelativeUtilities = relativeUtilities;
            this.fireValueSourceChanged(new ValueSourceChangeEvent(this, ValueSourceChangeEvent.ValueSourceChangeType.USE_RELATIVE_UTILITIES, relativeUtilities));
        }
    }

    public ValueSource clone() {
        ValueSource clone = new ValueSource(this.domainConfigManager, null, null, this.useDomainGrouping, this.Id);
        clone.setLabel(this.label);
        clone.setAutoNaming(this.autoNaming);
        clone.setSeriesFormat(this.format.clone());
        clone.useRelativeUtilities = this.useRelativeUtilities;
        clone.setAggregationWindowing(this.aggregationWindowing.clone());
        for (Map.Entry<SeriesUsageType, AbstractAggregationFunction.AggregationFunctionType> entry : this.aggregationFunctionTypeMap.entrySet()) {
            clone.setAggregationFunction(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<SeriesUsageType, Object> entry : this.dataTableColumnMap.entrySet()) {
            try {
                clone.setDataTableColumn(entry.getKey(), ((DataTableColumn)entry.getValue()).clone());
            }
            catch (ChartConfigurationException e) {
                throw new RuntimeException("this should not happen");
            }
        }
        return clone;
    }

    public DataTableColumn getDataTableColumn(SeriesUsageType seriesUsage) {
        return this.dataTableColumnMap.get((Object)seriesUsage);
    }

    public boolean doesAggregationFunctionSupportValueType(AggregationFunction function, DataTableColumn.ValueType valueType) {
        switch (valueType) {
            case DATE_TIME: {
                return function.supportsValueType(9);
            }
            case NOMINAL: {
                return function.supportsValueType(1);
            }
            case NUMERICAL: {
                return function.supportsValueType(2);
            }
            case INVALID: 
            case UNKNOWN: {
                return false;
            }
        }
        return false;
    }

    public List<PlotConfigurationError> getErrors() {
        DataTableColumn.ValueType seriesValueType;
        LinkedList<PlotConfigurationError> errors = new LinkedList<PlotConfigurationError>();
        if (this.useDomainGrouping) {
            for (SeriesUsageType usageType : this.getDefinedUsageTypes()) {
                DataTableColumn.ValueType valueType = this.getDataTableColumn(usageType).getValueType();
                AggregationFunction aggregationFunction = this.getAggregationFunction(usageType);
                if (this.doesAggregationFunctionSupportValueType(aggregationFunction, valueType)) continue;
                errors.add(new PlotConfigurationError("value_type_not_supported_by_aggregation", new Object[]{this.toString(), usageType, valueType, aggregationFunction.getName()}));
            }
        }
        DataTableColumn.ValueType valueType = this.getValueType();
        if (this.format.getUtilityUsage() != SeriesFormat.IndicatorType.NONE && this.getDefinedUsageTypes().contains((Object)SeriesUsageType.INDICATOR_1) && (seriesValueType = this.getValueType(SeriesUsageType.INDICATOR_1)) != valueType) {
            errors.add(new PlotConfigurationError("incompatible_utility_value_type", new Object[]{this.toString(), SeriesUsageType.INDICATOR_1, valueType, seriesValueType}));
        }
        if (this.format.getUtilityUsage() != SeriesFormat.IndicatorType.NONE && this.getDefinedUsageTypes().contains((Object)SeriesUsageType.INDICATOR_2) && this.format.getUtilityUsage() != SeriesFormat.IndicatorType.DIFFERENCE && (seriesValueType = this.getValueType(SeriesUsageType.INDICATOR_2)) != valueType) {
            errors.add(new PlotConfigurationError("incompatible_utility_value_type", new Object[]{this.toString(), SeriesUsageType.INDICATOR_2, valueType, seriesValueType}));
        }
        return errors;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        if (this.format.getSeriesType() == SeriesFormat.VisualizationType.LINES_AND_SHAPES) {
            if (this.format.getItemShape() == SeriesFormat.ItemShape.NONE && this.format.getLineStyle() == LineFormat.LineStyle.NONE && this.format.getUtilityUsage() == SeriesFormat.IndicatorType.NONE) {
                warnings.add(new PlotConfigurationError("invisible_format", this.toString()));
            } else if (this.format.getItemShape() == SeriesFormat.ItemShape.NONE && this.format.getAreaFillStyle() == SeriesFormat.FillStyle.NONE) {
                warnings.add(new PlotConfigurationError("invisible_format", this.toString()));
            }
        }
        if (this.format.getUtilityUsage() == SeriesFormat.IndicatorType.NONE) {
            if (this.getDataTableColumn(SeriesUsageType.INDICATOR_1) != null || this.getDataTableColumn(SeriesUsageType.INDICATOR_2) != null) {
                warnings.add(new PlotConfigurationError("unused_utility_series", this.toString(), SeriesFormat.IndicatorType.NONE.getName()));
            }
        } else if (this.format.getUtilityUsage() == SeriesFormat.IndicatorType.DIFFERENCE && this.getDataTableColumn(SeriesUsageType.INDICATOR_2) != null) {
            warnings.add(new PlotConfigurationError("unused_secondary_utility_series", this.toString(), SeriesFormat.IndicatorType.DIFFERENCE.getName()));
        }
        return warnings;
    }

    public boolean isSamplingSuggested() {
        return !this.isUsingDomainGrouping();
    }

    public int getId() {
        return this.Id;
    }

    void setDomainConfigManager(DomainConfigManager domainConfigManager) {
        this.domainConfigManager = domainConfigManager;
    }

    public static enum SeriesUsageType {
        MAIN_SERIES,
        INDICATOR_1,
        INDICATOR_2;

    }
}

