/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.configuration.DataTableColumn;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;

public class DataTableColumnIndex
implements DataTableListener {
    private int index = -1;
    private DataTableColumn dataTableColumn;
    private boolean upToDate = false;
    private DataTable dataTable;

    public DataTableColumnIndex(DataTableColumn dataTableColumn, DataTable dataTable) {
        this.dataTableColumn = dataTableColumn;
        this.dataTable = dataTable;
    }

    public DataTableColumn getDataTableColumn() {
        return this.dataTableColumn;
    }

    public void setDataTableColumn(DataTableColumn dataTableColumn) {
        if (dataTableColumn != this.dataTableColumn) {
            this.dataTableColumn = dataTableColumn;
            this.index = -1;
            this.upToDate = false;
        }
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public void setDataTable(DataTable dataTable) {
        if (dataTable != this.dataTable) {
            if (this.dataTable != null) {
                dataTable.removeDataTableListener((DataTableListener)this);
            }
            this.dataTable = dataTable;
            if (dataTable != null) {
                dataTable.addDataTableListener((DataTableListener)this, true);
            }
            this.invalidate();
        }
    }

    public int getIndex() {
        if (!this.upToDate) {
            this.update();
        }
        return this.index;
    }

    public void invalidate() {
        this.upToDate = false;
    }

    private void update() {
        this.index = DataTableColumn.getColumnIndex(this.dataTable, this.dataTableColumn);
        this.upToDate = true;
    }

    public void dataTableUpdated(DataTable source) {
        this.invalidate();
    }
}

