/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DomainConfigManager;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.listener.DimensionConfigListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableNaturalSortProvider;
import com.rapidminer.datatable.DataTableSortProvider;
import com.rapidminer.datatable.SortedDataTableView;
import java.util.LinkedList;
import java.util.List;

public class DomainConfigManagerData
implements DimensionConfigListener {
    private PlotInstance plotInstance;
    private DimensionConfigChangeEvent lastProcessedEvent = null;

    public DomainConfigManagerData(PlotInstance plotInstance) {
        if (plotInstance == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.plotInstance = plotInstance;
        this.applySorting();
    }

    public void applySorting() {
        SortedDataTableView dataTable = this.plotInstance.getPlotData().getSortedDataTableWithoutImplicitUpdate();
        DomainConfigManager domainConfigManager = this.plotInstance.getCurrentPlotConfigurationClone().getDomainConfigManager();
        switch (domainConfigManager.getSortingMode()) {
            case ASCENDING: {
                int columnIdx = DataTableColumn.getColumnIndex((DataTable)dataTable, domainConfigManager.getDataTableColumn());
                dataTable.setSortProvider((DataTableSortProvider)new DataTableNaturalSortProvider(columnIdx, true));
                break;
            }
            case NONE: {
                dataTable.setSortProvider(null);
            }
        }
    }

    @Override
    public void dimensionConfigChanged(DimensionConfigChangeEvent e) {
        if (e == null || e == this.lastProcessedEvent) {
            return;
        }
        this.lastProcessedEvent = e;
        switch (e.getType()) {
            case COLUMN: 
            case SORTING: {
                this.applySorting();
                break;
            }
        }
    }

    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errorList = new LinkedList<PlotConfigurationError>();
        DataTable dataTable = this.plotInstance.getPlotData().getOriginalDataTable();
        DomainConfigManager domainConfigManager = this.plotInstance.getCurrentPlotConfigurationClone().getDomainConfigManager();
        if (!domainConfigManager.getDataTableColumn().isValidForDataTable(dataTable)) {
            PlotConfigurationError error = new PlotConfigurationError("undefined_dimension", DimensionConfig.PlotDimension.DOMAIN.getName());
            errorList.add(error);
        }
        return errorList;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        return warnings;
    }

    public NumericalValueRange getEffectiveRange() {
        DomainConfigManager domainConfigManager = this.plotInstance.getCurrentPlotConfigurationClone().getDomainConfigManager();
        DefaultDimensionConfig domainConfig = domainConfigManager.getDomainConfig(domainConfigManager.isGrouping());
        DimensionConfigData domainData = this.plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        return domainData.getEffectiveRange();
    }
}

