/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.ValueSource;
import java.util.HashMap;
import java.util.Map;

public class GroupCellData {
    Map<ValueSource.SeriesUsageType, Map<DimensionConfig.PlotDimension, double[]>> dimensionToDataMap = new HashMap<ValueSource.SeriesUsageType, Map<DimensionConfig.PlotDimension, double[]>>();

    public Map<DimensionConfig.PlotDimension, double[]> getDataForUsageType(ValueSource.SeriesUsageType usageType) {
        return this.dimensionToDataMap.get((Object)usageType);
    }

    public void setDataForUsageType(ValueSource.SeriesUsageType usageType, Map<DimensionConfig.PlotDimension, double[]> data) {
        if (data != null) {
            this.dimensionToDataMap.put(usageType, data);
        } else {
            this.dimensionToDataMap.remove((Object)usageType);
        }
    }

    public int getSize() {
        Map<DimensionConfig.PlotDimension, double[]> mainData = this.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES);
        if (mainData == null) {
            return 0;
        }
        double[] domainData = mainData.get((Object)DimensionConfig.PlotDimension.DOMAIN);
        if (domainData == null) {
            return 0;
        }
        return domainData.length;
    }

    public Map<DimensionConfig.PlotDimension, double[]> initDataForUsageType(ValueSource.SeriesUsageType usageType, Iterable<DimensionConfig.PlotDimension> dimensions, int valueCount) {
        HashMap<DimensionConfig.PlotDimension, double[]> data = new HashMap<DimensionConfig.PlotDimension, double[]>();
        for (DimensionConfig.PlotDimension dimension : dimensions) {
            data.put(dimension, new double[valueCount]);
        }
        this.setDataForUsageType(usageType, data);
        return data;
    }
}

