/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.GroupCellData;
import com.owc.gui.charting.data.GroupCellKeyAndData;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GroupCellSeriesData
implements Iterable<GroupCellKeyAndData> {
    private List<GroupCellKeyAndData> groupCellSeriesData = new LinkedList<GroupCellKeyAndData>();

    public void addGroupCell(GroupCellKeyAndData groupCellKeyAndData) {
        this.groupCellSeriesData.add(groupCellKeyAndData);
    }

    public void clear() {
        this.groupCellSeriesData.clear();
    }

    public int groupCellCount() {
        return this.groupCellSeriesData.size();
    }

    public boolean isEmpty() {
        return this.groupCellSeriesData.isEmpty();
    }

    public Set<Double> getDistinctValues(ValueSource.SeriesUsageType usageType, DimensionConfig.PlotDimension dimension) {
        HashSet<Double> distinctValuesSet = new HashSet<Double>();
        for (GroupCellKeyAndData groupCellKeyAndData : this.groupCellSeriesData) {
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            for (double value : groupCellData.getDataForUsageType(usageType).get((Object)dimension)) {
                distinctValuesSet.add(value);
            }
        }
        return distinctValuesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Iterator<GroupCellKeyAndData> iterator() {
        Iterator<GroupCellKeyAndData> i = null;
        List<GroupCellKeyAndData> list = this.groupCellSeriesData;
        synchronized (list) {
            i = this.groupCellSeriesData.iterator();
        }
        return i;
    }

    public GroupCellKeyAndData getGroupCellKeyAndData(int seriesIdx) {
        return this.groupCellSeriesData.get(seriesIdx);
    }
}

