/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DomainConfigManager;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.data.DomainConfigManagerData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.RangeAxisData;
import com.owc.gui.charting.data.ValueSourceData;
import com.owc.gui.charting.listener.PlotConfigurationListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import com.owc.gui.charting.listener.events.ValueSourceChangeEvent;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.datatable.DataTableMappingProvider;
import com.rapidminer.datatable.FilteredDataTable;
import com.rapidminer.datatable.NominalSortingDataTableMapping;
import com.rapidminer.datatable.SortedDataTableView;
import com.rapidminer.datatable.ValueMappingDataTableView;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PlotData
implements DataTableListener,
PlotConfigurationListener {
    private final transient DataTable originalDataTable;
    private final transient ValueMappingDataTableView valueMappingDataTable;
    private final transient FilteredDataTable filteredDataTableView;
    private final transient SortedDataTableView sortedDataTableView;
    private transient DataTable cachedSampledDataTable = null;
    private transient boolean dataTableIsValid = false;
    private Map<Integer, DimensionConfigData> dimensionConfigDataMap = new HashMap<Integer, DimensionConfigData>();
    private Map<Integer, ValueSourceData> valueSourceDataMap = new HashMap<Integer, ValueSourceData>();
    private Map<Integer, RangeAxisData> rangeAxisDataMap = new HashMap<Integer, RangeAxisData>();
    private DomainConfigManagerData domainConfigManagerData;
    private PlotInstance plotInstance;
    private PlotConfigurationChangeEvent lastProcessedEvent = null;

    public PlotData(PlotInstance plotInstance, DataTable dataTable) {
        if (plotInstance == null) {
            throw new IllegalArgumentException("null not allowed for plotInstance");
        }
        this.plotInstance = plotInstance;
        plotInstance.setPlotData(this);
        PlotConfiguration plotConfiguration = plotInstance.getMasterPlotConfiguration();
        plotConfiguration.addPlotConfigurationListener(this, true);
        this.originalDataTable = dataTable;
        this.originalDataTable.addDataTableListener((DataTableListener)this, true);
        this.valueMappingDataTable = new ValueMappingDataTableView(this.originalDataTable);
        for (int i = 0; i < this.valueMappingDataTable.getColumnNumber(); ++i) {
            if (!this.valueMappingDataTable.isNominal(i)) continue;
            this.valueMappingDataTable.setMappingProvider(i, (DataTableMappingProvider)new NominalSortingDataTableMapping(this.valueMappingDataTable, i, true));
        }
        this.filteredDataTableView = new FilteredDataTable((DataTable)this.valueMappingDataTable);
        this.sortedDataTableView = new SortedDataTableView((DataTable)this.filteredDataTableView, null);
        this.sortedDataTableView.addDataTableListener((DataTableListener)this, true);
        for (ValueSource valueSource : plotConfiguration.getAllValueSources()) {
            ValueSourceData valueSourceData = new ValueSourceData(valueSource, plotInstance);
            this.valueSourceDataMap.put(valueSource.getId(), valueSourceData);
        }
        for (DefaultDimensionConfig dimensionConfig : plotConfiguration.getDefaultDimensionConfigs().values()) {
            DimensionConfigData dimensionConfigData = new DimensionConfigData(plotInstance, dimensionConfig);
            this.dimensionConfigDataMap.put(dimensionConfig.getId(), dimensionConfigData);
        }
        DefaultDimensionConfig domainConfig = plotConfiguration.getDomainConfigManager().getDomainConfig(true);
        this.dimensionConfigDataMap.put(domainConfig.getId(), new DimensionConfigData(plotInstance, domainConfig));
        domainConfig = plotConfiguration.getDomainConfigManager().getDomainConfig(false);
        this.dimensionConfigDataMap.put(domainConfig.getId(), new DimensionConfigData(plotInstance, domainConfig));
        this.domainConfigManagerData = new DomainConfigManagerData(plotInstance);
        for (RangeAxisConfig rangeAxisConfig : plotConfiguration.getRangeAxisConfigs()) {
            RangeAxisData rangeAxisData = new RangeAxisData(rangeAxisConfig, plotInstance);
            this.rangeAxisDataMap.put(rangeAxisConfig.getId(), rangeAxisData);
        }
        this.clearCache();
    }

    private void updateFilteredDataTable() {
        this.cachedSampledDataTable = null;
        LinkedList<ValueRange> dimensionRanges = new LinkedList<ValueRange>();
        for (DimensionConfig.PlotDimension dimension : DimensionConfig.PlotDimension.values()) {
            DimensionConfig dimConf = this.plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(dimension);
            if (dimConf == null || !dimConf.isUsingUserDefinedLowerBound() && !dimConf.isUsingUserDefinedUpperBound()) continue;
            ValueRange dimensionRange = dimConf.getUserDefinedRangeClone(this.filteredDataTableView.getParentTable());
            if (dimensionRange instanceof NumericalValueRange) {
                NumericalValueRange numericalDimensionRange = (NumericalValueRange)dimensionRange;
                if (!dimConf.isUsingUserDefinedLowerBound()) {
                    numericalDimensionRange.setLowerBound(Double.NEGATIVE_INFINITY);
                }
                if (!dimConf.isUsingUserDefinedUpperBound()) {
                    numericalDimensionRange.setUpperBound(Double.POSITIVE_INFINITY);
                }
            }
            if (dimensionRange == null) continue;
            dimensionRanges.add(dimensionRange);
        }
        this.filteredDataTableView.replaceConditions(dimensionRanges);
        this.dataTableIsValid = true;
    }

    public SortedDataTableView getDataTable() {
        if (!this.dataTableIsValid) {
            this.updateFilteredDataTable();
        }
        return this.sortedDataTableView;
    }

    public DataTable getDataTable(boolean sampled) {
        SortedDataTableView currentDataTable = this.getDataTable();
        if (!sampled) {
            return currentDataTable;
        }
        if (this.cachedSampledDataTable == null) {
            if (currentDataTable == null) {
                return null;
            }
            int maxRowCount = PlotConfiguration.getMaxAllowedValueCount();
            this.cachedSampledDataTable = currentDataTable.getRowNumber() <= maxRowCount ? currentDataTable : currentDataTable.sample(maxRowCount);
        }
        return this.cachedSampledDataTable;
    }

    public SortedDataTableView getSortedDataTableWithoutImplicitUpdate() {
        return this.sortedDataTableView;
    }

    public ValueMappingDataTableView getValueMappingDataTable() {
        return this.valueMappingDataTable;
    }

    public DataTable getOriginalDataTable() {
        return this.originalDataTable;
    }

    private void clearCache() {
        for (ValueSourceData valueSourceData : this.getValueSourcesData()) {
            valueSourceData.clearCache();
        }
        for (DimensionConfigData dimensionConfigData : this.dimensionConfigDataMap.values()) {
            dimensionConfigData.clearCache();
        }
        this.dataTableIsValid = false;
        this.cachedSampledDataTable = null;
    }

    public void dataTableUpdated(DataTable source) {
        if (source == this.originalDataTable) {
            this.clearCache();
        } else if (source == this.sortedDataTableView) {
            this.cachedSampledDataTable = null;
        }
    }

    public DimensionConfigData getDimensionConfigData(DefaultDimensionConfig dimensionConfig) {
        if (dimensionConfig != null) {
            int id = dimensionConfig.getId();
            return this.dimensionConfigDataMap.get(id);
        }
        return null;
    }

    public ValueSourceData getValueSourceData(ValueSource valueSource) {
        if (valueSource != null) {
            int id = valueSource.getId();
            return this.valueSourceDataMap.get(id);
        }
        return null;
    }

    public RangeAxisData getRangeAxisData(RangeAxisConfig rangeAxisConfig) {
        if (rangeAxisConfig != null) {
            int id = rangeAxisConfig.getId();
            return this.rangeAxisDataMap.get(id);
        }
        return null;
    }

    public DomainConfigManagerData getDomainConfigManagerData() {
        return this.domainConfigManagerData;
    }

    @Override
    public synchronized boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        RangeAxisConfig changeRangeAxis;
        if (change == null || change == this.lastProcessedEvent) {
            return true;
        }
        this.lastProcessedEvent = change;
        PlotConfiguration currentPlotConfig = this.plotInstance.getCurrentPlotConfigurationClone();
        int id = -1;
        DefaultDimensionConfig currentDimensionConfig = null;
        RangeAxisConfig currentRangeAxis = null;
        DimensionConfig changeDimensionConfig = change.getDimensionConfig();
        if (changeDimensionConfig != null) {
            id = changeDimensionConfig.getId();
            currentDimensionConfig = currentPlotConfig.getDefaultDimensionConfigById(id);
        }
        if ((changeRangeAxis = change.getRangeAxisConfig()) != null) {
            id = changeRangeAxis.getId();
            currentRangeAxis = currentPlotConfig.getRangeAxisConfigById(id);
        }
        switch (change.getType()) {
            case TRIGGER_REPLOT: {
                this.clearCache();
                break;
            }
            case AXES_FONT: {
                break;
            }
            case AXIS_LINE_COLOR: {
                break;
            }
            case AXIS_LINE_WIDTH: {
                break;
            }
            case FRAME_BACKGROUND_COLOR: {
                break;
            }
            case CHART_TITLE: {
                break;
            }
            case COLOR_SCHEME: {
                break;
            }
            case DATA_TABLE_EXCHANGED: {
                break;
            }
            case DIMENSION_CONFIG_ADDED: {
                if (currentDimensionConfig != null && id != -1) {
                    this.dimensionConfigDataMap.put(id, new DimensionConfigData(this.plotInstance, currentDimensionConfig));
                    this.debug("ADDED dimension " + currentDimensionConfig.getDimension().getName() + " ## ID: " + id);
                    this.clearCache();
                    break;
                }
                this.debug("#### CAUTION ###### ADD DIMENSION CONFIG: CURRENT DIMENSIONCONFIG " + changeDimensionConfig.getLabel() + " with id " + changeDimensionConfig.getId() + " IS NULL! Processing meta event?");
                break;
            }
            case DIMENSION_CONFIG_CHANGED: {
                this.dimensionConfigChanged(change.getDimensionChange());
                break;
            }
            case DIMENSION_CONFIG_REMOVED: {
                this.debug("REMOVED dimension " + changeDimensionConfig.getDimension().getName() + " ## ID: " + changeDimensionConfig.getId());
                this.dimensionConfigDataMap.remove(changeDimensionConfig.getId());
                this.clearCache();
                break;
            }
            case LEGEND_CHANGED: {
                break;
            }
            case PLOT_BACKGROUND_COLOR: {
                break;
            }
            case PLOT_ORIENTATION: {
                break;
            }
            case RANGE_AXIS_CONFIG_ADDED: {
                if (currentRangeAxis != null && id != -1) {
                    this.debug("range axis ADDED - " + currentRangeAxis.getLabel() + " ## ID: " + id);
                    this.rangeAxisDataMap.put(id, new RangeAxisData(currentRangeAxis, this.plotInstance));
                    for (ValueSource valueSource : currentRangeAxis.getValueSources()) {
                        this.debug("value source ADDED - " + valueSource.getLabel() + " ## ID: " + valueSource.getId());
                        this.valueSourceDataMap.put(valueSource.getId(), new ValueSourceData(valueSource, this.plotInstance));
                    }
                    break;
                }
                this.debug("#### CAUTION ###### ADD RANGE AXIS CONFIG: CURRENT RANGEAXISCONFIG " + changeRangeAxis.getLabel() + " with id " + changeRangeAxis.getId() + " IS NULL! Processing meta event?");
                break;
            }
            case RANGE_AXIS_CONFIG_CHANGED: {
                RangeAxisConfigChangeEvent rangeAxisConfigChange = change.getRangeAxisConfigChange();
                this.debug("range axis CHANGED - " + rangeAxisConfigChange.getSource().getLabel() + " ## ID: " + rangeAxisConfigChange.getSource().getId());
                this.rangeAxisConfigChanged(rangeAxisConfigChange);
                break;
            }
            case RANGE_AXIS_CONFIG_MOVED: {
                break;
            }
            case RANGE_AXIS_CONFIG_REMOVED: {
                RangeAxisConfig rangeAxis = change.getRangeAxisConfig();
                this.debug("range axis REMOVED - " + rangeAxis.getLabel() + " ## ID: " + rangeAxis.getId());
                this.rangeAxisDataMap.remove(rangeAxis.getId());
                for (ValueSource valueSource : rangeAxis.getValueSources()) {
                    this.valueSourceDataMap.remove(valueSource.getId());
                }
                this.clearCache();
                break;
            }
            case LINK_AND_BRUSH_SELECTION: {
                break;
            }
            case META_CHANGE: {
                for (PlotConfigurationChangeEvent e : change.getPlotConfigChangeEvents()) {
                    this.plotConfigurationChanged(e);
                }
                break;
            }
        }
        return true;
    }

    private void rangeAxisConfigChanged(RangeAxisConfigChangeEvent rangeAxisConfigChange) {
        int id;
        PlotConfiguration currentPlotConfig = this.plotInstance.getCurrentPlotConfigurationClone();
        RangeAxisConfig currentRangeAxisConfig = currentPlotConfig.getRangeAxisConfigById(id = rangeAxisConfigChange.getSource().getId());
        if (currentRangeAxisConfig == null) {
            this.debug("#### CAUTION #### RANGE AXIS CONFIG CHANGE: current range axis config " + rangeAxisConfigChange.getSource().getLabel() + " with id " + rangeAxisConfigChange.getSource().getId() + " is null! Meta change event?");
            return;
        }
        RangeAxisData rangeAxisData = this.getRangeAxisData(currentRangeAxisConfig);
        rangeAxisData.rangeAxisConfigChanged(rangeAxisConfigChange);
        ValueSource changeValueSource = rangeAxisConfigChange.getValueSource();
        ValueSource currentValueSource = null;
        if (changeValueSource != null) {
            id = changeValueSource.getId();
            currentValueSource = currentRangeAxisConfig.getValueSourceById(id);
        }
        switch (rangeAxisConfigChange.getType()) {
            case VALUE_SOURCE_ADDED: {
                if (currentValueSource != null) {
                    this.debug("value source ADDED - " + currentValueSource.getLabel() + " ## ID: " + currentValueSource.getId());
                    this.valueSourceDataMap.put(currentValueSource.getId(), new ValueSourceData(currentValueSource, this.plotInstance));
                    this.clearCache();
                    break;
                }
                this.debug("#### CAUTION #### VALUE SOURCE ADDED: current value source" + changeValueSource.getLabel() + " with id " + changeValueSource.getId() + " is null! Meta change event?");
                return;
            }
            case VALUE_SOURCE_CHANGED: {
                ValueSourceChangeEvent valueSourceChange = rangeAxisConfigChange.getValueSourceChange();
                changeValueSource = valueSourceChange.getSource();
                id = changeValueSource.getId();
                currentValueSource = currentRangeAxisConfig.getValueSourceById(id);
                if (currentValueSource != null) {
                    this.debug("value source CHANGED - " + currentValueSource.getLabel() + " ## ID: " + id);
                    this.getValueSourceData(currentValueSource).valueSourceChanged(valueSourceChange, currentValueSource);
                    break;
                }
                this.debug("#### CAUTION #### VALUE SOURCE CHANGED: current value source" + changeValueSource.getLabel() + " with id " + changeValueSource.getId() + " is null! Meta change event?");
                return;
            }
            case VALUE_SOURCE_REMOVED: {
                this.debug("value source REMOVED - " + changeValueSource.getLabel() + " ## ID: " + changeValueSource.getId());
                this.valueSourceDataMap.remove(changeValueSource.getId());
                this.clearCache();
                break;
            }
        }
    }

    private void dimensionConfigChanged(DimensionConfigChangeEvent dimensionChange) {
        PlotConfiguration currentPlotConfig = this.plotInstance.getCurrentPlotConfigurationClone();
        if (dimensionChange.getDimension() == DimensionConfig.PlotDimension.DOMAIN) {
            this.getDomainConfigManagerData().dimensionConfigChanged(dimensionChange);
            DomainConfigManager domainConfigManager = currentPlotConfig.getDomainConfigManager();
            this.getDimensionConfigData(domainConfigManager.getDomainConfig(false)).dimensionConfigChanged(dimensionChange);
            this.getDimensionConfigData(domainConfigManager.getDomainConfig(true)).dimensionConfigChanged(dimensionChange);
        } else {
            int id = dimensionChange.getSource().getId();
            DefaultDimensionConfig currentDimensionConfig = currentPlotConfig.getDefaultDimensionConfigById(id);
            if (currentDimensionConfig != null) {
                DimensionConfigData dimData = this.getDimensionConfigData(currentDimensionConfig);
                dimData.dimensionConfigChanged(dimensionChange);
            } else {
                this.debug("#### CAUTION #### DIMENSION CHANGED:  current dimension config " + dimensionChange.getSource().getLabel() + " with id " + dimensionChange.getSource().getId() + " is null! Meta change event?");
                return;
            }
        }
        if (dimensionChange.getType() == DimensionConfigChangeEvent.DimensionConfigChangeType.RANGE) {
            this.clearCache();
        }
    }

    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errors = new LinkedList<PlotConfigurationError>();
        for (ValueSourceData valueSourceData : this.getValueSourcesData()) {
            errors.addAll(valueSourceData.getErrors());
        }
        for (DimensionConfigData data : this.dimensionConfigDataMap.values()) {
            if (data.getDimensionConfig().getDimension() == DimensionConfig.PlotDimension.DOMAIN) continue;
            List<PlotConfigurationError> error = data.getErrors();
            errors.addAll(error);
        }
        DomainConfigManager domainConfigManager = this.plotInstance.getCurrentPlotConfigurationClone().getDomainConfigManager();
        DomainConfigManager.GroupingState groupingState = domainConfigManager.getGroupingState();
        switch (groupingState) {
            case GROUPED: {
                errors.addAll(this.getDimensionConfigData(domainConfigManager.getDomainConfig(true)).getErrors());
                break;
            }
            case PARTIALLY_GROUPED: {
                errors.addAll(this.getDimensionConfigData(domainConfigManager.getDomainConfig(true)).getErrors());
                errors.addAll(this.getDimensionConfigData(domainConfigManager.getDomainConfig(false)).getErrors());
                break;
            }
            case UNGROUPED: {
                errors.addAll(this.getDimensionConfigData(domainConfigManager.getDomainConfig(false)).getErrors());
            }
        }
        for (RangeAxisData data : this.rangeAxisDataMap.values()) {
            errors.addAll(data.getErrors());
        }
        errors.addAll(this.domainConfigManagerData.getErrors());
        return errors;
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        for (ValueSourceData valueSourceData : this.getValueSourcesData()) {
            warnings.addAll(valueSourceData.getErrors());
        }
        boolean xAddedWarning = false;
        for (DimensionConfigData dimensionConfigData : this.dimensionConfigDataMap.values()) {
            List<PlotConfigurationError> warning = dimensionConfigData.getWarnings();
            if (dimensionConfigData.getDimensionConfig().getDimension() == DimensionConfig.PlotDimension.DOMAIN) {
                if (xAddedWarning) continue;
                xAddedWarning = warning.size() > 0;
                warnings.addAll(warning);
                continue;
            }
            warnings.addAll(warning);
        }
        for (RangeAxisData rangeAxisData : this.rangeAxisDataMap.values()) {
            warnings.addAll(rangeAxisData.getWarnings());
        }
        warnings.addAll(this.domainConfigManagerData.getWarnings());
        return warnings;
    }

    private Collection<ValueSourceData> getValueSourcesData() {
        return this.valueSourceDataMap.values();
    }

    public boolean isValid() {
        return this.getErrors().isEmpty();
    }

    private void debug(String msg) {
        StaticDebug.debug("PlotData: " + msg);
    }

    public boolean isDataTableValid() {
        return this.dataTableIsValid;
    }
}

