/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.data;

import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.ValueSourceData;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.rapidminer.tools.container.Pair;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class RangeAxisData {
    private RangeAxisConfig rangeAxisConfig;
    private final PlotInstance plotInstance;
    private RangeAxisConfigChangeEvent lastProcessedEvent = null;
    private List<Pair<ValueSource, Double>> cachedDistinctSourcesAndValues = null;
    private double cachedMaxYValue = Double.NaN;
    private double cachedMinYValue = Double.NaN;
    private NumericalValueRange cachedAutoViewRange = null;

    public RangeAxisData(RangeAxisConfig rangeAxisConfig, PlotInstance plotInstance) {
        this.rangeAxisConfig = rangeAxisConfig;
        this.plotInstance = plotInstance;
    }

    private void updateValueCache() {
        this.cachedDistinctSourcesAndValues = new LinkedList<Pair<ValueSource, Double>>();
        HashSet<Double> distinctValues = new HashSet<Double>();
        this.cachedMinYValue = Double.POSITIVE_INFINITY;
        this.cachedMaxYValue = Double.NEGATIVE_INFINITY;
        LinkedList<ValueSource> valueSources = new LinkedList<ValueSource>();
        valueSources.addAll(this.rangeAxisConfig.getValueSources());
        for (ValueSource valueSource : valueSources) {
            ValueSourceData valueSourceData = this.plotInstance.getPlotData().getValueSourceData(valueSource);
            Pair<Double, Double> minMax = valueSourceData.getMinAndMaxValue();
            double minValue = (Double)minMax.getFirst();
            double maxValue = (Double)minMax.getSecond();
            if ((valueSource.getSeriesFormat().getSeriesType() == SeriesFormat.VisualizationType.AREA || valueSource.getSeriesFormat().getSeriesType() == SeriesFormat.VisualizationType.BARS) && valueSource.getSeriesFormat().getStackingMode() == SeriesFormat.StackingMode.RELATIVE) {
                minValue = 0.0;
                maxValue = 1.0;
            }
            if (minValue < this.cachedMinYValue) {
                this.cachedMinYValue = minValue;
            }
            if (maxValue > this.cachedMaxYValue) {
                this.cachedMaxYValue = maxValue;
            }
            for (Double value : valueSourceData.getDistinctValues()) {
                if (distinctValues.contains(value)) continue;
                distinctValues.add(value);
                this.cachedDistinctSourcesAndValues.add((Pair<ValueSource, Double>)new Pair((Object)valueSource, (Object)value));
            }
        }
        this.cachedAutoViewRange = new NumericalValueRange(this.cachedMinYValue, this.cachedMaxYValue, -1);
    }

    public List<Pair<ValueSource, Double>> getDistinctValues() {
        if (this.cachedDistinctSourcesAndValues == null) {
            this.updateValueCache();
        }
        return this.cachedDistinctSourcesAndValues;
    }

    public double getLowerViewBound() {
        if (this.rangeAxisConfig.isUsingUserDefinedLowerViewBound()) {
            return this.rangeAxisConfig.getUserDefinedRange().getLowerBound();
        }
        if (this.cachedAutoViewRange == null) {
            this.updateValueCache();
        }
        return this.cachedAutoViewRange.getLowerBound();
    }

    public double getUpperViewBound() {
        if (this.rangeAxisConfig.isUsingUserDefinedUpperViewBound()) {
            return this.rangeAxisConfig.getUserDefinedRange().getUpperBound();
        }
        if (this.cachedAutoViewRange == null) {
            this.updateValueCache();
        }
        return this.cachedAutoViewRange.getUpperBound();
    }

    private void invalidateCache() {
        this.cachedDistinctSourcesAndValues = null;
        this.cachedMaxYValue = Double.NaN;
        this.cachedMinYValue = Double.NaN;
        this.invalidateViewRange();
    }

    private void invalidateViewRange() {
        this.cachedAutoViewRange = null;
    }

    public double getMaxYValue() {
        if (Double.isNaN(this.cachedMaxYValue)) {
            this.updateValueCache();
        }
        return this.cachedMaxYValue;
    }

    public double getMinYValue() {
        if (Double.isNaN(this.cachedMinYValue)) {
            this.updateValueCache();
        }
        return this.cachedMinYValue;
    }

    public void rangeAxisConfigChanged(RangeAxisConfigChangeEvent e) {
        int id;
        if (e == null || e == this.lastProcessedEvent) {
            return;
        }
        this.lastProcessedEvent = e;
        PlotConfiguration currentPlotConfigurationClone = this.plotInstance.getCurrentPlotConfigurationClone();
        RangeAxisConfig rangeAxisConfigById = currentPlotConfigurationClone.getRangeAxisConfigById(id = e.getSource().getId());
        if (rangeAxisConfigById == null) {
            StaticDebug.debug("RangeAxisData: ### ATTENTION #### RangeAxis with ID " + id + " is null! Meta change event?");
            return;
        }
        this.setRangeAxisConfig(rangeAxisConfigById);
        switch (e.getType()) {
            case CLEARED: 
            case RANGE_CHANGED: 
            case VALUE_SOURCE_ADDED: 
            case VALUE_SOURCE_CHANGED: 
            case VALUE_SOURCE_REMOVED: 
            case VALUE_SOURCE_MOVED: {
                this.invalidateCache();
                break;
            }
        }
    }

    public RangeAxisConfig getRangeAxisConfig() {
        return this.rangeAxisConfig;
    }

    private void setRangeAxisConfig(RangeAxisConfig rangeAxisConfig) {
        if (rangeAxisConfig != null && rangeAxisConfig.getId() == this.rangeAxisConfig.getId()) {
            this.rangeAxisConfig = rangeAxisConfig;
        }
    }

    public List<PlotConfigurationError> getWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        if (this.rangeAxisConfig.getValueType() == DataTableColumn.ValueType.UNKNOWN) {
            return warnings;
        }
        double lowerViewBound = this.getLowerViewBound();
        double upperViewBound = this.getUpperViewBound();
        boolean equalUpperAndLowerBound = DataStructureUtils.almostEqual(lowerViewBound, upperViewBound, 1.0E-6);
        if (DataStructureUtils.greaterOrAlmostEqual(lowerViewBound, upperViewBound, 1.0E-6) && !equalUpperAndLowerBound) {
            warnings.add(new PlotConfigurationError("user_range_includes_no_data", this.rangeAxisConfig.getLabel()));
        } else {
            double maxYValue = this.getMaxYValue();
            double minYValue = this.getMinYValue();
            boolean equalMinAndMaxValue = DataStructureUtils.almostEqual(minYValue, maxYValue, 1.0E-6);
            if ((DataStructureUtils.greaterOrAlmostEqual(lowerViewBound, maxYValue, 1.0E-6) || DataStructureUtils.greaterOrAlmostEqual(minYValue, upperViewBound, 1.0E-6)) && !equalMinAndMaxValue) {
                warnings.add(new PlotConfigurationError("user_range_includes_no_data", this.rangeAxisConfig.getLabel()));
            }
        }
        return warnings;
    }

    public List<PlotConfigurationError> getErrors() {
        LinkedList<PlotConfigurationError> errors = new LinkedList<PlotConfigurationError>();
        double lowerViewBound = this.getLowerViewBound();
        double upperViewBound = this.getUpperViewBound();
        if (this.rangeAxisConfig.getValueType() == DataTableColumn.ValueType.DATE_TIME && (Double.isInfinite(lowerViewBound) || Double.isInfinite(upperViewBound))) {
            errors.add(new PlotConfigurationError("infite_range_for_date_axis", this.rangeAxisConfig.getLabel()));
            return errors;
        }
        if (this.rangeAxisConfig.isUsingUserDefinedUpperViewBound() && DataStructureUtils.greaterOrAlmostEqual(lowerViewBound, upperViewBound, 1.0E-6)) {
            errors.add(new PlotConfigurationError("axis_upper_range_below_lower_auto_range", this.rangeAxisConfig.getLabel(), lowerViewBound + ""));
            return errors;
        }
        return errors;
    }
}

