/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart;

import com.owc.gui.charting.ChartPlottimeException;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.ValueSourceData;
import com.owc.gui.charting.engine.jfreechart.RenderFormatDelegate;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedAreaRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedBarRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedClusteredXYBarRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedDeviationRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedLineAndShapeRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedScatterRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStackedAreaRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStackedBarRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStackedXYAreaRenderer2;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStackedXYBarRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStatisticalBarRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStatisticalLineAndShapeRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedXYAreaRenderer2;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedXYDifferenceRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedXYErrorRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedXYLineAndShapeRenderer;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.rapidminer.tools.LogService;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.ScatterRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;

public class ChartRendererFactory {
    private static final double DEFAULT_PERCENTUAL_XY_BAR_GAP = 0.04;

    private ChartRendererFactory() {
    }

    private static void configureXYLineAndShapeRenderer(XYLineAndShapeRenderer renderer, ValueSource valueSource, PlotInstance plotInstance) {
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        SeriesFormat seriesFormat = valueSource.getSeriesFormat();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfig colorDimensionConfig = plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.COLOR);
        DimensionConfig shapeDimensionConfig = plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.SHAPE);
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        int seriesCount = valueSourceData.getSeriesDataForAllGroupCells().groupCellCount();
        for (int seriesIdx = 0; seriesIdx < seriesCount; ++seriesIdx) {
            if (seriesFormat.getLineStyle() == LineFormat.LineStyle.NONE) {
                renderer.setSeriesLinesVisible(seriesIdx, false);
            } else {
                renderer.setSeriesLinesVisible(seriesIdx, true);
                renderer.setSeriesStroke(seriesIdx, (Stroke)seriesFormat.getStroke(), false);
            }
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, shapeDimensionConfig)) {
                if (seriesFormat.getItemShape() != SeriesFormat.ItemShape.NONE) {
                    renderer.setSeriesShapesVisible(seriesIdx, true);
                    renderer.setSeriesShape(seriesIdx, seriesFormat.getItemShape().getShape());
                } else {
                    renderer.setSeriesShapesVisible(seriesIdx, false);
                }
            }
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, colorDimensionConfig)) {
                Color itemColor = seriesFormat.getItemColor();
                renderer.setSeriesPaint(seriesIdx, (Paint)itemColor);
                renderer.setSeriesFillPaint(seriesIdx, (Paint)itemColor);
            }
            renderer.setSeriesOutlinePaint(seriesIdx, PlotConfiguration.DEFAULT_SERIES_OUTLINE_PAINT);
            renderer.setUseOutlinePaint(true);
        }
    }

    private static void initFormatDelegate(ValueSource valueSource, FormattedRenderer formattedRenderer, PlotInstance plotInstance) {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        LinkedList<Integer> seriesIndices = new LinkedList<Integer>();
        if (valueSourceData != null) {
            for (int i = 0; i < valueSourceData.getSeriesCount(); ++i) {
                seriesIndices.add(i);
            }
        } else {
            LogService.getRoot().log(Level.WARNING, "com.owc.gui.charting.engine.jfreechart.ChartRendererFactory.null_value_source");
        }
        ChartRendererFactory.initFormatDelegate(valueSource, seriesIndices, formattedRenderer, plotInstance);
    }

    private static void initFormatDelegate(ValueSource valueSource, int seriesIdx, FormattedRenderer formattedRenderer, PlotInstance plotInstance) {
        LinkedList<Integer> seriesIndices = new LinkedList<Integer>();
        seriesIndices.add(seriesIdx);
        ChartRendererFactory.initFormatDelegate(valueSource, seriesIndices, formattedRenderer, plotInstance);
    }

    private static void initFormatDelegate(ValueSource valueSource, List<Integer> seriesIndices, FormattedRenderer formattedRenderer, PlotInstance plotInstance) {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        RenderFormatDelegate formatDelegate = formattedRenderer.getFormatDelegate();
        formatDelegate.setConfiguration(valueSourceData, plotInstance);
    }

    public static XYItemRenderer[] createXYDifferenceRenderers(ValueSource valueSource, PlotInstance plotInstance) {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        FormattedXYDifferenceRenderer[] renderers = new FormattedXYDifferenceRenderer[valueSourceData.getSeriesCount()];
        for (int seriesIdx = 0; seriesIdx < valueSourceData.getSeriesCount(); ++seriesIdx) {
            FormattedXYDifferenceRenderer renderer = new FormattedXYDifferenceRenderer(seriesIdx);
            ChartRendererFactory.configureXYDifferenceRenderer(renderer, valueSource, plotInstance.getCurrentPlotConfigurationClone());
            ChartRendererFactory.initFormatDelegate(valueSource, seriesIdx, (FormattedRenderer)renderer, plotInstance);
            renderers[seriesIdx] = renderer;
        }
        return renderers;
    }

    private static void configureXYDifferenceRenderer(FormattedXYDifferenceRenderer renderer, ValueSource valueSource, PlotConfiguration plotConfiguration) {
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        SeriesFormat seriesFormat = valueSource.getSeriesFormat();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfig colorDimensionConfig = plotConfiguration.getDimensionConfig(DimensionConfig.PlotDimension.COLOR);
        DimensionConfig shapeDimensionConfig = plotConfiguration.getDimensionConfig(DimensionConfig.PlotDimension.SHAPE);
        int seriesCount = 1;
        for (int seriesIdx = 0; seriesIdx < seriesCount; ++seriesIdx) {
            if (seriesFormat.getLineStyle() != LineFormat.LineStyle.NONE) {
                renderer.setSeriesStroke(seriesIdx, seriesFormat.getStroke(), false);
            }
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, shapeDimensionConfig) && seriesFormat.getItemShape() != SeriesFormat.ItemShape.NONE) {
                renderer.setSeriesShape(seriesIdx, seriesFormat.getItemShape().getShape());
            }
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, colorDimensionConfig)) {
                Color itemColor = seriesFormat.getItemColor();
                Color halfTransparentPaint = DataStructureUtils.setColorAlpha(itemColor, itemColor.getAlpha() / 2);
                renderer.setSeriesPaint(0, halfTransparentPaint);
                renderer.setSeriesFillPaint(0, halfTransparentPaint);
                renderer.setPositivePaint(halfTransparentPaint);
                renderer.setNegativePaint(new Color(255 - itemColor.getRed(), 255 - itemColor.getGreen(), 255 - itemColor.getBlue(), itemColor.getAlpha() / 2));
            }
            renderer.setSeriesOutlinePaint(seriesIdx, PlotConfiguration.DEFAULT_SERIES_OUTLINE_PAINT);
        }
    }

    public static XYItemRenderer createXYErrorRenderer(ValueSource valueSource, PlotInstance plotInstance, XYDataset dataset) {
        FormattedXYErrorRenderer renderer = new FormattedXYErrorRenderer();
        ChartRendererFactory.configureXYLineAndShapeRenderer((XYLineAndShapeRenderer)renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        renderer.setDrawXError(false);
        renderer.setDrawYError(true);
        return renderer;
    }

    public static XYItemRenderer createDeviationRenderer(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedDeviationRenderer renderer = new FormattedDeviationRenderer();
        ChartRendererFactory.configureXYLineAndShapeRenderer((XYLineAndShapeRenderer)renderer, valueSource, plotInstance);
        renderer.setAlpha(0.5f * (float)valueSource.getSeriesFormat().getOpacity() / 255.0f);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    public static XYItemRenderer createClusteredXYBarRenderer(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedClusteredXYBarRenderer renderer = new FormattedClusteredXYBarRenderer(0.04, false);
        ChartRendererFactory.configureXYBarRenderer((XYBarRenderer)renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    private static void configureXYBarRenderer(XYBarRenderer renderer, ValueSource valueSource, PlotInstance plotInstance) {
        StandardXYBarPainter barPainter = new StandardXYBarPainter();
        renderer.setBarPainter((XYBarPainter)barPainter);
        renderer.setGradientPaintTransformer(null);
        SeriesFormat seriesFormat = valueSource.getSeriesFormat();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        int seriesCount = valueSourceData != null ? valueSourceData.getSeriesCount() : 0;
        DimensionConfig colorDimensionConfig = plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.COLOR);
        for (int seriesIdx = 0; seriesIdx < seriesCount; ++seriesIdx) {
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, colorDimensionConfig)) {
                renderer.setSeriesPaint(seriesIdx, seriesFormat.getAreaFillPaint());
            }
            renderer.setShadowVisible(false);
            renderer.setSeriesOutlinePaint(seriesIdx, PlotConfiguration.DEFAULT_SERIES_OUTLINE_PAINT);
        }
        renderer.setDrawBarOutline(true);
    }

    public static XYItemRenderer createStackedXYBarRenderer(ValueSource valueSource, PlotInstance plotInstance, boolean asPercentages) {
        FormattedStackedXYBarRenderer renderer = new FormattedStackedXYBarRenderer(0.1);
        renderer.setRenderAsPercentages(asPercentages);
        ChartRendererFactory.configureXYBarRenderer((XYBarRenderer)renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    public static XYItemRenderer createXYAreaRenderer2(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedXYAreaRenderer2 renderer = new FormattedXYAreaRenderer2();
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartRendererFactory.configureXYAreaRenderer2(valueSourceData, renderer);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    private static void configureXYAreaRenderer2(ValueSourceData valueSourceData, XYAreaRenderer2 renderer) {
        int seriesCount = valueSourceData.getSeriesCount();
        SeriesFormat seriesFormat = valueSourceData.getValueSource().getSeriesFormat();
        for (int seriesIdx = 0; seriesIdx < seriesCount; ++seriesIdx) {
            renderer.setSeriesPaint(seriesIdx, seriesFormat.getAreaFillPaint());
        }
        renderer.setOutline(false);
    }

    public static XYItemRenderer createStackedXYAreaRenderer2(ValueSource valueSource, PlotInstance plotInstance, boolean b) {
        FormattedStackedXYAreaRenderer2 renderer = new FormattedStackedXYAreaRenderer2();
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        ChartRendererFactory.configureXYAreaRenderer2(valueSourceData, (XYAreaRenderer2)renderer);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    public static XYItemRenderer createXYLineAndShapeRenderer(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedXYLineAndShapeRenderer renderer = new FormattedXYLineAndShapeRenderer();
        ChartRendererFactory.configureXYLineAndShapeRenderer(renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    public static FormattedStatisticalLineAndShapeRenderer createStatisticalLineAndShapeRenderer(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedStatisticalLineAndShapeRenderer renderer = new FormattedStatisticalLineAndShapeRenderer();
        ChartRendererFactory.configureLineAndShapeRenderer((LineAndShapeRenderer)renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    public static FormattedLineAndShapeRenderer createLineAndShapeRenderer(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedLineAndShapeRenderer renderer = new FormattedLineAndShapeRenderer();
        renderer.setDefaultEntityRadius(4);
        ChartRendererFactory.configureLineAndShapeRenderer(renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    private static void configureLineAndShapeRenderer(LineAndShapeRenderer renderer, ValueSource valueSource, PlotInstance plotInstance) {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        int seriesCount = valueSourceData.getSeriesCount();
        SeriesFormat seriesFormat = valueSource.getSeriesFormat();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfig colorDimensionConfig = plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.COLOR);
        DimensionConfig shapeDimensionConfig = plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.SHAPE);
        renderer.setDefaultEntityRadius(4);
        for (int seriesIdx = 0; seriesIdx < seriesCount; ++seriesIdx) {
            if (seriesFormat.getLineStyle() != LineFormat.LineStyle.NONE) {
                renderer.setSeriesLinesVisible(seriesIdx, true);
                renderer.setSeriesStroke(seriesIdx, (Stroke)seriesFormat.getStroke(), false);
            } else {
                renderer.setSeriesLinesVisible(seriesIdx, false);
            }
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, shapeDimensionConfig)) {
                if (seriesFormat.getItemShape() != SeriesFormat.ItemShape.NONE) {
                    renderer.setSeriesShapesVisible(seriesIdx, true);
                    renderer.setSeriesShape(seriesIdx, seriesFormat.getItemShape().getShape());
                } else {
                    renderer.setSeriesShapesVisible(seriesIdx, false);
                }
            }
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, colorDimensionConfig)) {
                Color itemColor = seriesFormat.getItemColor();
                renderer.setSeriesPaint(seriesIdx, (Paint)itemColor);
            }
            renderer.setSeriesOutlinePaint(seriesIdx, PlotConfiguration.DEFAULT_SERIES_OUTLINE_PAINT);
            renderer.setUseOutlinePaint(true);
        }
    }

    private static void configureScatterRenderer(ScatterRenderer renderer, ValueSource valueSource, PlotInstance plotInstance) throws ChartPlottimeException {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        int seriesCount = valueSourceData.getSeriesCount();
        SeriesFormat seriesFormat = valueSource.getSeriesFormat();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfig colorDimensionConfig = plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.COLOR);
        DimensionConfig shapeDimensionConfig = plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.SHAPE);
        renderer.setDefaultEntityRadius(4);
        for (int seriesIdx = 0; seriesIdx < seriesCount; ++seriesIdx) {
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, shapeDimensionConfig)) {
                renderer.setSeriesShape(seriesIdx, seriesFormat.getItemShape().getShape());
            }
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, colorDimensionConfig)) {
                Color itemColor = seriesFormat.getItemColor();
                renderer.setSeriesPaint(seriesIdx, (Paint)itemColor);
            }
            renderer.setSeriesOutlinePaint(seriesIdx, PlotConfiguration.DEFAULT_SERIES_OUTLINE_PAINT);
            renderer.setUseOutlinePaint(true);
            renderer.setDrawOutlines(true);
            renderer.setUseSeriesOffset(false);
        }
    }

    public static FormattedStatisticalBarRenderer createStatisticalBarRenderer(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedStatisticalBarRenderer renderer = new FormattedStatisticalBarRenderer();
        ChartRendererFactory.configureBarRenderer((BarRenderer)renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    private static void configureBarRenderer(BarRenderer renderer, ValueSource valueSource, PlotInstance plotInstance) {
        StandardBarPainter barPainter = new StandardBarPainter();
        renderer.setBarPainter((BarPainter)barPainter);
        renderer.setGradientPaintTransformer(null);
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        int seriesCount = valueSourceData.getSeriesCount();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfig colorDimensionConfig = plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.COLOR);
        SeriesFormat seriesFormat = valueSource.getSeriesFormat();
        for (int seriesIdx = 0; seriesIdx < seriesCount; ++seriesIdx) {
            if (!SeriesFormat.calculateIndividualFormatForEachItem(domainConfig, colorDimensionConfig)) {
                renderer.setSeriesPaint(seriesIdx, seriesFormat.getAreaFillPaint());
            }
            renderer.setShadowVisible(false);
            renderer.setSeriesOutlinePaint(seriesIdx, PlotConfiguration.DEFAULT_SERIES_OUTLINE_PAINT);
        }
        renderer.setDrawBarOutline(true);
    }

    public static FormattedBarRenderer createBarRenderer(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedBarRenderer renderer = new FormattedBarRenderer();
        ChartRendererFactory.configureBarRenderer(renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    public static FormattedStackedBarRenderer createStackedBarRenderer(ValueSource valueSource, PlotInstance plotInstance, boolean asPercentages) {
        FormattedStackedBarRenderer renderer = new FormattedStackedBarRenderer();
        ChartRendererFactory.configureBarRenderer((BarRenderer)renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        renderer.setRenderAsPercentages(asPercentages);
        return renderer;
    }

    public static FormattedAreaRenderer createAreaRenderer(ValueSource valueSource, PlotInstance plotInstance) {
        FormattedAreaRenderer renderer = new FormattedAreaRenderer();
        ChartRendererFactory.configureAreaRenderer(renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    private static void configureAreaRenderer(AreaRenderer renderer, ValueSource valueSource, PlotInstance plotInstance) {
        ValueSourceData valueSourceData = plotInstance.getPlotData().getValueSourceData(valueSource);
        int seriesCount = valueSourceData.getSeriesCount();
        SeriesFormat seriesFormat = valueSource.getSeriesFormat();
        for (int seriesIdx = 0; seriesIdx < seriesCount; ++seriesIdx) {
            renderer.setSeriesPaint(seriesIdx, seriesFormat.getAreaFillPaint());
        }
    }

    public static FormattedStackedAreaRenderer createStackedAreaRenderer(ValueSource valueSource, PlotInstance plotInstance, boolean asPercentages) {
        FormattedStackedAreaRenderer renderer = new FormattedStackedAreaRenderer();
        renderer.setRenderAsPercentages(asPercentages);
        ChartRendererFactory.configureAreaRenderer((AreaRenderer)renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }

    public static FormattedScatterRenderer createScatterRenderer(ValueSource valueSource, PlotInstance plotInstance) throws ChartPlottimeException {
        FormattedScatterRenderer renderer = new FormattedScatterRenderer();
        ChartRendererFactory.configureScatterRenderer(renderer, valueSource, plotInstance);
        ChartRendererFactory.initFormatDelegate(valueSource, renderer, plotInstance);
        return renderer;
    }
}

