/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart;

import com.owc.gui.charting.ChartPlottimeException;
import com.owc.gui.charting.ConfigurationChangeResponse;
import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.PlotConfigurationQuickFix;
import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.configuration.AxisParallelLineConfiguration;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.LegendConfiguration;
import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.ValueSourceData;
import com.owc.gui.charting.engine.PlotEngine;
import com.owc.gui.charting.engine.jfreechart.ChartAxisFactory;
import com.owc.gui.charting.engine.jfreechart.ChartDatasetFactory;
import com.owc.gui.charting.engine.jfreechart.ChartRendererFactory;
import com.owc.gui.charting.engine.jfreechart.MultiAxesCrosshairOverlay;
import com.owc.gui.charting.engine.jfreechart.PlotInstanceLegendCreator;
import com.owc.gui.charting.engine.jfreechart.actions.AddParallelLineAction;
import com.owc.gui.charting.engine.jfreechart.actions.ClearParallelLinesAction;
import com.owc.gui.charting.engine.jfreechart.actions.CopyChartAction;
import com.owc.gui.charting.engine.jfreechart.actions.ManageParallelLinesAction;
import com.owc.gui.charting.engine.jfreechart.actions.ManageZoomAction;
import com.owc.gui.charting.engine.jfreechart.dataset.ValueSourceToMultiValueCategoryDatasetAdapter;
import com.owc.gui.charting.engine.jfreechart.legend.ColoredBlockContainer;
import com.owc.gui.charting.engine.jfreechart.legend.SmartLegendTitle;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.LinkAndBrushChartPanel;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.plots.LinkAndBrushCategoryPlot;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.plots.LinkAndBrushPlot;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.plots.LinkAndBrushXYPlot;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedAreaRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedBarRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedLineAndShapeRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedScatterRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStackedAreaRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStackedBarRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStatisticalBarRenderer;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedStatisticalLineAndShapeRenderer;
import com.owc.gui.charting.listener.JFreeChartPlotEngineListener;
import com.owc.gui.charting.listener.PlotConfigurationListener;
import com.owc.gui.charting.listener.PlotConfigurationProcessingListener;
import com.owc.gui.charting.listener.events.DimensionConfigChangeEvent;
import com.owc.gui.charting.listener.events.LegendConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import com.owc.gui.charting.listener.events.SeriesFormatChangeEvent;
import com.owc.gui.charting.listener.events.ValueSourceChangeEvent;
import com.rapidminer.gui.plotter.CoordinateTransformation;
import com.rapidminer.gui.plotter.NullCoordinateTransformation;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.block.FlowArrangement;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.xy.DefaultIntervalXYDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;

public class JFreeChartPlotEngine
implements PlotEngine,
PlotConfigurationListener,
PlotConfigurationProcessingListener,
LegendItemSource {
    private boolean initializing = false;
    private List<WeakReference<JFreeChartPlotEngineListener>> listeners = new LinkedList<WeakReference<JFreeChartPlotEngineListener>>();
    private PlotInstance plotInstance;
    private PlotInstance nextPlotInstance = null;
    private final PlotInstanceLegendCreator legendCreator = new PlotInstanceLegendCreator();
    private transient LegendItemCollection cachedLegendItems = null;
    private final LinkAndBrushChartPanel chartPanel;
    private AtomicBoolean updatingChart;
    private boolean currentChartIsValid = false;
    private MultiAxesCrosshairOverlay crosshairOverlay = new MultiAxesCrosshairOverlay();
    private Object nextPlotInstanceLock = new Object();
    private JPopupMenu popupMenuChart;
    private MouseListener popupMenuListener;
    private AddParallelLineAction addParallelLineAction;
    private transient CoordinateTransformation coordinateTransformation = new NullCoordinateTransformation();

    public JFreeChartPlotEngine(PlotInstance plotInstanceForEngine, boolean zoomInOnSelection) {
        this.popupMenuChart = new JPopupMenu();
        this.popupMenuChart.add((Action)((Object)new CopyChartAction(this)));
        this.popupMenuChart.addSeparator();
        this.popupMenuChart.add((Action)((Object)new ManageZoomAction(this)));
        this.popupMenuChart.addSeparator();
        this.addParallelLineAction = new AddParallelLineAction(this);
        this.popupMenuChart.add((Action)((Object)this.addParallelLineAction));
        this.popupMenuChart.add((Action)((Object)new ManageParallelLinesAction(this)));
        this.popupMenuChart.addSeparator();
        this.popupMenuChart.add((Action)((Object)new ClearParallelLinesAction(this)));
        this.popupMenuListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JFreeChartPlotEngine.this.addParallelLineAction.setPopupLocation(e.getPoint());
                    JFreeChartPlotEngine.this.coordinateTransformation.showPopupMenu(new Point(e.getX(), e.getY()), (JComponent)JFreeChartPlotEngine.this.chartPanel, JFreeChartPlotEngine.this.popupMenuChart);
                }
            }
        };
        this.plotInstance = plotInstanceForEngine;
        this.updatingChart = new AtomicBoolean(false);
        this.chartPanel = new LinkAndBrushChartPanel(new JFreeChart((Plot)new CategoryPlot()), 50, 50, 50, 50, zoomInOnSelection);
        this.chartPanel.setMinimumDrawWidth(50);
        this.chartPanel.setMinimumDrawHeight(50);
        this.chartPanel.setMaximumDrawWidth(10000);
        this.chartPanel.setMaximumDrawHeight(10000);
        this.chartPanel.addMouseListener(this.popupMenuListener);
        this.subscribeAtPlotInstance(this.plotInstance);
    }

    public JFreeChartPlotEngine(PlotInstance plotInstanceForEngine, boolean zoomInOnSelection, boolean useBuffer) {
        this.popupMenuChart = new JPopupMenu();
        this.popupMenuChart.add((Action)((Object)new CopyChartAction(this)));
        this.popupMenuChart.addSeparator();
        this.popupMenuChart.add((Action)((Object)new ManageZoomAction(this)));
        this.popupMenuChart.addSeparator();
        this.addParallelLineAction = new AddParallelLineAction(this);
        this.popupMenuChart.add((Action)((Object)this.addParallelLineAction));
        this.popupMenuChart.add((Action)((Object)new ManageParallelLinesAction(this)));
        this.popupMenuChart.addSeparator();
        this.popupMenuChart.add((Action)((Object)new ClearParallelLinesAction(this)));
        this.popupMenuListener = new /* invalid duplicate definition of identical inner class */;
        this.plotInstance = plotInstanceForEngine;
        this.updatingChart = new AtomicBoolean(false);
        this.chartPanel = new LinkAndBrushChartPanel(new JFreeChart((Plot)new CategoryPlot()), 50, 50, 50, 50, zoomInOnSelection, useBuffer);
        this.chartPanel.setMinimumDrawWidth(50);
        this.chartPanel.setMinimumDrawHeight(50);
        this.chartPanel.setMaximumDrawWidth(10000);
        this.chartPanel.setMaximumDrawHeight(10000);
        this.chartPanel.addMouseListener(this.popupMenuListener);
        this.subscribeAtPlotInstance(this.plotInstance);
    }

    private void subscribeAtPlotInstance(PlotInstance plotInstance) {
        this.initializing = true;
        PlotConfiguration masterPlotConfiguration = plotInstance.getMasterPlotConfiguration();
        masterPlotConfiguration.addPlotConfigurationListener(this);
        masterPlotConfiguration.addPlotConfigurationProcessingListener(this);
        this.chartPanel.addLinkAndBrushSelectionListener(masterPlotConfiguration);
        this.initializing = false;
    }

    public boolean updatingChart() {
        return this.updatingChart.get();
    }

    public JFreeChart getCurrentChart() {
        JFreeChart currentChart = this.chartPanel.getChart();
        if (currentChart == null) {
            return new JFreeChart((Plot)new CategoryPlot());
        }
        return currentChart;
    }

    private synchronized void updateChartPanelChart(final boolean informPlotConfigWhenDone) {
        this.updatingChart.getAndSet(true);
        StaticDebug.debug("######################### STARTING CHART UPDATE ######################");
        SwingWorker<JFreeChart, Void> updateChartWorker = new SwingWorker<JFreeChart, Void>(){

            @Override
            public JFreeChart doInBackground() throws Exception {
                try {
                    if (!JFreeChartPlotEngine.this.isPlotInstanceValid()) {
                        return null;
                    }
                    try {
                        JFreeChartPlotEngine.this.invalidateCache();
                        JFreeChart createdChart = JFreeChartPlotEngine.this.createChart();
                        JFreeChartPlotEngine.this.updateLegendItems();
                        JFreeChartPlotEngine.this.checkWarnings();
                        JFreeChartPlotEngine.this.currentChartIsValid = true;
                        return createdChart;
                    }
                    catch (ChartPlottimeException e) {
                        JFreeChartPlotEngine.this.handlePlottimeException(e);
                        return null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingTools.showFinalErrorMessage((String)"generic_plotter_error", (Throwable)e, (boolean)true, (Object[])new Object[0]);
                    JFreeChartPlotEngine.this.handlePlottimeException(new ChartPlottimeException("generic_plotter_error", new Object[0]));
                    return null;
                }
            }

            @Override
            public void done() {
                try {
                    JFreeChart chart = null;
                    try {
                        chart = (JFreeChart)this.get(60L, TimeUnit.SECONDS);
                        JFreeChartPlotEngine.this.updatingChartPanelChartDone();
                    }
                    catch (Exception e) {
                        JFreeChartPlotEngine.this.updatingChartPanelChartDone();
                        e.printStackTrace();
                        JFreeChartPlotEngine.this.handlePlottimeException(new ChartPlottimeException("generic_plotter_error", new Object[0]));
                        return;
                    }
                    if (chart == null) {
                        JFreeChartPlotEngine.this.currentChartIsValid = false;
                        chart = new JFreeChart((Plot)new CategoryPlot());
                    }
                    JFreeChartPlotEngine.this.updateChartPanel(chart);
                    if (informPlotConfigWhenDone) {
                        JFreeChartPlotEngine.this.plotInstance.getMasterPlotConfiguration().plotConfigurationChangeEventProcessed();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingTools.showFinalErrorMessage((String)"generic_plotter_error", (Throwable)e, (Object[])new Object[0]);
                }
            }
        };
        updateChartWorker.execute();
    }

    private synchronized void updateChartPanel(final JFreeChart chart) {
        Runnable updateChartPanelRunnable = new Runnable(){

            @Override
            public void run() {
                if (chart != JFreeChartPlotEngine.this.chartPanel.getChart()) {
                    if (chart == null) {
                        JFreeChartPlotEngine.this.chartPanel.setChart(new JFreeChart((Plot)new CategoryPlot()));
                        JFreeChartPlotEngine.this.fireChartChanged(new JFreeChart((Plot)new CategoryPlot()));
                    } else {
                        RenderingHints renderingHints = chart.getRenderingHints();
                        renderingHints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                        renderingHints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                        chart.setRenderingHints(renderingHints);
                        JFreeChartPlotEngine.this.chartPanel.setChart(chart);
                        JFreeChartPlotEngine.this.fireChartChanged(chart);
                    }
                }
                if (chart != null) {
                    JFreeChartPlotEngine.this.chartPanel.removeOverlay(JFreeChartPlotEngine.this.crosshairOverlay);
                    JFreeChartPlotEngine.this.crosshairOverlay = new MultiAxesCrosshairOverlay();
                    if (chart.getPlot() instanceof XYPlot) {
                        int axisIdx = 0;
                        for (RangeAxisConfig rangeAxisConfig : JFreeChartPlotEngine.this.plotInstance.getCurrentPlotConfigurationClone().getRangeAxisConfigs()) {
                            for (AxisParallelLineConfiguration line : rangeAxisConfig.getCrossHairLines().getLines()) {
                                Crosshair crosshair = new Crosshair(line.getValue(), (Paint)line.getFormat().getColor(), (Stroke)line.getFormat().getStroke());
                                JFreeChartPlotEngine.this.crosshairOverlay.addRangeCrosshair(axisIdx, crosshair);
                            }
                            ++axisIdx;
                        }
                        for (AxisParallelLineConfiguration line : JFreeChartPlotEngine.this.plotInstance.getCurrentPlotConfigurationClone().getDomainConfigManager().getCrosshairLines().getLines()) {
                            Crosshair crosshair = new Crosshair(line.getValue(), (Paint)line.getFormat().getColor(), (Stroke)line.getFormat().getStroke());
                            JFreeChartPlotEngine.this.crosshairOverlay.addDomainCrosshair(crosshair);
                        }
                        JFreeChartPlotEngine.this.chartPanel.addOverlay(JFreeChartPlotEngine.this.crosshairOverlay);
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            updateChartPanelRunnable.run();
        } else {
            SwingUtilities.invokeLater(updateChartPanelRunnable);
        }
    }

    public void endInitializing() {
        if (this.initializing) {
            this.initializing = false;
            this.plotInstance.triggerReplot();
        }
    }

    public void startInitializing() {
        this.initializing = true;
    }

    private JFreeChart createChart() throws ChartPlottimeException {
        Plot plot = this.createPlot();
        if (plot == null) {
            throw new ChartPlottimeException("The plot created was a NULL plot.", new Object[0]);
        }
        JFreeChart chart = new JFreeChart(plot);
        this.formatChart(chart);
        return chart;
    }

    private void formatChart(JFreeChart chart) {
        Plot plot = chart.getPlot();
        PlotConfiguration currentPlotConfigurationClone = this.plotInstance.getCurrentPlotConfigurationClone();
        plot.setBackgroundPaint((Paint)currentPlotConfigurationClone.getPlotBackgroundColor());
        this.formatLegend(chart);
        chart.setBackgroundPaint((Paint)currentPlotConfigurationClone.getChartBackgroundColor());
        String text = currentPlotConfigurationClone.getTitleText();
        if (text == null) {
            chart.setTitle(text);
        } else {
            Font font = currentPlotConfigurationClone.getTitleFont();
            if (font == null) {
                font = new Font("Dialog", 0, 10);
            }
            TextTitle textTitle = new TextTitle(text, font);
            textTitle.setPaint((Paint)currentPlotConfigurationClone.getTitleColor());
            chart.setTitle(textTitle);
        }
    }

    private void formatLegend(JFreeChart chart) {
        List<LegendTitle> legendTitles = this.createLegendTitles();
        while (chart.getLegend() != null) {
            chart.removeLegend();
        }
        for (LegendTitle legendTitle : legendTitles) {
            chart.addLegend(legendTitle);
        }
        Font legendFont = this.plotInstance.getCurrentPlotConfigurationClone().getLegendConfiguration().getLegendFont();
        if (legendFont != null) {
            for (LegendTitle legendTitle : legendTitles) {
                legendTitle.setItemFont(legendFont);
            }
        }
    }

    private void invalidateCache() {
        this.cachedLegendItems = null;
    }

    public boolean replot() {
        if (this.initializing) {
            return true;
        }
        this.plotInstance.getMasterOfDesaster().clearAll();
        this.invalidateCache();
        this.updateChartPanelChart(true);
        return false;
    }

    private boolean isPlotInstanceValid() {
        this.plotInstance.getMasterOfDesaster().clearAll();
        if (!this.plotInstance.isValid()) {
            StaticDebug.debug("######## CAUTION: INVALID PLOT INSTANCE!!");
            if (!this.plotInstance.getCurrentPlotConfigurationClone().isValid()) {
                ConfigurationChangeResponse response = new ConfigurationChangeResponse();
                for (PlotConfigurationError error : this.plotInstance.getCurrentPlotConfigurationClone().getErrors()) {
                    response.addError(error);
                }
                this.plotInstance.getMasterOfDesaster().registerConfigurationChangeResponse(response);
                return false;
            }
            ConfigurationChangeResponse response = new ConfigurationChangeResponse();
            for (PlotConfigurationError error : this.plotInstance.getPlotData().getErrors()) {
                response.addError(error);
            }
            this.plotInstance.getMasterOfDesaster().registerConfigurationChangeResponse(response);
            return false;
        }
        return true;
    }

    private void setChartTitle() {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            String text = this.plotInstance.getCurrentPlotConfigurationClone().getTitleText();
            if (text == null) {
                chart.setTitle(text);
                return;
            }
            Font font = this.plotInstance.getCurrentPlotConfigurationClone().getTitleFont();
            if (font == null) {
                font = new Font("Dialog", 0, 10);
            }
            TextTitle textTitle = new TextTitle(text, font);
            textTitle.setPaint((Paint)this.plotInstance.getCurrentPlotConfigurationClone().getTitleColor());
            chart.setTitle(textTitle);
        }
    }

    private void setDomainAxisLabel(String name) {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            Plot plot = chart.getPlot();
            if (plot instanceof CategoryPlot) {
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                CategoryAxis domainAxis = categoryPlot.getDomainAxis();
                if (domainAxis != null) {
                    domainAxis.setLabel(name);
                }
            } else {
                XYPlot xyPlot = (XYPlot)plot;
                ValueAxis domainAxis = xyPlot.getDomainAxis();
                if (domainAxis != null) {
                    domainAxis.setLabel(name);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDomainAxisDateFormat(DateFormat dateFormat) {
        this.checkWarnings();
        JFreeChart chart = this.getCurrentChart();
        if (chart == null) return;
        Plot plot = chart.getPlot();
        if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            CategoryAxis domainAxis = categoryPlot.getDomainAxis();
            if (domainAxis == null) return;
        }
        XYPlot xyPlot = (XYPlot)plot;
        ValueAxis domainAxis = xyPlot.getDomainAxis();
        if (domainAxis == null || !(domainAxis instanceof DateAxis)) return;
        DateAxis dateAxis = (DateAxis)domainAxis;
        if (this.getPlotInstance().getCurrentPlotConfigurationClone().getDomainConfigManager().isUsingUserDefinedDateFormat()) {
            dateAxis.setDateFormatOverride(dateFormat);
            dateAxis.setTimeZone(TimeZone.getTimeZone("GMT"));
            return;
        } else {
            dateAxis.setDateFormatOverride(null);
        }
    }

    private void setRangeAxisLabel(String name, RangeAxisConfig source) {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            Plot plot = chart.getPlot();
            int rangeAxisIdx = this.plotInstance.getCurrentPlotConfigurationClone().getIndexOfRangeAxisConfigById(source.getId());
            if (rangeAxisIdx == -1) {
                return;
            }
            if (plot instanceof CategoryPlot) {
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                ValueAxis valueAxis = categoryPlot.getRangeAxis(rangeAxisIdx);
                if (valueAxis != null) {
                    valueAxis.setLabel(name);
                }
            } else {
                XYPlot xyPlot = (XYPlot)plot;
                ValueAxis valueAxis = xyPlot.getRangeAxis(rangeAxisIdx);
                if (valueAxis != null) {
                    valueAxis.setLabel(name);
                }
            }
        }
    }

    private void setPlotBackgroundColor(Color backgroundColor) {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            Plot plot = chart.getPlot();
            if (plot instanceof CategoryPlot) {
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                categoryPlot.setBackgroundPaint((Paint)backgroundColor);
            } else {
                XYPlot xyPlot = (XYPlot)plot;
                xyPlot.setBackgroundPaint((Paint)backgroundColor);
            }
        }
    }

    private void setChartBackgroundColor(Color backgroundColor) {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            chart.setBackgroundPaint((Paint)backgroundColor);
        }
    }

    private void setAxesFont(Font axesFont) {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            Plot plot = chart.getPlot();
            if (plot instanceof CategoryPlot) {
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                int rangeAxisCount = categoryPlot.getRangeAxisCount();
                for (int i = 0; i < rangeAxisCount; ++i) {
                    ValueAxis valueAxis = categoryPlot.getRangeAxis(i);
                    if (valueAxis == null) continue;
                    valueAxis.setLabelFont(axesFont);
                    valueAxis.setTickLabelFont(axesFont);
                }
                CategoryAxis domainAxis = categoryPlot.getDomainAxis();
                if (domainAxis != null) {
                    domainAxis.setLabelFont(axesFont);
                    domainAxis.setTickLabelFont(axesFont);
                }
            } else {
                XYPlot xyPlot = (XYPlot)plot;
                int rangeAxisCount = xyPlot.getRangeAxisCount();
                for (int i = 0; i < rangeAxisCount; ++i) {
                    ValueAxis rangeAxis = xyPlot.getRangeAxis(i);
                    if (rangeAxis == null) continue;
                    rangeAxis.setLabelFont(axesFont);
                    rangeAxis.setTickLabelFont(axesFont);
                }
                ValueAxis domainAxis = xyPlot.getDomainAxis();
                if (domainAxis != null) {
                    domainAxis.setLabelFont(axesFont);
                    domainAxis.setTickLabelFont(axesFont);
                }
            }
        }
    }

    private List<LegendTitle> createLegendTitles() {
        LinkedList<LegendTitle> legendTitles = new LinkedList<LegendTitle>();
        LegendConfiguration legendConfiguration = this.plotInstance.getCurrentPlotConfigurationClone().getLegendConfiguration();
        SmartLegendTitle legendTitle = new SmartLegendTitle(this, (Arrangement)new FlowArrangement(HorizontalAlignment.CENTER, VerticalAlignment.CENTER, 30.0, 2.0), (Arrangement)new ColumnArrangement(HorizontalAlignment.LEFT, VerticalAlignment.CENTER, 0.0, 2.0));
        legendTitle.setItemPaint(legendConfiguration.getLegendFontColor());
        RectangleEdge position = legendConfiguration.getLegendPosition().getPosition();
        if (position == null) {
            return legendTitles;
        }
        legendTitle.setPosition(position);
        if (legendConfiguration.isShowLegendFrame()) {
            legendTitle.setFrame((BlockFrame)new BlockBorder((Paint)legendConfiguration.getLegendFrameColor()));
        }
        ColoredBlockContainer wrapper = new ColoredBlockContainer(legendConfiguration.getLegendBackgroundColor());
        wrapper.add((Block)legendTitle.getItemContainer());
        wrapper.setPadding(3.0, 3.0, 3.0, 3.0);
        legendTitle.setWrapper(wrapper);
        legendTitles.add(legendTitle);
        return legendTitles;
    }

    private Plot createPlot() throws ChartPlottimeException {
        LinkAndBrushXYPlot xyPlot;
        PlotConfiguration currentPlotConfigurationClone = this.plotInstance.getCurrentPlotConfigurationClone();
        List<RangeAxisConfig> rangeAxes = currentPlotConfigurationClone.getRangeAxisConfigs();
        LinkAndBrushPlot plot = null;
        DataTableColumn.ValueType domainAxisType = currentPlotConfigurationClone.getDomainConfigManager().getValueType();
        if (domainAxisType == DataTableColumn.ValueType.NOMINAL) {
            LinkAndBrushCategoryPlot categoryPlot = new LinkAndBrushCategoryPlot();
            categoryPlot.setDomainAxis(ChartAxisFactory.createCategoryDomainAxis(currentPlotConfigurationClone));
            categoryPlot.setOrientation(currentPlotConfigurationClone.getOrientation());
            plot = categoryPlot;
        } else if (domainAxisType == DataTableColumn.ValueType.NUMERICAL) {
            xyPlot = new LinkAndBrushXYPlot();
            xyPlot.setDomainAxis(ChartAxisFactory.createNumericalDomainAxis(this.plotInstance));
            xyPlot.setOrientation(currentPlotConfigurationClone.getOrientation());
            plot = xyPlot;
        } else if (domainAxisType == DataTableColumn.ValueType.DATE_TIME) {
            xyPlot = new LinkAndBrushXYPlot();
            xyPlot.setDomainAxis(ChartAxisFactory.createDateDomainAxis(this.plotInstance));
            xyPlot.setOrientation(currentPlotConfigurationClone.getOrientation());
            plot = xyPlot;
        } else {
            if (domainAxisType == DataTableColumn.ValueType.INVALID) {
                throw new ChartPlottimeException("illegal_domain_type", new Object[]{domainAxisType});
            }
            if (domainAxisType == DataTableColumn.ValueType.UNKNOWN && currentPlotConfigurationClone.getAllValueSources().isEmpty()) {
                throw new ChartPlottimeException("no_value_source_defined", new Object[0]);
            }
            if (domainAxisType == DataTableColumn.ValueType.UNKNOWN) {
                throw new ChartPlottimeException("unknown_dimension_value_type", new Object[0]);
            }
            throw new RuntimeException("Item placement is neither categorical, date or numerical. This cannot happen.");
        }
        int rangeAxisIdx = 0;
        for (RangeAxisConfig rangeAxisConfig : rangeAxes) {
            List<ValueSource> valueSources = rangeAxisConfig.getValueSources();
            for (ValueSource valueSource : valueSources) {
                XYPlot xyPlot2;
                Vector<DimensionConfig.PlotDimension> dimensionVector = new Vector<DimensionConfig.PlotDimension>();
                dimensionVector.addAll(currentPlotConfigurationClone.getDefaultDimensionConfigs().keySet());
                if (domainAxisType == DataTableColumn.ValueType.NOMINAL) {
                    if (!valueSource.isUsingRelativeIndicator()) {
                        throw new ChartPlottimeException("absolute_indicator_but_nominal_domain", valueSource.getLabel());
                    }
                    CategoryPlot categoryPlot = plot;
                    this.addDataAndRendererToCategoryPlot(valueSource, categoryPlot, rangeAxisIdx);
                    continue;
                }
                if (domainAxisType == DataTableColumn.ValueType.NUMERICAL) {
                    xyPlot2 = (XYPlot)plot;
                    this.addDataAndRendererToXYPlot(valueSource, xyPlot2, rangeAxisIdx);
                    continue;
                }
                if (domainAxisType == DataTableColumn.ValueType.DATE_TIME) {
                    xyPlot2 = (XYPlot)plot;
                    this.addDataAndRendererToXYPlot(valueSource, xyPlot2, rangeAxisIdx);
                    continue;
                }
                throw new RuntimeException("Item placement is neither categorical nor numerical. This cannot happen.");
            }
            ValueAxis rangeAxis = ChartAxisFactory.createRangeAxis(rangeAxisConfig, this.plotInstance);
            if (rangeAxis != null) {
                if (domainAxisType == DataTableColumn.ValueType.NUMERICAL || domainAxisType == DataTableColumn.ValueType.DATE_TIME) {
                    try {
                        XYPlot xyPlot3 = (XYPlot)plot;
                        xyPlot3.setRangeAxis(rangeAxisIdx, rangeAxis);
                    }
                    catch (RuntimeException e) {
                        if (this.isProbablyZeroValuesOnLogScaleException(e)) {
                            String label = rangeAxisConfig.getLabel();
                            if (label == null) {
                                label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
                            }
                            throw new ChartPlottimeException("gui.plotter.error.log_axis_contains_zero", label);
                        }
                        throw e;
                    }
                } else if (domainAxisType == DataTableColumn.ValueType.NOMINAL) {
                    CategoryPlot categoryPlot = plot;
                    categoryPlot.setRangeAxis(rangeAxisIdx, rangeAxis);
                } else {
                    throw new RuntimeException("illegal value type on domain axis - this should not happen because of the checks above.");
                }
            }
            ++rangeAxisIdx;
        }
        return plot;
    }

    private void checkWarnings() {
        ConfigurationChangeResponse warningsResponse;
        this.plotInstance.getMasterOfDesaster().clearWarnings();
        if (this.plotInstance.hasWarnings()) {
            warningsResponse = new ConfigurationChangeResponse();
            for (PlotConfigurationError warning : this.plotInstance.getWarnings()) {
                warningsResponse.addWarning(warning);
            }
            this.plotInstance.getMasterOfDesaster().registerConfigurationChangeResponse(warningsResponse);
        }
        if (!this.getEngineWarnings().isEmpty()) {
            warningsResponse = new ConfigurationChangeResponse();
            for (PlotConfigurationError warning : this.getEngineWarnings()) {
                warningsResponse.addWarning(warning);
            }
            this.plotInstance.getMasterOfDesaster().registerConfigurationChangeResponse(warningsResponse);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addDataAndRendererToXYPlot(ValueSource valueSource, XYPlot plot, int rangeAxisIdx) throws ChartPlottimeException {
        void var8_30;
        XYItemRenderer renderer;
        SeriesFormat.VisualizationType seriesType = valueSource.getSeriesFormat().getSeriesType();
        SeriesFormat.StackingMode stackingMode = valueSource.getSeriesFormat().getStackingMode();
        SeriesFormat.IndicatorType errorIndicator = valueSource.getSeriesFormat().getUtilityUsage();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfigData domainConfigData = this.plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        if (seriesType == SeriesFormat.VisualizationType.LINES_AND_SHAPES) {
            if (errorIndicator == SeriesFormat.IndicatorType.DIFFERENCE) {
                XYItemRenderer[] renderers = ChartRendererFactory.createXYDifferenceRenderers(valueSource, this.plotInstance);
                if (domainConfigData.hasDuplicateValues()) {
                    this.throwDuplicateValuesNotSupported(valueSource, DimensionConfig.PlotDimension.DOMAIN);
                }
                for (int seriesIdx = 0; seriesIdx < renderers.length; ++seriesIdx) {
                    XYDataset xYDataset = ChartDatasetFactory.createDefaultXYDataset(valueSource, seriesIdx, this.plotInstance);
                    XYItemRenderer renderer2 = renderers[seriesIdx];
                    this.pushDataAndRendererIntoPlot(plot, rangeAxisIdx, renderer2, xYDataset);
                }
                return;
            }
            if (errorIndicator == SeriesFormat.IndicatorType.BARS) {
                DefaultIntervalXYDataset defaultIntervalXYDataset = ChartDatasetFactory.createDefaultIntervalXYDataset(valueSource, this.plotInstance, true);
                renderer = ChartRendererFactory.createXYErrorRenderer(valueSource, this.plotInstance, (XYDataset)defaultIntervalXYDataset);
            } else if (errorIndicator == SeriesFormat.IndicatorType.BAND) {
                DefaultIntervalXYDataset defaultIntervalXYDataset = ChartDatasetFactory.createDefaultIntervalXYDataset(valueSource, this.plotInstance, true);
                renderer = ChartRendererFactory.createDeviationRenderer(valueSource, this.plotInstance);
            } else {
                if (errorIndicator != SeriesFormat.IndicatorType.NONE) throw new IllegalArgumentException("unknown error indicator");
                XYDataset xYDataset = ChartDatasetFactory.createDefaultXYDataset(valueSource, this.plotInstance);
                renderer = ChartRendererFactory.createXYLineAndShapeRenderer(valueSource, this.plotInstance);
            }
        } else if (seriesType == SeriesFormat.VisualizationType.BARS) {
            if (errorIndicator != SeriesFormat.IndicatorType.NONE) {
                PlotConfigurationError error = new PlotConfigurationError("error_indicator_not_supported", valueSource.toString(), errorIndicator.getName());
                SeriesFormatChangeEvent change = new SeriesFormatChangeEvent(valueSource.getSeriesFormat(), SeriesFormat.IndicatorType.NONE);
                error.addQuickFix(new PlotConfigurationQuickFix(change));
                change = new SeriesFormatChangeEvent(valueSource.getSeriesFormat(), SeriesFormat.VisualizationType.LINES_AND_SHAPES);
                error.addQuickFix(new PlotConfigurationQuickFix(change));
                throw new ChartPlottimeException(error);
            }
            if (stackingMode == SeriesFormat.StackingMode.NONE) {
                if (!valueSource.isUsingDomainGrouping() || !domainConfig.getGrouping().definesUpperLowerBounds()) {
                    XYSeriesCollection xYSeriesCollection = ChartDatasetFactory.createXYSeriesCollection(valueSource, this.plotInstance, 0.95, false, true);
                } else {
                    DefaultIntervalXYDataset defaultIntervalXYDataset = ChartDatasetFactory.createDefaultIntervalXYDataset(valueSource, this.plotInstance, false);
                }
                renderer = ChartRendererFactory.createClusteredXYBarRenderer(valueSource, this.plotInstance);
            } else if (stackingMode == SeriesFormat.StackingMode.ABSOLUTE) {
                DefaultTableXYDataset defaultTableXYDataset = ChartDatasetFactory.createDefaultTableXYDataset(valueSource, this.plotInstance);
                renderer = ChartRendererFactory.createStackedXYBarRenderer(valueSource, this.plotInstance, false);
            } else {
                if (stackingMode != SeriesFormat.StackingMode.RELATIVE) throw new IllegalArgumentException("unknown stacking mode");
                DefaultTableXYDataset defaultTableXYDataset = ChartDatasetFactory.createDefaultTableXYDataset(valueSource, this.plotInstance);
                renderer = ChartRendererFactory.createStackedXYBarRenderer(valueSource, this.plotInstance, true);
            }
        } else {
            if (seriesType != SeriesFormat.VisualizationType.AREA) throw new IllegalArgumentException("unknown series type: " + (Object)((Object)seriesType));
            if (errorIndicator != SeriesFormat.IndicatorType.NONE) {
                PlotConfigurationError error = new PlotConfigurationError("error_indicator_not_supported", valueSource.toString(), errorIndicator.getName());
                SeriesFormatChangeEvent change = new SeriesFormatChangeEvent(valueSource.getSeriesFormat(), SeriesFormat.IndicatorType.NONE);
                error.addQuickFix(new PlotConfigurationQuickFix(change));
                change = new SeriesFormatChangeEvent(valueSource.getSeriesFormat(), SeriesFormat.VisualizationType.LINES_AND_SHAPES);
                error.addQuickFix(new PlotConfigurationQuickFix(change));
                throw new ChartPlottimeException(error);
            }
            if (stackingMode == SeriesFormat.StackingMode.NONE) {
                XYSeriesCollection xYSeriesCollection = ChartDatasetFactory.createXYSeriesCollection(valueSource, this.plotInstance, 0.0, false, true);
                renderer = ChartRendererFactory.createXYAreaRenderer2(valueSource, this.plotInstance);
            } else if (stackingMode == SeriesFormat.StackingMode.ABSOLUTE) {
                DefaultTableXYDataset defaultTableXYDataset = ChartDatasetFactory.createDefaultTableXYDataset(valueSource, this.plotInstance);
                renderer = ChartRendererFactory.createStackedXYAreaRenderer2(valueSource, this.plotInstance, false);
            } else {
                if (stackingMode != SeriesFormat.StackingMode.RELATIVE) throw new IllegalArgumentException("unknown stacking mode: " + (Object)((Object)stackingMode));
                PlotConfigurationError error = new PlotConfigurationError("stacking_mode_not_supported", valueSource.toString(), stackingMode.getName());
                SeriesFormatChangeEvent change = new SeriesFormatChangeEvent(valueSource.getSeriesFormat(), SeriesFormat.StackingMode.ABSOLUTE);
                error.addQuickFix(new PlotConfigurationQuickFix(change));
                throw new ChartPlottimeException(error);
            }
        }
        this.pushDataAndRendererIntoPlot(plot, rangeAxisIdx, renderer, (XYDataset)var8_30);
    }

    private void pushDataAndRendererIntoPlot(XYPlot plot, int rangeAxisIdx, XYItemRenderer renderer, XYDataset dataset) throws ChartPlottimeException {
        int datasetIdx;
        if (dataset != null && renderer != null) {
            datasetIdx = plot.getDatasetCount();
            if (datasetIdx > 0 && plot.getDataset(datasetIdx - 1) == null) {
                --datasetIdx;
            }
            try {
                plot.setDataset(datasetIdx, dataset);
            }
            catch (RuntimeException e) {
                if (this.isProbablyZeroValuesOnLogScaleException(e)) {
                    throw new ChartPlottimeException("gui.plotter.error.log_axis_contains_zero", "domain axis");
                }
                throw e;
            }
        } else {
            ChartPlottimeException chartPlottimeException = new ChartPlottimeException(new PlotConfigurationError("generic_plotter_error", new Object[0]));
            throw chartPlottimeException;
        }
        plot.mapDatasetToRangeAxis(datasetIdx, rangeAxisIdx);
        plot.setRenderer(datasetIdx, renderer);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addDataAndRendererToCategoryPlot(ValueSource valueSource, CategoryPlot plot, int rangeAxisIdx) throws ChartPlottimeException {
        int datasetIdx;
        void var10_31;
        void var11_20;
        SeriesFormat.VisualizationType seriesType = valueSource.getSeriesFormat().getSeriesType();
        SeriesFormat.StackingMode stackingMode = valueSource.getSeriesFormat().getStackingMode();
        SeriesFormat.IndicatorType errorIndicator = valueSource.getSeriesFormat().getUtilityUsage();
        DefaultDimensionConfig domainConfig = valueSource.getDomainConfig();
        DimensionConfigData domainConfigData = this.plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        ValueSourceData valueSourceData = this.plotInstance.getPlotData().getValueSourceData(valueSource);
        if (seriesType == SeriesFormat.VisualizationType.LINES_AND_SHAPES) {
            if (errorIndicator == SeriesFormat.IndicatorType.DIFFERENCE || errorIndicator == SeriesFormat.IndicatorType.BAND) {
                this.throwErrorIndicatorNotSupported(valueSource, errorIndicator);
                return;
            }
            if (errorIndicator == SeriesFormat.IndicatorType.BARS) {
                if (domainConfigData.hasDuplicateValues()) {
                    this.throwDuplicateValuesNotSupported(valueSource, DimensionConfig.PlotDimension.DOMAIN);
                    return;
                }
                DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = ChartDatasetFactory.createDefaultStatisticalCategoryDataset(valueSource, this.plotInstance);
                FormattedStatisticalLineAndShapeRenderer formattedStatisticalLineAndShapeRenderer = ChartRendererFactory.createStatisticalLineAndShapeRenderer(valueSource, this.plotInstance);
            } else {
                if (errorIndicator != SeriesFormat.IndicatorType.NONE) throw new IllegalArgumentException("unknown error indicator: " + (Object)((Object)errorIndicator));
                if (valueSource.isUsingDomainGrouping()) {
                    CategoryDataset categoryDataset = ChartDatasetFactory.createDefaultCategoryDataset(valueSource, this.plotInstance, false, true);
                    FormattedLineAndShapeRenderer formattedLineAndShapeRenderer = ChartRendererFactory.createLineAndShapeRenderer(valueSource, this.plotInstance);
                } else {
                    ValueSourceToMultiValueCategoryDatasetAdapter valueSourceToMultiValueCategoryDatasetAdapter = new ValueSourceToMultiValueCategoryDatasetAdapter(valueSourceData, this.plotInstance);
                    FormattedScatterRenderer formattedScatterRenderer = ChartRendererFactory.createScatterRenderer(valueSource, this.plotInstance);
                }
            }
        } else if (seriesType == SeriesFormat.VisualizationType.BARS) {
            if (domainConfigData.hasDuplicateValues()) {
                this.throwDuplicateValuesNotSupported(valueSource, DimensionConfig.PlotDimension.DOMAIN);
            }
            if (errorIndicator != SeriesFormat.IndicatorType.NONE && errorIndicator != SeriesFormat.IndicatorType.BARS || errorIndicator != SeriesFormat.IndicatorType.NONE && stackingMode != SeriesFormat.StackingMode.NONE) {
                this.throwErrorIndicatorNotSupported(valueSource, errorIndicator);
                return;
            }
            if (stackingMode == SeriesFormat.StackingMode.NONE) {
                if (errorIndicator == SeriesFormat.IndicatorType.BARS) {
                    DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = ChartDatasetFactory.createDefaultStatisticalCategoryDataset(valueSource, this.plotInstance);
                    FormattedStatisticalBarRenderer formattedStatisticalBarRenderer = ChartRendererFactory.createStatisticalBarRenderer(valueSource, this.plotInstance);
                } else {
                    CategoryDataset categoryDataset = ChartDatasetFactory.createDefaultCategoryDataset(valueSource, this.plotInstance, false, true);
                    FormattedBarRenderer formattedBarRenderer = ChartRendererFactory.createBarRenderer(valueSource, this.plotInstance);
                }
            } else if (stackingMode == SeriesFormat.StackingMode.ABSOLUTE) {
                CategoryDataset categoryDataset = ChartDatasetFactory.createDefaultCategoryDataset(valueSource, this.plotInstance, true, false);
                FormattedStackedBarRenderer formattedStackedBarRenderer = ChartRendererFactory.createStackedBarRenderer(valueSource, this.plotInstance, false);
            } else {
                if (stackingMode != SeriesFormat.StackingMode.RELATIVE) throw new IllegalArgumentException("unknown stacking mode");
                CategoryDataset categoryDataset = ChartDatasetFactory.createDefaultCategoryDataset(valueSource, this.plotInstance, true, false);
                FormattedStackedBarRenderer formattedStackedBarRenderer = ChartRendererFactory.createStackedBarRenderer(valueSource, this.plotInstance, true);
            }
        } else {
            if (seriesType != SeriesFormat.VisualizationType.AREA) throw new IllegalArgumentException("unknown series type: " + (Object)((Object)seriesType));
            if (domainConfigData.hasDuplicateValues()) {
                this.throwDuplicateValuesNotSupported(valueSource, DimensionConfig.PlotDimension.DOMAIN);
            }
            if (errorIndicator != SeriesFormat.IndicatorType.NONE) {
                this.throwErrorIndicatorNotSupported(valueSource, errorIndicator);
                return;
            }
            if (stackingMode == SeriesFormat.StackingMode.NONE) {
                CategoryDataset categoryDataset = ChartDatasetFactory.createDefaultCategoryDataset(valueSource, this.plotInstance, false, true);
                FormattedAreaRenderer formattedAreaRenderer = ChartRendererFactory.createAreaRenderer(valueSource, this.plotInstance);
            } else if (stackingMode == SeriesFormat.StackingMode.ABSOLUTE) {
                CategoryDataset categoryDataset = ChartDatasetFactory.createDefaultCategoryDataset(valueSource, this.plotInstance, true, false);
                FormattedStackedAreaRenderer formattedStackedAreaRenderer = ChartRendererFactory.createStackedAreaRenderer(valueSource, this.plotInstance, false);
            } else {
                if (stackingMode != SeriesFormat.StackingMode.RELATIVE) throw new IllegalArgumentException("unknown stacking mode: " + (Object)((Object)stackingMode));
                CategoryDataset categoryDataset = ChartDatasetFactory.createDefaultCategoryDataset(valueSource, this.plotInstance, true, false);
                FormattedStackedAreaRenderer formattedStackedAreaRenderer = ChartRendererFactory.createStackedAreaRenderer(valueSource, this.plotInstance, true);
            }
        }
        if (var11_20 != null && var10_31 != null) {
            datasetIdx = plot.getDatasetCount();
            if (datasetIdx > 0 && plot.getDataset(datasetIdx - 1) == null) {
                --datasetIdx;
            }
            try {
                plot.setDataset(datasetIdx, (CategoryDataset)var11_20);
            }
            catch (RuntimeException e) {
                if (!this.isProbablyZeroValuesOnLogScaleException(e)) throw e;
                throw new ChartPlottimeException("gui.plotter.error.log_axis_contains_zero", "domain axis");
            }
        } else {
            ChartPlottimeException chartPlottimeException = new ChartPlottimeException(new PlotConfigurationError("generic_plotter_error", new Object[0]));
            throw chartPlottimeException;
        }
        plot.mapDatasetToRangeAxis(datasetIdx, rangeAxisIdx);
        plot.setRenderer(datasetIdx, (CategoryItemRenderer)var10_31);
    }

    private void throwDuplicateValuesNotSupported(ValueSource valueSource, DimensionConfig.PlotDimension dimension) throws ChartPlottimeException {
        throw new ChartPlottimeException("duplicate_value", valueSource.toString(), dimension.getName());
    }

    private void throwErrorIndicatorNotSupported(ValueSource valueSource, SeriesFormat.IndicatorType errorIndicator) throws ChartPlottimeException {
        PlotConfigurationError error = new PlotConfigurationError("error_indicator_not_supported", valueSource.toString(), errorIndicator.getName());
        SeriesFormatChangeEvent change = new SeriesFormatChangeEvent(valueSource.getSeriesFormat(), SeriesFormat.IndicatorType.NONE);
        error.addQuickFix(new PlotConfigurationQuickFix(change));
        throw new ChartPlottimeException(error);
    }

    private void chartTitleChanged() {
        this.setChartTitle();
    }

    private void rangeAxisConfigAxisChanged(RangeAxisConfig rangeAxisConfig) {
        if (!this.isPlotInstanceValid()) {
            this.updateChartPanel(new JFreeChart((Plot)new CategoryPlot()));
            this.currentChartIsValid = false;
            return;
        }
        int axisIdx = this.plotInstance.getCurrentPlotConfigurationClone().getIndexOfRangeAxisConfigById(rangeAxisConfig.getId());
        if (axisIdx == -1) {
            return;
        }
        if (this.currentChartIsValid) {
            try {
                JFreeChart chart;
                ValueAxis updatedAxis = ChartAxisFactory.createRangeAxis(rangeAxisConfig, this.plotInstance);
                if (updatedAxis != null && (chart = this.getCurrentChart()) != null) {
                    Plot plot = chart.getPlot();
                    if (plot instanceof XYPlot) {
                        ((XYPlot)plot).setRangeAxis(axisIdx, updatedAxis);
                    } else if (plot instanceof CategoryPlot) {
                        ((CategoryPlot)plot).setRangeAxis(axisIdx, updatedAxis);
                    }
                }
                this.checkWarnings();
            }
            catch (ChartPlottimeException e) {
                this.handlePlottimeException(e);
            }
            catch (RuntimeException e) {
                if (this.isProbablyZeroValuesOnLogScaleException(e)) {
                    String label = rangeAxisConfig.getLabel();
                    if (label == null) {
                        label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
                    }
                    this.handlePlottimeException(new ChartPlottimeException("gui.plotter.error.log_axis_contains_zero", label));
                }
                throw e;
            }
        } else {
            this.updateChartPanelChart(true);
        }
    }

    private boolean isProbablyZeroValuesOnLogScaleException(RuntimeException e) {
        return "Values less than or equal to zero not allowed with logarithmic axis".equals(e.getMessage());
    }

    private void legendPositionChanged(LegendConfiguration.LegendPosition legendPosition) {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            LegendTitle legend = chart.getLegend();
            RectangleEdge position = legendPosition.getPosition();
            if (legend != null) {
                if (position != null) {
                    legend.setPosition(position);
                } else {
                    while (chart.getLegend() != null) {
                        chart.removeLegend();
                    }
                }
            } else if (position != null) {
                this.resetLegend();
            }
        }
    }

    private void plotBackgroundColorChanged(Color backgroundColor) {
        this.setPlotBackgroundColor(backgroundColor);
    }

    private void axesFontChanged(Font axesFont) {
        this.setAxesFont(axesFont);
    }

    private void legendFontChanged(Font legendFont) {
        this.resetLegend();
    }

    private void chartBackgroundColorChanged(Color chartBackgroundColor) {
        this.setChartBackgroundColor(chartBackgroundColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlotInstance(PlotInstance plotInstance) {
        if (plotInstance == null) {
            throw new IllegalArgumentException("null PlotConfiguration not allowed");
        }
        Object object = this.nextPlotInstanceLock;
        synchronized (object) {
            if (this.updatingChart.get()) {
                if (plotInstance != this.plotInstance) {
                    StaticDebug.debug("Set NEW PLOTINSTANCE for PlotEnginge " + plotInstance);
                    this.nextPlotInstance = plotInstance;
                }
            } else {
                this.nextPlotInstance = plotInstance;
                this.privateSetPlotInstance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updatingChartPanelChartDone() {
        StaticDebug.debug("Updating chart done!");
        this.updatingChart.getAndSet(false);
        Object object = this.nextPlotInstanceLock;
        synchronized (object) {
            if (this.nextPlotInstance != null) {
                this.privateSetPlotInstance();
            }
        }
    }

    private void privateSetPlotInstance() {
        StaticDebug.debug("PlotInstance has changed. Replacing..");
        this.unsubscribeFromPlotInstance(this.plotInstance);
        this.subscribeAtPlotInstance(this.nextPlotInstance);
        this.plotInstance = this.nextPlotInstance;
        this.nextPlotInstance = null;
        this.plotInstance.triggerReplot();
    }

    private void unsubscribeFromPlotInstance(PlotInstance plotInstance) {
        this.initializing = true;
        PlotConfiguration masterPlotConfiguration = plotInstance.getMasterPlotConfiguration();
        masterPlotConfiguration.removePlotConfigurationListener(this);
        masterPlotConfiguration.removePlotConfigurationProcessingListener(this);
        this.endProcessing();
        this.chartPanel.removeLinkAndBrushSelectionListener(masterPlotConfiguration);
        this.initializing = false;
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        boolean processed;
        PlotConfigurationChangeEvent.PlotConfigurationChangeType type = change.getType();
        switch (type) {
            case DIMENSION_CONFIG_ADDED: 
            case DIMENSION_CONFIG_REMOVED: 
            case RANGE_AXIS_CONFIG_ADDED: 
            case RANGE_AXIS_CONFIG_MOVED: 
            case RANGE_AXIS_CONFIG_REMOVED: 
            case COLOR_SCHEME: 
            case DATA_TABLE_EXCHANGED: 
            case TRIGGER_REPLOT: 
            case META_CHANGE: {
                processed = this.replot();
                break;
            }
            case AXES_FONT: {
                this.axesFontChanged(change.getAxesFont());
                processed = true;
                break;
            }
            case FRAME_BACKGROUND_COLOR: {
                this.chartBackgroundColorChanged(change.getFrameBackgroundColor());
                processed = true;
                break;
            }
            case CHART_TITLE: {
                this.chartTitleChanged();
                processed = true;
                break;
            }
            case DIMENSION_CONFIG_CHANGED: {
                processed = this.dimensionConfigChanged(change.getDimensionChange());
                break;
            }
            case LEGEND_CHANGED: {
                this.legendChanged(change.getLegendConfigurationChangeEvent());
                processed = true;
                break;
            }
            case PLOT_BACKGROUND_COLOR: {
                this.plotBackgroundColorChanged(change.getPlotBackgroundColor());
                processed = true;
                break;
            }
            case RANGE_AXIS_CONFIG_CHANGED: {
                processed = this.rangeAxisConfigChanged(change.getRangeAxisConfigChange());
                break;
            }
            case PLOT_ORIENTATION: {
                this.plotOrientationChanged(change.getOrientation());
                processed = true;
                break;
            }
            case AXIS_LINE_COLOR: {
                this.axisLineColorChanged(change.getDomainAxisLineColor());
                processed = true;
                break;
            }
            case AXIS_LINE_WIDTH: {
                this.axisLineWidthChanged(Float.valueOf(change.getDomainAxisLineWidth()));
                processed = true;
                break;
            }
            case LINK_AND_BRUSH_SELECTION: {
                this.checkWarnings();
                processed = this.replot();
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type " + (Object)((Object)type) + ". This should not happen.");
            }
        }
        return processed;
    }

    private void legendChanged(LegendConfigurationChangeEvent change) {
        switch (change.getType()) {
            case FONT: {
                this.legendFontChanged(change.getLegendFont());
                break;
            }
            case POSITON: {
                this.legendPositionChanged(change.getLegendPosition());
                break;
            }
            case SHOW_DIMENSION_TYPE: {
                this.legendShowDimensionTypeChanged(change.isShowDimensionType());
                break;
            }
            default: {
                this.resetLegend();
            }
        }
    }

    private void legendShowDimensionTypeChanged(boolean showDimensionType) {
        this.resetLegend();
    }

    private void resetLegend() {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            this.updateLegendItems();
            this.formatLegend(chart);
            this.checkWarnings();
        }
    }

    private void axisLineColorChanged(Color lineColor) {
        block2: {
            Plot plot;
            block3: {
                JFreeChart chart = this.getCurrentChart();
                if (chart == null) break block2;
                plot = chart.getPlot();
                if (!(plot instanceof CategoryPlot)) break block3;
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                ChartAxisFactory.formatAxis(this.plotInstance.getCurrentPlotConfigurationClone(), (Axis)categoryPlot.getDomainAxis());
                int rangeAxisCount = categoryPlot.getRangeAxisCount();
                for (int i = 0; i < rangeAxisCount; ++i) {
                    ValueAxis valueAxis = categoryPlot.getRangeAxis(i);
                    if (valueAxis == null) continue;
                    ChartAxisFactory.formatAxis(this.plotInstance.getCurrentPlotConfigurationClone(), (Axis)valueAxis);
                }
                break block2;
            }
            if (!(plot instanceof XYPlot)) break block2;
            XYPlot xyPlot = (XYPlot)plot;
            ChartAxisFactory.formatAxis(this.plotInstance.getCurrentPlotConfigurationClone(), (Axis)xyPlot.getDomainAxis());
            int rangeAxisCount = xyPlot.getRangeAxisCount();
            for (int i = 0; i < rangeAxisCount; ++i) {
                ValueAxis valueAxis = xyPlot.getRangeAxis(i);
                if (valueAxis == null) continue;
                valueAxis.setAxisLinePaint((Paint)lineColor);
                ChartAxisFactory.formatAxis(this.plotInstance.getCurrentPlotConfigurationClone(), (Axis)valueAxis);
            }
        }
    }

    private void axisLineWidthChanged(Float lineWidth) {
        block4: {
            BasicStroke stroke;
            Plot plot;
            block5: {
                JFreeChart chart = this.getCurrentChart();
                if (chart == null) break block4;
                plot = chart.getPlot();
                stroke = new BasicStroke(lineWidth.floatValue());
                if (!(plot instanceof CategoryPlot)) break block5;
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                CategoryAxis domainAxis = categoryPlot.getDomainAxis();
                if (domainAxis != null) {
                    domainAxis.setAxisLineStroke((Stroke)stroke);
                }
                int rangeAxisCount = categoryPlot.getRangeAxisCount();
                for (int i = 0; i < rangeAxisCount; ++i) {
                    ValueAxis valueAxis = categoryPlot.getRangeAxis(i);
                    if (valueAxis == null) continue;
                    valueAxis.setAxisLineStroke((Stroke)stroke);
                }
                break block4;
            }
            if (!(plot instanceof XYPlot)) break block4;
            XYPlot xyPlot = (XYPlot)plot;
            ValueAxis domainAxis = xyPlot.getDomainAxis();
            if (domainAxis != null) {
                domainAxis.setAxisLineStroke((Stroke)stroke);
            }
            int rangeAxisCount = xyPlot.getRangeAxisCount();
            for (int i = 0; i < rangeAxisCount; ++i) {
                ValueAxis valueAxis = xyPlot.getRangeAxis(i);
                if (valueAxis == null) continue;
                valueAxis.setAxisLineStroke((Stroke)stroke);
            }
        }
    }

    private void plotOrientationChanged(PlotOrientation orientation) {
        JFreeChart chart = this.getCurrentChart();
        if (chart != null) {
            Plot plot = chart.getPlot();
            if (plot instanceof CategoryPlot) {
                CategoryPlot categoryPlot = (CategoryPlot)plot;
                categoryPlot.setOrientation(orientation);
            } else if (plot instanceof XYPlot) {
                XYPlot xyPlot = (XYPlot)plot;
                xyPlot.setOrientation(orientation);
            }
        }
    }

    private boolean rangeAxisConfigChanged(RangeAxisConfigChangeEvent change) {
        RangeAxisConfig source = change.getSource();
        RangeAxisConfigChangeEvent.RangeAxisConfigChangeType type = change.getType();
        boolean processed = true;
        switch (type) {
            case VALUE_SOURCE_ADDED: 
            case VALUE_SOURCE_MOVED: 
            case VALUE_SOURCE_REMOVED: 
            case CLEARED: {
                return this.replot();
            }
            case LABEL: {
                String label = change.getLabel();
                if (label == null) {
                    label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
                }
                this.setRangeAxisLabel(label, source);
                break;
            }
            case SCALING: {
                this.rangeAxisConfigAxisChanged(source);
                break;
            }
            case VALUE_SOURCE_CHANGED: {
                processed = this.valueSouceChanged(change.getValueSourceChange());
                break;
            }
            case AUTO_NAMING: {
                break;
            }
            case RANGE_CHANGED: {
                this.rangeAxisConfigAxisChanged(source);
                break;
            }
            case CROSSHAIR_LINES_CHANGED: {
                this.updateChartPanel(this.getCurrentChart());
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type " + (Object)((Object)type) + " This should not happen.");
            }
        }
        return processed;
    }

    private boolean valueSouceChanged(ValueSourceChangeEvent change) {
        ValueSourceChangeEvent.ValueSourceChangeType type = change.getType();
        boolean processed = true;
        switch (type) {
            case USES_GROUPING: 
            case AGGREGATION_WINDOWING_CHANGED: 
            case USE_RELATIVE_UTILITIES: 
            case AGGREGATION_FUNCTION_MAP: 
            case DATATABLE_COLUMN_MAP: 
            case SERIES_FORMAT_CHANGED: {
                return this.replot();
            }
            case UPDATED: {
                break;
            }
            case LABEL: {
                this.resetLegend();
                break;
            }
            case AUTO_NAMING: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type " + (Object)((Object)type) + " This should not happen.");
            }
        }
        return processed;
    }

    private boolean dimensionConfigChanged(DimensionConfigChangeEvent change) {
        boolean processed;
        DimensionConfigChangeEvent.DimensionConfigChangeType type = change.getType();
        switch (type) {
            case LABEL: {
                if (change.getDimension() == DimensionConfig.PlotDimension.DOMAIN) {
                    String label = change.getLabel();
                    if (label == null) {
                        label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
                    }
                    this.setDomainAxisLabel(label);
                } else {
                    this.resetLegend();
                }
                processed = true;
                break;
            }
            case DATE_FORMAT_CHANGED: {
                if (change.getDimension() == DimensionConfig.PlotDimension.DOMAIN) {
                    this.setDomainAxisDateFormat(change.getDateFormat());
                } else {
                    this.resetLegend();
                }
                processed = true;
                break;
            }
            case COLOR_SCHEME: {
                processed = true;
                break;
            }
            case CROSSHAIR_LINES_CHANGED: {
                this.updateChartPanel(this.getCurrentChart());
                processed = true;
                break;
            }
            default: {
                return this.replot();
            }
        }
        return processed;
    }

    private void handlePlottimeException(ChartPlottimeException e) {
        if (this.plotInstance.getMasterOfDesaster() != null) {
            this.plotInstance.getMasterOfDesaster().registerConfigurationChangeResponse(e.getResponse());
        }
        this.invalidateCache();
        this.currentChartIsValid = false;
        this.updateChartPanel(new JFreeChart((Plot)new CategoryPlot()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LegendItemCollection getLegendItems() {
        if (this.plotInstance.getCurrentPlotConfigurationClone().getLegendConfiguration().getLegendPosition() == LegendConfiguration.LegendPosition.NONE) {
            return null;
        }
        JFreeChartPlotEngine jFreeChartPlotEngine = this;
        synchronized (jFreeChartPlotEngine) {
            return this.cachedLegendItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLegendItems() {
        JFreeChartPlotEngine jFreeChartPlotEngine = this;
        synchronized (jFreeChartPlotEngine) {
            this.cachedLegendItems = this.legendCreator.getLegendItems(this.plotInstance);
        }
    }

    public LinkAndBrushChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void addPlotEngineListener(JFreeChartPlotEngineListener l) {
        this.listeners.add(new WeakReference<JFreeChartPlotEngineListener>(l));
    }

    public void removePlotEngineListener(JFreeChartPlotEngineListener l) {
        Iterator<WeakReference<JFreeChartPlotEngineListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            JFreeChartPlotEngineListener listener = (JFreeChartPlotEngineListener)it.next().get();
            if (listener != null && listener != l) continue;
            it.remove();
        }
    }

    public void setCoordinateTransformation(CoordinateTransformation transformation) {
        this.coordinateTransformation = transformation;
        this.chartPanel.setCoordinateTransformation(transformation);
    }

    private void fireChartChanged(JFreeChart chart) {
        Iterator<WeakReference<JFreeChartPlotEngineListener>> defaultIt = this.listeners.iterator();
        while (defaultIt.hasNext()) {
            WeakReference<JFreeChartPlotEngineListener> wrl = defaultIt.next();
            JFreeChartPlotEngineListener l = (JFreeChartPlotEngineListener)wrl.get();
            if (l != null) {
                l.chartChanged(this, chart);
                continue;
            }
            defaultIt.remove();
        }
    }

    @Override
    public List<PlotConfigurationError> getEngineErrors() {
        LinkedList<PlotConfigurationError> errors = new LinkedList<PlotConfigurationError>();
        return errors;
    }

    @Override
    public List<PlotConfigurationError> getEngineWarnings() {
        LinkedList<PlotConfigurationError> warnings = new LinkedList<PlotConfigurationError>();
        PlotConfiguration plotConfiguration = this.plotInstance.getCurrentPlotConfigurationClone();
        if (plotConfiguration.getDomainConfigManager().isNominal()) {
            for (ValueSource valueSource : plotConfiguration.getAllValueSources()) {
                if (valueSource.getSeriesFormat().getSeriesType() != SeriesFormat.VisualizationType.LINES_AND_SHAPES || valueSource.getSeriesFormat().getLineStyle() == LineFormat.LineStyle.NONE || valueSource.isUsingDomainGrouping()) continue;
                warnings.add(new PlotConfigurationError("plot_does_not_support_lines", "categorical scatter plot with ungrouped domain axis", valueSource.toString()));
            }
        }
        for (ValueSource valueSource : plotConfiguration.getAllValueSources()) {
            SeriesFormat format = valueSource.getSeriesFormat();
            if (format.getSeriesType() != SeriesFormat.VisualizationType.LINES_AND_SHAPES || format.getUtilityUsage() != SeriesFormat.IndicatorType.DIFFERENCE || format.getItemShape() == SeriesFormat.ItemShape.NONE) continue;
            warnings.add(new PlotConfigurationError("difference_plot_with_items_not_supported", valueSource.toString()));
        }
        return warnings;
    }

    @Override
    public PlotInstance getPlotInstance() {
        return this.plotInstance;
    }

    @Override
    public void startProcessing() {
        this.plotInstance.getMasterOfDesaster().setCalculating(true);
    }

    @Override
    public void endProcessing() {
        this.plotInstance.getMasterOfDesaster().setCalculating(false);
    }
}

