/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart;

import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DistinctValueGrouping;
import com.owc.gui.charting.configuration.LineFormat;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.engine.jfreechart.legend.CustomLegendItem;
import com.owc.gui.charting.engine.jfreechart.legend.FlankedShapeLegendItem;
import com.owc.gui.charting.utility.ColorProvider;
import com.owc.gui.charting.utility.ContinuousColorProvider;
import com.owc.gui.charting.utility.ContinuousSizeProvider;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.ShapeProvider;
import com.owc.gui.charting.utility.SizeProvider;
import com.rapidminer.tools.I18N;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.sql.Date;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;

public class PlotInstanceLegendCreator {
    private static final String UNDEFINED_SHAPE_PATH_STRING = "61.60505,-17.6627 4.43287,24.66755 80.8122,70.71067 32.26478,19.44992 94.06958,-36.71539 86.87313,11.11169 -11.06983,73.56922 -54.23403,-3.79434 -74.09398,31.56769 -15.44503,27.50097 110.35408,39.30287 35.87633,109.92879 -26.99372,15.97748 -24.31258,-53.77902 -48.62472,-38.78282 -18.89542,11.65506 12.73492,55.53523 -57.74657,36.48531 -30.46568,-8.23435 18.26797,-39.15956 -3.71038,-55.83427 -28.37109,-21.5248 -41.8619,91.13915 -70.90379,2.49826 -15.22703,-46.47553 37.08276,-11.0608 44.75129,-69.85281 3.03046,-23.23351 -47.77036,-82.19632 6.76649,-97.83251";
    private static final String UNDEFINED_SHAPE_AND_COLOR_PATH_STRING = "-17.05687,19.94964 -48.00093,21.59475 -70.38775,35.29712 -21.74096,13.30706 -36.83506,39.34171 -61.62405,45.27914 -25.5254,6.11382 -51.52664,-10.74373 -77.69201,-12.81692 -25.4105,-2.01338 -52.92466,10.177 -76.46931,0.40989 -24.24409,-10.05727 -35.37093,-38.97845 -55.32056,-56.03532 -19.37409,-16.56478 -48.79884,-22.87497 -62.1059,-44.61593 -13.702365,-22.38682 -5.70472,-52.32474 -11.818535,-77.85014 -5.93744,-24.78899 -26.03352,-47.18948 -24.02014,-72.59998 2.07319,-26.16537 26.14049,-45.68475 36.197755,-69.92884 9.76712,-23.54465 6.67572,-53.47921 23.24049,-72.8533 17.05687,-19.949641 48.00093,-21.594751 70.38775,-35.297121 21.74096,-13.30706 36.83506,-39.341712 61.62405,-45.279142 25.5254,-6.11382 51.52664,10.74373 77.69201,12.81692 25.4105,2.01338 52.92466,-10.177 76.46931,-0.40989 24.24409,10.057272 35.37093,38.978452 55.32056,56.035323 19.37409,16.56478 48.79884,22.87497 62.1059,44.61593 13.70237,22.38682 5.70472,52.32474 11.81854,77.85014 5.93744,24.78899 26.03352,47.18948 24.02014,72.59998 -2.07319,26.16537 -26.14049,45.68475 -36.19776,69.92884 -9.76712,23.54465 -6.67572,53.47921 -23.24049,72.8533";
    private static final Shape UNDEFINED_SHAPE = PlotInstanceLegendCreator.shapeFromSvgRelativeBezierPath("61.60505,-17.6627 4.43287,24.66755 80.8122,70.71067 32.26478,19.44992 94.06958,-36.71539 86.87313,11.11169 -11.06983,73.56922 -54.23403,-3.79434 -74.09398,31.56769 -15.44503,27.50097 110.35408,39.30287 35.87633,109.92879 -26.99372,15.97748 -24.31258,-53.77902 -48.62472,-38.78282 -18.89542,11.65506 12.73492,55.53523 -57.74657,36.48531 -30.46568,-8.23435 18.26797,-39.15956 -3.71038,-55.83427 -28.37109,-21.5248 -41.8619,91.13915 -70.90379,2.49826 -15.22703,-46.47553 37.08276,-11.0608 44.75129,-69.85281 3.03046,-23.23351 -47.77036,-82.19632 6.76649,-97.83251", 0.05f);
    private static final Shape UNDEFINED_SHAPE_AND_COLOR = PlotInstanceLegendCreator.shapeFromSvgRelativeBezierPath("-17.05687,19.94964 -48.00093,21.59475 -70.38775,35.29712 -21.74096,13.30706 -36.83506,39.34171 -61.62405,45.27914 -25.5254,6.11382 -51.52664,-10.74373 -77.69201,-12.81692 -25.4105,-2.01338 -52.92466,10.177 -76.46931,0.40989 -24.24409,-10.05727 -35.37093,-38.97845 -55.32056,-56.03532 -19.37409,-16.56478 -48.79884,-22.87497 -62.1059,-44.61593 -13.702365,-22.38682 -5.70472,-52.32474 -11.818535,-77.85014 -5.93744,-24.78899 -26.03352,-47.18948 -24.02014,-72.59998 2.07319,-26.16537 26.14049,-45.68475 36.197755,-69.92884 9.76712,-23.54465 6.67572,-53.47921 23.24049,-72.8533 17.05687,-19.949641 48.00093,-21.594751 70.38775,-35.297121 21.74096,-13.30706 36.83506,-39.341712 61.62405,-45.279142 25.5254,-6.11382 51.52664,10.74373 77.69201,12.81692 25.4105,2.01338 52.92466,-10.177 76.46931,-0.40989 24.24409,10.057272 35.37093,38.978452 55.32056,56.035323 19.37409,16.56478 48.79884,22.87497 62.1059,44.61593 13.70237,22.38682 5.70472,52.32474 11.81854,77.85014 5.93744,24.78899 26.03352,47.18948 24.02014,72.59998 -2.07319,26.16537 -26.14049,45.68475 -36.19776,69.92884 -9.76712,23.54465 -6.67572,53.47921 -23.24049,72.8533", 0.02f);
    private static final Color UNDEFINED_COLOR = Color.DARK_GRAY;
    private static final Paint UNDEFINED_COLOR_PAINT = PlotInstanceLegendCreator.createTransparentCheckeredPaint(UNDEFINED_COLOR, 1);
    private static final Paint UNDEFINED_LINE_COLOR = Color.DARK_GRAY;
    private static final Shape BAR_SHAPE = PlotInstanceLegendCreator.createBarShape();
    private static final Shape AREA_SHAPE = PlotInstanceLegendCreator.createAreaShape();
    private static final BasicStroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    private static final double MIN_LEGEND_ITEM_SCALING_FACTOR = 0.2;
    private static final double MAX_LEGEND_ITEM_SCALING_FACTOR = 1.5;

    public LegendItemCollection getLegendItems(PlotInstance plotInstance) {
        PlotConfiguration plotConfiguration = plotInstance.getCurrentPlotConfigurationClone();
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        List<ValueSource> allValueSources = plotConfiguration.getAllValueSources();
        if (!allValueSources.isEmpty()) {
            legendItemCollection.add(this.createTitleLegendItem(I18N.getGUILabel((String)"plotter.legend.plots_heading.label", (Object[])new Object[0]) + ":", plotConfiguration));
        }
        for (ValueSource valueSource : allValueSources) {
            CustomLegendItem legendItem = this.createValueSourceLegendItem(plotConfiguration, valueSource);
            if (legendItem == null) continue;
            legendItemCollection.add((LegendItem)legendItem);
        }
        List<Set<DimensionConfig.PlotDimension>> dimensionsWithLegend = this.findCompatibleDimensions(plotConfiguration, allValueSources);
        for (Set<DimensionConfig.PlotDimension> dimensionSet : dimensionsWithLegend) {
            DimensionConfig.PlotDimension aDimension = dimensionSet.iterator().next();
            DimensionConfig dimensionConfig = plotConfiguration.getDimensionConfig(aDimension);
            this.createDimensionConfigLegendItem(plotInstance, (DefaultDimensionConfig)dimensionConfig, dimensionSet, legendItemCollection);
        }
        return legendItemCollection;
    }

    private List<Set<DimensionConfig.PlotDimension>> findCompatibleDimensions(PlotConfiguration plotConfiguration, List<ValueSource> allValueSources) {
        Map<DimensionConfig.PlotDimension, DefaultDimensionConfig> dimensionConfigMap = plotConfiguration.getDefaultDimensionConfigs();
        LinkedList<Set<DimensionConfig.PlotDimension>> dimensionsWithLegend = new LinkedList<Set<DimensionConfig.PlotDimension>>();
        for (Map.Entry<DimensionConfig.PlotDimension, DefaultDimensionConfig> dimensionEntry : dimensionConfigMap.entrySet()) {
            DimensionConfig.PlotDimension dimension = dimensionEntry.getKey();
            DefaultDimensionConfig dimensionConfig = dimensionEntry.getValue();
            boolean createLegend = false;
            if (dimensionConfig.isGrouping()) {
                createLegend = true;
            } else {
                for (ValueSource valueSource : allValueSources) {
                    if (valueSource.isUsingDomainGrouping()) continue;
                    createLegend = true;
                    break;
                }
            }
            if (!createLegend) continue;
            if (!dimensionConfig.isNominal()) {
                HashSet<DimensionConfig.PlotDimension> newSet = new HashSet<DimensionConfig.PlotDimension>();
                newSet.add(dimension);
                dimensionsWithLegend.add(newSet);
                continue;
            }
            boolean compatibleToSomething = false;
            for (Set dimensionSet : dimensionsWithLegend) {
                boolean compatible = true;
                for (DimensionConfig.PlotDimension comparedDimension : dimensionSet) {
                    DefaultDimensionConfig comparedDimensionConfig = (DefaultDimensionConfig)plotConfiguration.getDimensionConfig(comparedDimension);
                    if (!comparedDimensionConfig.isNominal()) {
                        compatible = false;
                        break;
                    }
                    if (!dimensionConfig.getDataTableColumn().equals(comparedDimensionConfig.getDataTableColumn())) {
                        compatible = false;
                        break;
                    }
                    if (comparedDimensionConfig.isGrouping() && comparedDimensionConfig.getGrouping() instanceof DistinctValueGrouping && !dimensionConfig.isGrouping() && dimensionConfig.isNominal()) {
                        compatible = true;
                        continue;
                    }
                    if (dimensionConfig.isGrouping() && dimensionConfig.getGrouping() instanceof DistinctValueGrouping && !comparedDimensionConfig.isGrouping() && comparedDimensionConfig.isNominal()) {
                        compatible = true;
                        continue;
                    }
                    if (dimensionConfig.isGrouping() != comparedDimensionConfig.isGrouping()) {
                        compatible = false;
                        break;
                    }
                    if (!dimensionConfig.isGrouping()) {
                        compatible = true;
                        continue;
                    }
                    if (dimensionConfig.getGrouping().equals(comparedDimensionConfig.getGrouping())) {
                        compatible = true;
                        continue;
                    }
                    compatible = false;
                    break;
                }
                if (!compatible) continue;
                dimensionSet.add(dimension);
                compatibleToSomething = true;
                break;
            }
            if (compatibleToSomething) continue;
            HashSet<DimensionConfig.PlotDimension> hashSet = new HashSet<DimensionConfig.PlotDimension>();
            hashSet.add(dimension);
            dimensionsWithLegend.add(hashSet);
        }
        return dimensionsWithLegend;
    }

    private CustomLegendItem createValueSourceLegendItem(PlotConfiguration plotConfig, ValueSource valueSource) {
        Shape shape;
        Paint linePaint;
        HashSet<DimensionConfig.PlotDimension> dimensions = new HashSet<DimensionConfig.PlotDimension>();
        block3: for (DimensionConfig.PlotDimension dimension : DimensionConfig.PlotDimension.values()) {
            switch (dimension) {
                case DOMAIN: 
                case VALUE: {
                    continue block3;
                }
                default: {
                    if (!valueSource.useSeriesFormatForDimension(plotConfig, dimension)) continue block3;
                    dimensions.add(dimension);
                }
            }
        }
        if (dimensions.isEmpty()) {
            return null;
        }
        SeriesFormat format = valueSource.getSeriesFormat();
        String description = "";
        String toolTipText = "";
        String urlText = "";
        boolean shapeVisible = true;
        boolean shapeFilled = true;
        Paint fillPaint = UNDEFINED_COLOR_PAINT;
        boolean shapeOutlineVisible = true;
        Color outlinePaint = PlotConfiguration.DEFAULT_OUTLINE_COLOR;
        BasicStroke outlineStroke = DEFAULT_OUTLINE_STROKE;
        boolean lineVisible = format.getLineStyle() != LineFormat.LineStyle.NONE && format.getSeriesType() == SeriesFormat.VisualizationType.LINES_AND_SHAPES;
        String label = valueSource.toString();
        if (label == null) {
            label = "";
        }
        if (dimensions.contains((Object)DimensionConfig.PlotDimension.COLOR)) {
            Color color = format.getItemColor();
            linePaint = fillPaint = format.getAreaFillPaint(color);
        } else if (format.getAreaFillStyle() == SeriesFormat.FillStyle.NONE) {
            linePaint = fillPaint = new Color(0, 0, 0, 0);
        } else if (format.getAreaFillStyle() == SeriesFormat.FillStyle.SOLID) {
            fillPaint = UNDEFINED_COLOR_PAINT;
            linePaint = UNDEFINED_LINE_COLOR;
        } else {
            linePaint = fillPaint = format.getAreaFillPaint(UNDEFINED_COLOR);
        }
        SeriesFormat.VisualizationType seriesType = valueSource.getSeriesFormat().getSeriesType();
        if (seriesType == SeriesFormat.VisualizationType.LINES_AND_SHAPES) {
            shape = dimensions.contains((Object)DimensionConfig.PlotDimension.SHAPE) ? format.getItemShape().getShape() : (dimensions.contains((Object)DimensionConfig.PlotDimension.COLOR) ? UNDEFINED_SHAPE : UNDEFINED_SHAPE_AND_COLOR);
            if (dimensions.contains((Object)DimensionConfig.PlotDimension.SIZE)) {
                AffineTransform transformation = new AffineTransform();
                double scalingFactor = format.getItemSize();
                transformation.scale(scalingFactor, scalingFactor);
                shape = transformation.createTransformedShape(shape);
            }
        } else if (seriesType == SeriesFormat.VisualizationType.BARS) {
            shape = BAR_SHAPE;
        } else if (seriesType == SeriesFormat.VisualizationType.AREA) {
            shape = AREA_SHAPE;
        } else {
            throw new RuntimeException("Unknown SeriesType. This should not happen.");
        }
        float lineLength = 0.0f;
        if (lineVisible) {
            lineLength = format.getLineWidth();
            if (lineLength < 1.0f) {
                lineLength = 1.0f;
            }
            if (lineLength > 1.0f) {
                lineLength = 1.0f + (float)Math.log(lineLength) / 2.0f;
            }
            lineLength = Math.max(lineLength * 30.0f, format.getStrokeLength() * 2.0f);
            if (shape != null) {
                lineLength = Math.max(lineLength, (float)shape.getBounds().getWidth() * 2.0f);
            }
        }
        Line2D.Float line = new Line2D.Float(0.0f, 0.0f, lineLength, 0.0f);
        BasicStroke lineStroke = format.getStroke();
        if (lineStroke == null) {
            lineStroke = new BasicStroke();
        }
        BasicStroke s = lineStroke;
        lineStroke = new BasicStroke(s.getLineWidth(), 0, 1, s.getMiterLimit(), s.getDashArray(), s.getDashPhase());
        return new CustomLegendItem(label, description, toolTipText, urlText, shapeVisible, shape, shapeFilled, fillPaint, shapeOutlineVisible, (Paint)outlinePaint, (Stroke)outlineStroke, lineVisible, (Shape)line, (Stroke)lineStroke, linePaint);
    }

    private static GeneralPath createAreaShape() {
        GeneralPath areaShape = new GeneralPath();
        areaShape.moveTo(0.0f, 0.0f);
        areaShape.lineTo(0.0f, -5.0f);
        areaShape.lineTo(5.0f, -10.0f);
        areaShape.lineTo(10.0f, -5.0f);
        areaShape.lineTo(15.0f, -7.0f);
        areaShape.lineTo(15.0f, 0.0f);
        areaShape.closePath();
        return areaShape;
    }

    private static GeneralPath createBarShape() {
        GeneralPath barShape = new GeneralPath();
        barShape.moveTo(0.0f, 0.0f);
        barShape.lineTo(0.0f, -5.0f);
        barShape.lineTo(5.0f, -5.0f);
        barShape.lineTo(5.0f, 0.0f);
        barShape.lineTo(5.0f, -15.0f);
        barShape.lineTo(10.0f, -15.0f);
        barShape.lineTo(10.0f, 0.0f);
        barShape.lineTo(10.0f, -10.0f);
        barShape.lineTo(15.0f, -10.0f);
        barShape.lineTo(15.0f, 0.0f);
        barShape.closePath();
        return barShape;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createDimensionConfigLegendItem(PlotInstance plotInstance, DefaultDimensionConfig dimensionConfig, Set<DimensionConfig.PlotDimension> dimensionSet, LegendItemCollection legendItemCollection) {
        PlotConfiguration plotConfiguration = plotInstance.getCurrentPlotConfigurationClone();
        DimensionConfigData dimensionConfigData = plotInstance.getPlotData().getDimensionConfigData(dimensionConfig);
        if (dimensionConfig.isGrouping()) {
            if (dimensionConfig.isNominal()) {
                this.createCategoricalLegendItems(plotInstance, dimensionSet, legendItemCollection, dimensionConfigData.getDistinctValues());
                return;
            } else {
                if (!dimensionConfig.isNumerical() && !dimensionConfig.isDate()) throw new RuntimeException("unknown data type during legend creation - this should not happen");
                this.createDimensionTitleLegendItem(plotInstance, dimensionSet, legendItemCollection);
                double minValue = dimensionConfigData.getMinValue();
                double maxValue = dimensionConfigData.getMaxValue();
                LegendItem legendItem = this.createContinuousLegendItem(plotInstance, dimensionSet, minValue, maxValue, dimensionConfig.isDate() ? dimensionConfig.getDateFormat() : null);
                if (legendItem == null) return;
                legendItemCollection.add(legendItem);
            }
            return;
        } else {
            boolean createLegend = false;
            for (ValueSource valueSource : plotConfiguration.getAllValueSources()) {
                if (valueSource.isUsingDomainGrouping()) continue;
                createLegend = true;
                break;
            }
            if (!createLegend) return;
            if (dimensionConfig.isNominal()) {
                List<Double> values = dimensionConfigData.getDistinctValues();
                this.createCategoricalLegendItems(plotInstance, dimensionSet, legendItemCollection, values);
                return;
            } else {
                if (!dimensionConfig.isNumerical() && !dimensionConfig.isDate()) throw new RuntimeException("unknown data type during legend creation - this should not happen");
                this.createDimensionTitleLegendItem(plotInstance, dimensionSet, legendItemCollection);
                double minValue = dimensionConfigData.getMinValue();
                double maxValue = dimensionConfigData.getMaxValue();
                LegendItem legendItem = this.createContinuousLegendItem(plotInstance, dimensionSet, minValue, maxValue, dimensionConfig.isDate() ? dimensionConfig.getDateFormat() : null);
                if (legendItem == null) return;
                legendItemCollection.add(legendItem);
            }
        }
    }

    private LegendItem createContinuousLegendItem(PlotInstance plotInstance, Set<DimensionConfig.PlotDimension> dimensionSet, double minValue, double maxValue, DateFormat dateFormat) {
        PlotConfiguration plotConfiguration = plotInstance.getCurrentPlotConfigurationClone();
        DimensionConfig.PlotDimension dimension = dimensionSet.iterator().next();
        DefaultDimensionConfig dimensionConfig = (DefaultDimensionConfig)plotConfiguration.getDimensionConfig(dimension);
        DimensionConfigData dimensionConfigData = plotInstance.getPlotData().getDimensionConfigData(dimensionConfig);
        String label = "";
        if (dimension == DimensionConfig.PlotDimension.COLOR) {
            ColorProvider colorProvider = dimensionConfigData.getColorProvider();
            if (!colorProvider.supportsNumericalValues()) {
                throw new RuntimeException("Color provider for continuous legend item does not support numerical values.");
            }
            int width = 50;
            int height = 10;
            float[] fractions = new float[50];
            Color[] colors = new Color[50];
            for (int i = 0; i < 50; ++i) {
                float fraction = (float)i / 49.0f;
                double fractionValue = colorProvider instanceof ContinuousColorProvider && ((ContinuousColorProvider)colorProvider).isColorMinMaxValueDifferentFromOriginal(((ContinuousColorProvider)colorProvider).getMinValue(), ((ContinuousColorProvider)colorProvider).getMaxValue()) ? ((ContinuousColorProvider)colorProvider).getMinValue() + (double)fraction * (((ContinuousColorProvider)colorProvider).getMaxValue() - ((ContinuousColorProvider)colorProvider).getMinValue()) : minValue + (double)fraction * (maxValue - minValue);
                colors[i] = colorProvider.getColorForValue(fractionValue);
                fractions[i] = fraction;
            }
            LinearGradientPaint shapeFillPaint = new LinearGradientPaint(new Point(0, 0), new Point(50, 0), fractions, colors, MultipleGradientPaint.CycleMethod.REPEAT);
            Rectangle itemShape = new Rectangle(50, 10);
            if (colorProvider instanceof ContinuousColorProvider) {
                return this.createFlankedShapeLegendItem(label, ((ContinuousColorProvider)colorProvider).getMinValue(), ((ContinuousColorProvider)colorProvider).getMaxValue(), itemShape, shapeFillPaint, true, dateFormat);
            }
            return this.createFlankedShapeLegendItem(label, minValue, maxValue, itemShape, shapeFillPaint, true, dateFormat);
        }
        if (dimension == DimensionConfig.PlotDimension.SHAPE) {
            return null;
        }
        if (dimension == DimensionConfig.PlotDimension.SIZE) {
            SizeProvider sizeProvider = dimensionConfigData.getSizeProvider();
            if (!sizeProvider.supportsNumericalValues()) {
                throw new RuntimeException("Size provider for continuous legend item does not support numerical values.");
            }
            double minScalingFactor = sizeProvider.getMinScalingFactor();
            double maxScalingFactor = sizeProvider.getMaxScalingFactor();
            ContinuousSizeProvider legendSizeProvider = new ContinuousSizeProvider(minScalingFactor, maxScalingFactor, 0.2, 1.5, false);
            int legendItemCount = 4;
            Area composedShape = new Area();
            Shape originalShape = UNDEFINED_SHAPE;
            if (dimensionSet.contains((Object)DimensionConfig.PlotDimension.SIZE) && dimensionSet.size() == 1) {
                originalShape = UNDEFINED_SHAPE_AND_COLOR;
            }
            double maxHeight = originalShape.getBounds().getHeight() * 1.5;
            for (int i = 0; i < legendItemCount; ++i) {
                double fraction = minScalingFactor + (double)i / (double)legendItemCount * (maxScalingFactor - minScalingFactor);
                double legendScalingFactor = legendSizeProvider.getScalingFactorForValue(fraction);
                double composedWidth = composedShape.getBounds().getWidth();
                AffineTransform t = new AffineTransform();
                t.scale(legendScalingFactor, legendScalingFactor);
                Shape shape = t.createTransformedShape(originalShape);
                t = new AffineTransform();
                double shapeWidth = shape.getBounds().getWidth();
                double shapeHeight = shape.getBounds().getHeight();
                t.translate(composedWidth + shapeWidth * 0.1, (maxHeight - shapeHeight) / 2.0);
                t.translate(-shape.getBounds().getMinX(), -shape.getBounds().getMinY());
                shape = t.createTransformedShape(shape);
                composedShape.add(new Area(shape));
            }
            return this.createFlankedShapeLegendItem(label, minValue, maxValue, composedShape, UNDEFINED_COLOR_PAINT, false, dateFormat);
        }
        throw new RuntimeException("Unsupported dimension. Execution path should never reach this line.");
    }

    private LegendItem createFlankedShapeLegendItem(String label, double minValue, double maxValue, Shape itemShape, Paint shapeFillPaint, boolean shapeOutlineVisible, DateFormat dateFormat) {
        String description = "";
        String toolTipText = "";
        String urlText = "";
        boolean shapeVisible = true;
        boolean shapeFilled = true;
        Color outlinePaint = Color.BLACK;
        BasicStroke outlineStroke = DEFAULT_OUTLINE_STROKE;
        boolean lineVisible = false;
        Line2D.Float line = new Line2D.Float();
        BasicStroke lineStroke = new BasicStroke();
        Color linePaint = Color.BLACK;
        FlankedShapeLegendItem legendItem = new FlankedShapeLegendItem(label, description, toolTipText, urlText, shapeVisible, itemShape, shapeFilled, shapeFillPaint, shapeOutlineVisible, (Paint)outlinePaint, (Stroke)outlineStroke, lineVisible, (Shape)line, (Stroke)lineStroke, (Paint)linePaint);
        if (dateFormat != null) {
            legendItem.setLeftShapeLabel(dateFormat.format(new Date((long)minValue)));
            legendItem.setRightShapeLabel(dateFormat.format(new Date((long)maxValue)));
        } else {
            int powerOf10 = DataStructureUtils.getOptimalPrecision(minValue, maxValue);
            legendItem.setLeftShapeLabel(DataStructureUtils.getRoundedString(minValue, powerOf10 - 1));
            legendItem.setRightShapeLabel(DataStructureUtils.getRoundedString(maxValue, powerOf10 - 1));
        }
        return legendItem;
    }

    private void createCategoricalLegendItems(PlotInstance plotInstance, Set<DimensionConfig.PlotDimension> dimensionSet, LegendItemCollection legendItemCollection, Iterable<Double> values) {
        this.createDimensionTitleLegendItem(plotInstance, dimensionSet, legendItemCollection);
        PlotConfiguration plotConfig = plotInstance.getCurrentPlotConfigurationClone();
        Ellipse2D.Float defaultShape = new Ellipse2D.Float(-5.0f, -5.0f, 10.0f, 10.0f);
        Color defaultOutlineColor = PlotConfiguration.DEFAULT_OUTLINE_COLOR;
        ColorProvider colorProvider = null;
        ShapeProvider shapeProvider = null;
        SizeProvider sizeProvider = null;
        DefaultDimensionConfig dimensionConfig = (DefaultDimensionConfig)plotConfig.getDimensionConfig(dimensionSet.iterator().next());
        DimensionConfigData dimensionConfigData = plotInstance.getPlotData().getDimensionConfigData(dimensionConfig);
        for (DimensionConfig.PlotDimension dimension : dimensionSet) {
            if (dimension == DimensionConfig.PlotDimension.COLOR) {
                colorProvider = dimensionConfigData.getColorProvider();
                continue;
            }
            if (dimension == DimensionConfig.PlotDimension.SHAPE) {
                shapeProvider = dimensionConfigData.getShapeProvider();
                continue;
            }
            if (dimension != DimensionConfig.PlotDimension.SIZE) continue;
            sizeProvider = dimensionConfigData.getSizeProvider();
        }
        ContinuousSizeProvider legendSizeProvider = null;
        if (sizeProvider != null) {
            double minScalingFactor = sizeProvider.getMinScalingFactor();
            double maxScalingFactor = sizeProvider.getMaxScalingFactor();
            double minLegendScalingFactor = 0.2;
            double maxLegendScalingFactor = 1.5;
            if (minScalingFactor > maxScalingFactor) {
                double tmp = minScalingFactor;
                minScalingFactor = maxScalingFactor;
                maxScalingFactor = tmp;
                minLegendScalingFactor = 1.5;
                maxLegendScalingFactor = 0.2;
            }
            legendSizeProvider = new ContinuousSizeProvider(minScalingFactor, maxScalingFactor, minLegendScalingFactor, maxLegendScalingFactor, false);
        }
        for (Double value : values) {
            String label;
            BasicStroke outlineStroke;
            Shape shape = defaultShape;
            Color outlineColor = new Color(0, 0, 0, 0);
            if (shapeProvider != null) {
                shape = shapeProvider.getShapeForCategory(value);
                outlineStroke = DEFAULT_OUTLINE_STROKE;
                outlineColor = defaultOutlineColor;
            } else {
                outlineStroke = new BasicStroke();
                shape = colorProvider != null ? UNDEFINED_SHAPE : UNDEFINED_SHAPE_AND_COLOR;
            }
            Paint paint = UNDEFINED_COLOR_PAINT;
            if (colorProvider != null) {
                paint = colorProvider.getColorForValue(value);
            }
            double scalingFactor = 1.0;
            if (sizeProvider != null) {
                scalingFactor = sizeProvider.getScalingFactorForValue(value);
                scalingFactor = legendSizeProvider.getScalingFactorForValue(scalingFactor);
                AffineTransform transformation = new AffineTransform();
                transformation.scale(scalingFactor, scalingFactor);
                shape = transformation.createTransformedShape(shape);
            }
            if ((label = dimensionConfigData.getStringForValue(value)) == null) {
                label = "";
            }
            CustomLegendItem legendItem = new CustomLegendItem(label, null, null, null, shape, paint, (Stroke)outlineStroke, (Paint)outlineColor);
            legendItemCollection.add((LegendItem)legendItem);
        }
    }

    private void createDimensionTitleLegendItem(PlotInstance plotInstance, Set<DimensionConfig.PlotDimension> dimensionSet, LegendItemCollection legendItemCollection) {
        PlotConfiguration plotConfig = plotInstance.getCurrentPlotConfigurationClone();
        StringBuilder titleBuilder = new StringBuilder();
        boolean first = true;
        boolean showDimensionType = plotConfig.getLegendConfiguration().isShowDimensionType();
        if (showDimensionType) {
            for (DimensionConfig.PlotDimension dimension : dimensionSet) {
                if (!first) {
                    titleBuilder.append(", ");
                }
                titleBuilder.append(dimension.getShortName());
                first = false;
            }
        }
        if (showDimensionType) {
            titleBuilder.append(" (");
        }
        HashSet<String> uniqueDimensionLabels = new HashSet<String>();
        first = true;
        for (DimensionConfig.PlotDimension dimension : dimensionSet) {
            DefaultDimensionConfig dimensionConfig = (DefaultDimensionConfig)plotConfig.getDimensionConfig(dimension);
            String label = dimensionConfig.getLabel();
            if (label == null) {
                label = I18N.getGUILabel((String)"plotter.unnamed_value_label", (Object[])new Object[0]);
            }
            if (uniqueDimensionLabels.contains(label)) continue;
            if (!first) {
                titleBuilder.append(", ");
                first = false;
            }
            titleBuilder.append(label);
            uniqueDimensionLabels.add(label);
        }
        if (showDimensionType) {
            titleBuilder.append(")");
        }
        titleBuilder.append(": ");
        legendItemCollection.add(this.createTitleLegendItem(titleBuilder.toString(), plotConfig));
    }

    private LegendItem createTitleLegendItem(String titleString, PlotConfiguration plotConfiguration) {
        LegendItem titleItem = new LegendItem(titleString, "", "", "", false, (Shape)new Rectangle(), false, (Paint)Color.WHITE, false, (Paint)Color.WHITE, (Stroke)new BasicStroke(), false, (Shape)new Rectangle(), (Stroke)new BasicStroke(), (Paint)Color.WHITE);
        Font titleFont = titleItem.getLabelFont();
        if (titleFont == null) {
            titleFont = plotConfiguration.getLegendConfiguration().getLegendFont();
        }
        titleItem.setLabelFont(titleFont.deriveFont(1));
        return titleItem;
    }

    private static Paint createTransparentCheckeredPaint(Color color, int checkerSize) {
        int s = checkerSize;
        BufferedImage bufferedImage = new BufferedImage(2 * s, 2 * s, 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color c1 = DataStructureUtils.setColorAlpha(color, (int)((double)color.getAlpha() * 0.8));
        Color c2 = DataStructureUtils.setColorAlpha(color, (int)((double)color.getAlpha() * 0.2));
        g2.setStroke(new BasicStroke(0.0f));
        g2.setPaint(c2);
        g2.setColor(c2);
        g2.fillRect(0, 0, s, s);
        g2.fillRect(s, s, s, s);
        g2.setPaint(c1);
        g2.setColor(c1);
        g2.fillRect(0, s, s, s);
        g2.fillRect(s, 0, s, s);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 2 * s, 2 * s);
        return new TexturePaint(bufferedImage, rect);
    }

    public static Shape shapeFromSvgRelativeBezierPath(String pathString, float scalingFactor) {
        String[] points = pathString.split(" ");
        float y2 = 0.0f;
        float x2 = 0.0f;
        float s = scalingFactor;
        Path2D.Float path = new Path2D.Float();
        for (int i = 0; i < points.length / 3; ++i) {
            String c1String = points[i * 3 + 0];
            String c2String = points[i * 3 + 1];
            String targetString = points[i * 3 + 2];
            String[] c1Split = c1String.split(",");
            String[] c2Split = c2String.split(",");
            String[] targetSplit = targetString.split(",");
            float x1 = x2;
            float y1 = y2;
            x2 = s * Float.parseFloat(targetSplit[0]) + x1;
            y2 = s * Float.parseFloat(targetSplit[1]) + y1;
            float cx1 = s * Float.parseFloat(c1Split[0]) + x1;
            float cy1 = s * Float.parseFloat(c1Split[1]) + y1;
            float cx2 = s * Float.parseFloat(c2Split[0]) + x1;
            float cy2 = s * Float.parseFloat(c2Split[1]) + y1;
            CubicCurve2D.Float curve = new CubicCurve2D.Float(x1, y1, cx1, cy1, cx2, cy2, x2, y2);
            path.append(curve, true);
        }
        return path;
    }
}

