/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart;

import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.GroupCellKey;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.GroupCellData;
import com.owc.gui.charting.data.GroupCellKeyAndData;
import com.owc.gui.charting.data.GroupCellSeriesData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.ValueSourceData;
import com.owc.gui.charting.listener.RenderFormatDelegateChangeListener;
import com.owc.gui.charting.listener.SeriesFormatListener;
import com.owc.gui.charting.listener.events.SeriesFormatChangeEvent;
import com.owc.gui.charting.utility.ColorProvider;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.ShapeProvider;
import com.owc.gui.charting.utility.SizeProvider;
import com.owc.gui.charting.utility.ValueRange;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class RenderFormatDelegate
implements SeriesFormatListener {
    private List<RenderFormatDelegateChangeListener> listeners = new LinkedList<RenderFormatDelegateChangeListener>();
    private Vector<GroupCellKey> groupCellKeysBySeriesIdx;
    private SeriesFormat seriesFormat;
    private ColorProvider colorProvider;
    private ShapeProvider shapeProvider;
    private boolean individualColorForEachItem;
    private boolean seriesColorFromDimensionConfig;
    private Vector<double[]> colorValues;
    private boolean individualShapeForEachItem;
    private boolean seriesShapeFromDimensionConfig;
    private Vector<double[]> shapeValues;
    private boolean individualSizeForEachItem;
    private boolean seriesSizeFromDimensionConfig;
    private Vector<double[]> sizeValues;
    private Vector<double[]> selectedValues;
    private SizeProvider sizeProvider;

    public RenderFormatDelegate() {
        this.groupCellKeysBySeriesIdx = null;
    }

    public RenderFormatDelegate(ValueSourceData valueSourceData, PlotInstance plotInstance) {
        this.setConfiguration(valueSourceData, plotInstance);
    }

    public Paint getSeriesFillPaint(int seriesIdx) {
        if (!this.individualColorForEachItem) {
            if (this.colorProvider != null && this.seriesColorFromDimensionConfig) {
                double colorIdx = this.getValueOfCurrentRange(seriesIdx, DimensionConfig.PlotDimension.COLOR);
                Color seriesColor = this.colorProvider.getColorForValue(colorIdx);
                seriesColor = DataStructureUtils.setColorAlpha(seriesColor, DataStructureUtils.multiplyOpacities256(seriesColor.getAlpha(), this.seriesFormat.getOpacity()));
                Paint seriesPaint = this.seriesFormat.getAreaFillPaint(seriesColor);
                return seriesPaint;
            }
            return this.seriesFormat.getAreaFillPaint();
        }
        return null;
    }

    public Paint getItemPaint(int seriesIdx, int valueIdx) {
        boolean selected = this.isItemSelected(seriesIdx, valueIdx);
        if (!this.individualColorForEachItem) {
            if (this.colorProvider != null && this.seriesColorFromDimensionConfig) {
                double colorIdx = this.getValueOfCurrentRange(seriesIdx, DimensionConfig.PlotDimension.COLOR);
                Color seriesColor = this.colorProvider.getColorForValue(colorIdx);
                seriesColor = DataStructureUtils.setColorAlpha(seriesColor, DataStructureUtils.multiplyOpacities256(seriesColor.getAlpha(), this.seriesFormat.getOpacity()));
                if (!selected) {
                    seriesColor = DataStructureUtils.setColorAlpha(seriesColor, 20);
                }
                Paint seriesPaint = this.seriesFormat.getAreaFillPaint(seriesColor);
                return seriesPaint;
            }
            Color color = this.seriesFormat.getItemColor();
            if (!selected) {
                color = DataStructureUtils.setColorAlpha(color, 20);
            }
            return this.seriesFormat.getAreaFillPaint(color);
        }
        if (this.colorProvider == null) {
            return null;
        }
        double value = this.getItemValue(seriesIdx, DimensionConfig.PlotDimension.COLOR, valueIdx);
        Color itemColor = this.colorProvider.getColorForValue(value);
        itemColor = DataStructureUtils.setColorAlpha(itemColor, DataStructureUtils.multiplyOpacities256(itemColor.getAlpha(), this.seriesFormat.getOpacity()));
        if (!selected) {
            itemColor = DataStructureUtils.setColorAlpha(itemColor, 20);
        }
        Paint paint = this.seriesFormat.getAreaFillPaint(itemColor);
        return paint;
    }

    public boolean isItemSelected(int seriesIdx, int valueIdx) {
        double selectedValue = this.getItemValue(seriesIdx, DimensionConfig.PlotDimension.SELECTED, valueIdx);
        boolean selected = selectedValue == 1.0;
        return selected;
    }

    private double getItemValue(int seriesIdx, DimensionConfig.PlotDimension dimension, int valueIdx) {
        switch (dimension) {
            case COLOR: {
                return this.colorValues.get(seriesIdx)[valueIdx];
            }
            case SHAPE: {
                return this.shapeValues.get(seriesIdx)[valueIdx];
            }
            case SIZE: {
                return this.sizeValues.get(seriesIdx)[valueIdx];
            }
            case SELECTED: {
                return this.selectedValues.get(seriesIdx)[valueIdx];
            }
        }
        throw new IllegalArgumentException("getItemValue called for dimension " + (Object)((Object)dimension) + " which is unsupported by RenderFormatDelegate - this should not happen.");
    }

    public Shape getItemShape(int seriesIdx, int valueIdx) {
        double scalingFactor;
        Shape shape;
        if (!this.individualShapeForEachItem) {
            Shape seriesShape;
            if (this.seriesShapeFromDimensionConfig) {
                double shapeIdx = this.getValueOfCurrentRange(seriesIdx, DimensionConfig.PlotDimension.SHAPE);
                seriesShape = this.shapeProvider.getShapeForCategory(shapeIdx);
            } else {
                seriesShape = this.seriesFormat.getItemShape().getShape();
            }
            shape = seriesShape;
        } else {
            Shape itemShape;
            if (this.shapeProvider == null) {
                return null;
            }
            double shapeValue = this.getItemValue(seriesIdx, DimensionConfig.PlotDimension.SHAPE, valueIdx);
            shape = itemShape = this.shapeProvider.getShapeForCategory(shapeValue);
        }
        if (!this.individualSizeForEachItem) {
            if (this.seriesSizeFromDimensionConfig) {
                double sizeIdx = this.getValueOfCurrentRange(seriesIdx, DimensionConfig.PlotDimension.SIZE);
                scalingFactor = this.sizeProvider.getScalingFactorForValue(sizeIdx);
            } else {
                scalingFactor = this.seriesFormat.getItemSize();
            }
        } else {
            if (this.sizeProvider == null) {
                return null;
            }
            double sizeValue = this.getItemValue(seriesIdx, DimensionConfig.PlotDimension.SIZE, valueIdx);
            scalingFactor = this.sizeProvider.getScalingFactorForValue(sizeValue);
        }
        shape = this.scaleShape(shape, scalingFactor);
        return shape;
    }

    private Shape scaleShape(Shape shape, double scalingFactor) {
        if (scalingFactor != 1.0) {
            AffineTransform t = new AffineTransform();
            t.scale(scalingFactor, scalingFactor);
            shape = t.createTransformedShape(shape);
        }
        return shape;
    }

    public void setConfiguration(ValueSourceData valueSourceData, PlotInstance plotInstance) {
        DefaultDimensionConfig colorDimensionConfig = (DefaultDimensionConfig)plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.COLOR);
        this.colorProvider = colorDimensionConfig != null ? plotInstance.getPlotData().getDimensionConfigData(colorDimensionConfig).getColorProvider() : null;
        DefaultDimensionConfig shapeDimensionConfig = (DefaultDimensionConfig)plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.SHAPE);
        this.shapeProvider = shapeDimensionConfig != null ? plotInstance.getPlotData().getDimensionConfigData(shapeDimensionConfig).getShapeProvider() : null;
        DefaultDimensionConfig sizeDimensionConfig = (DefaultDimensionConfig)plotInstance.getCurrentPlotConfigurationClone().getDimensionConfig(DimensionConfig.PlotDimension.SIZE);
        this.sizeProvider = sizeDimensionConfig != null ? plotInstance.getPlotData().getDimensionConfigData(sizeDimensionConfig).getSizeProvider() : null;
        this.individualColorForEachItem = SeriesFormat.calculateIndividualFormatForEachItem(valueSourceData.getValueSource().getDomainConfig(), colorDimensionConfig);
        this.seriesColorFromDimensionConfig = SeriesFormat.useSeriesFormatFromDimensionConfig(valueSourceData.getValueSource().getDomainConfig(), colorDimensionConfig);
        this.individualShapeForEachItem = SeriesFormat.calculateIndividualFormatForEachItem(valueSourceData.getValueSource().getDomainConfig(), shapeDimensionConfig);
        this.seriesShapeFromDimensionConfig = SeriesFormat.useSeriesFormatFromDimensionConfig(valueSourceData.getValueSource().getDomainConfig(), shapeDimensionConfig);
        this.individualSizeForEachItem = SeriesFormat.calculateIndividualFormatForEachItem(valueSourceData.getValueSource().getDomainConfig(), sizeDimensionConfig);
        this.seriesSizeFromDimensionConfig = SeriesFormat.useSeriesFormatFromDimensionConfig(valueSourceData.getValueSource().getDomainConfig(), sizeDimensionConfig);
        this.seriesFormat = valueSourceData.getValueSource().getSeriesFormat();
        if (this.individualColorForEachItem) {
            this.colorValues = this.copySeriesValues(valueSourceData, DimensionConfig.PlotDimension.COLOR);
        }
        if (this.individualShapeForEachItem) {
            this.shapeValues = this.copySeriesValues(valueSourceData, DimensionConfig.PlotDimension.SHAPE);
        }
        if (this.individualSizeForEachItem) {
            this.sizeValues = this.copySeriesValues(valueSourceData, DimensionConfig.PlotDimension.SIZE);
        }
        this.selectedValues = this.copySeriesValues(valueSourceData, DimensionConfig.PlotDimension.SELECTED);
        if (this.seriesColorFromDimensionConfig || this.seriesShapeFromDimensionConfig || this.seriesSizeFromDimensionConfig) {
            GroupCellSeriesData seriesDataForAllGroupCells = valueSourceData.getSeriesDataForAllGroupCells();
            this.groupCellKeysBySeriesIdx = new Vector(seriesDataForAllGroupCells.groupCellCount());
            for (GroupCellKeyAndData groupCellKeyAndData : seriesDataForAllGroupCells) {
                this.groupCellKeysBySeriesIdx.add(groupCellKeyAndData.getKey());
            }
        }
        this.fireChanged();
    }

    private Vector<double[]> copySeriesValues(ValueSourceData valueSourceData, DimensionConfig.PlotDimension dimension) {
        Vector<double[]> seriesValues = new Vector<double[]>(valueSourceData.getSeriesDataForAllGroupCells().groupCellCount());
        for (GroupCellKeyAndData groupCellKeyAndData : valueSourceData.getSeriesDataForAllGroupCells()) {
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            double[] seriesData = new double[groupCellData.getSize()];
            int i = 0;
            double[] dArray = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES).get((Object)dimension);
            int n = dArray.length;
            for (int j = 0; j < n; ++j) {
                double d;
                seriesData[i] = d = dArray[j];
                ++i;
            }
            seriesValues.add(seriesData);
        }
        return seriesValues;
    }

    public void addListener(RenderFormatDelegateChangeListener l) {
        this.listeners.add(l);
    }

    public void removeListener(RenderFormatDelegateChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChanged() {
        for (RenderFormatDelegateChangeListener l : this.listeners) {
            l.renderFormatDelegateChanged(this);
        }
    }

    @Override
    public void seriesFormatChanged(SeriesFormatChangeEvent e) {
        this.fireChanged();
    }

    public Color getSeriesColor(int seriesIdx) {
        if (!this.individualColorForEachItem) {
            if (this.seriesColorFromDimensionConfig) {
                double colorIdx = this.getValueOfCurrentRange(seriesIdx, DimensionConfig.PlotDimension.COLOR);
                int opacity = this.seriesFormat.getOpacity();
                Color color = this.colorProvider.getColorForValue(colorIdx);
                color = DataStructureUtils.setColorAlpha(color, DataStructureUtils.multiplyOpacities256(color.getAlpha(), opacity));
                return color;
            }
            return this.seriesFormat.getItemColor();
        }
        return null;
    }

    public SeriesFormat getSeriesFormat() {
        return this.seriesFormat;
    }

    private double getValueOfCurrentRange(int seriesIdx, DimensionConfig.PlotDimension dimension) {
        ValueRange currentValueRange = this.groupCellKeysBySeriesIdx.get(seriesIdx).getRangeForDimension(dimension);
        if (currentValueRange == null) {
            return Double.NaN;
        }
        double value = currentValueRange.getValue();
        return value;
    }

    public Paint getItemOutlinePaint(int seriesIdx, int valueIdx) {
        return null;
    }
}

