/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.dataset;

import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.GroupCellKey;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.data.GroupCellData;
import com.owc.gui.charting.data.GroupCellKeyAndData;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.ValueSourceData;
import com.owc.gui.charting.engine.jfreechart.ChartDatasetFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.MultiValueCategoryDataset;

public class ValueSourceToMultiValueCategoryDatasetAdapter
extends AbstractDataset
implements MultiValueCategoryDataset,
RangeInfo,
Cloneable {
    private static final long serialVersionUID = 1L;
    private ValueSourceData valueSourceData;
    private PlotInstance plotInstance;
    private transient Vector<String> seriesNamesCache = null;
    private transient double minValueCache = Double.NaN;
    private transient double maxValueCache = Double.NaN;
    private transient Vector<Double> domainValuesCache = null;
    private transient Map<GroupCellKey, Map<Integer, Vector<Double>>> groupCellKeyToDomainValueToValuesCache = null;
    private transient Map<GroupCellKey, Map<Integer, Vector<Integer>>> groupCellKeyToDomainValueToValueIdxCache = null;

    public ValueSourceToMultiValueCategoryDatasetAdapter(ValueSourceData valueSourceData, PlotInstance plotInstance) {
        if (valueSourceData == null || plotInstance == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.valueSourceData = valueSourceData;
        this.plotInstance = plotInstance;
    }

    public String getRowKey(int row) {
        if (this.seriesNamesCache == null) {
            this.updateSeriesNameCache();
        }
        return this.seriesNamesCache.get(row);
    }

    public int getRowIndex(Comparable key) {
        if (this.seriesNamesCache == null) {
            this.updateSeriesNameCache();
        }
        return this.seriesNamesCache.indexOf(key);
    }

    private void updateSeriesNameCache() {
        this.seriesNamesCache = new Vector(this.valueSourceData.getSeriesCount());
        for (GroupCellKeyAndData groupCellKeyAndData : this.valueSourceData.getSeriesDataForAllGroupCells()) {
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            this.seriesNamesCache.add(ChartDatasetFactory.generateSeriesName(this.valueSourceData.getValueSource(), groupCellKey, this.plotInstance.getCurrentPlotConfigurationClone()));
        }
    }

    public List<String> getRowKeys() {
        if (this.seriesNamesCache == null) {
            this.updateSeriesNameCache();
        }
        return this.seriesNamesCache;
    }

    public String getColumnKey(int column) {
        if (this.domainValuesCache == null) {
            this.updateValuesCache();
        }
        Double columnValue = this.domainValuesCache.get(column);
        DefaultDimensionConfig domainConfig = this.valueSourceData.getValueSource().getDomainConfig();
        return this.plotInstance.getPlotData().getDimensionConfigData(domainConfig).getStringForValue(columnValue);
    }

    public int getColumnIndex(Comparable key) {
        if (this.domainValuesCache == null) {
            this.updateValuesCache();
        }
        return this.domainValuesCache.indexOf(key);
    }

    public List<Double> getColumnKeys() {
        if (this.domainValuesCache == null) {
            this.updateValuesCache();
        }
        return this.domainValuesCache;
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return null;
    }

    public int getRowCount() {
        return this.valueSourceData.getSeriesCount();
    }

    public int getColumnCount() {
        DefaultDimensionConfig domainConfig = this.valueSourceData.getValueSource().getDomainConfig();
        return this.plotInstance.getPlotData().getDimensionConfigData(domainConfig).getDistinctValueCount();
    }

    public Number getValue(int row, int column) {
        List<Double> values = this.getValues(row, column);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public double getRangeLowerBound(boolean includeInterval) {
        if (Double.isNaN(this.minValueCache)) {
            this.updateValuesCache();
        }
        return this.minValueCache;
    }

    public double getRangeUpperBound(boolean includeInterval) {
        if (Double.isNaN(this.minValueCache)) {
            this.updateValuesCache();
        }
        return this.maxValueCache;
    }

    public Range getRangeBounds(boolean includeInterval) {
        if (Double.isNaN(this.minValueCache) || Double.isNaN(this.maxValueCache)) {
            this.updateValuesCache();
        }
        return new Range(this.minValueCache, this.maxValueCache);
    }

    public List<Double> getValues(int row, int column) {
        GroupCellKey groupCellKey;
        Map<Integer, Vector<Double>> map;
        if (this.groupCellKeyToDomainValueToValuesCache == null) {
            this.updateValuesCache();
        }
        if ((map = this.groupCellKeyToDomainValueToValuesCache.get(groupCellKey = this.valueSourceData.getSeriesDataForAllGroupCells().getGroupCellKeyAndData(row).getKey())) != null) {
            return map.get(column);
        }
        return new LinkedList<Double>();
    }

    public List<Double> getValues(Comparable rowKey, Comparable columnKey) {
        Number row = (Number)((Object)rowKey);
        Number column = (Number)((Object)columnKey);
        return this.getValues(row.intValue(), column.intValue());
    }

    private void updateValuesCache() {
        this.minValueCache = Double.POSITIVE_INFINITY;
        this.maxValueCache = Double.NEGATIVE_INFINITY;
        this.groupCellKeyToDomainValueToValuesCache = new HashMap<GroupCellKey, Map<Integer, Vector<Double>>>();
        this.groupCellKeyToDomainValueToValueIdxCache = new HashMap<GroupCellKey, Map<Integer, Vector<Integer>>>();
        this.seriesNamesCache = new Vector(this.valueSourceData.getSeriesCount());
        DefaultDimensionConfig domainConfig = this.valueSourceData.getValueSource().getDomainConfig();
        DimensionConfigData domainConfigData = this.plotInstance.getPlotData().getDimensionConfigData(domainConfig);
        this.domainValuesCache = new Vector(domainConfigData.getDistinctValueCount());
        this.domainValuesCache.addAll(domainConfigData.getDistinctValues());
        Collections.sort(this.domainValuesCache);
        for (GroupCellKeyAndData groupCellKeyAndData : this.valueSourceData.getSeriesDataForAllGroupCells()) {
            GroupCellData groupCellData = groupCellKeyAndData.getData();
            GroupCellKey groupCellKey = groupCellKeyAndData.getKey();
            this.seriesNamesCache.add(ChartDatasetFactory.generateSeriesName(this.valueSourceData.getValueSource(), groupCellKey, this.plotInstance.getCurrentPlotConfigurationClone()));
            double[] yData = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES).get((Object)DimensionConfig.PlotDimension.VALUE);
            double[] domainData = groupCellData.getDataForUsageType(ValueSource.SeriesUsageType.MAIN_SERIES).get((Object)DimensionConfig.PlotDimension.DOMAIN);
            HashMap<Integer, Vector<Double>> domainToValuesMap = new HashMap<Integer, Vector<Double>>();
            HashMap<Integer, Vector<Integer>> domainToValueIdxMap = new HashMap<Integer, Vector<Integer>>();
            for (int i = 0; i < yData.length; ++i) {
                double y = yData[i];
                double x = domainData[i];
                int xIdx = this.getColumnIndex(Double.valueOf(x));
                if (y > this.maxValueCache) {
                    this.maxValueCache = y;
                }
                if (y < this.minValueCache) {
                    this.minValueCache = y;
                }
                this.groupCellKeyToDomainValueToValuesCache.put(groupCellKey, domainToValuesMap);
                this.groupCellKeyToDomainValueToValueIdxCache.put(groupCellKey, domainToValueIdxMap);
                Vector<Double> valueListForX = (Vector<Double>)domainToValuesMap.get(xIdx);
                Vector<Integer> valueIdxListForX = (Vector<Integer>)domainToValueIdxMap.get(xIdx);
                if (valueListForX == null) {
                    valueListForX = new Vector<Double>();
                    valueIdxListForX = new Vector<Integer>();
                    valueListForX.add(y);
                    valueIdxListForX.add(i);
                    domainToValuesMap.put(xIdx, valueListForX);
                    domainToValueIdxMap.put(xIdx, valueIdxListForX);
                    continue;
                }
                valueListForX.add(y);
                valueIdxListForX.add(i);
            }
        }
    }

    public int getValueIndex(int row, int column, int valueIdx) {
        if (this.groupCellKeyToDomainValueToValueIdxCache == null) {
            this.updateValuesCache();
        }
        GroupCellKey groupCellKey = this.valueSourceData.getSeriesDataForAllGroupCells().getGroupCellKeyAndData(row).getKey();
        Map<Integer, Vector<Integer>> map = this.groupCellKeyToDomainValueToValueIdxCache.get(groupCellKey);
        Vector<Integer> vector = map.get(column);
        return vector.get(valueIdx);
    }
}

