/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.link_and_brush;

import com.owc.gui.charting.engine.jfreechart.link_and_brush.ChartPanel;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.Overlay;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushSelection;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushSelectionListener;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.plots.LinkAndBrushPlot;
import com.rapidminer.gui.plotter.CoordinateTransformation;
import com.rapidminer.gui.plotter.NullCoordinateTransformation;
import com.rapidminer.tools.container.Pair;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Pannable;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class LinkAndBrushChartPanel
extends ChartPanel {
    private static final long serialVersionUID = 1L;
    private boolean zoomOnLinkAndBrushSelection;
    private boolean blockSelectionOrZoom = false;
    private transient CoordinateTransformation coordinateTransformation = new NullCoordinateTransformation();
    private transient List<WeakReference<LinkAndBrushSelectionListener>> listeners = new LinkedList<WeakReference<LinkAndBrushSelectionListener>>();

    public LinkAndBrushChartPanel(JFreeChart chart, boolean zoomOnLinkAndBrushSelection) {
        super(chart, 600, 400, 200, 133, 1024, 768, true, false, false, false, false, false, true);
        this.zoomOnLinkAndBrushSelection = zoomOnLinkAndBrushSelection;
        this.setInitialDelay(200);
        this.setMouseWheelEnabled(false);
    }

    public LinkAndBrushChartPanel(JFreeChart chart, int defaultWidth, int defaultHeigth, int minDrawWidth, int minDrawHeigth, boolean zoomOnLinkAndBrush) {
        super(chart, defaultWidth, defaultHeigth, minDrawWidth, minDrawHeigth, 1024, 768, true, false, false, false, false, false, true);
        this.zoomOnLinkAndBrushSelection = zoomOnLinkAndBrush;
        this.setInitialDelay(200);
        this.setMouseWheelEnabled(false);
    }

    public LinkAndBrushChartPanel(JFreeChart chart, int defaultWidth, int defaultHeigth, int minDrawWidth, int minDrawHeigth, boolean zoomOnLinkAndBrush, boolean useBuffer) {
        super(chart, defaultWidth, defaultHeigth, minDrawWidth, minDrawHeigth, 1024, 768, useBuffer, false, false, false, false, false, true);
        this.zoomOnLinkAndBrushSelection = zoomOnLinkAndBrush;
        this.setMouseWheelEnabled(false);
    }

    @Override
    public void restoreAutoBounds() {
        Plot plot = this.getChart().getPlot();
        if (plot == null) {
            return;
        }
        boolean savedNotify = plot.isNotify();
        plot.setNotify(false);
        if (plot instanceof LinkAndBrushPlot) {
            LinkAndBrushPlot LABPlot = (LinkAndBrushPlot)plot;
            LinkedList<Pair<Integer, Range>> zoomedDomainAxisRanges = new LinkedList<Pair<Integer, Range>>();
            LinkedList<Pair<Integer, Range>> zoomedRangeAxisRanges = new LinkedList<Pair<Integer, Range>>();
            zoomedDomainAxisRanges.addAll(LABPlot.restoreAutoDomainAxisBounds(this.zoomOnLinkAndBrushSelection));
            zoomedRangeAxisRanges.addAll(LABPlot.restoreAutoRangeAxisBounds(this.zoomOnLinkAndBrushSelection));
            if (this.zoomOnLinkAndBrushSelection) {
                this.informLinkAndBrushSelectionListeners(new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.RESTORE_AUTO_BOUNDS, zoomedDomainAxisRanges, zoomedRangeAxisRanges));
            } else {
                this.informLinkAndBrushSelectionListeners(new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.RESTORE_SELECTION, zoomedDomainAxisRanges, zoomedRangeAxisRanges));
            }
        } else {
            this.restoreAutoDomainBounds();
            this.restoreAutoRangeBounds();
        }
        plot.setNotify(savedNotify);
    }

    @Override
    public void zoom(Rectangle2D selection) {
        Point2D selectOrigin = this.translateScreenToJava2D(new Point((int)Math.ceil(selection.getX()), (int)Math.ceil(selection.getY())));
        PlotRenderingInfo plotInfo = this.getChartRenderingInfo().getPlotInfo();
        Rectangle2D scaledDataArea = this.getScreenDataArea((int)selection.getCenterX(), (int)selection.getCenterY());
        if (selection.getHeight() > 0.0 && selection.getWidth() > 0.0) {
            double hLower = (selection.getMinX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double hUpper = (selection.getMaxX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double vLower = (scaledDataArea.getMaxY() - selection.getMaxY()) / scaledDataArea.getHeight();
            double vUpper = (scaledDataArea.getMaxY() - selection.getMinY()) / scaledDataArea.getHeight();
            Plot p = this.getChart().getPlot();
            if (p instanceof LinkAndBrushPlot) {
                PlotOrientation orientation = null;
                if (p instanceof XYPlot) {
                    XYPlot xyPlot = (XYPlot)p;
                    orientation = xyPlot.getOrientation();
                }
                if (p instanceof CategoryPlot) {
                    CategoryPlot categoryPlot = (CategoryPlot)p;
                    orientation = categoryPlot.getOrientation();
                }
                boolean savedNotify = p.isNotify();
                p.setNotify(false);
                LinkAndBrushPlot LABPlot = (LinkAndBrushPlot)p;
                LinkedList<Pair<Integer, Range>> zoomedDomainAxisRanges = new LinkedList<Pair<Integer, Range>>();
                LinkedList<Pair<Integer, Range>> zoomedRangeAxisRanges = new LinkedList<Pair<Integer, Range>>();
                if (orientation == PlotOrientation.HORIZONTAL) {
                    zoomedDomainAxisRanges.addAll(LABPlot.calculateDomainAxesZoom(vLower, vUpper, this.zoomOnLinkAndBrushSelection));
                    zoomedRangeAxisRanges.addAll(LABPlot.calculateRangeAxesZoom(hLower, hUpper, plotInfo, selectOrigin, this.zoomOnLinkAndBrushSelection));
                } else {
                    zoomedDomainAxisRanges.addAll(LABPlot.calculateDomainAxesZoom(hLower, hUpper, this.zoomOnLinkAndBrushSelection));
                    zoomedRangeAxisRanges.addAll(LABPlot.calculateRangeAxesZoom(vLower, vUpper, plotInfo, selectOrigin, this.zoomOnLinkAndBrushSelection));
                }
                p.setNotify(savedNotify);
                if (this.zoomOnLinkAndBrushSelection) {
                    this.informLinkAndBrushSelectionListeners(new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.ZOOM_IN, zoomedDomainAxisRanges, zoomedRangeAxisRanges));
                } else {
                    this.informLinkAndBrushSelectionListeners(new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.SELECTION, zoomedDomainAxisRanges, zoomedRangeAxisRanges));
                }
            } else {
                super.zoom(selection);
            }
        }
    }

    public void setZoomOnLinkAndBrushSelection(boolean zoomOnLinkAndBrushSelection) {
        this.zoomOnLinkAndBrushSelection = zoomOnLinkAndBrushSelection;
    }

    public boolean getZoomOnLinkAndBrushSelection() {
        return this.zoomOnLinkAndBrushSelection;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getChart() == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double available = new Rectangle2D.Double(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean scale = false;
        double drawWidth = ((RectangularShape)available).getWidth();
        double drawHeight = ((RectangularShape)available).getHeight();
        this.setScaleX(1.0);
        this.setScaleY(1.0);
        if (drawWidth < (double)this.getMinimumDrawWidth()) {
            this.setScaleX(drawWidth / (double)this.getMinimumDrawWidth());
            drawWidth = this.getMinimumDrawWidth();
            scale = true;
        } else if (drawWidth > (double)this.getMaximumDrawWidth()) {
            this.setScaleX(drawWidth / (double)this.getMaximumDrawWidth());
            drawWidth = this.getMaximumDrawWidth();
            scale = true;
        }
        if (drawHeight < (double)this.getMinimumDrawHeight()) {
            this.setScaleY(drawHeight / (double)this.getMinimumDrawHeight());
            drawHeight = this.getMinimumDrawHeight();
            scale = true;
        } else if (drawHeight > (double)this.getMaximumDrawHeight()) {
            this.setScaleY(drawHeight / (double)this.getMaximumDrawHeight());
            drawHeight = this.getMaximumDrawHeight();
            scale = true;
        }
        Rectangle2D.Double chartArea = new Rectangle2D.Double(0.0, 0.0, drawWidth, drawHeight);
        if (this.isUsingBuffer()) {
            if (this.getBuffer() == null || (double)this.getChartBufferWidth() != ((RectangularShape)available).getWidth() || (double)this.getChartBufferHeight() != ((RectangularShape)available).getHeight()) {
                this.setBufferWidth((int)((RectangularShape)available).getWidth());
                this.setBufferHeight((int)((RectangularShape)available).getHeight());
                GraphicsConfiguration gc = g2.getDeviceConfiguration();
                this.setBuffer(gc.createCompatibleImage(this.getChartBufferWidth(), this.getChartBufferHeight(), 3));
                this.setRefreshBuffer(true);
            }
            if (this.getRefreshBuffer()) {
                this.setRefreshBuffer(false);
                Rectangle2D.Double bufferArea = new Rectangle2D.Double(0.0, 0.0, this.getChartBufferWidth(), this.getChartBufferHeight());
                Graphics2D bufferG2 = (Graphics2D)this.getBuffer().getGraphics();
                Rectangle r = new Rectangle(0, 0, this.getChartBufferWidth(), this.getChartBufferHeight());
                bufferG2.setPaint(this.getBackground());
                bufferG2.fill(r);
                if (scale) {
                    AffineTransform saved = bufferG2.getTransform();
                    AffineTransform st = AffineTransform.getScaleInstance(this.getScaleX(), this.getScaleY());
                    bufferG2.transform(st);
                    this.getChart().draw(bufferG2, (Rectangle2D)chartArea, this.getAnchor(), this.getChartRenderingInfo());
                    bufferG2.setTransform(saved);
                } else {
                    this.getChart().draw(bufferG2, (Rectangle2D)bufferArea, this.getAnchor(), this.getChartRenderingInfo());
                }
            }
            g2.drawImage(this.getBuffer(), insets.left, insets.top, this);
        } else {
            AffineTransform saved = g2.getTransform();
            g2.translate(insets.left, insets.top);
            if (scale) {
                AffineTransform st = AffineTransform.getScaleInstance(this.getScaleX(), this.getScaleY());
                g2.transform(st);
            }
            this.getChart().draw(g2, (Rectangle2D)chartArea, this.getAnchor(), this.getChartRenderingInfo());
            g2.setTransform(saved);
        }
        for (Overlay overlay : this.getOverlays()) {
            overlay.paintOverlay(g2, this);
        }
        this.drawZoomRectangle(g2, !this.isUsingBuffer());
        g2.dispose();
        this.setAnchor(null);
        this.setVerticalTraceLine(null);
        this.setHorizontalTraceLine(null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.blockSelectionOrZoom = !SwingUtilities.isLeftMouseButton(e);
        super.mousePressed(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.blockSelectionOrZoom) {
            return;
        }
        if (this.getPopup() != null && this.getPopup().isShowing()) {
            return;
        }
        if (this.getPanLast() != null) {
            double dx = (double)e.getX() - this.getPanLast().getX();
            double dy = (double)e.getY() - this.getPanLast().getY();
            if (dx == 0.0 && dy == 0.0) {
                return;
            }
            double wPercent = -dx / this.getPanWidth();
            double hPercent = dy / this.getPanHeight();
            boolean old = this.getChart().getPlot().isNotify();
            this.getChart().getPlot().setNotify(false);
            Pannable p = (Pannable)this.getChart().getPlot();
            if (p.getOrientation() == PlotOrientation.VERTICAL) {
                p.panDomainAxes(wPercent, this.getChartRenderingInfo().getPlotInfo(), (Point2D)this.getPanLast());
                p.panRangeAxes(hPercent, this.getChartRenderingInfo().getPlotInfo(), (Point2D)this.getPanLast());
            } else {
                p.panDomainAxes(hPercent, this.getChartRenderingInfo().getPlotInfo(), (Point2D)this.getPanLast());
                p.panRangeAxes(wPercent, this.getChartRenderingInfo().getPlotInfo(), (Point2D)this.getPanLast());
            }
            this.setPanLast(e.getPoint());
            this.getChart().getPlot().setNotify(old);
            return;
        }
        if (this.getZoomPoint() == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        if (!this.isUsingBuffer()) {
            this.drawZoomRectangle(g2, true);
        }
        boolean hZoom = false;
        boolean vZoom = false;
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            hZoom = this.isRangeZoomable();
            vZoom = this.isDomainZoomable();
        } else {
            hZoom = this.isDomainZoomable();
            vZoom = this.isRangeZoomable();
        }
        Point2D zoomPoint = this.getZoomPoint();
        Rectangle2D scaledDataArea = this.getScreenDataArea((int)zoomPoint.getX(), (int)zoomPoint.getY());
        if (hZoom && vZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.setZoomRectangle(new Rectangle2D.Double(zoomPoint.getX(), zoomPoint.getY(), xmax - zoomPoint.getX(), ymax - zoomPoint.getY()));
        } else if (hZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            this.setZoomRectangle(new Rectangle2D.Double(zoomPoint.getX(), scaledDataArea.getMinY(), xmax - zoomPoint.getX(), scaledDataArea.getHeight()));
        } else if (vZoom) {
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.setZoomRectangle(new Rectangle2D.Double(scaledDataArea.getMinX(), zoomPoint.getY(), scaledDataArea.getWidth(), ymax - zoomPoint.getY()));
        }
        if (this.isUsingBuffer()) {
            this.repaint();
        } else {
            this.drawZoomRectangle(g2, true);
        }
        g2.dispose();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Rectangle2D zoomRectangle = this.getZoomRectangle();
        Point2D zoomPoint = this.getZoomPoint();
        if (this.getPanLast() != null) {
            this.setPanLast(null);
            this.setCursor(Cursor.getDefaultCursor());
        } else if (zoomRectangle != null) {
            boolean zoomTrigger2;
            boolean hZoom = false;
            boolean vZoom = false;
            if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
                hZoom = this.isRangeZoomable();
                vZoom = this.isDomainZoomable();
            } else {
                hZoom = this.isDomainZoomable();
                vZoom = this.isRangeZoomable();
            }
            boolean zoomTrigger1 = hZoom && Math.abs((double)e.getX() - zoomPoint.getX()) >= (double)this.getZoomTriggerDistance();
            boolean bl = zoomTrigger2 = vZoom && Math.abs((double)e.getY() - zoomPoint.getY()) >= (double)this.getZoomTriggerDistance();
            if (zoomTrigger1 || zoomTrigger2) {
                if (hZoom && (double)e.getX() < zoomPoint.getX() || vZoom && (double)e.getY() < zoomPoint.getY()) {
                    this.restoreAutoBounds();
                } else {
                    double h;
                    double w;
                    double y;
                    double x;
                    Rectangle2D screenDataArea = this.getScreenDataArea((int)zoomPoint.getX(), (int)zoomPoint.getY());
                    double maxX = screenDataArea.getMaxX();
                    double maxY = screenDataArea.getMaxY();
                    if (!vZoom) {
                        x = zoomPoint.getX();
                        y = screenDataArea.getMinY();
                        w = Math.min(zoomRectangle.getWidth(), maxX - zoomPoint.getX());
                        h = screenDataArea.getHeight();
                    } else if (!hZoom) {
                        x = screenDataArea.getMinX();
                        y = zoomPoint.getY();
                        w = screenDataArea.getWidth();
                        h = Math.min(zoomRectangle.getHeight(), maxY - zoomPoint.getY());
                    } else {
                        x = zoomPoint.getX();
                        y = zoomPoint.getY();
                        w = Math.min(zoomRectangle.getWidth(), maxX - zoomPoint.getX());
                        h = Math.min(zoomRectangle.getHeight(), maxY - zoomPoint.getY());
                    }
                    Rectangle2D.Double zoomArea = new Rectangle2D.Double(x, y, w, h);
                    this.zoom(zoomArea);
                }
                this.setZoomPoint(null);
                this.setZoomRectangle(null);
            } else {
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                if (this.isUsingBuffer()) {
                    this.repaint();
                } else {
                    this.drawZoomRectangle(g2, true);
                }
                g2.dispose();
                this.setZoomPoint(null);
                this.setZoomRectangle(null);
            }
        } else if (e.isPopupTrigger() && this.getPopup() != null) {
            this.displayPopupMenu(e.getX(), e.getY());
        }
    }

    private void drawZoomRectangle(Graphics2D g2, boolean xor) {
        Rectangle2D zoomRectangle = this.getZoomRectangle();
        if (zoomRectangle != null) {
            zoomRectangle = this.coordinateTransformation.transformRectangle(zoomRectangle, (JComponent)this);
            if (!(this.coordinateTransformation instanceof NullCoordinateTransformation)) {
                g2 = this.coordinateTransformation.getTransformedGraphics((JComponent)this);
            }
            if (xor) {
                g2.setXORMode(Color.gray);
            }
            if (this.isFillZoomRectangle()) {
                g2.setPaint(this.getZoomFillPaint());
                g2.fill(zoomRectangle);
            } else {
                g2.setPaint(this.getZoomOutlinePaint());
                g2.draw(zoomRectangle);
            }
            if (xor) {
                g2.setPaintMode();
            }
        }
    }

    public void addLinkAndBrushSelectionListener(LinkAndBrushSelectionListener l) {
        this.listeners.add(new WeakReference<LinkAndBrushSelectionListener>(l));
    }

    public void removeLinkAndBrushSelectionListener(LinkAndBrushSelectionListener l) {
        Iterator<WeakReference<LinkAndBrushSelectionListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            WeakReference<LinkAndBrushSelectionListener> wrl = it.next();
            LinkAndBrushSelectionListener listener = (LinkAndBrushSelectionListener)wrl.get();
            if (listener != l && listener != null) continue;
            it.remove();
        }
    }

    public void informLinkAndBrushSelectionListeners(LinkAndBrushSelection e) {
        LinkedList<WeakReference<LinkAndBrushSelectionListener>> listenersCopy = new LinkedList<WeakReference<LinkAndBrushSelectionListener>>();
        listenersCopy.addAll(this.listeners);
        Iterator it = listenersCopy.iterator();
        while (it.hasNext()) {
            WeakReference wrl = (WeakReference)it.next();
            LinkAndBrushSelectionListener l = (LinkAndBrushSelectionListener)wrl.get();
            if (l != null) {
                l.selectedLinkAndBrushRectangle(e);
                continue;
            }
            it.remove();
        }
    }

    public void setCoordinateTransformation(CoordinateTransformation transformation) {
        this.coordinateTransformation = transformation;
    }
}

