/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.engine.jfreechart.renderer;

import com.owc.gui.charting.engine.jfreechart.RenderFormatDelegate;
import com.owc.gui.charting.engine.jfreechart.dataset.ValueSourceToMultiValueCategoryDatasetAdapter;
import com.owc.gui.charting.engine.jfreechart.renderer.FormattedRenderer;
import com.owc.gui.charting.utility.DataStructureUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.ScatterRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ShapeUtilities;

public class FormattedScatterRenderer
extends ScatterRenderer
implements FormattedRenderer {
    private static final long serialVersionUID = 1L;
    private RenderFormatDelegate formatDelegate = new RenderFormatDelegate();

    @Override
    public RenderFormatDelegate getFormatDelegate() {
        return this.formatDelegate;
    }

    public Paint getItemPaint(int seriesIdx, int valueIdx) {
        Paint paint = this.getFormatDelegate().getItemPaint(seriesIdx, valueIdx);
        if (paint == null) {
            paint = super.getItemPaint(seriesIdx, valueIdx);
        }
        return paint;
    }

    public Shape getItemShape(int seriesIdx, int valueIdx) {
        Shape shapeFromDelegate = this.getFormatDelegate().getItemShape(seriesIdx, valueIdx);
        if (shapeFromDelegate == null) {
            return super.getItemShape(seriesIdx, valueIdx);
        }
        return shapeFromDelegate;
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (!this.getItemVisible(row, column)) {
            return;
        }
        int visibleRow = state.getVisibleSeriesIndex(row);
        if (visibleRow < 0) {
            return;
        }
        int visibleRowCount = state.getVisibleSeriesCount();
        PlotOrientation orientation = plot.getOrientation();
        ValueSourceToMultiValueCategoryDatasetAdapter dataSet = (ValueSourceToMultiValueCategoryDatasetAdapter)dataset;
        List<Double> values = dataSet.getValues(row, column);
        if (values == null) {
            return;
        }
        int valueCount = values.size();
        for (int i = 0; i < valueCount; ++i) {
            double x1 = this.getUseSeriesOffset() ? domainAxis.getCategorySeriesMiddle(column, dataset.getColumnCount(), visibleRow, visibleRowCount, this.getItemMargin(), dataArea, plot.getDomainAxisEdge()) : domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            Number n = values.get(i);
            int idx = dataSet.getValueIndex(row, column, i);
            double value = n.doubleValue();
            double y1 = rangeAxis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
            Shape shape = this.getItemShape(row, idx);
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)y1, (double)x1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)x1, (double)y1);
            }
            if (this.getItemShapeFilled(row, column)) {
                if (this.getUseFillPaint()) {
                    g2.setPaint(this.getItemFillPaint(row, column));
                } else {
                    g2.setPaint(this.getItemPaint(row, idx));
                }
                g2.fill(shape);
            }
            if (!this.getDrawOutlines()) continue;
            if (this.getUseOutlinePaint()) {
                g2.setPaint(this.getItemOutlinePaint(row, column));
            } else {
                g2.setPaint(this.getItemPaint(row, idx));
            }
            g2.setStroke(this.getItemOutlineStroke(row, column));
            g2.draw(shape);
        }
    }

    public Paint getItemOutlinePaint(int seriesIdx, int valueIdx) {
        if (this.getFormatDelegate().isItemSelected(seriesIdx, valueIdx)) {
            return super.getItemOutlinePaint(seriesIdx, valueIdx);
        }
        return DataStructureUtils.setColorAlpha(Color.LIGHT_GRAY, 20);
    }
}

