/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.listener.PlotConfigurationListener;
import com.owc.gui.charting.listener.PlotInstanceChangedListener;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class AbstractConfigurationPanel
extends JPanel
implements PlotConfigurationListener,
PlotInstanceChangedListener {
    private transient List<PlotInstanceChangedListener> plotInstanceChangeListener = new LinkedList<PlotInstanceChangedListener>();
    private static final long serialVersionUID = 1L;
    private boolean enabled = true;
    private final Insets standardInset = new Insets(0, 5, 5, 5);
    private final Map<DatasetTransformationType, PlotInstance> typeToInstanceMap = new HashMap<DatasetTransformationType, PlotInstance>();
    private DatasetTransformationType currentType = DatasetTransformationType.ORIGINAL;

    public AbstractConfigurationPanel(PlotInstance plotInstance) {
        this.setLayout(new GridBagLayout());
        this.typeToInstanceMap.put(DatasetTransformationType.ORIGINAL, plotInstance);
    }

    protected void registerAsPlotConfigurationListener() {
        this.getCurrentPlotInstance().getMasterPlotConfiguration().addPlotConfigurationListener(this);
    }

    protected void unregisterAsPlotConfigurationListener() {
        this.getCurrentPlotInstance().getMasterPlotConfiguration().removePlotConfigurationListener(this);
    }

    protected PlotConfiguration getPlotConfiguration() {
        return this.getPlotInstance(this.currentType).getMasterPlotConfiguration();
    }

    protected void setPlotConfiguration(PlotConfiguration configuration) {
        this.getPlotInstance(this.currentType).setPlotConfiguration(configuration);
    }

    protected PlotInstance getCurrentPlotInstance() {
        return this.typeToInstanceMap.get((Object)this.currentType);
    }

    protected void setPlotInstance(PlotInstance instance, DatasetTransformationType type) {
        PlotInstance oldPlotInstance = this.getCurrentPlotInstance();
        this.typeToInstanceMap.put(type, instance);
        this.currentType = type;
        if (instance != null && oldPlotInstance != null) {
            this.informPlotInstanceChangeListener(oldPlotInstance, instance, type);
        }
    }

    protected DatasetTransformationType getCurrentTranformationType() {
        return this.currentType;
    }

    protected void addPlotInstanceChangeListener(PlotInstanceChangedListener l) {
        this.plotInstanceChangeListener.add(l);
    }

    protected void removePlotInstanceChangeListener(PlotInstanceChangedListener l) {
        this.plotInstanceChangeListener.remove(l);
    }

    protected void informPlotInstanceChangeListener(PlotInstance oldPlotInstance, PlotInstance newPlotInstance, DatasetTransformationType newType) {
        for (PlotInstanceChangedListener l : this.plotInstanceChangeListener) {
            l.plotInstanceChanged(oldPlotInstance, newPlotInstance, newType);
        }
    }

    @Override
    public void plotInstanceChanged(PlotInstance oldPlotInstance, PlotInstance newPlotInstance, DatasetTransformationType newType) {
        oldPlotInstance.getMasterPlotConfiguration().removePlotConfigurationListener(this);
        this.setPlotInstance(newPlotInstance, newType);
        this.registerAsPlotConfigurationListener();
        this.adaptGUI();
    }

    protected PlotInstance getPlotInstance(DatasetTransformationType type) {
        return this.typeToInstanceMap.get((Object)type);
    }

    protected void addTwoComponentRow(JPanel addTarget, JComponent first, JComponent second) {
        if (!(addTarget.getLayout() instanceof GridBagLayout)) {
            throw new RuntimeException("JPanel with GridBagLayout is mandatory!");
        }
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 0;
        itemConstraint.weightx = 0.0;
        itemConstraint.gridwidth = 1;
        itemConstraint.anchor = 17;
        itemConstraint.insets = this.standardInset;
        addTarget.add((Component)first, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 2;
        itemConstraint.insets = this.standardInset;
        addTarget.add((Component)second, itemConstraint);
    }

    protected Insets getStandardInsets() {
        return this.standardInset;
    }

    protected void addThreeComponentRow(JPanel addTarget, JLabel label, JComponent second, JComponent third) {
        if (!(addTarget.getLayout() instanceof GridBagLayout)) {
            throw new RuntimeException("JPanel with GridBagLayout is mandatory!");
        }
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 0;
        itemConstraint.weightx = 0.0;
        itemConstraint.gridwidth = 1;
        itemConstraint.insets = this.standardInset;
        itemConstraint.anchor = 21;
        addTarget.add((Component)label, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        itemConstraint.fill = 2;
        itemConstraint.insets = this.standardInset;
        addTarget.add((Component)second, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.anchor = 13;
        itemConstraint.fill = 2;
        itemConstraint.insets = this.standardInset;
        addTarget.add((Component)third, itemConstraint);
    }

    protected void addSeperatorToPanel(JPanel addTarget) {
        if (!(addTarget.getLayout() instanceof GridBagLayout)) {
            throw new RuntimeException("JPanel with GridBagLayout is mandatory!");
        }
        JSeparator separator = new JSeparator(0);
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = -1;
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 2;
        itemConstraint.insets = new Insets(0, 5, 5, 5);
        addTarget.add((Component)separator, itemConstraint);
    }

    protected Icon createColoredRectangleIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (color != null) {
            Color newColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
            g2.setColor(newColor);
        } else {
            g2.setColor(Color.gray);
        }
        g2.fillRect(0, 0, 10, 10);
        return new ImageIcon(bufferedImage);
    }

    public void disableAllComponents() {
        if (this.enabled) {
            SwingTools.setEnabledRecursive((Component)this, (boolean)false);
            this.enabled = false;
        }
    }

    public void enableAllComponents() {
        if (!this.enabled) {
            SwingTools.setEnabledRecursive((Component)this, (boolean)true);
            this.enabled = true;
        }
    }

    protected void processPlotConfigurationMetaChange(PlotConfigurationChangeEvent change) {
        for (PlotConfigurationChangeEvent e : change.getPlotConfigChangeEvents()) {
            this.plotConfigurationChanged(e);
        }
    }

    protected abstract void adaptGUI();

    public static enum DatasetTransformationType {
        ORIGINAL,
        DE_PIVOTED;

    }
}

