/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractTreeSelectionDependentPanel;
import com.owc.gui.charting.gui.cellrenderer.EnumComboBoxCellRenderer;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import com.owc.gui.charting.listener.events.ValueSourceChangeEvent;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AreaAndBarChartConfigurationPanel
extends AbstractTreeSelectionDependentPanel {
    private static final long serialVersionUID = 1L;
    private JLabel stackingModeLabel;
    private JComboBox<SeriesFormat.StackingMode> stackingModeComboBox;
    private JLabel itemColorLabel;
    private JButton itemColorButton;
    private JLabel fillStyleLabel;
    private JComboBox<SeriesFormat.FillStyle> fillStyleComboBox;
    private JLabel opacityLabel;
    private JSlider opacitySlider;

    public AreaAndBarChartConfigurationPanel(boolean smallIcons, JTree plotConfigurationTree, PlotInstance plotInstance) {
        super(plotConfigurationTree, plotInstance);
        this.createComponents(smallIcons);
        this.registerAsPlotConfigurationListener();
        this.initComponents();
        this.setPreferredSize(new Dimension(220, 200));
    }

    private void createComponents(boolean smallIcons) {
        this.fillStyleLabel = new ResourceLabel("plotter.configuration_dialog.fill_style", new Object[0]);
        this.fillStyleComboBox = new JComboBox<SeriesFormat.FillStyle>(SeriesFormat.FillStyle.values());
        this.fillStyleLabel.setLabelFor(this.fillStyleComboBox);
        this.fillStyleComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.fillstyle"));
        this.fillStyleComboBox.setSelectedIndex(0);
        this.fillStyleComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AreaAndBarChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat().setAreaFillStyle((SeriesFormat.FillStyle)((Object)AreaAndBarChartConfigurationPanel.this.fillStyleComboBox.getSelectedItem()));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addTwoComponentRow(this, this.fillStyleLabel, this.fillStyleComboBox);
        this.stackingModeLabel = new ResourceLabel("plotter.configuration_dialog.stacking_mode", new Object[0]);
        this.stackingModeComboBox = new JComboBox<SeriesFormat.StackingMode>(SeriesFormat.StackingMode.values());
        this.stackingModeLabel.setLabelFor(this.stackingModeComboBox);
        this.stackingModeComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.stacking_mode"));
        this.stackingModeComboBox.setSelectedIndex(0);
        this.stackingModeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AreaAndBarChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat().setStackingMode((SeriesFormat.StackingMode)((Object)AreaAndBarChartConfigurationPanel.this.stackingModeComboBox.getSelectedItem()));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addTwoComponentRow(this, this.stackingModeLabel, this.stackingModeComboBox);
        this.itemColorLabel = new ResourceLabel("plotter.configuration_dialog.item_color", new Object[0]);
        this.itemColorLabel.setPreferredSize(new Dimension(80, 15));
        this.itemColorButton = new JButton((Action)new ResourceAction(smallIcons, "plotter.configuration_dialog.choose_item_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AreaAndBarChartConfigurationPanel.this.createItemColorDialog();
            }
        });
        this.itemColorLabel.setLabelFor(this.itemColorButton);
        this.addTwoComponentRow(this, this.itemColorLabel, this.itemColorButton);
        this.opacityLabel = new ResourceLabel("plotter.configuration_dialog.opacity", new Object[0]);
        this.opacitySlider = new JSlider(0, 255, 125);
        this.opacityLabel.setLabelFor(this.opacitySlider);
        this.opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    AreaAndBarChartConfigurationPanel.this.getSelectedValueSource().getSeriesFormat().setOpacity(source.getValue());
                }
            }
        });
        this.addTwoComponentRow(this, this.opacityLabel, this.opacitySlider);
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        this.add((Component)new JPanel(), itemConstraint);
    }

    private void initComponents() {
        this.adaptGUI();
    }

    private void createItemColorDialog() {
        if (this.getSelectedValueSource() != null) {
            Color itemColor = this.getSelectedValueSource().getSeriesFormat().getItemColor();
            Color newItemColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.choose_color.label", (Object[])new Object[0]), itemColor);
            if (newItemColor != null && !newItemColor.equals(itemColor)) {
                this.getSelectedValueSource().getSeriesFormat().setItemColor(newItemColor);
            }
        }
    }

    private void opacityChanged(Integer integer) {
        this.opacitySlider.setValue(integer);
    }

    private void fillStyleSelectionChanged(SeriesFormat.FillStyle fillStyle) {
        this.fillStyleComboBox.setSelectedItem((Object)fillStyle);
    }

    private void stackingModeSelectionChanged(SeriesFormat.StackingMode stackingMode) {
        this.stackingModeComboBox.setSelectedItem((Object)stackingMode);
    }

    @Override
    protected void adaptGUI() {
        if (this.getSelectedValueSource() != null) {
            SeriesFormat format = this.getSelectedValueSource().getSeriesFormat();
            this.opacityChanged(format.getOpacity());
            this.fillStyleSelectionChanged(format.getAreaFillStyle());
            this.stackingModeSelectionChanged(format.getStackingMode());
        }
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        RangeAxisConfigChangeEvent rangeAxisConfigChange;
        PlotConfigurationChangeEvent.PlotConfigurationChangeType type = change.getType();
        if (type == PlotConfigurationChangeEvent.PlotConfigurationChangeType.RANGE_AXIS_CONFIG_CHANGED && (rangeAxisConfigChange = change.getRangeAxisConfigChange()).getType() == RangeAxisConfigChangeEvent.RangeAxisConfigChangeType.VALUE_SOURCE_CHANGED) {
            ValueSourceChangeEvent valueSourceChange = rangeAxisConfigChange.getValueSourceChange();
            if (valueSourceChange.getType() == ValueSourceChangeEvent.ValueSourceChangeType.SERIES_FORMAT_CHANGED) {
                this.adaptGUI();
            }
            if (valueSourceChange.getType() == ValueSourceChangeEvent.ValueSourceChangeType.USES_GROUPING) {
                this.adaptGUI();
            }
        }
        if (type == PlotConfigurationChangeEvent.PlotConfigurationChangeType.DIMENSION_CONFIG_ADDED && change.getDimension() == DimensionConfig.PlotDimension.COLOR) {
            this.adaptGUI();
        }
        if (type == PlotConfigurationChangeEvent.PlotConfigurationChangeType.DIMENSION_CONFIG_REMOVED && change.getDimension() == DimensionConfig.PlotDimension.COLOR) {
            this.adaptGUI();
        }
        if (type == PlotConfigurationChangeEvent.PlotConfigurationChangeType.META_CHANGE) {
            this.processPlotConfigurationMetaChange(change);
        }
        return true;
    }
}

