/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.StaticDebug;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.AxisConfigurationContainer;
import com.owc.gui.charting.gui.ChartTitleConfigurationContainer;
import com.owc.gui.charting.gui.ColorSchemeDialog;
import com.owc.gui.charting.gui.LegendConfigurationPanel;
import com.owc.gui.charting.gui.cellrenderer.ColorSchemeComboBoxRenderer;
import com.owc.gui.charting.gui.cellrenderer.EnumComboBoxCellRenderer;
import com.owc.gui.charting.gui.popup.PopupAction;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.templates.style.ColorScheme;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jfree.chart.plot.PlotOrientation;

public class GlobalConfigurationPanel
extends AbstractConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private JTextField titleTextField;
    private JComboBox<PlotOrientation> plotOrientationComboBox;
    private final int fontSize = 12;
    private JToggleButton titleConfigButton;
    private AxisConfigurationContainer axisConfigurationContainer;
    private LegendConfigurationPanel legendConfigContainer;
    private JButton plotBackgroundColorChooserButton;
    private JButton frameBackgroundColorChooserButton;
    private JLabel plotBackGroundColorLabel;
    private JLabel frameBackGroundColorLabel;
    private DefaultComboBoxModel<ColorScheme> colorsSchemesComboBoxModel;
    private JComboBox<ColorScheme> colorSchemesComboBox;
    private ChartTitleConfigurationContainer chartTitleConfigurationContainer;

    public GlobalConfigurationPanel(PlotInstance plotInstance) {
        super(plotInstance);
        this.axisConfigurationContainer = new AxisConfigurationContainer(plotInstance);
        this.addPlotInstanceChangeListener(this.axisConfigurationContainer);
        this.legendConfigContainer = new LegendConfigurationPanel(plotInstance);
        this.addPlotInstanceChangeListener(this.legendConfigContainer);
        this.chartTitleConfigurationContainer = new ChartTitleConfigurationContainer(this.getCurrentPlotInstance());
        this.addPlotInstanceChangeListener(this.chartTitleConfigurationContainer);
        this.createComponents();
        this.registerAsPlotConfigurationListener();
        this.adaptGUI();
    }

    private void createComponents() {
        ResourceLabel titleLabel = new ResourceLabel("plotter.configuration_dialog.chart_title", new Object[0]);
        String title = this.getPlotConfiguration().getTitleText();
        if (title == null) {
            title = "";
        }
        this.titleTextField = new JTextField(title);
        titleLabel.setLabelFor(this.titleTextField);
        this.titleTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String newTitle = GlobalConfigurationPanel.this.titleTextField.getText();
                String titleText = GlobalConfigurationPanel.this.getCurrentPlotInstance().getMasterPlotConfiguration().getTitleText();
                if (titleText != null) {
                    if (!titleText.equals(newTitle) || titleText == null && newTitle.length() > 0) {
                        if (newTitle.length() > 0) {
                            GlobalConfigurationPanel.this.getPlotConfiguration().setTitleText(newTitle);
                        } else {
                            GlobalConfigurationPanel.this.getPlotConfiguration().setTitleText(null);
                        }
                    }
                } else if (newTitle.length() > 0) {
                    GlobalConfigurationPanel.this.getPlotConfiguration().setTitleText(newTitle);
                } else {
                    GlobalConfigurationPanel.this.getPlotConfiguration().setTitleText(null);
                }
                if (newTitle.equals("Iris") && SwingTools.isControlOrMetaDown((KeyEvent)e) && e.getKeyCode() == 68) {
                    GlobalConfigurationPanel.this.startAnimation();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.titleTextField.setPreferredSize(new Dimension(115, 23));
        this.titleConfigButton = new JToggleButton((Action)((Object)new PopupAction(true, "plotter.configuration_dialog.open_popup", (Component)this.chartTitleConfigurationContainer, PopupAction.PopupPosition.HORIZONTAL, new Object[0])));
        this.addThreeComponentRow(this, (JLabel)titleLabel, this.titleTextField, this.titleConfigButton);
        ResourceLabel plotOrientationLabel = new ResourceLabel("plotter.configuration_dialog.global_config_panel.plot_orientation", new Object[0]);
        PlotOrientation[] orientations = new PlotOrientation[]{PlotOrientation.HORIZONTAL, PlotOrientation.VERTICAL};
        this.plotOrientationComboBox = new JComboBox<PlotOrientation>(orientations);
        plotOrientationLabel.setLabelFor(this.plotOrientationComboBox);
        this.plotOrientationComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter"));
        this.plotOrientationComboBox.setSelectedIndex(0);
        this.plotOrientationComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GlobalConfigurationPanel.this.getPlotConfiguration().setOrientation((PlotOrientation)GlobalConfigurationPanel.this.plotOrientationComboBox.getSelectedItem());
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addTwoComponentRow(this, (JComponent)plotOrientationLabel, this.plotOrientationComboBox);
        ResourceLabel legendStyleConfigureLabel = new ResourceLabel("plotter.configuration_dialog.global_config_panel.legend_style", new Object[0]);
        JToggleButton legendStyleConfigButton = new JToggleButton((Action)((Object)new PopupAction(true, "plotter.configuration_dialog.open_popup", (Component)this.legendConfigContainer, PopupAction.PopupPosition.HORIZONTAL, new Object[0])));
        legendStyleConfigureLabel.setLabelFor(legendStyleConfigButton);
        this.addTwoComponentRow(this, (JComponent)legendStyleConfigureLabel, legendStyleConfigButton);
        ResourceLabel axisStyleConfigureLabel = new ResourceLabel("plotter.configuration_dialog.global_config_panel.axis_style", new Object[0]);
        JToggleButton axisStyleConfigureButton = new JToggleButton((Action)((Object)new PopupAction(true, "plotter.configuration_dialog.open_popup", (Component)this.axisConfigurationContainer, PopupAction.PopupPosition.HORIZONTAL, new Object[0])));
        axisStyleConfigureLabel.setLabelFor(axisStyleConfigureButton);
        this.addTwoComponentRow(this, (JComponent)axisStyleConfigureLabel, axisStyleConfigureButton);
        ResourceLabel colorConfigureLabel = new ResourceLabel("plotter.configuration_dialog.global_config_panel.color_scheme", new Object[0]);
        this.colorsSchemesComboBoxModel = new DefaultComboBoxModel();
        this.colorSchemesComboBox = new JComboBox<ColorScheme>(this.colorsSchemesComboBoxModel);
        colorConfigureLabel.setLabelFor(this.colorSchemesComboBox);
        this.colorSchemesComboBox.setRenderer(new ColorSchemeComboBoxRenderer());
        this.colorSchemesComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ColorScheme colorScheme = (ColorScheme)GlobalConfigurationPanel.this.colorSchemesComboBox.getSelectedItem();
                if (colorScheme != null) {
                    GlobalConfigurationPanel.this.getPlotConfiguration().setActiveColorScheme(colorScheme.getName());
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        JButton colorConfigButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.open_color_scheme_dialog", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                GlobalConfigurationPanel.this.createColorSchemeDialog();
            }
        });
        this.addThreeComponentRow(this, (JLabel)colorConfigureLabel, this.colorSchemesComboBox, colorConfigButton);
        this.plotBackGroundColorLabel = new ResourceLabel("plotter.configuration_dialog.global_config_panel.select_plot_background_color", new Object[0]);
        this.plotBackgroundColorChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.select_plot_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                GlobalConfigurationPanel.this.createPlotBackgroundColorDialog();
            }
        });
        this.plotBackGroundColorLabel.setLabelFor(this.plotBackgroundColorChooserButton);
        this.addTwoComponentRow(this, this.plotBackGroundColorLabel, this.plotBackgroundColorChooserButton);
        this.frameBackGroundColorLabel = new ResourceLabel("plotter.configuration_dialog.global_config_panel.select_frame_background_color", new Object[0]);
        this.frameBackgroundColorChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.select_frame_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                GlobalConfigurationPanel.this.createFrameBackgroundColorDialog();
            }
        });
        this.frameBackGroundColorLabel.setLabelFor(this.frameBackgroundColorChooserButton);
        this.addTwoComponentRow(this, this.frameBackGroundColorLabel, this.frameBackgroundColorChooserButton);
        JPanel spacerPanel = new JPanel();
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        this.add((Component)spacerPanel, itemConstraint);
    }

    private void startAnimation() {
        StaticDebug.debug("Starting animation");
    }

    @Override
    protected void adaptGUI() {
        Color chartBackgroundColor;
        Font titleFont;
        String title = this.getPlotConfiguration().getTitleText();
        if (title == null) {
            title = "";
        }
        if (!title.equals(this.titleTextField.getText())) {
            this.titleTextField.setText(title);
        }
        if ((titleFont = this.getPlotConfiguration().getTitleFont()) != null) {
            this.titleTextField.setFont(new Font(titleFont.getFamily(), titleFont.getStyle(), 12));
        }
        this.plotOrientationChanged(this.getPlotConfiguration().getOrientation());
        Color backgroundColor = this.getPlotConfiguration().getPlotBackgroundColor();
        if (backgroundColor == null) {
            backgroundColor = Color.white;
        }
        if ((chartBackgroundColor = this.getPlotConfiguration().getChartBackgroundColor()) == null) {
            chartBackgroundColor = Color.white;
        }
        Map<String, ColorScheme> colorSchemes = this.getPlotConfiguration().getColorSchemes();
        this.colorsSchemesComboBoxModel.removeAllElements();
        for (ColorScheme scheme : colorSchemes.values()) {
            this.colorsSchemesComboBoxModel.addElement(scheme);
        }
        this.colorsSchemesComboBoxModel.setSelectedItem(this.getPlotConfiguration().getActiveColorScheme());
    }

    private void plotOrientationChanged(PlotOrientation orientation) {
        this.plotOrientationComboBox.setSelectedItem(orientation);
    }

    private void createPlotBackgroundColorDialog() {
        Color newBackgroundColor;
        Color oldColor = this.getPlotConfiguration().getPlotBackgroundColor();
        if (oldColor == null) {
            oldColor = Color.white;
        }
        if ((newBackgroundColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.global_config_panel.plot_background_color_title.label", (Object[])new Object[0]), oldColor)) != null && !newBackgroundColor.equals(oldColor)) {
            this.getPlotConfiguration().setPlotBackgroundColor(newBackgroundColor);
        }
    }

    private void createFrameBackgroundColorDialog() {
        Color newBackgroundColor;
        Color oldColor = this.getPlotConfiguration().getChartBackgroundColor();
        if (oldColor == null) {
            oldColor = Color.white;
        }
        if ((newBackgroundColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.global_config_panel.chart_background_color_title.label", (Object[])new Object[0]), oldColor)) != null && !newBackgroundColor.equals(oldColor)) {
            this.getPlotConfiguration().setFrameBackgroundColor(newBackgroundColor);
        }
    }

    private void createColorSchemeDialog() {
        ColorSchemeDialog colorSchemeDialog = new ColorSchemeDialog(this, "plotter.configuration_dialog.color_scheme_dialog", this.getPlotConfiguration(), new Object[0]);
        colorSchemeDialog.setVisible(true);
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        PlotConfigurationChangeEvent.PlotConfigurationChangeType type = change.getType();
        switch (type) {
            case CHART_TITLE: {
                this.adaptGUI();
                break;
            }
            case PLOT_ORIENTATION: {
                this.adaptGUI();
                break;
            }
            case PLOT_BACKGROUND_COLOR: {
                this.adaptGUI();
                break;
            }
            case FRAME_BACKGROUND_COLOR: {
                this.adaptGUI();
                break;
            }
            case COLOR_SCHEME: {
                this.adaptGUI();
                break;
            }
            case META_CHANGE: {
                this.adaptGUI();
                break;
            }
        }
        return true;
    }
}

