/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.LegendConfiguration;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.FontDialog;
import com.owc.gui.charting.gui.cellrenderer.EnumComboBoxCellRenderer;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class LegendConfigurationPanel
extends AbstractConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final int fontSize = 12;
    private JComboBox<LegendConfiguration.LegendPosition> legendPositionComboBox;
    private ResourceLabel legendFontLabel;
    private ResourceLabel showDimensionTypeLabel;
    private JCheckBox showDimensionTypeCheckBox;
    private JButton legendFontChooserButton;
    private ResourceLabel legendBackGroundColorLabel;
    private JButton legendBackgroundColorChooserButton;
    private ResourceLabel legendFrameColorLabel;
    private JButton legendFrameColorChooserButton;
    private ResourceLabel showLegendFrameLabel;
    private JCheckBox showLegendFrameCheckBox;
    private ResourceLabel legendFontColorLabel;
    private JButton legendFontColorChooserButton;

    public LegendConfigurationPanel(PlotInstance plotInstance) {
        super(plotInstance);
        this.createComponents();
        this.registerAsPlotConfigurationListener();
        this.adaptGUI();
    }

    private void createComponents() {
        ResourceLabel legendPositionLabel = new ResourceLabel("plotter.configuration_dialog.legend_position", new Object[0]);
        this.legendPositionComboBox = new JComboBox<LegendConfiguration.LegendPosition>(LegendConfiguration.LegendPosition.values());
        legendPositionLabel.setLabelFor(this.legendPositionComboBox);
        this.legendPositionComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.legendposition"));
        this.legendPositionComboBox.setSelectedIndex(0);
        this.legendPositionComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                LegendConfigurationPanel.this.getPlotConfiguration().getLegendConfiguration().setLegendPosition((LegendConfiguration.LegendPosition)((Object)LegendConfigurationPanel.this.legendPositionComboBox.getSelectedItem()));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addTwoComponentRow(this, (JComponent)legendPositionLabel, this.legendPositionComboBox);
        this.legendFontLabel = new ResourceLabel("plotter.configuration_dialog.legend_font", new Object[0]);
        this.legendFontChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.legend_font", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                LegendConfigurationPanel.this.createLegendFontDialog();
            }
        });
        this.legendFontLabel.setLabelFor((Component)this.legendFontChooserButton);
        this.addTwoComponentRow(this, (JComponent)this.legendFontLabel, this.legendFontChooserButton);
        this.legendFontColorLabel = new ResourceLabel("plotter.configuration_dialog.legend_color_dialog.select_legend_font_color", new Object[0]);
        this.legendFontColorChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.select_legend_font_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                LegendConfigurationPanel.this.createLegendFontColorDialog();
            }
        });
        this.legendFontColorLabel.setLabelFor((Component)this.legendFontColorChooserButton);
        this.addTwoComponentRow(this, (JComponent)this.legendFontColorLabel, this.legendFontColorChooserButton);
        this.showDimensionTypeLabel = new ResourceLabel("plotter.configuration_dialog.show_dimension_type", new Object[0]);
        this.showDimensionTypeCheckBox = new JCheckBox();
        this.showDimensionTypeLabel.setLabelFor((Component)this.showDimensionTypeCheckBox);
        this.showDimensionTypeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegendConfigurationPanel.this.getPlotConfiguration().getLegendConfiguration().setShowDimensionType(LegendConfigurationPanel.this.showDimensionTypeCheckBox.isSelected());
            }
        });
        this.addTwoComponentRow(this, (JComponent)this.showDimensionTypeLabel, this.showDimensionTypeCheckBox);
        this.legendBackGroundColorLabel = new ResourceLabel("plotter.configuration_dialog.legend_color_dialog.select_legend_background_color", new Object[0]);
        this.legendBackgroundColorChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.select_legend_background_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                LegendConfigurationPanel.this.createLegendBackgroundColorDialog();
            }
        });
        this.legendBackGroundColorLabel.setLabelFor((Component)this.legendBackgroundColorChooserButton);
        this.addTwoComponentRow(this, (JComponent)this.legendBackGroundColorLabel, this.legendBackgroundColorChooserButton);
        this.showLegendFrameLabel = new ResourceLabel("plotter.configuration_dialog.show_legend_frame", new Object[0]);
        this.showLegendFrameCheckBox = new JCheckBox();
        this.showLegendFrameLabel.setLabelFor((Component)this.showLegendFrameCheckBox);
        this.showLegendFrameCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegendConfigurationPanel.this.getPlotConfiguration().getLegendConfiguration().setShowLegendFrame(LegendConfigurationPanel.this.showLegendFrameCheckBox.isSelected());
            }
        });
        this.addTwoComponentRow(this, (JComponent)this.showLegendFrameLabel, this.showLegendFrameCheckBox);
        this.legendFrameColorLabel = new ResourceLabel("plotter.configuration_dialog.legend_color_dialog.select_legend_frame_color", new Object[0]);
        this.legendFrameColorChooserButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.select_legend_frame_color", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                LegendConfigurationPanel.this.createLegendFrameColorDialog();
            }
        });
        this.legendFrameColorLabel.setLabelFor((Component)this.legendFrameColorChooserButton);
        this.addTwoComponentRow(this, (JComponent)this.legendFrameColorLabel, this.legendFrameColorChooserButton);
    }

    private void createLegendBackgroundColorDialog() {
        Color newBackgroundColor;
        Color oldColor = this.getPlotConfiguration().getLegendConfiguration().getLegendBackgroundColor();
        if (oldColor == null) {
            oldColor = LegendConfiguration.DEFAULT_LEGEND_BACKGROUND_COLOR;
        }
        if ((newBackgroundColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.global_config_panel.legend_background_color_title.label", (Object[])new Object[0]), oldColor)) != null && !newBackgroundColor.equals(oldColor)) {
            this.getPlotConfiguration().getLegendConfiguration().setLegendBackgroundColor(newBackgroundColor);
        }
    }

    private void createLegendFontColorDialog() {
        Color newBackgroundColor;
        Color oldColor = this.getPlotConfiguration().getLegendConfiguration().getLegendBackgroundColor();
        if (oldColor == null) {
            oldColor = LegendConfiguration.DEFAULT_LEGEND_FONT_COLOR;
        }
        if ((newBackgroundColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.global_config_panel.legend_font_color_title.label", (Object[])new Object[0]), oldColor)) != null && !newBackgroundColor.equals(oldColor)) {
            this.getPlotConfiguration().getLegendConfiguration().setLegendFontColor(newBackgroundColor);
        }
    }

    private void createLegendFrameColorDialog() {
        Color newBackgroundColor;
        Color oldColor = this.getPlotConfiguration().getLegendConfiguration().getLegendFrameColor();
        if (oldColor == null) {
            oldColor = LegendConfiguration.DEFAULT_LEGEND_FRAME_COLOR;
        }
        if ((newBackgroundColor = JColorChooser.showDialog(this, I18N.getGUILabel((String)"plotter.configuration_dialog.global_config_panel.legend_frame_color_title.label", (Object[])new Object[0]), oldColor)) != null && !newBackgroundColor.equals(oldColor)) {
            this.getPlotConfiguration().getLegendConfiguration().setLegendFrameColor(newBackgroundColor);
        }
    }

    @Override
    protected void adaptGUI() {
        Font legendFont = this.getPlotConfiguration().getLegendConfiguration().getLegendFont();
        if (legendFont != null) {
            this.legendFontLabel.setFont(new Font(legendFont.getFamily(), legendFont.getStyle(), 12));
        }
        this.legendPositionComboBox.setSelectedItem((Object)this.getPlotConfiguration().getLegendConfiguration().getLegendPosition());
        this.showDimensionTypeCheckBox.setSelected(this.getPlotConfiguration().getLegendConfiguration().isShowDimensionType());
        this.showLegendFrameCheckBox.setSelected(this.getPlotConfiguration().getLegendConfiguration().isShowLegendFrame());
    }

    private void createLegendFontDialog() {
        Font legendFont = this.getPlotConfiguration().getLegendConfiguration().getLegendFont();
        if (legendFont == null) {
            legendFont = LegendConfiguration.DEFAULT_LEGEND_FONT;
        }
        FontDialog fontDialog = new FontDialog(this, legendFont, "plotter.configuration_dialog.global_config_panel.select_legend_font");
        fontDialog.setVisible(true);
        fontDialog.requestFocus();
        if (fontDialog.getReturnStatus() == 1) {
            this.getPlotConfiguration().getLegendConfiguration().setLegendFont(fontDialog.getFont());
        }
        fontDialog.dispose();
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        PlotConfigurationChangeEvent.PlotConfigurationChangeType type = change.getType();
        switch (type) {
            case LEGEND_CHANGED: {
                this.adaptGUI();
                break;
            }
            case META_CHANGE: {
                this.adaptGUI();
                break;
            }
        }
        return true;
    }
}

