/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.data.RangeAxisData;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.owc.gui.charting.gui.treenodes.RangeAxisConfigTreeNode;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.RangeAxisConfigChangeEvent;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class RangeAxisConfigPanel
extends AbstractConfigurationPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private RangeAxisConfig selectedRangeAxisConfig = null;
    private JTextField rangeAxisLabelTextfield;
    private JToggleButton automateLabelCheckBox;
    private JLabel rangeAxisLabelLabel;
    private JCheckBox logarithmicCheckBox;
    private JLabel logarithmicLabel;
    private JLabel lowerBoundLabel;
    private JCheckBox lowerBoundCheckBox;
    private JSpinner lowerBoundSpinner;
    private JLabel upperBoundLabel;
    private JCheckBox upperBoundCheckBox;
    private JSpinner upperBoundSpinner;

    public RangeAxisConfigPanel(JTree plotConfigTree, PlotInstance plotInstance) {
        super(plotInstance);
        this.createComponents();
        this.registerAsPlotConfigurationListener();
        plotConfigTree.addTreeSelectionListener(this);
    }

    private void createComponents() {
        this.rangeAxisLabelLabel = new JLabel(I18N.getGUILabel((String)"plotter.configuration_dialog.dimension_axis_title.label", (Object[])new Object[0]));
        this.rangeAxisLabelTextfield = new JTextField();
        this.rangeAxisLabelLabel.setLabelFor(this.rangeAxisLabelTextfield);
        this.rangeAxisLabelTextfield.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (RangeAxisConfigPanel.this.selectedRangeAxisConfig != null) {
                    String newTitle = RangeAxisConfigPanel.this.rangeAxisLabelTextfield.getText();
                    String titleText = RangeAxisConfigPanel.this.selectedRangeAxisConfig.getLabel();
                    if (titleText != null && !titleText.equals(newTitle) || titleText == null && newTitle.length() > 0) {
                        if (newTitle.length() > 0) {
                            RangeAxisConfigPanel.this.selectedRangeAxisConfig.setLabel(newTitle);
                        } else {
                            RangeAxisConfigPanel.this.selectedRangeAxisConfig.setLabel(null);
                        }
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.rangeAxisLabelTextfield.setPreferredSize(new Dimension(100, 22));
        this.automateLabelCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.automatic_axis_label.label", (Object[])new Object[0]));
        this.automateLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RangeAxisConfigPanel.this.selectedRangeAxisConfig != null) {
                    RangeAxisConfigPanel.this.selectedRangeAxisConfig.setAutoNaming(RangeAxisConfigPanel.this.automateLabelCheckBox.isSelected());
                }
            }
        });
        this.addThreeComponentRow(this, this.rangeAxisLabelLabel, this.rangeAxisLabelTextfield, this.automateLabelCheckBox);
        this.logarithmicLabel = new ResourceLabel("plotter.configuration_dialog.logarithmic", new Object[0]);
        this.logarithmicCheckBox = new JCheckBox();
        this.logarithmicLabel.setLabelFor(this.logarithmicCheckBox);
        this.logarithmicCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RangeAxisConfigPanel.this.selectedRangeAxisConfig != null) {
                    RangeAxisConfigPanel.this.selectedRangeAxisConfig.setLogarithmicAxis(RangeAxisConfigPanel.this.logarithmicCheckBox.isSelected());
                }
            }
        });
        this.addTwoComponentRow(this, this.logarithmicLabel, this.logarithmicCheckBox);
        this.upperBoundLabel = new ResourceLabel("plotter.configuration_dialog.upper_bound", new Object[0]);
        this.upperBoundSpinner = new JSpinner(new SpinnerNumberModel((Number)1.0, null, null, (Number)0.1));
        this.upperBoundLabel.setLabelFor(this.upperBoundSpinner);
        this.upperBoundSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Double newUpperBound;
                RangeAxisData selectedRangeAxisData;
                Double oldUpperBound;
                if (RangeAxisConfigPanel.this.selectedRangeAxisConfig != null && !Objects.equals(oldUpperBound = Double.valueOf((selectedRangeAxisData = RangeAxisConfigPanel.this.getCurrentPlotInstance().getPlotData().getRangeAxisData(RangeAxisConfigPanel.this.selectedRangeAxisConfig)).getUpperViewBound()), newUpperBound = (Double)RangeAxisConfigPanel.this.upperBoundSpinner.getValue())) {
                    RangeAxisConfigPanel.this.selectedRangeAxisConfig.setUpperViewBound(newUpperBound);
                }
            }
        });
        this.upperBoundCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.use_boundary.label", (Object[])new Object[0]));
        this.upperBoundCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RangeAxisConfigPanel.this.selectedRangeAxisConfig != null) {
                    RangeAxisConfigPanel.this.selectedRangeAxisConfig.setUseUserDefinedUpperViewBound(!RangeAxisConfigPanel.this.upperBoundCheckBox.isSelected());
                }
            }
        });
        this.addThreeComponentRow(this, this.upperBoundLabel, this.upperBoundSpinner, this.upperBoundCheckBox);
        this.lowerBoundLabel = new ResourceLabel("plotter.configuration_dialog.lower_bound", new Object[0]);
        this.lowerBoundSpinner = new JSpinner(new SpinnerNumberModel((Number)0.0, null, null, (Number)0.1));
        this.lowerBoundLabel.setLabelFor(this.lowerBoundSpinner);
        this.lowerBoundSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Double newLowerBound;
                RangeAxisData selectedRangeAxisData;
                Double oldLowerBound;
                if (RangeAxisConfigPanel.this.selectedRangeAxisConfig != null && !Objects.equals(oldLowerBound = Double.valueOf((selectedRangeAxisData = RangeAxisConfigPanel.this.getCurrentPlotInstance().getPlotData().getRangeAxisData(RangeAxisConfigPanel.this.selectedRangeAxisConfig)).getLowerViewBound()), newLowerBound = (Double)RangeAxisConfigPanel.this.lowerBoundSpinner.getValue())) {
                    RangeAxisConfigPanel.this.selectedRangeAxisConfig.setLowerViewBound(newLowerBound);
                }
            }
        });
        this.lowerBoundCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.use_boundary.label", (Object[])new Object[0]));
        this.lowerBoundCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RangeAxisConfigPanel.this.selectedRangeAxisConfig != null) {
                    RangeAxisConfigPanel.this.selectedRangeAxisConfig.setUseUserDefinedLowerViewBound(!RangeAxisConfigPanel.this.lowerBoundCheckBox.isSelected());
                }
            }
        });
        this.addThreeComponentRow(this, this.lowerBoundLabel, this.lowerBoundSpinner, this.lowerBoundCheckBox);
        JPanel spacerPanel = new JPanel();
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        this.add((Component)spacerPanel, itemConstraint);
    }

    private void rangeAxisLabelChanged(String label) {
        String oldText = this.rangeAxisLabelTextfield.getText();
        if (!oldText.equals(label)) {
            if (label != null) {
                this.rangeAxisLabelTextfield.setText(label);
            } else {
                this.rangeAxisLabelTextfield.setText("");
            }
        }
    }

    private void automateNamingChanged(boolean automateLabel) {
        this.automateLabelCheckBox.setSelected(automateLabel);
        this.rangeAxisLabelTextfield.setEnabled(!automateLabel);
    }

    private void upperBoundChanged(Double upperBound) {
        this.upperBoundSpinner.setValue(upperBound);
    }

    private void lowerBoundChanged(Double lowerBound) {
        this.lowerBoundSpinner.setValue(lowerBound);
    }

    private void useLowerBoundChanged(boolean useLowerBound, boolean visible) {
        this.lowerBoundCheckBox.setSelected(!useLowerBound);
        this.lowerBoundSpinner.setVisible(visible);
        this.lowerBoundSpinner.setEnabled(useLowerBound);
        this.lowerBoundCheckBox.setVisible(visible);
        this.lowerBoundLabel.setVisible(visible);
    }

    private void useUpperBoundChanged(boolean useUpperBound, boolean visible) {
        this.upperBoundCheckBox.setSelected(!useUpperBound);
        this.upperBoundSpinner.setVisible(visible);
        this.upperBoundSpinner.setEnabled(useUpperBound);
        this.upperBoundCheckBox.setVisible(visible);
        this.upperBoundLabel.setVisible(visible);
    }

    @Override
    protected void adaptGUI() {
        if (this.selectedRangeAxisConfig != null) {
            boolean enable = this.selectedRangeAxisConfig.getValueType() != DataTableColumn.ValueType.NOMINAL;
            this.logarithmicLabel.setVisible(enable);
            this.logarithmicCheckBox.setVisible(enable);
            this.logarithmicCheckBox.setSelected(this.selectedRangeAxisConfig.isLogarithmicAxis());
            this.rangeAxisLabelChanged(this.selectedRangeAxisConfig.getLabel());
            this.automateNamingChanged(this.selectedRangeAxisConfig.isAutoNaming());
            this.upperBoundChanged(this.selectedRangeAxisConfig.getUserDefinedRange().getUpperBound());
            this.lowerBoundChanged(this.selectedRangeAxisConfig.getUserDefinedRange().getLowerBound());
            this.useLowerBoundChanged(this.selectedRangeAxisConfig.isUsingUserDefinedLowerViewBound(), enable);
            this.useUpperBoundChanged(this.selectedRangeAxisConfig.isUsingUserDefinedUpperViewBound(), enable);
            boolean visibleRangSelection = this.selectedRangeAxisConfig.getValueType() != DataTableColumn.ValueType.DATE_TIME;
            this.lowerBoundCheckBox.setVisible(visibleRangSelection);
            this.lowerBoundLabel.setVisible(visibleRangSelection);
            this.lowerBoundSpinner.setVisible(visibleRangSelection);
            this.upperBoundCheckBox.setVisible(visibleRangSelection);
            this.upperBoundLabel.setVisible(visibleRangSelection);
            this.upperBoundSpinner.setVisible(visibleRangSelection);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
        if (newLeadSelectionPath == null) {
            this.selectedRangeAxisConfig = null;
            return;
        }
        Object lastPathComponent = newLeadSelectionPath.getLastPathComponent();
        if (lastPathComponent instanceof RangeAxisConfigTreeNode) {
            RangeAxisConfig selectedConfig;
            this.selectedRangeAxisConfig = selectedConfig = ((RangeAxisConfigTreeNode)lastPathComponent).getUserObject();
            this.adaptGUI();
        } else {
            this.selectedRangeAxisConfig = null;
        }
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        RangeAxisConfigChangeEvent rangeAxisConfigChange;
        RangeAxisConfig source;
        PlotConfigurationChangeEvent.PlotConfigurationChangeType plotConfigChangeType = change.getType();
        if (plotConfigChangeType == PlotConfigurationChangeEvent.PlotConfigurationChangeType.RANGE_AXIS_CONFIG_CHANGED && this.selectedRangeAxisConfig == (source = (rangeAxisConfigChange = change.getRangeAxisConfigChange()).getSource())) {
            this.adaptGUI();
        }
        if (plotConfigChangeType == PlotConfigurationChangeEvent.PlotConfigurationChangeType.META_CHANGE) {
            this.processPlotConfigurationMetaChange(change);
        }
        return true;
    }
}

