/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.PlotConfigurationError;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.AbstractTreeSelectionDependentPanel;
import com.owc.gui.charting.gui.AttributeDropTextField;
import com.owc.gui.charting.gui.PlotConfigurationTreeModel;
import com.owc.gui.charting.gui.SeriesFormatConfigurationPanel;
import com.owc.gui.charting.gui.WindowingConfigurationContainer;
import com.owc.gui.charting.gui.cellrenderer.EnumComboBoxCellRenderer;
import com.owc.gui.charting.gui.dnd.DataTableColumnListTransferHandler;
import com.owc.gui.charting.gui.popup.PopupAction;
import com.owc.gui.charting.listener.events.PlotConfigurationChangeEvent;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreePath;

public class ValueSourceConfigurationPanel
extends AbstractTreeSelectionDependentPanel {
    private static final long serialVersionUID = 1L;
    private JLabel seriesTypeLabel;
    private JComboBox<SeriesFormat.VisualizationType> seriesTypeComboBox;
    private ResourceLabel formatLabel;
    private JToggleButton formatConfigureButton;
    private JLabel aggregationLabel;
    private JComboBox<Object> aggregationComboBox;
    private JLabel windowingLabel;
    private JToggleButton windowingButton;
    private JLabel utilityIndicatorLabel;
    private JComboBox<SeriesFormat.IndicatorType> utilityIndicatorComboBox;
    private JCheckBox relativeIndicatorCheckBox;
    private JLabel firstUtilityAttributeLabel;
    private JComboBox<AbstractAggregationFunction.AggregationFunctionType> firstUtilityAggregationComboBox;
    private JTextField firstUtilityTextField;
    private JLabel secondUtilityAttributeLabel;
    private JTextField secondUtilityTextField;
    private JComboBox<AbstractAggregationFunction.AggregationFunctionType> secondUtilityAggregationComboBox;
    private JButton firstUtilityRemoveAttributeButton;
    private JButton secondUtilityRemoveAttributeButton;
    private SeriesFormatConfigurationPanel seriesTypeConfigurationPanel;
    private WindowingConfigurationContainer windowConfigurationPanel;
    private DefaultComboBoxModel<Object> aggregationComboBoxModel;
    private ExtendedHTMLJEditorPane configureGroupingButton;
    private final JTree plotConfigurationTree;
    private JLabel valueSourceLabelLabel;
    private JTextField valueSourceLabelTextfield;
    private JCheckBox automateLabelCheckBox;

    public ValueSourceConfigurationPanel(boolean smallIcons, JTree plotConfigurationTree, DataTableColumnListTransferHandler th, PlotInstance plotInstance) {
        super(plotConfigurationTree, plotInstance);
        this.plotConfigurationTree = plotConfigurationTree;
        this.seriesTypeConfigurationPanel = new SeriesFormatConfigurationPanel(smallIcons, plotConfigurationTree, plotInstance);
        this.addPlotInstanceChangeListener(this.seriesTypeConfigurationPanel);
        this.windowConfigurationPanel = new WindowingConfigurationContainer(plotConfigurationTree, plotInstance);
        this.addPlotInstanceChangeListener(this.windowConfigurationPanel);
        this.createComponents(plotConfigurationTree, th);
        this.registerAsPlotConfigurationListener();
        this.adaptGUI();
    }

    private void createComponents(JTree plotConfigTree, DataTableColumnListTransferHandler th) {
        this.valueSourceLabelLabel = new JLabel(I18N.getGUILabel((String)"plotter.configuration_dialog.dimension_axis_title.label", (Object[])new Object[0]));
        AbstractAggregationFunction.AggregationFunctionType[] textFieldAndCheckBoxPanel = new JPanel(new GridBagLayout());
        this.valueSourceLabelTextfield = new JTextField();
        this.valueSourceLabelLabel.setLabelFor(this.valueSourceLabelTextfield);
        this.valueSourceLabelTextfield.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ValueSource selectedValueSource = ValueSourceConfigurationPanel.this.getSelectedValueSource();
                if (selectedValueSource != null) {
                    String newTitle = ValueSourceConfigurationPanel.this.valueSourceLabelTextfield.getText();
                    String titleText = selectedValueSource.getLabel();
                    if (titleText != null && !titleText.equals(newTitle) || titleText == null && newTitle.length() > 0) {
                        if (newTitle.length() > 0) {
                            selectedValueSource.setLabel(newTitle);
                        } else {
                            selectedValueSource.setLabel(null);
                        }
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.valueSourceLabelTextfield.setPreferredSize(new Dimension(100, 22));
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 1.0;
        itemConstraint.fill = 2;
        itemConstraint.gridwidth = -1;
        textFieldAndCheckBoxPanel.add((Component)this.valueSourceLabelTextfield, itemConstraint);
        this.automateLabelCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.automatic_axis_label.label", (Object[])new Object[0]));
        this.automateLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueSource selectedValueSource = ValueSourceConfigurationPanel.this.getSelectedValueSource();
                if (selectedValueSource != null) {
                    selectedValueSource.setAutoNaming(ValueSourceConfigurationPanel.this.automateLabelCheckBox.isSelected());
                }
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 0.0;
        itemConstraint.fill = 0;
        itemConstraint.gridwidth = 0;
        textFieldAndCheckBoxPanel.add((Component)this.automateLabelCheckBox, itemConstraint);
        this.addTwoComponentRow(this, this.valueSourceLabelLabel, (JComponent)textFieldAndCheckBoxPanel);
        this.seriesTypeLabel = new JLabel(I18N.getGUILabel((String)"plotter.configuration_dialog.series_type.label", (Object[])new Object[0]));
        this.seriesTypeLabel.setPreferredSize(new Dimension(80, 15));
        this.seriesTypeComboBox = new JComboBox<SeriesFormat.VisualizationType>(SeriesFormat.VisualizationType.values());
        this.seriesTypeLabel.setLabelFor(this.seriesTypeComboBox);
        this.seriesTypeComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.series_type"));
        this.seriesTypeComboBox.setSelectedIndex(0);
        this.seriesTypeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ValueSource selectedValueSource = ValueSourceConfigurationPanel.this.getSelectedValueSource();
                if (selectedValueSource != null) {
                    selectedValueSource.getSeriesFormat().setSeriesType((SeriesFormat.VisualizationType)((Object)ValueSourceConfigurationPanel.this.seriesTypeComboBox.getSelectedItem()));
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addTwoComponentRow(this, this.seriesTypeLabel, this.seriesTypeComboBox);
        this.formatLabel = new ResourceLabel("plotter.configuration_dialog.format_label", new Object[0]);
        this.formatConfigureButton = new JToggleButton((Action)((Object)new PopupAction(true, "plotter.configuration_dialog.format_button", (Component)this.seriesTypeConfigurationPanel, PopupAction.PopupPosition.HORIZONTAL, new Object[0])));
        this.formatLabel.setLabelFor((Component)this.formatConfigureButton);
        this.addTwoComponentRow(this, (JComponent)this.formatLabel, this.formatConfigureButton);
        this.aggregationLabel = new ResourceLabel("plotter.configuration_dialog.aggregate_function", new Object[0]);
        this.aggregationComboBoxModel = new DefaultComboBoxModel();
        this.aggregationComboBoxModel.addElement(I18N.getGUILabel((String)"plotter.aggregation_function.NONE.label", (Object[])new Object[0]));
        for (AbstractAggregationFunction.AggregationFunctionType type : AbstractAggregationFunction.AggregationFunctionType.values()) {
            this.aggregationComboBoxModel.addElement(type);
        }
        JPanel aggragationPanel = new JPanel(new GridBagLayout());
        this.aggregationComboBox = new JComboBox<Object>(this.aggregationComboBoxModel);
        this.aggregationLabel.setLabelFor(this.aggregationComboBox);
        this.aggregationComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ValueSource selectedValueSource = ValueSourceConfigurationPanel.this.getSelectedValueSource();
                if (selectedValueSource != null) {
                    Object selectedItem = ValueSourceConfigurationPanel.this.aggregationComboBox.getSelectedItem();
                    boolean process = ValueSourceConfigurationPanel.this.getPlotConfiguration().isProcessingEvents();
                    ValueSourceConfigurationPanel.this.getPlotConfiguration().setProcessEvents(false);
                    if (selectedItem instanceof AbstractAggregationFunction.AggregationFunctionType) {
                        AbstractAggregationFunction.AggregationFunctionType type = (AbstractAggregationFunction.AggregationFunctionType)selectedItem;
                        selectedValueSource.setAggregationFunction(ValueSource.SeriesUsageType.MAIN_SERIES, type);
                        selectedValueSource.setUseDomainGrouping(true);
                        ValueSourceConfigurationPanel.this.configureGroupingButton.setEnabled(true);
                    } else {
                        selectedValueSource.setUseDomainGrouping(false);
                        selectedValueSource.setAggregationFunction(ValueSource.SeriesUsageType.MAIN_SERIES, null);
                        ValueSourceConfigurationPanel.this.configureGroupingButton.setEnabled(false);
                    }
                    ValueSourceConfigurationPanel.this.getPlotConfiguration().setProcessEvents(process);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.aggregationComboBox.setSelectedItem(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[3]);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 0;
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        itemConstraint.fill = 2;
        itemConstraint.insets = new Insets(0, 0, 5, 5);
        aggragationPanel.add(this.aggregationComboBox, itemConstraint);
        final String content = I18N.getGUILabel((String)"plotter.configuration_dialog.value_source_panel.show_grouping_configuration.label", (Object[])new Object[0]);
        this.configureGroupingButton = new ExtendedHTMLJEditorPane("", this.buildHTMLString("0000FF", content));
        this.configureGroupingButton.setEditable(false);
        this.configureGroupingButton.setFocusable(false);
        this.configureGroupingButton.setBackground(this.getBackground());
        this.configureGroupingButton.setCursor(new Cursor(12));
        this.configureGroupingButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValueSourceConfigurationPanel.this.configureGroupingButton.setText(ValueSourceConfigurationPanel.this.buildHTMLString("0000FF", content));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ValueSourceConfigurationPanel.this.configureGroupingButton.setText(ValueSourceConfigurationPanel.this.buildHTMLString("000099", content));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ValueSourceConfigurationPanel.this.configureGroupingButton.isEnabled()) {
                    PlotConfigurationTreeModel model = (PlotConfigurationTreeModel)ValueSourceConfigurationPanel.this.plotConfigurationTree.getModel();
                    TreePath pathToXDimension = new TreePath(model.getRoot());
                    pathToXDimension = pathToXDimension.pathByAddingChild(model.getChild(model.getRoot(), 0));
                    ValueSourceConfigurationPanel.this.plotConfigurationTree.scrollPathToVisible(pathToXDimension);
                    ValueSourceConfigurationPanel.this.plotConfigurationTree.setSelectionPath(pathToXDimension);
                }
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 1;
        itemConstraint.weightx = 0.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 2;
        itemConstraint.insets = new Insets(0, 5, 5, 0);
        aggragationPanel.add((Component)this.configureGroupingButton, itemConstraint);
        this.addTwoComponentRow(this, this.aggregationLabel, aggragationPanel);
        this.windowingLabel = new ResourceLabel("plotter.configuration_dialog.value_source_panel.windowing", new Object[0]);
        this.windowingButton = new JToggleButton((Action)((Object)new PopupAction(true, "plotter.configuration_dialog.configure_windowing", (Component)this.windowConfigurationPanel, PopupAction.PopupPosition.HORIZONTAL, new Object[0])));
        this.windowingLabel.setLabelFor(this.windowingButton);
        this.addTwoComponentRow(this, this.windowingLabel, this.windowingButton);
        this.utilityIndicatorLabel = new ResourceLabel("plotter.configuration_dialog.utility_indicator", new Object[0]);
        JPanel utilityIndicatorPanel = new JPanel(new GridBagLayout());
        this.utilityIndicatorComboBox = new JComboBox<SeriesFormat.IndicatorType>(SeriesFormat.IndicatorType.values());
        this.utilityIndicatorLabel.setLabelFor(this.utilityIndicatorComboBox);
        this.utilityIndicatorComboBox.setRenderer(new EnumComboBoxCellRenderer("plotter.error_indicator"));
        this.utilityIndicatorComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ValueSource selectedValueSource = ValueSourceConfigurationPanel.this.getSelectedValueSource();
                if (selectedValueSource != null) {
                    selectedValueSource.getSeriesFormat().setUtilityUsage((SeriesFormat.IndicatorType)((Object)ValueSourceConfigurationPanel.this.utilityIndicatorComboBox.getSelectedItem()));
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.utilityIndicatorComboBox.setSelectedItem((Object)SeriesFormat.IndicatorType.NONE);
        this.relativeIndicatorCheckBox = new JCheckBox(I18N.getGUILabel((String)"plotter.configuration_dialog.relative.label", (Object[])new Object[0]));
        this.relativeIndicatorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueSource selectedValueSource = ValueSourceConfigurationPanel.this.getSelectedValueSource();
                if (selectedValueSource != null) {
                    selectedValueSource.setUseRelativeUtilities(ValueSourceConfigurationPanel.this.relativeIndicatorCheckBox.isSelected());
                }
            }
        });
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 0;
        itemConstraint.weightx = 1.0;
        itemConstraint.gridwidth = -1;
        itemConstraint.fill = 2;
        itemConstraint.insets = new Insets(0, 0, 5, 5);
        utilityIndicatorPanel.add(this.utilityIndicatorComboBox, itemConstraint);
        itemConstraint = new GridBagConstraints();
        itemConstraint.gridx = 1;
        itemConstraint.weightx = 0.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.fill = 2;
        itemConstraint.insets = new Insets(0, 5, 5, 0);
        utilityIndicatorPanel.add((Component)this.relativeIndicatorCheckBox, itemConstraint);
        this.addTwoComponentRow(this, this.utilityIndicatorLabel, utilityIndicatorPanel);
        this.firstUtilityAttributeLabel = new ResourceLabel("plotter.configuration_dialog.utility1", new Object[0]);
        JPanel firstErrorAttributePanel = new JPanel(new GridBagLayout());
        GridBagConstraints itemConstraint2 = new GridBagConstraints();
        this.firstUtilityTextField = new AttributeDropTextField(plotConfigTree, th, ValueSource.SeriesUsageType.INDICATOR_1);
        this.firstUtilityTextField.setPreferredSize(new Dimension(100, 18));
        this.firstUtilityAttributeLabel.setLabelFor(this.firstUtilityTextField);
        itemConstraint2.fill = 2;
        itemConstraint2.weightx = 1.0;
        itemConstraint2.insets = new Insets(0, 0, 0, 4);
        firstErrorAttributePanel.add((Component)this.firstUtilityTextField, itemConstraint2);
        this.firstUtilityRemoveAttributeButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.remove_button", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    ValueSourceConfigurationPanel.this.getSelectedValueSource().setDataTableColumn(ValueSource.SeriesUsageType.INDICATOR_1, null);
                }
                catch (ChartConfigurationException e1) {
                    PlotConfigurationError plotConfigurationError = e1.getResponse().getErrors().get(0);
                    SwingTools.showVerySimpleErrorMessage((String)plotConfigurationError.getErrorId(), (Object[])plotConfigurationError.getMessageParameters());
                }
            }
        });
        itemConstraint2.fill = 2;
        itemConstraint2.weightx = 0.0;
        itemConstraint2.gridwidth = 0;
        firstErrorAttributePanel.add((Component)this.firstUtilityRemoveAttributeButton, itemConstraint2);
        this.firstUtilityAggregationComboBox = new JComboBox<AbstractAggregationFunction.AggregationFunctionType>(AbstractAggregationFunction.AggregationFunctionType.values());
        this.firstUtilityAggregationComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ValueSource selectedValueSource = ValueSourceConfigurationPanel.this.getSelectedValueSource();
                if (selectedValueSource != null) {
                    selectedValueSource.setAggregationFunction(ValueSource.SeriesUsageType.INDICATOR_1, (AbstractAggregationFunction.AggregationFunctionType)ValueSourceConfigurationPanel.this.firstUtilityAggregationComboBox.getSelectedItem());
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        itemConstraint2 = new GridBagConstraints();
        itemConstraint2.gridx = 0;
        itemConstraint2.weightx = 0.0;
        itemConstraint2.gridwidth = 1;
        itemConstraint2.insets = this.getStandardInsets();
        itemConstraint2.anchor = 21;
        this.add((Component)this.firstUtilityAttributeLabel, itemConstraint2);
        itemConstraint2 = new GridBagConstraints();
        itemConstraint2.gridx = 1;
        itemConstraint2.weightx = 1.0;
        itemConstraint2.gridwidth = -1;
        itemConstraint2.fill = 2;
        itemConstraint2.insets = this.getStandardInsets();
        this.add((Component)firstErrorAttributePanel, itemConstraint2);
        itemConstraint2 = new GridBagConstraints();
        itemConstraint2.weightx = 0.0;
        itemConstraint2.gridwidth = 0;
        itemConstraint2.anchor = 13;
        itemConstraint2.fill = 0;
        itemConstraint2.insets = this.getStandardInsets();
        this.add(this.firstUtilityAggregationComboBox, itemConstraint2);
        this.secondUtilityAttributeLabel = new ResourceLabel("plotter.configuration_dialog.utility2", new Object[0]);
        JPanel secondErrorAttributePanel = new JPanel(new GridBagLayout());
        itemConstraint2 = new GridBagConstraints();
        this.secondUtilityTextField = new AttributeDropTextField(plotConfigTree, th, ValueSource.SeriesUsageType.INDICATOR_2);
        this.secondUtilityTextField.setPreferredSize(new Dimension(100, 18));
        this.secondUtilityAttributeLabel.setLabelFor(this.secondUtilityTextField);
        itemConstraint2.fill = 2;
        itemConstraint2.weightx = 1.0;
        itemConstraint2.insets = new Insets(0, 0, 0, 4);
        secondErrorAttributePanel.add((Component)this.secondUtilityTextField, itemConstraint2);
        this.secondUtilityRemoveAttributeButton = new JButton((Action)new ResourceAction(true, "plotter.configuration_dialog.remove_button", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    ValueSourceConfigurationPanel.this.getSelectedValueSource().setDataTableColumn(ValueSource.SeriesUsageType.INDICATOR_2, null);
                }
                catch (ChartConfigurationException e1) {
                    PlotConfigurationError plotConfigurationError = e1.getResponse().getErrors().get(0);
                    SwingTools.showVerySimpleErrorMessage((String)plotConfigurationError.getErrorId(), (Object[])plotConfigurationError.getMessageParameters());
                }
            }
        });
        itemConstraint2.fill = 0;
        itemConstraint2.weightx = 0.0;
        itemConstraint2.gridwidth = 0;
        secondErrorAttributePanel.add((Component)this.secondUtilityRemoveAttributeButton, itemConstraint2);
        this.secondUtilityAggregationComboBox = new JComboBox<AbstractAggregationFunction.AggregationFunctionType>(AbstractAggregationFunction.AggregationFunctionType.values());
        this.secondUtilityAggregationComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ValueSource selectedValueSource = ValueSourceConfigurationPanel.this.getSelectedValueSource();
                if (selectedValueSource != null) {
                    selectedValueSource.setAggregationFunction(ValueSource.SeriesUsageType.INDICATOR_2, (AbstractAggregationFunction.AggregationFunctionType)ValueSourceConfigurationPanel.this.secondUtilityAggregationComboBox.getSelectedItem());
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        itemConstraint2 = new GridBagConstraints();
        itemConstraint2.gridx = 0;
        itemConstraint2.weightx = 0.0;
        itemConstraint2.gridwidth = 1;
        itemConstraint2.insets = this.getStandardInsets();
        itemConstraint2.anchor = 21;
        this.add((Component)this.secondUtilityAttributeLabel, itemConstraint2);
        itemConstraint2 = new GridBagConstraints();
        itemConstraint2.gridx = 1;
        itemConstraint2.weightx = 1.0;
        itemConstraint2.gridwidth = -1;
        itemConstraint2.fill = 2;
        itemConstraint2.insets = this.getStandardInsets();
        this.add((Component)secondErrorAttributePanel, itemConstraint2);
        itemConstraint2 = new GridBagConstraints();
        itemConstraint2.weightx = 0.0;
        itemConstraint2.gridwidth = 0;
        itemConstraint2.anchor = 13;
        itemConstraint2.fill = 0;
        itemConstraint2.insets = this.getStandardInsets();
        this.add(this.secondUtilityAggregationComboBox, itemConstraint2);
        JPanel spacerPanel = new JPanel();
        itemConstraint2 = new GridBagConstraints();
        itemConstraint2.fill = 1;
        itemConstraint2.weightx = 1.0;
        itemConstraint2.weighty = 1.0;
        itemConstraint2.gridwidth = 0;
        this.add((Component)spacerPanel, itemConstraint2);
    }

    private void useGroupingChanged(boolean grouped) {
        if (!grouped) {
            this.aggregationComboBox.setSelectedIndex(0);
            this.configureGroupingButton.setEnabled(false);
        }
        this.configureGroupingButton.setEnabled(true);
        this.windowingLabel.setEnabled(grouped);
        this.windowingButton.setEnabled(grouped);
        if (this.utilityIndicatorComboBox.getSelectedItem() != SeriesFormat.IndicatorType.NONE) {
            this.firstUtilityAggregationComboBox.setEnabled(grouped);
            this.secondUtilityAggregationComboBox.setEnabled(grouped);
        }
    }

    private void autoNamingChanged(boolean autoNaming) {
        this.automateLabelCheckBox.setSelected(autoNaming);
        this.valueSourceLabelTextfield.setEnabled(!autoNaming);
    }

    private void labelChanged(String label) {
        String oldText = this.valueSourceLabelTextfield.getText();
        if (!oldText.equals(label)) {
            if (label != null) {
                this.valueSourceLabelTextfield.setText(label);
            } else {
                this.valueSourceLabelTextfield.setText("");
            }
        }
    }

    private void firstUtilityDataTableColumnChanged(DataTableColumn column) {
        if (column != null) {
            this.firstUtilityTextField.setText(column.getName());
        } else {
            this.firstUtilityTextField.setText("");
        }
    }

    private void secondUtilityDataTableColumnChanged(DataTableColumn column) {
        if (column != null) {
            this.secondUtilityTextField.setText(column.getName());
        } else {
            this.secondUtilityTextField.setText("");
        }
    }

    private String buildHTMLString(String hexColor, String content) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<div style=\"color:#");
        builder.append(hexColor);
        builder.append(";text-decoration:underline;font-family:Lucida Sans;font-size:12pt\">");
        builder.append(content);
        builder.append("</div>");
        builder.append("</html>");
        String output = builder.toString();
        return output;
    }

    private void errorIndicatorChanged(SeriesFormat.IndicatorType utilityUsage) {
        DataTableColumn dataTableColumn;
        this.utilityIndicatorComboBox.setSelectedItem((Object)utilityUsage);
        boolean enableFirstUtility = false;
        boolean enableSecondUtility = false;
        if (utilityUsage != SeriesFormat.IndicatorType.NONE) {
            enableFirstUtility = true;
            enableSecondUtility = true;
        }
        this.relativeIndicatorCheckBox.setEnabled(enableFirstUtility);
        boolean useGrouping = false;
        ValueSource source = this.getSelectedValueSource();
        if (source != null) {
            useGrouping = source.isUsingDomainGrouping();
        }
        this.firstUtilityAggregationComboBox.setEnabled(enableFirstUtility && useGrouping);
        if (enableFirstUtility && (dataTableColumn = this.getSelectedValueSource().getDataTableColumn(ValueSource.SeriesUsageType.INDICATOR_1)) != null) {
            this.firstUtilityTextField.setText(dataTableColumn.getName());
        }
        if (utilityUsage == SeriesFormat.IndicatorType.DIFFERENCE) {
            enableSecondUtility = false;
        }
        this.secondUtilityAggregationComboBox.setEnabled(enableSecondUtility && useGrouping);
    }

    private void firstUtilityAggregationChanged(AbstractAggregationFunction.AggregationFunctionType aggreagtionFunctionType) {
        if (aggreagtionFunctionType != null) {
            this.firstUtilityAggregationComboBox.setSelectedItem(aggreagtionFunctionType);
        } else {
            this.firstUtilityAggregationComboBox.setSelectedItem(AbstractAggregationFunction.AggregationFunctionType.average);
        }
    }

    private void secondUtilityAggregationChanged(AbstractAggregationFunction.AggregationFunctionType aggreagtionFunctionType) {
        if (aggreagtionFunctionType != null) {
            this.secondUtilityAggregationComboBox.setSelectedItem(aggreagtionFunctionType);
        } else {
            this.secondUtilityAggregationComboBox.setSelectedItem(AbstractAggregationFunction.AggregationFunctionType.average);
        }
    }

    private void seriesTypeSelectionChanged(SeriesFormat.VisualizationType seriesType) {
        this.seriesTypeComboBox.setSelectedItem((Object)seriesType);
    }

    private void mainAggregationFunctionChanged(AbstractAggregationFunction.AggregationFunctionType aggreagtionFunctionType) {
        ValueSource selectedValueSource = this.getSelectedValueSource();
        boolean notGrouping = false;
        if (selectedValueSource != null) {
            boolean bl = notGrouping = !selectedValueSource.isUsingDomainGrouping();
        }
        if (aggreagtionFunctionType == null || notGrouping) {
            this.aggregationComboBox.setSelectedIndex(0);
            this.configureGroupingButton.setEnabled(false);
        } else {
            this.aggregationComboBox.setSelectedItem(aggreagtionFunctionType);
            this.configureGroupingButton.setEnabled(true);
        }
    }

    private void useRelativeUtilitiesChanged(Boolean useRelative) {
        this.relativeIndicatorCheckBox.setSelected(useRelative);
    }

    @Override
    protected void adaptGUI() {
        ValueSource selectedValueSource = this.getSelectedValueSource();
        if (selectedValueSource != null) {
            this.labelChanged(selectedValueSource.getLabel());
            this.autoNamingChanged(selectedValueSource.isAutoNaming());
            SeriesFormat format = selectedValueSource.getSeriesFormat();
            this.seriesTypeSelectionChanged(format.getSeriesType());
            boolean usingDomainGrouping = selectedValueSource.isUsingDomainGrouping();
            this.useGroupingChanged(usingDomainGrouping);
            this.mainAggregationFunctionChanged(selectedValueSource.getAggregationFunctionType(ValueSource.SeriesUsageType.MAIN_SERIES));
            this.errorIndicatorChanged(format.getUtilityUsage());
            this.useRelativeUtilitiesChanged(selectedValueSource.isUsingRelativeIndicator());
            this.firstUtilityAggregationChanged(selectedValueSource.getAggregationFunctionType(ValueSource.SeriesUsageType.INDICATOR_1));
            this.firstUtilityDataTableColumnChanged(selectedValueSource.getDataTableColumn(ValueSource.SeriesUsageType.INDICATOR_1));
            this.secondUtilityAggregationChanged(selectedValueSource.getAggregationFunctionType(ValueSource.SeriesUsageType.INDICATOR_2));
            this.secondUtilityDataTableColumnChanged(selectedValueSource.getDataTableColumn(ValueSource.SeriesUsageType.INDICATOR_2));
        }
    }

    @Override
    public boolean plotConfigurationChanged(PlotConfigurationChangeEvent change) {
        PlotConfigurationChangeEvent.PlotConfigurationChangeType type = change.getType();
        if (type == PlotConfigurationChangeEvent.PlotConfigurationChangeType.RANGE_AXIS_CONFIG_CHANGED) {
            this.adaptGUI();
        }
        if (type == PlotConfigurationChangeEvent.PlotConfigurationChangeType.META_CHANGE) {
            this.processPlotConfigurationMetaChange(change);
        }
        return true;
    }
}

