/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.cellrenderer;

import com.owc.gui.charting.gui.cellrenderer.ComboSeparatorsRenderer;
import com.owc.gui.charting.templates.style.ColorRGB;
import com.owc.gui.charting.templates.style.ColorScheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ColorSchemeComboBoxRenderer
extends ComboSeparatorsRenderer<Object> {
    private static final int WIDTH = 130;
    private static final int HEIGHT = 20;
    private JLabel nameLabel;
    private JPanel[] colorPanels;
    private JPanel colorSchemeComponent = new JPanel(new GridBagLayout());
    private JPanel colorPanel;

    public ColorSchemeComboBoxRenderer() {
        super(new DefaultListCellRenderer());
        int nameLabelWidth = 100;
        this.nameLabel = new JLabel("");
        this.nameLabel.setPreferredSize(new Dimension(nameLabelWidth, 20));
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.weightx = 0.0;
        itemConstraint.weighty = 0.0;
        itemConstraint.insets = new Insets(2, 1, 2, 1);
        this.colorSchemeComponent.add((Component)this.nameLabel, itemConstraint);
        int width = 130 - nameLabelWidth;
        this.colorPanel = new JPanel(new FlowLayout());
        this.colorPanel.setPreferredSize(new Dimension(width, 20));
        int size = 5;
        this.colorPanels = new JPanel[size];
        int fraction = width / size;
        HashMap<Integer, Integer> fractionMap = new HashMap<Integer, Integer>();
        for (int j = 0; j < size; ++j) {
            fractionMap.put(j, fraction);
        }
        int fractionSum = size * fraction;
        int index = 0;
        while (fractionSum < width) {
            fractionMap.put(index, (Integer)fractionMap.get(index));
            ++fractionSum;
            ++index;
        }
        for (int i = 0; i < size; ++i) {
            JPanel newColorPanel = new JPanel();
            newColorPanel.setPreferredSize(new Dimension((Integer)fractionMap.get(i), 20));
            this.colorPanel.add(newColorPanel);
            this.colorPanels[i] = newColorPanel;
        }
        GridBagConstraints itemConstraint2 = new GridBagConstraints();
        itemConstraint2.weightx = 1.0;
        itemConstraint2.weighty = 1.0;
        itemConstraint2.insets = new Insets(2, 1, 2, 1);
        itemConstraint2.fill = 1;
        this.colorSchemeComponent.add((Component)this.colorPanel, itemConstraint2);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component renderComponent = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        renderComponent.setPreferredSize(new Dimension(130, 20));
        if (value instanceof ColorScheme && index != -1) {
            this.adaptColorSchemePreviewComponent((ColorScheme)value, renderComponent, index);
            return this.colorSchemeComponent;
        }
        return renderComponent;
    }

    private void adaptColorSchemePreviewComponent(ColorScheme colorScheme, Component comp, int index) {
        this.nameLabel.setText(colorScheme.getName());
        List<ColorRGB> colors = colorScheme.getColors();
        int colorCount = colors.size();
        Color background = comp.getBackground();
        for (int i = 0; i < this.colorPanels.length; ++i) {
            if (i < colorCount) {
                Color cColor = ColorRGB.convertToColor(colors.get(i));
                this.colorPanels[i].setBackground(cColor);
                continue;
            }
            this.colorPanels[i].setBackground(background);
        }
        this.colorSchemeComponent.setBackground(background);
        this.colorPanel.setBackground(background);
    }

    @Override
    protected boolean addSeparatorAfter(JList<?> list, Object value, int index) {
        return !(value instanceof ColorScheme);
    }
}

