/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.cellrenderer;

import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.gui.cellrenderer.TreeNodeColors;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DataTableColumnListCellRenderer
implements ListCellRenderer<DataTableColumn> {
    private final Color BORDER_SELECTION_COLOR = UIManager.getColor("Tree.selectionBorderColor").darker();
    private JPanel container = new JPanel(new GridBagLayout());
    private Border noFocusBorder;
    private Border focusBorder;
    private JLabel tableColumnLabel = new JLabel();

    public DataTableColumnListCellRenderer() {
        this.focusBorder = BorderFactory.createLineBorder(this.BORDER_SELECTION_COLOR);
        this.noFocusBorder = BorderFactory.createLineBorder(Color.WHITE);
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.insets = new Insets(2, 1, 2, 1);
        itemConstraint.anchor = 17;
        itemConstraint.weightx = 1.0;
        itemConstraint.fill = 2;
        this.container.add((Component)this.tableColumnLabel, itemConstraint);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends DataTableColumn> list, DataTableColumn value, int index, boolean isSelected, boolean cellHasFocus) {
        String i18nKey;
        String text;
        DataTableColumn.ValueType valueType = null;
        if (value == null) {
            text = "##ERROR## Empty";
        } else {
            text = value.toString();
            valueType = value.getValueType();
        }
        this.tableColumnLabel.setText(text);
        if (valueType == DataTableColumn.ValueType.DATE_TIME) {
            this.tableColumnLabel.setForeground(TreeNodeColors.getDateColor());
            i18nKey = "plotter.configuration_dialog.table_column_date_time";
        } else if (valueType == DataTableColumn.ValueType.NOMINAL) {
            this.tableColumnLabel.setForeground(TreeNodeColors.getNominalColor());
            i18nKey = "plotter.configuration_dialog.table_column_nominal";
        } else {
            this.tableColumnLabel.setForeground(TreeNodeColors.getNumericalColor());
            i18nKey = "plotter.configuration_dialog.table_column_numerical";
        }
        String icon = I18N.getMessageOrNull((ResourceBundle)I18N.getGUIBundle(), (String)("gui.label." + i18nKey + ".icon"), (Object[])new Object[0]);
        if (icon != null) {
            ImageIcon iicon = SwingTools.createIcon((String)("16/" + icon), (boolean)true);
            this.tableColumnLabel.setIcon(iicon);
        }
        this.container.setBackground(list.getBackground());
        if (isSelected || cellHasFocus) {
            this.container.setBackground(list.getSelectionBackground());
            this.container.setForeground(list.getSelectionForeground());
        } else {
            this.container.setForeground(list.getForeground());
            this.container.setBackground(list.getBackground());
        }
        if (cellHasFocus) {
            this.container.setBorder(this.focusBorder);
        } else {
            this.container.setBorder(this.noFocusBorder);
        }
        return this.container;
    }
}

