/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.dialog;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.data.DimensionConfigData;
import com.owc.gui.charting.engine.jfreechart.JFreeChartPlotEngine;
import com.owc.gui.charting.engine.jfreechart.link_and_brush.listener.LinkAndBrushSelection;
import com.owc.gui.charting.utility.ContinuousColorProvider;
import com.owc.gui.charting.utility.NumericalValueRange;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.container.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class ManageZoomDialog
extends JDialog {
    private JButton okButton;
    private JButton cancelButton;
    private JButton restoreColorButton;
    private JComboBox<RangeAxisConfig> rangeAxisSelectionCombobox;
    private JTextField domainRangeLowerBoundField;
    private JTextField domainRangeUpperBoundField;
    private JTextField valueRangeLowerBoundField;
    private JTextField valueRangeUpperBoundField;
    private JTextField colorMinValueField;
    private JTextField colorMaxValueField;
    private double domainRangeLowerBound = 0.0;
    private double domainRangeUpperBound = 0.0;
    private double valueRangeLowerBound = 0.0;
    private double valueRangeUpperBound = 0.0;
    private double colorMinValue = 0.0;
    private double colorMaxValue = 0.0;
    private JRadioButton zoomRadiobutton;
    private JRadioButton selectionRadiobutton;
    private JFreeChartPlotEngine engine;
    private static final long serialVersionUID = 1932257219370926682L;

    public ManageZoomDialog() {
        super((Frame)ApplicationFrame.getApplicationFrame());
        this.setupGUI();
    }

    private void setupGUI() {
        JPanel mainPanel = new JPanel();
        this.setContentPane(mainPanel);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 2, 5);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BorderLayout());
        this.zoomRadiobutton = new JRadioButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.zoom.label", (Object[])new Object[0]));
        this.zoomRadiobutton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.zoom.tip", (Object[])new Object[0]));
        this.zoomRadiobutton.setSelected(true);
        radioPanel.add((Component)this.zoomRadiobutton, "Before");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.selectionRadiobutton = new JRadioButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.selection.label", (Object[])new Object[0]));
        this.selectionRadiobutton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.selection.tip", (Object[])new Object[0]));
        this.selectionRadiobutton.setHorizontalAlignment(0);
        radioPanel.add((Component)this.selectionRadiobutton, "After");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)radioPanel, gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.zoomRadiobutton);
        group.add(this.selectionRadiobutton);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 10;
        this.rangeAxisSelectionCombobox = new JComboBox();
        this.rangeAxisSelectionCombobox.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.range_axis_combobox.tip", (Object[])new Object[0]));
        this.rangeAxisSelectionCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageZoomDialog.this.updateValueRange();
            }
        });
        this.add(this.rangeAxisSelectionCombobox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 2, 5);
        JLabel domainRangeLowerBoundLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.domain_lower_bound.label", (Object[])new Object[0]));
        this.add((Component)domainRangeLowerBoundLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.fill = 2;
        this.domainRangeLowerBoundField = new JTextField();
        this.domainRangeLowerBoundField.setText(String.valueOf(this.domainRangeLowerBound));
        this.domainRangeLowerBoundField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return ManageZoomDialog.this.verifyDomainRangeLowerBoundInput(input);
            }
        });
        this.domainRangeLowerBoundField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.domain_lower_bound.tip", (Object[])new Object[0]));
        this.add((Component)this.domainRangeLowerBoundField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        JLabel domainRangeUpperBoundLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.domain_upper_bound.label", (Object[])new Object[0]));
        this.add((Component)domainRangeUpperBoundLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        this.domainRangeUpperBoundField = new JTextField();
        this.domainRangeUpperBoundField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.domain_upper_bound.tip", (Object[])new Object[0]));
        this.domainRangeUpperBoundField.setText(String.valueOf(this.domainRangeUpperBound));
        this.domainRangeUpperBoundField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return ManageZoomDialog.this.verifyDomainRangeUpperBoundInput(input);
            }
        });
        this.add((Component)this.domainRangeUpperBoundField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 0;
        JLabel valueRangeLowerBoundLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.value_lower_bound.label", (Object[])new Object[0]));
        this.add((Component)valueRangeLowerBoundLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.fill = 2;
        this.valueRangeLowerBoundField = new JTextField();
        this.valueRangeLowerBoundField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.value_lower_bound.tip", (Object[])new Object[0]));
        this.valueRangeLowerBoundField.setText(String.valueOf(this.valueRangeLowerBound));
        this.valueRangeLowerBoundField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return ManageZoomDialog.this.verifyValueRangeLowerBoundInput(input);
            }
        });
        this.add((Component)this.valueRangeLowerBoundField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.fill = 0;
        JLabel valueRangeUpperBoundLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.value_upper_bound.label", (Object[])new Object[0]));
        this.add((Component)valueRangeUpperBoundLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.fill = 2;
        this.valueRangeUpperBoundField = new JTextField();
        this.valueRangeUpperBoundField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.value_upper_bound.tip", (Object[])new Object[0]));
        this.valueRangeUpperBoundField.setText(String.valueOf(this.valueRangeUpperBound));
        this.valueRangeUpperBoundField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return ManageZoomDialog.this.verifyValueRangeUpperBoundInput(input);
            }
        });
        this.add((Component)this.valueRangeUpperBoundField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.fill = 0;
        gbc.anchor = 17;
        JLabel colorMinValueLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.color_min_value.label", (Object[])new Object[0]));
        this.add((Component)colorMinValueLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.fill = 2;
        this.colorMinValueField = new JTextField();
        this.colorMinValueField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.color_min_value.tip", (Object[])new Object[0]));
        this.colorMinValueField.setText(String.valueOf(this.colorMinValue));
        this.colorMinValueField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return ManageZoomDialog.this.verifyColorInput(input);
            }
        });
        this.colorMinValueField.setEnabled(false);
        this.add((Component)this.colorMinValueField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.fill = 0;
        JLabel colorMaxValueLabel = new JLabel(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.color_max_value.label", (Object[])new Object[0]));
        this.add((Component)colorMaxValueLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.fill = 2;
        this.colorMaxValueField = new JTextField();
        this.colorMaxValueField.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.color_max_value.tip", (Object[])new Object[0]));
        this.colorMaxValueField.setText(String.valueOf(this.colorMaxValue));
        this.colorMaxValueField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return ManageZoomDialog.this.verifyColorInput(input);
            }
        });
        this.colorMaxValueField.setEnabled(false);
        this.add((Component)this.colorMaxValueField, gbc);
        gbc.gridx = 1;
        gbc.gridy = 9;
        gbc.fill = 0;
        this.restoreColorButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.restore_color.label", (Object[])new Object[0]));
        this.restoreColorButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.restore_color.tip", (Object[])new Object[0]));
        this.restoreColorButton.setIcon(SwingTools.createIcon((String)("16/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.restore_color.icon", (Object[])new Object[0]))));
        this.restoreColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkAndBrushSelection linkAndBrushSelection = new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.RESTORE_COLOR, new LinkedList<Pair<Integer, Range>>(), new LinkedList<Pair<Integer, Range>>(), null, null, ManageZoomDialog.this.engine.getPlotInstance());
                ManageZoomDialog.this.engine.getChartPanel().informLinkAndBrushSelectionListeners(linkAndBrushSelection);
                ManageZoomDialog.this.updateColorValues();
            }
        });
        this.restoreColorButton.setEnabled(false);
        this.add((Component)this.restoreColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(2, 5, 5, 5);
        this.add((Component)new JSeparator(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.okButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.ok.label", (Object[])new Object[0]));
        this.okButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.ok.tip", (Object[])new Object[0]));
        this.okButton.setIcon(SwingTools.createIcon((String)("24/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.ok.icon", (Object[])new Object[0]))));
        this.okButton.setMnemonic(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.ok.mne", (Object[])new Object[0]).toCharArray()[0]);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkAndBrushSelection linkAndBrushSelection;
                boolean zoomOnLinkAndBrushSelection;
                boolean fieldsPassedChecks = ManageZoomDialog.this.checkFields();
                if (!fieldsPassedChecks) {
                    return;
                }
                Object selectedItem = ManageZoomDialog.this.rangeAxisSelectionCombobox.getSelectedItem();
                if (selectedItem != null && selectedItem instanceof RangeAxisConfig) {
                    RangeAxisConfig config = (RangeAxisConfig)selectedItem;
                    zoomOnLinkAndBrushSelection = ManageZoomDialog.this.engine.getChartPanel().getZoomOnLinkAndBrushSelection();
                    Range domainRange = new Range(Double.parseDouble(ManageZoomDialog.this.domainRangeLowerBoundField.getText()), Double.parseDouble(ManageZoomDialog.this.domainRangeUpperBoundField.getText()));
                    Range valueRange = new Range(Double.parseDouble(ManageZoomDialog.this.valueRangeLowerBoundField.getText()), Double.parseDouble(ManageZoomDialog.this.valueRangeUpperBoundField.getText()));
                    LinkedList<Pair<Integer, Range>> domainRangeList = new LinkedList<Pair<Integer, Range>>();
                    if (domainRange.getUpperBound() != 0.0) {
                        domainRangeList.add(new Pair((Object)0, (Object)domainRange));
                    }
                    LinkedList<Pair<Integer, Range>> valueRangeList = new LinkedList<Pair<Integer, Range>>();
                    if (ManageZoomDialog.this.engine.getPlotInstance().getMasterPlotConfiguration().getRangeAxisConfigs().size() > 0 && valueRange.getUpperBound() != 0.0) {
                        valueRangeList.add((Pair<Integer, Range>)new Pair((Object)ManageZoomDialog.this.engine.getPlotInstance().getMasterPlotConfiguration().getIndexOfRangeAxisConfigById(config.getId()), (Object)valueRange));
                    }
                    linkAndBrushSelection = null;
                    if (ManageZoomDialog.this.zoomRadiobutton.isSelected()) {
                        linkAndBrushSelection = new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.ZOOM_IN, domainRangeList, valueRangeList);
                        if (ManageZoomDialog.this.isColorChanged(Double.parseDouble(ManageZoomDialog.this.colorMinValueField.getText()), Double.parseDouble(ManageZoomDialog.this.colorMaxValueField.getText()))) {
                            linkAndBrushSelection = new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.COLOR_ZOOM, domainRangeList, valueRangeList, Double.parseDouble(ManageZoomDialog.this.colorMinValueField.getText()), Double.parseDouble(ManageZoomDialog.this.colorMaxValueField.getText()), ManageZoomDialog.this.engine.getPlotInstance());
                        }
                    } else if (ManageZoomDialog.this.selectionRadiobutton.isSelected()) {
                        linkAndBrushSelection = new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.SELECTION, domainRangeList, valueRangeList);
                        if (ManageZoomDialog.this.isColorChanged(Double.parseDouble(ManageZoomDialog.this.colorMinValueField.getText()), Double.parseDouble(ManageZoomDialog.this.colorMaxValueField.getText()))) {
                            linkAndBrushSelection = new LinkAndBrushSelection(LinkAndBrushSelection.SelectionType.COLOR_SELECTION, domainRangeList, valueRangeList, Double.parseDouble(ManageZoomDialog.this.colorMinValueField.getText()), Double.parseDouble(ManageZoomDialog.this.colorMaxValueField.getText()), ManageZoomDialog.this.engine.getPlotInstance());
                        }
                    }
                } else {
                    return;
                }
                ManageZoomDialog.this.engine.getChartPanel().informLinkAndBrushSelectionListeners(linkAndBrushSelection);
                ManageZoomDialog.this.engine.getChartPanel().setZoomOnLinkAndBrushSelection(zoomOnLinkAndBrushSelection);
                ManageZoomDialog.this.dispose();
            }
        });
        this.okButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ManageZoomDialog.this.okButton.doClick();
                }
            }
        });
        this.add((Component)this.okButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 11;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.cancelButton = new JButton(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.cancel.label", (Object[])new Object[0]));
        this.cancelButton.setToolTipText(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.cancel.tip", (Object[])new Object[0]));
        this.cancelButton.setIcon(SwingTools.createIcon((String)("24/" + I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.cancel.icon", (Object[])new Object[0]))));
        this.cancelButton.setMnemonic(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.cancel.mne", (Object[])new Object[0]).toCharArray()[0]);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageZoomDialog.this.dispose();
            }
        });
        this.add((Component)this.cancelButton, gbc);
        this.setMinimumSize(new Dimension(375, 360));
        this.setLocationRelativeTo(this.getOwner());
        this.setTitle(I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.action.manage_zoom.title.label", (Object[])new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ManageZoomDialog.this.okButton.requestFocusInWindow();
            }
        });
    }

    public void setChartEngine(JFreeChartPlotEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine must not be null!");
        }
        this.engine = engine;
        this.setPlotConfiguration(engine.getPlotInstance().getMasterPlotConfiguration());
    }

    private void setPlotConfiguration(PlotConfiguration plotConfig) {
        if (plotConfig == null) {
            throw new IllegalArgumentException("plotConfig must not be null!");
        }
        Vector<RangeAxisConfig> rangeConfigsVector = new Vector<RangeAxisConfig>();
        String selectedItem = String.valueOf(this.rangeAxisSelectionCombobox.getSelectedItem());
        for (RangeAxisConfig config : plotConfig.getRangeAxisConfigs()) {
            rangeConfigsVector.add(config);
        }
        this.rangeAxisSelectionCombobox.setModel(new DefaultComboBoxModel(rangeConfigsVector));
        if (selectedItem != null) {
            for (int i = 0; i < this.rangeAxisSelectionCombobox.getItemCount(); ++i) {
                if (!String.valueOf(this.rangeAxisSelectionCombobox.getItemAt(i)).equals(selectedItem)) continue;
                this.rangeAxisSelectionCombobox.setSelectedIndex(i);
                break;
            }
        }
        Plot plot = this.engine.getChartPanel().getChart().getPlot();
        double domainLowerBound = 0.0;
        double domainUpperBound = 0.0;
        boolean disableDomainZoom = false;
        NumericalValueRange effectiveRange = this.engine.getPlotInstance().getPlotData().getDomainConfigManagerData().getEffectiveRange();
        if (plot instanceof XYPlot) {
            ValueAxis domainAxis = ((XYPlot)plot).getDomainAxis();
            if (domainAxis != null) {
                Range range = domainAxis.getRange();
                domainLowerBound = range.getLowerBound();
                domainUpperBound = range.getUpperBound();
            } else if (effectiveRange != null) {
                domainLowerBound = effectiveRange.getLowerBound();
                domainUpperBound = effectiveRange.getUpperBound();
            } else {
                disableDomainZoom = true;
            }
        } else if (effectiveRange != null) {
            domainLowerBound = effectiveRange.getLowerBound();
            domainUpperBound = effectiveRange.getUpperBound();
        } else {
            disableDomainZoom = true;
        }
        this.domainRangeLowerBoundField.setText(String.valueOf(domainLowerBound));
        this.domainRangeUpperBoundField.setText(String.valueOf(domainUpperBound));
        this.domainRangeLowerBoundField.setEnabled(!disableDomainZoom);
        this.domainRangeUpperBoundField.setEnabled(!disableDomainZoom);
        this.updateValueRange();
        this.updateColorValues();
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private boolean verifyDomainRangeUpperBoundInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            if (inputString.startsWith("-")) {
                double domainUpperBound = Double.parseDouble(inputString.substring(1));
                domainUpperBound = -domainUpperBound;
            } else {
                double domainUpperBound = Double.parseDouble(inputString);
            }
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private boolean verifyDomainRangeLowerBoundInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            if (inputString.startsWith("-")) {
                double domainLowerBound = Double.parseDouble(inputString.substring(1));
                domainLowerBound = -domainLowerBound;
            } else {
                double domainLowerBound = Double.parseDouble(inputString);
            }
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private boolean verifyValueRangeLowerBoundInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            if (inputString.startsWith("-")) {
                double valueLowerBound = Double.parseDouble(inputString.substring(1));
                valueLowerBound = -valueLowerBound;
            } else {
                double valueLowerBound = Double.parseDouble(inputString);
            }
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private boolean verifyValueRangeUpperBoundInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            if (inputString.startsWith("-")) {
                double valueUpperBound = Double.parseDouble(inputString.substring(1));
                valueUpperBound = -valueUpperBound;
            } else {
                double valueUpperBound = Double.parseDouble(inputString);
            }
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private boolean verifyColorInput(JComponent input) {
        JTextField textField = (JTextField)input;
        String inputString = textField.getText();
        try {
            if (inputString.startsWith("-")) {
                double color = Double.parseDouble(inputString.substring(1));
                color = -color;
            } else {
                double color = Double.parseDouble(inputString);
            }
        }
        catch (NumberFormatException e) {
            textField.setForeground(Color.RED);
            return false;
        }
        textField.setForeground(Color.BLACK);
        return true;
    }

    private boolean checkFields() {
        if (!this.domainRangeLowerBoundField.getInputVerifier().verify(this.domainRangeLowerBoundField)) {
            this.domainRangeLowerBoundField.requestFocusInWindow();
            return false;
        }
        if (!this.domainRangeUpperBoundField.getInputVerifier().verify(this.domainRangeUpperBoundField)) {
            this.domainRangeUpperBoundField.requestFocusInWindow();
            return false;
        }
        if (!this.valueRangeLowerBoundField.getInputVerifier().verify(this.valueRangeLowerBoundField)) {
            this.valueRangeLowerBoundField.requestFocusInWindow();
            return false;
        }
        if (!this.valueRangeUpperBoundField.getInputVerifier().verify(this.valueRangeUpperBoundField)) {
            this.valueRangeUpperBoundField.requestFocusInWindow();
            return false;
        }
        if (!this.colorMinValueField.getInputVerifier().verify(this.colorMinValueField)) {
            this.colorMinValueField.requestFocusInWindow();
            return false;
        }
        if (!this.colorMaxValueField.getInputVerifier().verify(this.colorMaxValueField)) {
            this.colorMaxValueField.requestFocusInWindow();
            return false;
        }
        double domainLowerBound = Double.parseDouble(this.domainRangeLowerBoundField.getText());
        double domainUpperBound = Double.parseDouble(this.domainRangeUpperBoundField.getText());
        double valueLowerBound = Double.parseDouble(this.valueRangeLowerBoundField.getText());
        double valueUpperBound = Double.parseDouble(this.valueRangeUpperBoundField.getText());
        if (domainLowerBound == domainUpperBound && domainLowerBound != 0.0) {
            this.domainRangeUpperBoundField.requestFocusInWindow();
            return false;
        }
        if (valueLowerBound == valueUpperBound && valueLowerBound != 0.0) {
            this.valueRangeUpperBoundField.requestFocusInWindow();
            return false;
        }
        if (domainLowerBound > domainUpperBound) {
            this.domainRangeUpperBoundField.requestFocusInWindow();
            return false;
        }
        if (valueLowerBound > valueUpperBound) {
            this.valueRangeUpperBoundField.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void updateValueRange() {
        PlotConfiguration plotConfig = this.engine.getPlotInstance().getMasterPlotConfiguration();
        Plot plot = this.engine.getChartPanel().getChart().getPlot();
        int index = this.rangeAxisSelectionCombobox.getSelectedIndex();
        if (index == -1) {
            index = 0;
        }
        if (plotConfig.getRangeAxisConfigs().size() > index) {
            double valueUpperBound;
            double valueLowerBound;
            RangeAxisConfig config = plotConfig.getRangeAxisConfigs().get(index);
            if (plot instanceof XYPlot) {
                ValueAxis rangeAxis = ((XYPlot)plot).getRangeAxis(index);
                if (rangeAxis != null) {
                    Range range = rangeAxis.getRange();
                    valueLowerBound = range.getLowerBound();
                    valueUpperBound = range.getUpperBound();
                } else {
                    valueLowerBound = this.engine.getPlotInstance().getPlotData().getRangeAxisData(config).getLowerViewBound();
                    valueUpperBound = this.engine.getPlotInstance().getPlotData().getRangeAxisData(config).getUpperViewBound();
                }
            } else if (plot instanceof CategoryPlot) {
                ValueAxis rangeAxis = ((CategoryPlot)plot).getRangeAxis(index);
                if (rangeAxis != null) {
                    Range range = rangeAxis.getRange();
                    valueLowerBound = range.getLowerBound();
                    valueUpperBound = range.getUpperBound();
                } else {
                    valueLowerBound = this.engine.getPlotInstance().getPlotData().getRangeAxisData(config).getLowerViewBound();
                    valueUpperBound = this.engine.getPlotInstance().getPlotData().getRangeAxisData(config).getUpperViewBound();
                }
            } else {
                valueLowerBound = this.engine.getPlotInstance().getPlotData().getRangeAxisData(config).getLowerViewBound();
                valueUpperBound = this.engine.getPlotInstance().getPlotData().getRangeAxisData(config).getUpperViewBound();
            }
            this.valueRangeLowerBoundField.setText(String.valueOf(valueLowerBound));
            this.valueRangeUpperBoundField.setText(String.valueOf(valueUpperBound));
        }
    }

    private void updateColorValues() {
        DimensionConfigData dimensionConfigData = this.engine.getPlotInstance().getPlotData().getDimensionConfigData(this.engine.getPlotInstance().getMasterPlotConfiguration().getDefaultDimensionConfigs().get((Object)DimensionConfig.PlotDimension.COLOR));
        if (dimensionConfigData != null && dimensionConfigData.getColorProvider() instanceof ContinuousColorProvider) {
            ContinuousColorProvider colProv = (ContinuousColorProvider)dimensionConfigData.getColorProvider();
            this.colorMinValueField.setText(String.valueOf(colProv.getMinValue()));
            this.colorMaxValueField.setText(String.valueOf(colProv.getMaxValue()));
            this.colorMinValueField.setEnabled(true);
            this.colorMaxValueField.setEnabled(true);
            this.restoreColorButton.setEnabled(true);
        } else {
            this.colorMinValueField.setText("0");
            this.colorMaxValueField.setText("0");
            this.colorMinValueField.setEnabled(false);
            this.colorMaxValueField.setEnabled(false);
            this.restoreColorButton.setEnabled(false);
        }
    }

    private boolean isColorChanged(double minValue, double maxValue) {
        ContinuousColorProvider colProv;
        DimensionConfigData dimensionConfigData = this.engine.getPlotInstance().getPlotData().getDimensionConfigData(this.engine.getPlotInstance().getMasterPlotConfiguration().getDefaultDimensionConfigs().get((Object)DimensionConfig.PlotDimension.COLOR));
        return dimensionConfigData != null && dimensionConfigData.getColorProvider() instanceof ContinuousColorProvider && (colProv = (ContinuousColorProvider)dimensionConfigData.getColorProvider()).isColorMinMaxValueDifferentFromOriginal(minValue, maxValue);
    }
}

