/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.dnd;

import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.gui.AttributeDropTextField;
import com.owc.gui.charting.gui.dnd.DataTableColumnCollection;
import com.owc.gui.charting.gui.treenodes.ValueSourceTreeNode;
import com.rapidminer.gui.dnd.AbstractPatchedTransferHandler;
import java.awt.datatransfer.Transferable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DataTableColumnDropTextFieldTransferHandler
extends AbstractPatchedTransferHandler
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private final ValueSource.SeriesUsageType seriesUsageType;
    private ValueSource currentValueSource;
    private final AttributeDropTextField aDTF;

    public DataTableColumnDropTextFieldTransferHandler(JTree plotConfigTree, ValueSource.SeriesUsageType seriesUsage, AttributeDropTextField aDTF) {
        this.seriesUsageType = seriesUsage;
        plotConfigTree.addTreeSelectionListener(this);
        this.aDTF = aDTF;
    }

    public Icon getVisualRepresentation(Transferable t) {
        return null;
    }

    protected Transferable createTransferable(JComponent c) {
        return null;
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    public boolean doesSupportFlavor(TransferHandler.TransferSupport support) {
        if (!this.aDTF.isEnabled()) {
            return false;
        }
        return support.isDataFlavorSupported(DataTableColumnCollection.DATATABLE_COLUMN_COLLECTION_FLAVOR);
    }

    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean copySupported;
        if (!this.doesSupportFlavor(support)) {
            return false;
        }
        try {
            Transferable transferable = support.getTransferable();
            DataTableColumnCollection dataTableColumnCollection = (DataTableColumnCollection)transferable.getTransferData(DataTableColumnCollection.DATATABLE_COLUMN_COLLECTION_FLAVOR);
            int size = dataTableColumnCollection.getDataTableColumns().size();
            if (size > 1 || size == 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (!support.isDrop()) {
            return false;
        }
        boolean bl = copySupported = (1 & support.getSourceDropActions()) == 1;
        if (copySupported) {
            support.setDropAction(1);
            return true;
        }
        return false;
    }

    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        try {
            if (this.currentValueSource != null) {
                Transferable transferable = support.getTransferable();
                DataTableColumnCollection dataTableColumnCollection = (DataTableColumnCollection)transferable.getTransferData(DataTableColumnCollection.DATATABLE_COLUMN_COLLECTION_FLAVOR);
                this.currentValueSource.setDataTableColumn(this.seriesUsageType, dataTableColumnCollection.getDataTableColumns().get(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
        if (newLeadSelectionPath == null) {
            return;
        }
        Object lastPathComponent = newLeadSelectionPath.getLastPathComponent();
        if (lastPathComponent instanceof ValueSourceTreeNode) {
            ValueSourceTreeNode valueSourceNode = (ValueSourceTreeNode)lastPathComponent;
            ValueSource selectedValueSource = valueSourceNode.getUserObject();
            if (selectedValueSource == this.currentValueSource) {
                return;
            }
            this.currentValueSource = selectedValueSource;
        } else {
            this.currentValueSource = null;
        }
    }
}

